/*
 * Decompiled with CFR 0.152.
 */
package dangerzone;

import dangerzone.DangerZone;
import dangerzone.Dimensions;
import dangerzone.InventoryContainer;
import dangerzone.ModelBase;
import dangerzone.TextureMapper;
import dangerzone.World;
import dangerzone.WorldRenderer;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entities;
import dangerzone.entities.Entity;
import dangerzone.items.Item;
import dangerzone.items.Items;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.Color;
import org.newdawn.slick.TrueTypeFont;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureImpl;

public class WorldRendererUtils {
    private static boolean square_compiled = false;
    private static int squareid;
    private static final int blockrenderwidth = 16;
    public static Texture hotbarbackground;
    public static Texture firetexture;
    private static boolean fire_compiled;
    private static int fire_list1;
    private static int fire_list2;
    private static int fire_list3;
    private static int fire_list4;
    private static int fire_list5;
    private static int fire_list6;
    private static int fire_list7;
    private static int fire_list8;
    private static float sunspin;
    private static int blink;
    private static Entity curr_entity;
    private static int curr_entity_count;
    private static float pitchdir;
    private static float ticker;
    private static float curr_yaw;
    private static float curr_pitch;

    static {
        hotbarbackground = null;
        firetexture = null;
        fire_compiled = false;
        sunspin = 0.0f;
        blink = 0;
        curr_entity = null;
        curr_entity_count = 0;
        pitchdir = 0.3f;
        ticker = 0.0f;
        curr_yaw = 0.0f;
        curr_pitch = 0.0f;
    }

    public static void drawShowcaseMonster() {
        while (curr_entity == null) {
            curr_entity = Entities.random_entity();
            if (curr_entity != null) {
                curr_entity.init();
                curr_yaw = DangerZone.rand.nextInt(360);
                curr_pitch = DangerZone.rand.nextInt(60) - 30;
                if (DangerZone.rand.nextInt(50) == 1) {
                    curr_entity = DangerZone.player;
                }
                if (WorldRendererUtils.curr_entity.model == null) {
                    curr_entity = null;
                }
                if (curr_entity != null && curr_entity.getTexture() == null) {
                    curr_entity = null;
                }
                if (curr_entity != null && DangerZone.world != null && curr_entity != DangerZone.player) {
                    WorldRendererUtils.curr_entity.world = DangerZone.world;
                    DangerZone.world.playSound(curr_entity.getLivingSound(), DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy, DangerZone.player.posz, 0.5f, 1.0f);
                }
            }
            curr_entity_count = 600;
        }
        if ((ticker += 1.0f) > 1000000.0f) {
            ticker = 0.0f;
        }
        curr_yaw += 0.75f;
        if ((curr_pitch += pitchdir) > 30.0f) {
            pitchdir = -0.25f;
        }
        if (curr_pitch < -30.0f) {
            pitchdir = 0.25f;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)((DangerZone.player.posy - (double)(curr_entity.getHeight() / 2.0f)) * 16.0), (double)(-((2.5f + curr_entity.getWidth() * 2.5f + curr_entity.getHeight() * 1.75f) * 16.0f)));
        if (curr_yaw != 0.0f) {
            GL11.glRotatef((float)curr_yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (curr_pitch != 0.0f) {
            GL11.glRotatef((float)curr_pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        GL11.glColor3f((float)0.95f, (float)0.95f, (float)0.95f);
        ModelBase model = WorldRendererUtils.curr_entity.model;
        WorldRendererUtils.loadtexture(curr_entity.getTexture());
        model.doScale(curr_entity);
        model.render(curr_entity, ticker, 0.11f, 0.0f, 0.0f, 0.0f, 1.0f);
        GL11.glPopMatrix();
        GL11.glDisable((int)2929);
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)DangerZone.screen_width, (double)0.0, (double)DangerZone.screen_height, (double)-320.0, (double)320.0);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        WorldRendererUtils.textAt(DangerZone.font, 50.0f, 150.0f, WorldRendererUtils.curr_entity.uniquename);
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glEnable((int)2929);
        if (--curr_entity_count <= 0) {
            curr_entity = null;
        }
    }

    public static void loadtexture(Texture lt) {
        if (lt == null) {
            return;
        }
        TextureImpl.unbind();
        lt.bind();
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
    }

    public static void textAt(TrueTypeFont ff, float xpos, float ypos, String text) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)xpos, (float)ypos, (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        ff.drawString(0.0f, 0.0f, text, Color.lightGray);
        GL11.glPopMatrix();
    }

    public static void drawSquare() {
        if (!square_compiled) {
            squareid = DangerZone.wr.getNextRenderID();
            GL11.glNewList((int)squareid, (int)4864);
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)8.0f, (float)8.0f, (float)0.0f);
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)-8.0f, (float)8.0f, (float)0.0f);
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)-8.0f, (float)-8.0f, (float)0.0f);
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)8.0f, (float)-8.0f, (float)0.0f);
            GL11.glEnd();
            GL11.glEndList();
            square_compiled = true;
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glCallList((int)squareid);
        GL11.glDisable((int)3042);
    }

    public static float getLightMapValue(World w, int d, int x, int y, int z) {
        short[] lightmap = null;
        lightmap = w.chunkcache.getDecoratedChunkLightmap(d, x, y, z);
        if (lightmap == null) {
            return 0.0f;
        }
        float tmp = lightmap[(x & 0xF) * 16 + (z & 0xF)];
        return tmp / 1000.0f;
    }

    public static float getTotalLightAt(World w, int d, int x, int y, int z) {
        short[] lightmap = null;
        float lt = WorldRendererUtils.getBrightnessForLevel(d, y);
        lightmap = w.chunkcache.getDecoratedChunkLightmap(d, x, y, z);
        if (lightmap == null) {
            return lt;
        }
        float tmp = lightmap[(x & 0xF) * 16 + (z & 0xF)];
        return tmp / 1000.0f + lt;
    }

    public static float getBrightnessForLevel(int d, int yp) {
        float tod = DangerZone.world.timetimer % DangerZone.world.lengthOfDay;
        float fsin = (float)Math.sin(Math.toRadians(tod / (float)DangerZone.world.lengthOfDay * 360.0f));
        if ((fsin *= 1.75f) > 1.0f) {
            fsin = 1.0f;
        }
        if (fsin < -1.0f) {
            fsin = -1.0f;
        }
        float f = 0.5f + 0.45f * fsin;
        if (yp < 50 && Dimensions.DimensionArray[d].fade_light_level) {
            if (yp < 0) {
                yp = 0;
            }
            float f2 = (float)yp / (50.0f + (50.0f - (float)yp));
            f *= f2;
        }
        return f;
    }

    public static void drawRectangleWithTexture(Texture t, float xpos, float ypos, float xsize, float ysize) {
        DangerZone.wr.forceloadtexture(t);
        float w = t.getWidth();
        float h = t.getHeight();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)xpos, (float)ypos, (float)0.0f);
        GL11.glScalef((float)(xsize / t.getWidth()), (float)(ysize / t.getHeight()), (float)1.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)w, (float)0.0f);
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)h);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)w, (float)h);
        GL11.glVertex3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    private static void drawhotbarbackground() {
        if (hotbarbackground == null) {
            hotbarbackground = TextureMapper.getTexture("res/menus/bkg1.png");
        }
        GL11.glScalef((float)3.25f, (float)3.25f, (float)3.25f);
        DangerZone.wr.loadtexture(hotbarbackground);
        WorldRendererUtils.drawSquare();
        GL11.glScalef((float)0.30769232f, (float)0.30769232f, (float)0.30769232f);
    }

    public static void drawHotbar(World world) {
        if (DangerZone.current_gui != null) {
            return;
        }
        InventoryContainer ic = null;
        DangerZone.wr.setBrightnessNonFocus();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(DangerZone.screen_width / 2 - 300), (float)30.0f, (float)0.0f);
        int i = 0;
        while (i < 10) {
            WorldRenderer.last_texture = -1;
            if (i == DangerZone.player.gethotbarindex()) {
                DangerZone.wr.setBrightnessFocus();
            }
            WorldRendererUtils.drawhotbarbackground();
            ic = DangerZone.player.getHotbar(i);
            if (ic != null) {
                if (ic.bid != 0) {
                    GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
                    if (Blocks.showTop(ic.bid)) {
                        DangerZone.wr.drawTexturedSquare(0, Blocks.isSolidForRender(ic.bid), ic.bid);
                    } else {
                        DangerZone.wr.drawTexturedCube(8, Blocks.isSolidForRender(ic.bid), ic.bid, 0, false);
                    }
                    GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                }
                if (ic.iid != 0) {
                    int md;
                    Item it;
                    GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
                    DangerZone.wr.loadtexture(Items.getTexture(ic.iid));
                    WorldRendererUtils.drawSquare();
                    GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                    if (ic.count == 1 && ic.currentuses > 0 && ic.getMaxStack() == 1 && (it = ic.getItem()) != null && (md = it.maxuses) > 0) {
                        float xs;
                        float pu = (float)ic.currentuses / (float)md;
                        if (pu > 1.0f) {
                            pu = 1.0f;
                        }
                        if (pu < 0.0f) {
                            pu = 0.0f;
                        }
                        if ((xs = 32.0f * (1.0f - pu)) < 1.0f) {
                            xs = 1.0f;
                        }
                        GL11.glPushMatrix();
                        GL11.glDisable((int)3553);
                        GL11.glTranslatef((float)-16.0f, (float)-18.0f, (float)0.0f);
                        GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
                        GL11.glBegin((int)7);
                        GL11.glColor3f((float)pu, (float)(1.0f - pu), (float)0.0f);
                        GL11.glVertex3f((float)xs, (float)2.0f, (float)0.0f);
                        GL11.glColor3f((float)pu, (float)(1.0f - pu), (float)0.0f);
                        GL11.glVertex3f((float)0.0f, (float)2.0f, (float)0.0f);
                        GL11.glColor3f((float)pu, (float)(1.0f - pu), (float)0.0f);
                        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
                        GL11.glColor3f((float)pu, (float)(1.0f - pu), (float)0.0f);
                        GL11.glVertex3f((float)xs, (float)0.0f, (float)0.0f);
                        GL11.glEnd();
                        GL11.glEnable((int)3553);
                        GL11.glPopMatrix();
                    }
                }
                if (ic.count > 1) {
                    if (ic.count > 9) {
                        WorldRendererUtils.textAt(DangerZone.wr.font, -12.0f, 10.0f, String.format("%d", ic.count));
                    } else {
                        WorldRendererUtils.textAt(DangerZone.wr.font, -6.0f, 10.0f, String.format("%d", ic.count));
                    }
                }
                DangerZone.wr.setBrightnessNonFocus();
            }
            DangerZone.wr.setBrightnessNonFocus();
            GL11.glTranslatef((float)60.0f, (float)0.0f, (float)0.0f);
            ++i;
        }
        GL11.glPopMatrix();
    }

    public static void drawHealth(World world) {
        if (DangerZone.current_gui != null) {
            return;
        }
        if (WorldRenderer.heart_texture == null || WorldRenderer.unheart_texture == null) {
            return;
        }
        DangerZone.wr.setBrightnessNonFocus();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(DangerZone.screen_width / 2 - 300 - 14), (float)65.0f, (float)0.0f);
        float h = DangerZone.player.getHealth() / DangerZone.player.getMaxHealth();
        h *= 20.0f;
        int i = 0;
        while (i < 20) {
            if (h > (float)i + 0.5f) {
                DangerZone.wr.loadtexture(WorldRenderer.heart_texture);
            } else {
                DangerZone.wr.loadtexture(WorldRenderer.unheart_texture);
            }
            WorldRendererUtils.drawSquare();
            GL11.glTranslatef((float)30.0f, (float)0.0f, (float)0.0f);
            ++i;
        }
        GL11.glPopMatrix();
    }

    public static void drawHunger(World world) {
        if (DangerZone.current_gui != null) {
            return;
        }
        if (WorldRenderer.hungerfull_texture == null || WorldRenderer.hungerempty_texture == null) {
            return;
        }
        DangerZone.wr.setBrightnessNonFocus();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)(DangerZone.screen_width / 2) - 285.0f - 14.0f), (float)75.0f, (float)0.0f);
        float h = DangerZone.player.getHunger() / DangerZone.player.getMaxHunger();
        h *= 19.0f;
        int i = 0;
        while (i < 19) {
            if (h > (float)i + 0.5f) {
                DangerZone.wr.loadtexture(WorldRenderer.hungerfull_texture);
            } else {
                DangerZone.wr.loadtexture(WorldRenderer.hungerempty_texture);
            }
            WorldRendererUtils.drawSquare();
            GL11.glTranslatef((float)30.0f, (float)0.0f, (float)0.0f);
            ++i;
        }
        GL11.glPopMatrix();
    }

    public static void drawMagic(World world) {
        if (DangerZone.current_gui != null) {
            return;
        }
        if (DangerZone.player.getMaxMagic() < 1.0f) {
            return;
        }
        ++blink;
        if (WorldRenderer.magic_texture == null || WorldRenderer.magicempty_texture == null) {
            return;
        }
        DangerZone.wr.setBrightnessNonFocus();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)(DangerZone.screen_width / 2) - 270.0f - 14.0f), (float)85.0f, (float)0.0f);
        float h = DangerZone.player.getMagic() / DangerZone.player.getMaxMagic();
        h *= 18.0f;
        int i = 0;
        while (i < 18) {
            if (h > (float)i + 0.5f) {
                DangerZone.wr.loadtexture(WorldRenderer.magic_texture);
            } else {
                DangerZone.wr.loadtexture(WorldRenderer.magicempty_texture);
            }
            if (DangerZone.magic_power != 0.0f) {
                if ((blink & 7) > 3 || (float)i + 0.5f > DangerZone.magic_power * 18.0f) {
                    WorldRendererUtils.drawSquare();
                }
            } else {
                WorldRendererUtils.drawSquare();
            }
            GL11.glTranslatef((float)30.0f, (float)0.0f, (float)0.0f);
            ++i;
        }
        GL11.glPopMatrix();
    }

    public static void drawAir(World world) {
        if (DangerZone.current_gui != null) {
            return;
        }
        if (WorldRenderer.bubble_texture == null) {
            return;
        }
        if (!Blocks.isLiquid(world.getblock(DangerZone.player.dimension, (int)DangerZone.player.posx, (int)(DangerZone.player.posy + (double)DangerZone.player.eyeheight), (int)DangerZone.player.posz))) {
            return;
        }
        DangerZone.wr.setBrightnessNonFocus();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)(DangerZone.screen_width / 2) - 255.0f - 14.0f), (float)95.0f, (float)0.0f);
        float h = DangerZone.player.getAir() / DangerZone.player.getMaxAir();
        h *= 17.0f;
        int i = 0;
        while (i < 17) {
            if (h > (float)i + 0.5f) {
                DangerZone.wr.loadtexture(WorldRenderer.bubble_texture);
                WorldRendererUtils.drawSquare();
            }
            GL11.glTranslatef((float)30.0f, (float)0.0f, (float)0.0f);
            ++i;
        }
        GL11.glPopMatrix();
    }

    public static void drawSunAndMoon(World world, boolean spinit) {
        double dist = 254.0f * (float)DangerZone.renderdistance;
        float scale = (float)DangerZone.renderdistance / 24.0f;
        int tod = world.getTimeOfDay();
        int lod = world.getLengthOfDay();
        boolean moon = false;
        if (tod > lod / 2) {
            tod -= lod / 2;
            moon = true;
        }
        double sposx = DangerZone.player.posx % 16.0 * 16.0;
        double sposy = dist * Math.sin(Math.toRadians((float)tod / (float)lod * 360.0f));
        double sposz = dist * Math.cos(Math.toRadians((float)tod / (float)lod * 360.0f)) + DangerZone.player.posz % 16.0 * 16.0;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)sposx), (float)((float)(sposy + DangerZone.player.posy * 16.0)), (float)((float)sposz));
        GL11.glRotatef((float)(360.0f - (float)tod / (float)lod * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        DangerZone.wr.setBrightness(1.0f);
        if (!moon) {
            DangerZone.wr.loadtexture(WorldRenderer.sun_texture);
        } else {
            DangerZone.wr.loadtexture(WorldRenderer.moon_texture);
        }
        if (DangerZone.fog_enable) {
            GL11.glDisable((int)2912);
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glScalef((float)(20.0f * scale), (float)(20.0f * scale), (float)(20.0f * scale));
        if (!moon) {
            GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
        }
        if (spinit && !moon) {
            GL11.glRotatef((float)((sunspin += 0.15f) % 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        WorldRendererUtils.drawSquare();
        GL11.glScalef((float)(0.05f / scale), (float)(0.05f / scale), (float)(0.05f / scale));
        if (!moon) {
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        }
        GL11.glDisable((int)3042);
        if (DangerZone.fog_enable) {
            GL11.glEnable((int)2912);
        }
        DangerZone.wr.setBrightness();
        GL11.glPopMatrix();
    }

    public static void drawEntityOnFire(Entity ent) {
        if (firetexture == null) {
            firetexture = TextureMapper.getTexture("res/misc/fire_side.png");
        }
        if (!fire_compiled) {
            float offinc = 0.0f;
            fire_list1 = DangerZone.wr.getNextRenderID();
            GL11.glNewList((int)fire_list1, (int)4864);
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)1.0f, (float)offinc);
            GL11.glVertex3f((float)9.0f, (float)9.0f, (float)0.0f);
            GL11.glTexCoord2f((float)0.0f, (float)offinc);
            GL11.glVertex3f((float)-9.0f, (float)9.0f, (float)0.0f);
            GL11.glTexCoord2f((float)0.0f, (float)(offinc + 0.125f));
            GL11.glVertex3f((float)-9.0f, (float)-9.0f, (float)0.0f);
            GL11.glTexCoord2f((float)1.0f, (float)(offinc + 0.125f));
            GL11.glVertex3f((float)9.0f, (float)-9.0f, (float)0.0f);
            GL11.glEnd();
            GL11.glEndList();
            fire_list2 = DangerZone.wr.getNextRenderID();
            GL11.glNewList((int)fire_list2, (int)4864);
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)1.0f, (float)(offinc += 0.125f));
            GL11.glVertex3f((float)9.0f, (float)9.0f, (float)0.0f);
            GL11.glTexCoord2f((float)0.0f, (float)offinc);
            GL11.glVertex3f((float)-9.0f, (float)9.0f, (float)0.0f);
            GL11.glTexCoord2f((float)0.0f, (float)(offinc + 0.125f));
            GL11.glVertex3f((float)-9.0f, (float)-9.0f, (float)0.0f);
            GL11.glTexCoord2f((float)1.0f, (float)(offinc + 0.125f));
            GL11.glVertex3f((float)9.0f, (float)-9.0f, (float)0.0f);
            GL11.glEnd();
            GL11.glEndList();
            fire_list3 = DangerZone.wr.getNextRenderID();
            GL11.glNewList((int)fire_list3, (int)4864);
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)1.0f, (float)(offinc += 0.125f));
            GL11.glVertex3f((float)9.0f, (float)9.0f, (float)0.0f);
            GL11.glTexCoord2f((float)0.0f, (float)offinc);
            GL11.glVertex3f((float)-9.0f, (float)9.0f, (float)0.0f);
            GL11.glTexCoord2f((float)0.0f, (float)(offinc + 0.125f));
            GL11.glVertex3f((float)-9.0f, (float)-9.0f, (float)0.0f);
            GL11.glTexCoord2f((float)1.0f, (float)(offinc + 0.125f));
            GL11.glVertex3f((float)9.0f, (float)-9.0f, (float)0.0f);
            GL11.glEnd();
            GL11.glEndList();
            fire_list4 = DangerZone.wr.getNextRenderID();
            GL11.glNewList((int)fire_list4, (int)4864);
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)1.0f, (float)(offinc += 0.125f));
            GL11.glVertex3f((float)9.0f, (float)9.0f, (float)0.0f);
            GL11.glTexCoord2f((float)0.0f, (float)offinc);
            GL11.glVertex3f((float)-9.0f, (float)9.0f, (float)0.0f);
            GL11.glTexCoord2f((float)0.0f, (float)(offinc + 0.125f));
            GL11.glVertex3f((float)-9.0f, (float)-9.0f, (float)0.0f);
            GL11.glTexCoord2f((float)1.0f, (float)(offinc + 0.125f));
            GL11.glVertex3f((float)9.0f, (float)-9.0f, (float)0.0f);
            GL11.glEnd();
            GL11.glEndList();
            fire_list5 = DangerZone.wr.getNextRenderID();
            GL11.glNewList((int)fire_list5, (int)4864);
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)1.0f, (float)(offinc += 0.125f));
            GL11.glVertex3f((float)9.0f, (float)9.0f, (float)0.0f);
            GL11.glTexCoord2f((float)0.0f, (float)offinc);
            GL11.glVertex3f((float)-9.0f, (float)9.0f, (float)0.0f);
            GL11.glTexCoord2f((float)0.0f, (float)(offinc + 0.125f));
            GL11.glVertex3f((float)-9.0f, (float)-9.0f, (float)0.0f);
            GL11.glTexCoord2f((float)1.0f, (float)(offinc + 0.125f));
            GL11.glVertex3f((float)9.0f, (float)-9.0f, (float)0.0f);
            GL11.glEnd();
            GL11.glEndList();
            fire_list6 = DangerZone.wr.getNextRenderID();
            GL11.glNewList((int)fire_list6, (int)4864);
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)1.0f, (float)(offinc += 0.125f));
            GL11.glVertex3f((float)9.0f, (float)9.0f, (float)0.0f);
            GL11.glTexCoord2f((float)0.0f, (float)offinc);
            GL11.glVertex3f((float)-9.0f, (float)9.0f, (float)0.0f);
            GL11.glTexCoord2f((float)0.0f, (float)(offinc + 0.125f));
            GL11.glVertex3f((float)-9.0f, (float)-9.0f, (float)0.0f);
            GL11.glTexCoord2f((float)1.0f, (float)(offinc + 0.125f));
            GL11.glVertex3f((float)9.0f, (float)-9.0f, (float)0.0f);
            GL11.glEnd();
            GL11.glEndList();
            fire_list7 = DangerZone.wr.getNextRenderID();
            GL11.glNewList((int)fire_list7, (int)4864);
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)1.0f, (float)(offinc += 0.125f));
            GL11.glVertex3f((float)9.0f, (float)9.0f, (float)0.0f);
            GL11.glTexCoord2f((float)0.0f, (float)offinc);
            GL11.glVertex3f((float)-9.0f, (float)9.0f, (float)0.0f);
            GL11.glTexCoord2f((float)0.0f, (float)(offinc + 0.125f));
            GL11.glVertex3f((float)-9.0f, (float)-9.0f, (float)0.0f);
            GL11.glTexCoord2f((float)1.0f, (float)(offinc + 0.125f));
            GL11.glVertex3f((float)9.0f, (float)-9.0f, (float)0.0f);
            GL11.glEnd();
            GL11.glEndList();
            fire_list8 = DangerZone.wr.getNextRenderID();
            GL11.glNewList((int)fire_list8, (int)4864);
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)1.0f, (float)(offinc += 0.125f));
            GL11.glVertex3f((float)9.0f, (float)9.0f, (float)0.0f);
            GL11.glTexCoord2f((float)0.0f, (float)offinc);
            GL11.glVertex3f((float)-9.0f, (float)9.0f, (float)0.0f);
            GL11.glTexCoord2f((float)0.0f, (float)(offinc + 0.125f));
            GL11.glVertex3f((float)-9.0f, (float)-9.0f, (float)0.0f);
            GL11.glTexCoord2f((float)1.0f, (float)(offinc + 0.125f));
            GL11.glVertex3f((float)9.0f, (float)-9.0f, (float)0.0f);
            GL11.glEnd();
            GL11.glEndList();
            fire_compiled = true;
        }
        DangerZone.wr.loadtexture(firetexture);
        int which = DangerZone.rand.nextInt(8);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
        GL11.glScalef((float)ent.getWidth(), (float)(ent.getHeight() * 1.25f), (float)1.0f);
        GL11.glTranslatef((float)0.0f, (float)8.0f, (float)0.0f);
        switch (which) {
            case 0: {
                GL11.glCallList((int)fire_list1);
                break;
            }
            case 1: {
                GL11.glCallList((int)fire_list2);
                break;
            }
            case 2: {
                GL11.glCallList((int)fire_list3);
                break;
            }
            case 3: {
                GL11.glCallList((int)fire_list4);
                break;
            }
            case 4: {
                GL11.glCallList((int)fire_list5);
                break;
            }
            case 5: {
                GL11.glCallList((int)fire_list6);
                break;
            }
            case 6: {
                GL11.glCallList((int)fire_list7);
                break;
            }
            case 7: {
                GL11.glCallList((int)fire_list8);
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

