/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.threads;

import dangerzone.DangerZone;
import dangerzone.ListCoords;
import dangerzone.blocks.Blocks;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class NotifyBlockTicker
implements Runnable {
    public static List<ListCoords> blocklist = null;
    public static List<ListCoords> workinglist = null;
    public static List<ListCoords> notyetlist = null;
    private static Lock lock = new ReentrantLock();
    public static volatile int recursioncount = 0;

    @Override
    public void run() {
        Thread thisthread = Thread.currentThread();
        thisthread.setPriority(1);
        blocklist = new ArrayList<ListCoords>();
        workinglist = null;
        notyetlist = null;
        try {
            Thread.sleep(4000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        while (DangerZone.gameover == 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (DangerZone.f12_on) continue;
            lock.lock();
            notyetlist = new ArrayList<ListCoords>();
            workinglist = new ArrayList<ListCoords>();
            Iterator<ListCoords> ib = blocklist.iterator();
            ListCoords li = null;
            while (ib.hasNext()) {
                li = ib.next();
                int bid = DangerZone.server_chunk_cache.getBlockTry(li.dim, li.xpos, li.ypos, li.zpos);
                if (bid == 0) continue;
                --li.count;
                if (li.count <= 0) {
                    workinglist.add(li);
                    continue;
                }
                notyetlist.add(li);
            }
            blocklist = notyetlist;
            notyetlist = null;
            lock.unlock();
            ib = workinglist.iterator();
            li = null;
            while (ib.hasNext()) {
                li = ib.next();
                int bid = DangerZone.server_chunk_cache.getBlockTry(li.dim, li.xpos, li.ypos, li.zpos);
                if (bid == 0 || !(DangerZone.server.distToNearestPlayerFromHere(li.dim, li.xpos, li.ypos, li.zpos) < (double)DangerZone.entityupdatedist)) continue;
                Blocks.notifyNeighborChanged(bid, DangerZone.server_world, li.dim, li.xpos, li.ypos, li.zpos);
            }
            workinglist = null;
        }
    }

    public static void addNotifySingle(int d, int x, int y, int z) {
        NotifyBlockTicker.addNotifySingle(d, x, y, z, 0);
    }

    public static void addNotifySingle(int d, int x, int y, int z, int c) {
        if (blocklist == null) {
            return;
        }
        if (!DangerZone.start_server) {
            return;
        }
        if (x < 0 || y < 0 || z < 0) {
            return;
        }
        lock.lock();
        ListCoords ln = new ListCoords(d, x, y, z, c);
        Iterator<ListCoords> ib = blocklist.iterator();
        ListCoords li = null;
        while (ib.hasNext()) {
            li = ib.next();
            if (li.dim != d || li.xpos != x || li.ypos != y || li.zpos != z) continue;
            lock.unlock();
            return;
        }
        blocklist.add(ln);
        lock.unlock();
    }

    public static void addNotifyBlocksAround(int d, int x, int y, int z) {
        NotifyBlockTicker.addNotifyBlocksAround(d, x, y, z, 0);
    }

    public static void addNotifyBlocksAround(int d, int x, int y, int z, int c) {
        int k;
        int j;
        int i;
        if (blocklist == null) {
            return;
        }
        if (!DangerZone.start_server) {
            return;
        }
        if (x < 0 || y < 0 || z < 0) {
            return;
        }
        lock.lock();
        if (blocklist.size() > 4000 && c <= 1) {
            if (++recursioncount > 500) {
                --recursioncount;
                lock.unlock();
                return;
            }
            lock.unlock();
            int i2 = -1;
            while (i2 <= 1) {
                int j2 = -1;
                while (j2 <= 1) {
                    int k2 = -1;
                    while (k2 <= 1) {
                        int bid;
                        if ((i2 != 0 || j2 != 0 || k2 != 0) && (bid = DangerZone.server_chunk_cache.getBlockTry(d, x + i2, y + j2, z + k2)) != 0) {
                            Blocks.notifyNeighborChanged(bid, DangerZone.server_world, d, x + i2, y + j2, z + k2);
                        }
                        ++k2;
                    }
                    ++j2;
                }
                ++i2;
            }
            lock.lock();
            --recursioncount;
            lock.unlock();
            return;
        }
        int[][][] blks = new int[3][3][3];
        ListCoords ln = null;
        Iterator<ListCoords> ib = blocklist.iterator();
        ListCoords li = null;
        while (ib.hasNext()) {
            li = ib.next();
            if (li.dim != d || li.xpos < x - 1 || li.ypos < y - 1 || li.zpos < z - 1 || li.xpos > x + 1 || li.ypos > y + 1 || li.zpos > z + 1) continue;
            i = li.xpos - x;
            j = li.ypos - y;
            k = li.zpos - z;
            if (i == 0 && j == 0 && k == 0) continue;
            blks[i + 1][j + 1][k + 1] = 1;
        }
        i = -1;
        while (i <= 1) {
            j = -1;
            while (j <= 1) {
                k = -1;
                while (k <= 1) {
                    int bid;
                    if ((i != 0 || j != 0 || k != 0) && blks[i + 1][j + 1][k + 1] == 0 && (bid = DangerZone.server_chunk_cache.getBlockTry(d, x + i, y + j, z + k)) != 0) {
                        ln = new ListCoords(d, x + i, y + j, z + k, c + blocklist.size() / 250);
                        blocklist.add(ln);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        lock.unlock();
    }
}

