/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class Fish
extends EntityLiving {
    public Fish(World w) {
        super(w);
        this.maxrenderdist = 160;
        this.height = 0.85f;
        this.width = 0.75f;
        this.uniquename = "DangerZone:Fish";
        this.moveSpeed = 0.175f;
        this.setMaxHealth(1.0f);
        this.setHealth(1.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(0.0f);
        this.movefrequency = 25;
        this.setExperience(1);
        this.canSwim = true;
        this.takesFallDamage = true;
        this.canBreateUnderWater = true;
        this.targetLiquidOnly = true;
        this.daytimespawn = true;
        this.nighttimespawn = false;
        this.daytimedespawn = false;
        this.nighttimedespawn = true;
    }

    @Override
    public String getLivingSound() {
        if (this.world.rand.nextBoolean()) {
            return null;
        }
        return "DangerZone:little_splash";
    }

    @Override
    public String getHurtSound() {
        return "DangerZone:little_splat";
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:little_splat";
    }

    @Override
    public void doDeathDrops() {
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand(this.world, 0, Items.trophyfish.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        Utils.doDropRand(this.world, 0, Items.fishmeat.itemID, 1.5f, this.dimension, this.posx, this.posy, this.posz);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/Fishtexture.png");
        }
        return this.texture;
    }
}

