/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.Explosion;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.entities.EntityLiving;
import org.newdawn.slick.opengl.Texture;

public class EntityExplosiveBlock
extends EntityLiving {
    int exploded_already = 0;

    public EntityExplosiveBlock(World w) {
        super(w);
        this.uniquename = "DangerZone:EntityExplosiveBlock";
        this.width = 0.9f;
        this.height = 0.9f;
        this.moveSpeed = 0.0f;
        this.movefrequency = 5555;
        this.setVarFloat(10, DangerZone.rand.nextInt(100) + 1);
        this.setHealth(1.0f);
        this.setMaxHealth(1.0f);
    }

    @Override
    public void update(float deltaT) {
        if (this.world.isServer) {
            if (Blocks.getMaxStack(this.getBID()) == 0) {
                this.deadflag = true;
            } else {
                this.setVarFloat(11, this.getVarFloat(11) + 1.0f);
                if (this.getVarFloat(11) > this.getVarFloat(10)) {
                    this.exploded_already = 1;
                    Explosion.boom(this, this.world, this.dimension, this.posx, this.posy, this.posz, (int)this.getAttackDamage(), true);
                    this.deadflag = true;
                }
            }
        }
        super.update(deltaT);
    }

    @Override
    public void onDeath() {
        if (this.exploded_already == 0) {
            this.exploded_already = 1;
            Explosion.boom(this, this.world, this.dimension, this.posx, this.posy, this.posz, (int)this.getAttackDamage(), true);
        }
    }

    @Override
    public float getWidth() {
        if (this.getVarFloat(11) == 0.0f) {
            return 1.0f;
        }
        return this.width + this.getVarFloat(11) * this.width * 1.5f / this.getVarFloat(10);
    }

    @Override
    public float getHeight() {
        if (this.getVarFloat(11) == 0.0f) {
            return 1.0f;
        }
        return this.height + this.getVarFloat(11) * this.height * 1.5f / this.getVarFloat(10);
    }

    @Override
    public float getScale() {
        if (this.getVarFloat(11) == 0.0f) {
            return 1.0f;
        }
        return 1.0f + this.getVarFloat(11) * 1.5f / this.getVarFloat(10);
    }

    @Override
    public boolean takesDamageFrom(int dt) {
        return dt != 9;
    }

    @Override
    public Texture getTexture() {
        return null;
    }

    @Override
    public boolean isDying() {
        return false;
    }

    @Override
    public void doDeathAnimation() {
        this.deathfactor = 0.0f;
        this.motionz = 0.0f;
        this.motionx = 0.0f;
        this.motiony = 0.0f;
    }
}

