/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.items.Items;

public class EntityDesk
extends Entity {
    public int blocktries = 0;

    public EntityDesk(World w) {
        super(w);
        this.uniquename = "DangerZone:EntityDesk";
        this.ignoreCollisions = true;
        this.width = 0.01f;
        this.height = 0.01f;
        this.has_inventory = true;
        this.maxrenderdist = 64;
    }

    @Override
    public void update(float deltaT) {
        int bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy, (int)this.posz);
        if (bid != Blocks.desk.blockID && this.world.isServer) {
            ++this.blocktries;
            if (this.blocktries > 20) {
                int ix = 0;
                while (ix < 50) {
                    InventoryContainer ic = this.getInventory(ix);
                    if (ic != null && ic.count > 0) {
                        String icstring = null;
                        icstring = ic.getUniqueName();
                        int iid = Items.findByName(icstring);
                        bid = Blocks.findByName(icstring);
                        int i = 0;
                        while (i < ic.count) {
                            Utils.doDropRand(this.world, bid, iid, 2.0f, this.dimension, this.posx, this.posy, this.posz);
                            ++i;
                        }
                    }
                    ++ix;
                }
                this.world.playSound("DangerZone:pop", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
                this.deadflag = true;
            }
        }
        this.motionz = 0.0f;
        this.motiony = 0.0f;
        this.motionx = 0.0f;
        super.update(deltaT);
    }

    @Override
    public boolean rightClickedByPlayer(Player p, InventoryContainer ic) {
        int bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy, (int)this.posz);
        if (bid != Blocks.desk.blockID) {
            this.deadflag = true;
            return false;
        }
        Blocks.rightClickOnBlock(Blocks.desk.blockID, p, this.dimension, (int)this.posx, (int)this.posy, (int)this.posz);
        return false;
    }
}

