/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.blocks;

import dangerzone.BreakChecks;
import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.StitchedTexture;
import dangerzone.VBOBuffer;
import dangerzone.World;
import dangerzone.WorldRenderer;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import dangerzone.blocks.ModelStand;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlockItem;
import dangerzone.entities.EntityStand;
import dangerzone.threads.VBODataBuilderThread;
import java.util.List;
import java.util.ListIterator;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.opengl.Texture;

public class BlockStand
extends Block {
    public static ModelStand mdl = null;
    private String fulltexturestring = null;
    private Texture fulltexture = null;

    public BlockStand(String n, String flattxt, String txt) {
        super(n, flattxt);
        this.isSolidForRendering = false;
        this.isSolid = false;
        this.hasOwnRenderer = true;
        this.alwaysRender = true;
        this.maxdamage = 5;
        this.burntime = 90;
        this.friction = 0.65f;
        this.fulltexturestring = txt;
        this.breaksound = "DangerZone:woodbreak";
        this.placesound = "DangerZone:woodplace";
        this.hitsound = "DangerZone:woodhit";
        if (mdl == null) {
            mdl = new ModelStand();
        }
    }

    @Override
    public boolean rightClickOnBlock(Player p, int dimension, int x, int y, int z) {
        Entity eb;
        if (p == null || p.world.isServer) {
            return false;
        }
        List<Entity> nearby_list = null;
        EntityStand ec = null;
        nearby_list = DangerZone.entityManager.findEntitiesInRange(2.0f, dimension, x, y, z);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            Entity e = null;
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = li.next();
                if (!(e instanceof EntityStand) || (int)e.posx != x || (int)e.posy != y || (int)e.posz != z) continue;
                ec = (EntityStand)e;
                break;
            }
        }
        if (ec == null && (eb = p.world.createEntityByName("DangerZone:EntityStand", dimension, (double)x + 0.5, (double)y + (double)0.05f, (double)z + 0.5)) != null) {
            eb.init();
            p.world.spawnEntityInWorld(eb);
        }
        return false;
    }

    @Override
    public void onBlockPlaced(World w, int dimension, int x, int y, int z) {
        Entity eb;
        if (w.isServer && (eb = w.createEntityByName("DangerZone:EntityStand", dimension, (double)x + 0.5, (double)y + (double)0.05f, (double)z + 0.5)) != null) {
            eb.init();
            w.spawnEntityInWorld(eb);
        }
    }

    @Override
    public String getStepSound() {
        int i = DangerZone.rand.nextInt(4);
        if (i == 0) {
            return "DangerZone:wood1";
        }
        if (i == 1) {
            return "DangerZone:wood2";
        }
        if (i == 2) {
            return "DangerZone:wood3";
        }
        return "DangerZone:wood4";
    }

    @Override
    public void notifyNeighborChanged(World w, int d, int x, int y, int z) {
        int bid = 0;
        if (!w.isServer) {
            return;
        }
        if (w.getblock(d, x, y, z) != this.blockID) {
            return;
        }
        bid = w.getblock(d, x, y - 1, z);
        if (!Blocks.isSolid(bid)) {
            if (!BreakChecks.canChangeBlock(w, d, x, y, z, d, x, y, z, 0, 0)) {
                return;
            }
            w.setblock(d, x, y, z, 0);
            EntityBlockItem e = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, d, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
            if (e != null) {
                e.fill(this, 1);
                w.spawnEntityInWorld(e);
            }
        }
    }

    @Override
    public boolean doPlaceBlock(int focusbid, Player p, World w, int dimension, int x, int y, int z, int side) {
        if (!Blocks.isSolid(focusbid)) {
            return false;
        }
        if (Blocks.isLeaves(focusbid)) {
            return false;
        }
        if (!Blocks.isSolidThisSide(focusbid, w, dimension, x, y, z, side)) {
            return false;
        }
        if (!BreakChecks.canChangeBlock(p, dimension, x, y, z, this.blockID, 0)) {
            return false;
        }
        if (side != 0) {
            return false;
        }
        w.setblockandmeta(dimension, x, y + 1, z, this.blockID, side << 8);
        this.onBlockPlaced(w, dimension, x, y + 1, z);
        w.playSound(Blocks.getPlaceSound(this.blockID), dimension, x, y, z, 0.5f, 1.0f);
        return true;
    }

    @Override
    public Texture getTexture(int side) {
        if (this.texture == null || this.fulltexture == null) {
            this.texture = this.initBlockTexture(this.texturepath);
            this.fulltexture = this.initBlockTexture(this.fulltexturestring);
        }
        if (side == 5) {
            return this.fulltexture;
        }
        return this.texture;
    }

    @Override
    public String getStitchedTextureName(int side) {
        return this.fulltexturestring;
    }

    @Override
    public void renderMeToVBO(long[] chunkvbos, WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus, int xo, int yo, int zo) {
        VBOBuffer v = null;
        StitchedTexture st = null;
        st = VBODataBuilderThread.findVBOtextureforblockside(5, bid);
        if (st == null) {
            return;
        }
        v = VBODataBuilderThread.findOrMakeVBOForTexture(chunkvbos, st, this.isTranslucent);
        if (v == null) {
            return;
        }
        BlockStand.mdl.stem.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 0);
        BlockStand.mdl.xbase1.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 0);
        BlockStand.mdl.xbase2.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 0);
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < 2) {
                BlockStand.mdl.top.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo + i * 4, yo, zo + j * 4, 0);
                ++j;
            }
            ++i;
        }
        BlockStand.mdl.zbase1.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 0);
        BlockStand.mdl.zbase2.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 0);
        BlockStand.mdl.xbase1a.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 0);
        BlockStand.mdl.xbase2a.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 0);
        BlockStand.mdl.zbase1a.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 0);
        BlockStand.mdl.zbase2a.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 0);
        BlockStand.mdl.frame1.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 0);
        BlockStand.mdl.frame2.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 0);
        BlockStand.mdl.frame4.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 0);
        BlockStand.mdl.frame5.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 0);
        BlockStand.mdl.frame7.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 0);
        BlockStand.mdl.frame8.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 0);
        BlockStand.mdl.frame10.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 0);
        BlockStand.mdl.frame11.renderToVBO(v, st, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb, xo, yo, zo, 0);
    }

    @Override
    public void renderMeHeld(WorldRenderer wr, Entity e, int bid, boolean isdisplay) {
        if (e == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)14.0f, (float)4.0f, (float)0.0f);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
        GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.renderMe(wr, e.world, e.dimension, (int)e.posx, (int)e.posy, (int)e.posz, bid, 256, 0, false);
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        GL11.glPopMatrix();
    }

    @Override
    public void renderMe(WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus) {
        wr.loadtextureforblockside(5, bid, false);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)-8.0f, (float)0.0f);
        BlockStand.mdl.stem.render(1.0f);
        BlockStand.mdl.xbase1.render(1.0f);
        BlockStand.mdl.xbase2.render(1.0f);
        BlockStand.mdl.zbase1.render(1.0f);
        BlockStand.mdl.zbase2.render(1.0f);
        BlockStand.mdl.xbase1a.render(1.0f);
        BlockStand.mdl.xbase2a.render(1.0f);
        BlockStand.mdl.zbase1a.render(1.0f);
        BlockStand.mdl.zbase2a.render(1.0f);
        BlockStand.mdl.frame1.render(1.0f);
        BlockStand.mdl.frame2.render(1.0f);
        BlockStand.mdl.frame4.render(1.0f);
        BlockStand.mdl.frame5.render(1.0f);
        BlockStand.mdl.frame7.render(1.0f);
        BlockStand.mdl.frame8.render(1.0f);
        BlockStand.mdl.frame10.render(1.0f);
        BlockStand.mdl.frame11.render(1.0f);
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < 2) {
                BlockStand.mdl.top.render(1.0f);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-4.0f);
                ++j;
            }
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)8.0f);
            GL11.glTranslatef((float)4.0f, (float)0.0f, (float)0.0f);
            ++i;
        }
        GL11.glTranslatef((float)-8.0f, (float)0.0f, (float)0.0f);
        GL11.glPopMatrix();
    }
}

