/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.blocks;

import dangerzone.BreakChecks;
import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.ServerHooker;
import dangerzone.StitchedTexture;
import dangerzone.TextureMapper;
import dangerzone.ToDoList;
import dangerzone.World;
import dangerzone.WorldRenderer;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlockItem;
import dangerzone.entities.EntityLiving;
import dangerzone.gui.InventoryMenus;
import java.util.List;
import java.util.ListIterator;
import org.newdawn.slick.opengl.Texture;

public class Block {
    public int blockID = 0;
    public String texturepath;
    public String uniquename;
    public int maxstack = 64;
    public Texture texture = null;
    public StitchedTexture stitchedtexture = new StitchedTexture();
    public boolean randomtick = false;
    public boolean alwaystick = false;
    public boolean hasOwnRenderer = false;
    public boolean isSolidForRendering = true;
    public boolean renderAllSides = false;
    public boolean alwaysRender = false;
    public boolean renderSmaller = false;
    public boolean isTranslucent = false;
    public boolean isSolid = true;
    public boolean isLiquid = false;
    public boolean isSquishy = false;
    public String breaksound = null;
    public String placesound = null;
    public String hitsound = null;
    public boolean isWood = false;
    public boolean canLeavesGrow = false;
    public boolean isLeaves = false;
    public boolean isStone = false;
    public boolean isDirt = false;
    public boolean isWaterPlant = false;
    public boolean showInInventory = true;
    public int menu = InventoryMenus.GENERIC;
    public int maxdamage = 20;
    public float friction = 0.02f;
    public float brightness = 0.0f;
    public String particlename = null;
    public int mindamage = 0;
    public boolean hasFront = false;
    public int burntime = 0;
    public boolean showTop = false;
    public Block active_partner = null;
    public Block static_partner = null;

    public Block(String n, String txt) {
        this.texturepath = txt;
        this.uniquename = n;
        this.breaksound = "DangerZone:blockbreak";
        this.placesound = "DangerZone:blockplace";
        this.hitsound = "DangerZone:blockhit";
        this.maxstack = 64;
        this.maxdamage = 20;
    }

    public String getBreakSound() {
        return this.breaksound;
    }

    public String getPlaceSound() {
        return this.placesound;
    }

    public String getHitSound() {
        return this.hitsound;
    }

    public String getStepSound() {
        int i = DangerZone.rand.nextInt(3);
        if (i == 0) {
            return "DangerZone:stone1";
        }
        if (i == 1) {
            return "DangerZone:stone2";
        }
        return "DangerZone:stone3";
    }

    public String getParticleName() {
        return this.particlename;
    }

    public void tickMe(World w, int d, int x, int y, int z) {
    }

    public void inUseTick(Entity e, InventoryContainer ic, int invindex) {
    }

    public void onCrafted(Player p, InventoryContainer ic) {
    }

    public void inventoryTick(Entity e, InventoryContainer ic, int invindex) {
    }

    public void tickMeFast(World w, int d, int x, int y, int z) {
    }

    public void notifyNeighborChanged(World w, int d, int x, int y, int z) {
    }

    public float getBrightness(World w, int d, int x, int y, int z) {
        return this.brightness;
    }

    public void renderMe(WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int side, boolean focused) {
    }

    public void renderMeToVBO(long[] chunkvbos, WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int side, boolean focused, int xo, int yo, int zo) {
    }

    public void renderMeHeld(WorldRenderer wr, Entity e, int bid, boolean isdisplay) {
        if (e == null) {
            return;
        }
        this.renderMe(wr, e.world, e.dimension, (int)e.posx, (int)e.posy, (int)e.posz, bid, 0, 0, false);
    }

    public Texture getTexture(int side) {
        if (this.texture == null) {
            this.texture = this.initBlockTexture(this.texturepath);
        }
        return this.texture;
    }

    public StitchedTexture getStitchedTexture(int side) {
        return this.stitchedtexture;
    }

    public String getStitchedTextureName(int side) {
        return this.texturepath;
    }

    public boolean rightClickOnBlock(Player p, int dimension, int x, int y, int z) {
        if (p != null && p.world.isServer) {
            ServerHooker.rightClickOnBlock(p, dimension, x, y, z);
        }
        return true;
    }

    public boolean getIsSolid(World w, int d, int x, int y, int z) {
        return this.isSolid;
    }

    public boolean isSolidThisSide(World w, int d, int x, int y, int z, int side) {
        return this.isSolid;
    }

    public void bumpedBlock(Entity e, World w, int d, int x, int y, int z) {
    }

    public void entityInLiquid(Entity e) {
    }

    public boolean leftClickOnBlock(Player p, int dimension, int x, int y, int z) {
        if (p != null && p.world.isServer) {
            ServerHooker.leftClickOnBlock(p, dimension, x, y, z);
        }
        return true;
    }

    public void onBlockBroken(Player p, int dimension, int x, int y, int z) {
        ServerHooker.onBlockBroken(p, dimension, x, y, z);
    }

    public void onBlockPlaced(World w, int dimension, int x, int y, int z) {
    }

    public int getBlockDrop(Player p, World w, int dimension, int x, int y, int z) {
        return this.blockID;
    }

    public int getItemDrop(Player p, World w, int dimension, int x, int y, int z) {
        return 0;
    }

    public int getDropCount(Player p, World w, int dimension, int x, int y, int z) {
        return 1;
    }

    public void doSteppedOn(Entity e, World w, int d, int x, int y, int z) {
    }

    public void doIsIn(Entity e, World w, int d, int x, int y, int z) {
    }

    public void doEntered(Entity e, World w, int d, int x, int y, int z) {
    }

    public Texture initBlockTexture(String tp) {
        return TextureMapper.getTexture(tp);
    }

    public boolean onLeftClick(Entity holder, Entity clickedon, InventoryContainer ic) {
        return true;
    }

    public boolean onRightClick(Entity holder, Entity clickedon, InventoryContainer ic) {
        return false;
    }

    public void onFoodEaten(Entity e) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean doPlaceBlock(int focusbid, Player p, World w, int dimension, int x, int y, int z, int side) {
        int meta = 0;
        int newbid = 0;
        int newx = x;
        int newy = y;
        int newz = z;
        if (this.hasFront && p != null) {
            double dx = (double)((float)x + 0.5f) - p.posx;
            double dz = (double)((float)z + 0.5f) - p.posz;
            meta = Math.abs(dx) > Math.abs(dz) ? (dx > 0.0 ? 12288 : 4096) : (dz > 0.0 ? 8192 : 0);
        }
        if (!Blocks.isSquishy(focusbid) && (Blocks.isLiquid(focusbid) || Blocks.isLeaves(focusbid) && !Blocks.isLeaves(this.blockID) || !Blocks.isSolid(focusbid, w, dimension, x, y, z) || !Blocks.isSolidThisSide(focusbid, w, dimension, x, y, z, side))) {
            EntityBlockItem eb;
            if (this.entityInBlock(w, dimension, x, y, z)) {
                return false;
            }
            if (!BreakChecks.canChangeBlock(p, dimension, x, y, z, this.blockID, meta)) return false;
            int bbid = Blocks.getBlockDrop(focusbid, p, w, dimension, x, y, z);
            int biid = Blocks.getItemDrop(focusbid, p, w, dimension, x, y, z);
            w.setblockandmeta(dimension, x, y, z, this.blockID, meta);
            this.onBlockPlaced(w, dimension, x, y, z);
            if (w.isServer && p != null) {
                ++p.blocks_placed;
                ++p.blocks_broken;
                if (p.server_thread != null) {
                    p.server_thread.sendStatsToPlayer();
                }
                ToDoList.onPlaced(p, dimension, x, y, z, this.blockID);
            }
            if (bbid > 0 && (eb = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, dimension, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5)) != null) {
                eb.fill(bbid, 0, 1);
                w.spawnEntityInWorld(eb);
            }
            if (biid > 0 && (eb = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, dimension, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5)) != null) {
                eb.fill(0, biid, 1);
                w.spawnEntityInWorld(eb);
            }
        } else {
            switch (side) {
                case 0: {
                    ++newy;
                    break;
                }
                case 1: {
                    ++newz;
                    break;
                }
                case 2: {
                    --newz;
                    break;
                }
                case 3: {
                    --newx;
                    break;
                }
                case 4: {
                    ++newx;
                    break;
                }
                case 5: {
                    --newy;
                }
            }
            if (this.entityInBlock(w, dimension, newx, newy, newz)) {
                return false;
            }
            if (!BreakChecks.canChangeBlock(p, dimension, newx, newy, newz, this.blockID, meta)) {
                return false;
            }
            newbid = w.getblock(dimension, newx, newy, newz);
            if (newbid != 0) {
                EntityBlockItem eb;
                if (Blocks.isSquishy(newbid) || !Blocks.isLiquid(newbid) && (!Blocks.isLeaves(newbid) || Blocks.isLeaves(this.blockID)) && Blocks.isSolid(newbid, w, dimension, newx, newy, newz)) return false;
                int bbid = Blocks.getBlockDrop(newbid, p, w, dimension, newx, newy, newz);
                int biid = Blocks.getItemDrop(newbid, p, w, dimension, newx, newy, newz);
                w.setblockandmeta(dimension, newx, newy, newz, this.blockID, meta);
                this.onBlockPlaced(w, dimension, newx, newy, newz);
                if (p != null) {
                    ++p.blocks_broken;
                }
                if (bbid > 0 && (eb = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, dimension, (double)newx + 0.5, (double)newy + 0.5, (double)newz + 0.5)) != null) {
                    eb.fill(bbid, 0, 1);
                    w.spawnEntityInWorld(eb);
                }
                if (biid > 0 && (eb = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, dimension, (double)newx + 0.5, (double)newy + 0.5, (double)newz + 0.5)) != null) {
                    eb.fill(0, biid, 1);
                    w.spawnEntityInWorld(eb);
                }
            } else {
                w.setblockandmeta(dimension, newx, newy, newz, this.blockID, meta);
                this.onBlockPlaced(w, dimension, newx, newy, newz);
            }
            if (w.isServer && p != null) {
                ++p.blocks_placed;
                if (p.server_thread != null) {
                    p.server_thread.sendStatsToPlayer();
                }
                ToDoList.onPlaced(p, dimension, newx, newy, newz, this.blockID);
            }
        }
        w.playSound(Blocks.getPlaceSound(this.blockID), dimension, newx, newy, newz, 0.25f, 1.0f);
        return true;
    }

    private boolean entityInBlock(World w, int d, int x, int y, int z) {
        List<Entity> nearby_list = null;
        nearby_list = w.isServer ? DangerZone.server.entityManager.findEntitiesInRange(16.0f, d, x, y, z) : DangerZone.entityManager.findEntitiesInRange(16.0f, d, x, y, z);
        if (nearby_list != null) {
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                Entity e = li.next();
                if (e.canthitme || e.ignoreCollisions) continue;
                if (x == (int)e.posx && y == (int)e.posy && z == (int)e.posz) {
                    return true;
                }
                if (!(e instanceof EntityLiving)) continue;
                EntityLiving el = (EntityLiving)e;
                int intheight = (int)(el.getHeight() + 0.995f);
                int k = 0;
                while (k < intheight) {
                    double dz;
                    double dx;
                    if ((int)el.posy + k == y && Math.sqrt((dx = el.posx - ((double)x + 0.5)) * dx + (dz = el.posz - ((double)z + 0.5)) * dz) < (double)(0.5f + el.getWidth() / 2.0f)) {
                        return true;
                    }
                    ++k;
                }
            }
        }
        return false;
    }
}

