/*
 * Decompiled with CFR 0.152.
 */
package dangerzone;

import dangerzone.Chunk;
import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.ServerHooks;
import dangerzone.SpawnlistEntry;
import dangerzone.World;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;

public class ServerHooker {
    public static ServerHooks[] ServerHooksArray = null;
    public static final int ServerHooksMAX = 64;

    ServerHooker() {
    }

    public static Player getNewPlayerObject(World w) {
        if (ServerHooksArray == null) {
            return new Player(w);
        }
        Player p = null;
        int i = 0;
        while (i < 64) {
            if (ServerHooksArray[i] != null && (p = ServerHooksArray[i].getNewPlayerObject(w)) != null) {
                return p;
            }
            ++i;
        }
        return new Player(w);
    }

    public static void registerServerHooks(ServerHooks b) {
        int i;
        if (ServerHooksArray == null) {
            ServerHooksArray = new ServerHooks[64];
            i = 0;
            while (i < 64) {
                ServerHooker.ServerHooksArray[i] = null;
                ++i;
            }
        }
        i = 0;
        while (i < 64) {
            if (ServerHooksArray[i] == null) {
                ServerHooker.ServerHooksArray[i] = b;
                return;
            }
            ++i;
        }
    }

    public static boolean player_logged_in(Player p) {
        if (ServerHooksArray == null) {
            return true;
        }
        int i = 0;
        while (i < 64) {
            if (ServerHooksArray[i] != null && !ServerHooksArray[i].player_logged_in(p)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean player_login_respawn(Player p, boolean respawn) {
        if (ServerHooksArray == null) {
            return respawn;
        }
        int i = 0;
        while (i < 64) {
            if (ServerHooksArray[i] != null && ServerHooksArray[i].player_login_respawn(p, respawn) != respawn) {
                return !respawn;
            }
            ++i;
        }
        return respawn;
    }

    public static boolean player_load(Player p) {
        if (ServerHooksArray == null) {
            return DangerZone.server.loadPlayer(p);
        }
        boolean isnew = DangerZone.server.loadPlayer(p);
        int i = 0;
        while (i < 64) {
            if (ServerHooksArray[i] != null) {
                ServerHooksArray[i].player_load(p, isnew);
            }
            ++i;
        }
        return isnew;
    }

    public static boolean player_always_connect(Player p) {
        if (ServerHooksArray == null) {
            return false;
        }
        int i = 0;
        while (i < 64) {
            if (ServerHooksArray[i] != null && ServerHooksArray[i].player_always_connect(p)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void player_save(Player p) {
        if (ServerHooksArray == null) {
            DangerZone.server.saveThisPlayer(p);
            return;
        }
        DangerZone.server.saveThisPlayer(p);
        int i = 0;
        while (i < 64) {
            if (ServerHooksArray[i] != null) {
                ServerHooksArray[i].player_save(p);
            }
            ++i;
        }
    }

    public static void player_logged_out(Player p) {
        if (ServerHooksArray == null) {
            return;
        }
        int i = 0;
        while (i < 64) {
            if (ServerHooksArray[i] != null) {
                ServerHooksArray[i].player_logged_out(p);
            }
            ++i;
        }
    }

    public static boolean player_died(Player p) {
        if (ServerHooksArray == null) {
            return true;
        }
        boolean retval = true;
        int i = 0;
        while (i < 64) {
            if (ServerHooksArray[i] != null && !ServerHooksArray[i].player_died(p)) {
                retval = false;
            }
            ++i;
        }
        return retval;
    }

    public static boolean critter_died(EntityLiving e) {
        if (ServerHooksArray == null) {
            return true;
        }
        boolean retval = true;
        int i = 0;
        while (i < 64) {
            if (ServerHooksArray[i] != null && !ServerHooksArray[i].critter_died(e)) {
                retval = false;
            }
            ++i;
        }
        return retval;
    }

    public static boolean player_respawned(Player p) {
        if (ServerHooksArray == null) {
            return true;
        }
        boolean retval = true;
        int i = 0;
        while (i < 64) {
            if (ServerHooksArray[i] != null && !ServerHooksArray[i].player_respawned(p)) {
                retval = false;
            }
            ++i;
        }
        return retval;
    }

    public static boolean player_teleport(Player p, int d, double x, double y, double z) {
        if (ServerHooksArray == null) {
            return true;
        }
        boolean retval = true;
        int i = 0;
        while (i < 64) {
            if (ServerHooksArray[i] != null && !ServerHooksArray[i].player_teleport(p, d, x, y, z)) {
                retval = false;
            }
            ++i;
        }
        return retval;
    }

    public static void entity_loop_start(float deltaT) {
        if (ServerHooksArray == null) {
            return;
        }
        int i = 0;
        while (i < 64) {
            if (ServerHooksArray[i] != null) {
                ServerHooksArray[i].entity_loop_start(deltaT);
            }
            ++i;
        }
    }

    public static void player_entity_loop_start(Player p) {
        if (ServerHooksArray == null) {
            return;
        }
        int i = 0;
        while (i < 64) {
            if (ServerHooksArray[i] != null) {
                ServerHooksArray[i].player_entity_loop_start(p);
            }
            ++i;
        }
    }

    public static void entity_action(Entity e, float deltaT) {
        if (ServerHooksArray == null) {
            return;
        }
        int i = 0;
        while (i < 64) {
            if (ServerHooksArray[i] != null) {
                ServerHooksArray[i].entity_action(e, deltaT);
            }
            ++i;
        }
    }

    public static void onBlockBroken(Player p, int d, int x, int y, int z) {
        if (ServerHooksArray == null) {
            return;
        }
        int i = 0;
        while (i < 64) {
            if (ServerHooksArray[i] != null) {
                ServerHooksArray[i].onBlockBroken(p, d, x, y, z);
            }
            ++i;
        }
    }

    public static void leftClickOnBlock(Player p, int d, int x, int y, int z) {
        if (ServerHooksArray == null) {
            return;
        }
        int i = 0;
        while (i < 64) {
            if (ServerHooksArray[i] != null) {
                ServerHooksArray[i].leftClickOnBlock(p, d, x, y, z);
            }
            ++i;
        }
    }

    public static void rightClickOnBlock(Player p, int d, int x, int y, int z) {
        if (ServerHooksArray == null) {
            return;
        }
        int i = 0;
        while (i < 64) {
            if (ServerHooksArray[i] != null) {
                ServerHooksArray[i].rightClickOnBlock(p, d, x, y, z);
            }
            ++i;
        }
    }

    public static boolean clickedHotBar(Player p, int which, int leftrightmid, boolean shifted) {
        if (ServerHooksArray == null) {
            return true;
        }
        boolean retval = true;
        int i = 0;
        while (i < 64) {
            if (ServerHooksArray[i] != null && !ServerHooksArray[i].clickedHotBar(p, which, leftrightmid, shifted)) {
                retval = false;
            }
            ++i;
        }
        return retval;
    }

    public static boolean clickedArmor(Player p, int which, int leftrightmid, boolean shifted) {
        if (ServerHooksArray == null) {
            return true;
        }
        boolean retval = true;
        int i = 0;
        while (i < 64) {
            if (ServerHooksArray[i] != null && !ServerHooksArray[i].clickedArmor(p, which, leftrightmid, shifted)) {
                retval = false;
            }
            ++i;
        }
        return retval;
    }

    public static boolean clickedInventory(Player p, int which, int leftrightmid, boolean shifted) {
        if (ServerHooksArray == null) {
            return true;
        }
        boolean retval = true;
        int i = 0;
        while (i < 64) {
            if (ServerHooksArray[i] != null && !ServerHooksArray[i].clickedInventory(p, which, leftrightmid, shifted)) {
                retval = false;
            }
            ++i;
        }
        return retval;
    }

    public static boolean clickedEntityInventory(Player p, int eid, int which, int leftrightmid, boolean shifted) {
        if (ServerHooksArray == null) {
            return true;
        }
        boolean retval = true;
        int i = 0;
        while (i < 64) {
            if (ServerHooksArray[i] != null && !ServerHooksArray[i].clickedEntityInventory(p, eid, which, leftrightmid, shifted)) {
                retval = false;
            }
            ++i;
        }
        return retval;
    }

    public static boolean doAttackFrom(EntityLiving e, Entity attckr, int dt, float pain) {
        if (ServerHooksArray == null) {
            return true;
        }
        boolean retval = true;
        int i = 0;
        while (i < 64) {
            if (ServerHooksArray[i] != null && !ServerHooksArray[i].doAttackFrom(e, attckr, dt, pain)) {
                retval = false;
            }
            ++i;
        }
        return retval;
    }

    public static boolean canClaimHere(Player p, int d, int x, int y, int z) {
        if (ServerHooksArray == null) {
            return true;
        }
        int i = 0;
        while (i < 64) {
            if (ServerHooksArray[i] != null && !ServerHooksArray[i].canClaimHere(p, d, x, y, z)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean canSpawnHere(World w, int d, int x, int z, SpawnlistEntry st) {
        if (ServerHooksArray == null) {
            return true;
        }
        int i = 0;
        while (i < 64) {
            if (ServerHooksArray[i] != null && !ServerHooksArray[i].canSpawnHere(w, d, x, z, st)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Entity spawnEntityByName(String name, World w, int d, double x, double y, double z) {
        Entity e = null;
        if (ServerHooksArray == null) {
            return e;
        }
        int i = 0;
        while (i < 64) {
            if (ServerHooksArray[i] != null && (e = ServerHooksArray[i].spawnEntityByName(name, w, d, x, y, z)) != null) break;
            ++i;
        }
        return e;
    }

    public static void tickChunk(Player p, World w, Chunk c) {
        if (ServerHooksArray == null) {
            return;
        }
        int i = 0;
        while (i < 64) {
            if (ServerHooksArray[i] != null) {
                ServerHooksArray[i].tickChunk(p, w, c);
            }
            ++i;
        }
    }
}

