/*
 * Decompiled with CFR 0.152.
 */
package dangerzone;

import dangerzone.CreatureTypes;
import dangerzone.DangerZone;
import dangerzone.ListCoords;
import dangerzone.Player;
import dangerzone.World;
import dangerzone.biomes.Biome;
import dangerzone.biomes.BiomeManager;
import dangerzone.entities.Entities;
import dangerzone.entities.Entity;
import dangerzone.threads.SpawnerThread;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Chunk {
    public int chunkX;
    public int chunkZ;
    public int dimension;
    public int isDecorated;
    public short[][] blockdata = null;
    public short[][] metadata = null;
    public int isChanged;
    public int isValid = 0;
    public int must_be_written = 0;
    private int chunkDiskVersion = 105;
    public short[] drawn = null;
    public short[][] lightmap = null;
    public volatile long[] VBOids = null;
    public boolean amGenerating = false;
    public boolean amDecorating = false;
    public List<ListCoords> tickblocks = null;
    public int redraw = 0;
    public Biome mybiome = null;
    public float b_red;
    public float b_green;
    public float b_blue;
    public List<String> ownernames = null;
    private Lock rwlock = new ReentrantLock();

    public Chunk(int d, int x, int y, int z) {
        this.blockdata = new short[256][];
        this.metadata = new short[256][];
        this.drawn = new short[256];
        this.chunkX = x >> 4;
        this.chunkZ = z >> 4;
        this.isDecorated = 0;
        this.isChanged = 0;
        this.dimension = d;
        int i = 0;
        while (i < 256) {
            this.blockdata[i] = null;
            this.metadata[i] = null;
            this.drawn[i] = 1;
            ++i;
        }
        this.isValid = 0;
        this.VBOids = new long[20];
        this.amGenerating = false;
        this.amDecorating = false;
        this.tickblocks = null;
        this.ownernames = null;
        this.redraw = 1;
        this.b_blue = 1.0f;
        this.b_green = 1.0f;
        this.b_red = 1.0f;
    }

    public int getblock(int x, int y, int z) {
        int i = x & 0xF;
        int j = y & 0xFF;
        int k = z & 0xF;
        if (this.blockdata[j] == null) {
            return 0;
        }
        return this.blockdata[j][i * 16 + k] & 0xFFFF;
    }

    public int getblockmeta(int x, int y, int z) {
        int i = x & 0xF;
        int j = y & 0xFF;
        int k = z & 0xF;
        if (this.metadata[j] == null) {
            return 0;
        }
        return this.metadata[j][i * 16 + k] & 0xFFFF;
    }

    public void setowners(List<String> newowners) {
        this.ownernames = newowners;
        this.isChanged = 1;
        this.must_be_written = 1;
    }

    public void setblock(int x, int y, int z, int type) {
        if (DangerZone.freeze_world) {
            return;
        }
        int i = x & 0xF;
        int j = y & 0xFF;
        int k = z & 0xF;
        this.tickblocks = null;
        if (this.blockdata[j] == null) {
            if (type == 0) {
                return;
            }
            this.blockdata[j] = new short[256];
        }
        this.drawn[j] = 1;
        this.drawn[j + 1 & 0xFF] = 1;
        this.drawn[j - 1 & 0xFF] = 1;
        short d = this.blockdata[j][i * 16 + k];
        this.blockdata[j][i * 16 + k] = (short)(type & 0xFFFF);
        if (d != type) {
            this.isChanged = 1;
            this.must_be_written = 1;
        }
    }

    public void setblockmeta(int x, int y, int z, int meta) {
        if (DangerZone.freeze_world) {
            return;
        }
        int i = x & 0xF;
        int j = y & 0xFF;
        int k = z & 0xF;
        if (this.metadata[j] == null) {
            if (meta == 0) {
                return;
            }
            this.metadata[j] = new short[256];
        }
        this.drawn[j] = 1;
        this.drawn[j + 1 & 0xFF] = 1;
        this.drawn[j - 1 & 0xFF] = 1;
        short d = this.metadata[j][i * 16 + k];
        this.metadata[j][i * 16 + k] = (short)(meta & 0xFFFF);
        if (d != meta) {
            this.isChanged = 1;
            this.must_be_written = 1;
        }
    }

    public void generate(World w, int d, int x, int y, int z) {
        if (DangerZone.freeze_world) {
            this.isValid = 1;
            return;
        }
        if (this.isValid != 0 || this.isDecorated != 0 || this.amGenerating) {
            return;
        }
        BiomeManager bm = null;
        this.amGenerating = true;
        this.chunkX = x >> 4;
        this.chunkZ = z >> 4;
        this.dimension = d;
        this.isChanged = 0;
        bm = w.getBiomeManager(d, x, y, z);
        if (bm != null) {
            this.mybiome = bm.getBiomeForChunk(null, d, x, y, z);
            if (this.mybiome != null) {
                bm.generate(w, d, this.mybiome, this, this.chunkX, this.chunkZ);
                this.b_red = this.mybiome.mul_red;
                this.b_green = this.mybiome.mul_green;
                this.b_blue = this.mybiome.mul_blue;
            }
        }
        this.isChanged = 0;
        this.isDecorated = 0;
        this.isValid = 1;
        this.must_be_written = 1;
        this.amGenerating = false;
    }

    public void decorate(World w, int d, int x, int y, int z) {
        if (DangerZone.freeze_world) {
            this.isDecorated = 1;
            return;
        }
        if (this.isValid == 0 || this.isDecorated != 0 || this.amDecorating) {
            return;
        }
        this.amDecorating = true;
        if (this.mybiome == null) {
            this.mybiome = w.getBiome(d, x, y, z);
        }
        if (this.mybiome != null) {
            w.decorate(w, d, this.mybiome, this.chunkX, this.chunkZ);
            this.mybiome.decorate(w, d, this, this.chunkX, this.chunkZ);
        }
        SpawnerThread.doSpawnChunk(this, w, d, x, z, CreatureTypes.PERMANENT);
        this.isDecorated = 1;
        this.must_be_written = 1;
        DangerZone.server.flushAll();
        this.amDecorating = false;
    }

    public void saveToDisk(boolean remove_entities) {
        int i;
        String filepath = new String();
        File f = null;
        FileOutputStream os = null;
        BufferedOutputStream bos = null;
        ObjectOutputStream oos = null;
        this.rwlock.lock();
        if (this.must_be_written != 0) {
            int separator = -1;
            filepath = String.format("worlds/%s/Dimension-%d/%2x/%d_%d.dat", DangerZone.worldname, this.dimension, this.chunkX + this.chunkZ & 0xFF, this.chunkX, this.chunkZ);
            f = new File(filepath);
            f.getParentFile().mkdirs();
            try {
                os = new FileOutputStream(filepath);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            bos = new BufferedOutputStream(os, 16000);
            try {
                oos = new ObjectOutputStream(bos);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                oos.writeInt(this.chunkDiskVersion);
                if (this.ownernames == null) {
                    oos.writeInt(0);
                } else {
                    int olen = this.ownernames.size();
                    String owner = null;
                    oos.writeInt(olen);
                    int j = 0;
                    while (j < olen) {
                        owner = this.ownernames.get(j);
                        int ilen = owner.length();
                        oos.writeInt(ilen);
                        i = 0;
                        while (i < ilen) {
                            oos.writeChar(owner.charAt(i));
                            ++i;
                        }
                        ++j;
                    }
                }
                oos.writeInt(this.chunkX);
                oos.writeInt(this.chunkZ);
                oos.writeInt(this.dimension);
                oos.writeInt(this.isDecorated);
                this.isChanged = 0;
                oos.writeInt(this.isChanged);
                oos.writeInt(this.isValid);
                this.must_be_written = 0;
                oos.writeInt(this.must_be_written);
                oos.writeFloat(this.b_red);
                oos.writeFloat(this.b_green);
                oos.writeFloat(this.b_blue);
                oos.writeInt(separator);
                i = 0;
                while (i < 256) {
                    if (this.blockdata[i] != null) {
                        oos.writeInt(i);
                        short curval = this.blockdata[i][0];
                        int curcount = 0;
                        int indx = 0;
                        while (indx < 256) {
                            if (this.blockdata[i][indx] == curval) {
                                curcount = (short)(curcount + 1);
                            } else {
                                oos.writeShort(curcount);
                                oos.writeShort(curval);
                                curcount = 1;
                                curval = this.blockdata[i][indx];
                            }
                            indx = (short)(indx + 1);
                        }
                        oos.writeShort(curcount);
                        oos.writeShort(curval);
                    }
                    ++i;
                }
                oos.writeInt(separator);
                i = 0;
                while (i < 256) {
                    if (this.metadata[i] != null) {
                        oos.writeInt(i);
                        oos.writeObject(this.metadata[i]);
                    }
                    ++i;
                }
                oos.writeInt(separator);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                oos.flush();
                oos.close();
                bos.flush();
                bos.close();
                os.flush();
                os.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        boolean eic = DangerZone.server.entityManager.areEntitiesInChunk(this.dimension, this.chunkX, this.chunkZ);
        filepath = String.format("worlds/%s/Dimension-%d/%2x/%d_%d.properties", DangerZone.worldname, this.dimension, this.chunkX + this.chunkZ & 0xFF, this.chunkX, this.chunkZ);
        f = new File(filepath);
        f.getParentFile().mkdirs();
        f.delete();
        if (!eic) {
            this.rwlock.unlock();
            return;
        }
        Properties prop = new Properties();
        OutputStream output = null;
        try {
            Entity[] entlist = DangerZone.server.entityManager.getEntitiesInChunk(this.dimension, this.chunkX, this.chunkZ);
            int elen = entlist.length;
            if (elen > 0) {
                output = new FileOutputStream(filepath);
                bos = new BufferedOutputStream(output, 16000);
                int entcount = 0;
                i = 0;
                while (i < elen) {
                    if (entlist[i] != null) {
                        if (!(entlist[i] instanceof Player)) {
                            String s = String.format("Entity_%d:", entcount);
                            prop.setProperty(String.format("%s%s", s, "uniquename"), entlist[i].uniquename);
                            if (remove_entities) {
                                entlist[i].de_init();
                            }
                            entlist[i].writeSelf(prop, s);
                            ++entcount;
                        }
                        if (remove_entities) {
                            DangerZone.server.entityManager.removeEntityByID(entlist[i].entityID);
                            DangerZone.server.sendEntityRemoveToAll(entlist[i]);
                        }
                    }
                    ++i;
                }
                prop.store(bos, null);
            }
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        if (output != null) {
            try {
                bos.flush();
                bos.close();
                output.flush();
                ((FileOutputStream)output).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.rwlock.unlock();
    }

    public boolean readFromDisk() {
        int separator;
        int ondiskversion;
        BufferedInputStream bos;
        ObjectInputStream oos;
        FileInputStream os;
        String filepath;
        block47: {
            block46: {
                filepath = new String();
                filepath = String.format("worlds/%s/Dimension-%d/%2x/%d_%d.dat", DangerZone.worldname, this.dimension, this.chunkX + this.chunkZ & 0xFF, this.chunkX, this.chunkZ);
                os = null;
                oos = null;
                bos = null;
                this.rwlock.lock();
                try {
                    os = new FileInputStream(filepath);
                }
                catch (FileNotFoundException e) {
                    this.rwlock.unlock();
                    return false;
                }
                bos = new BufferedInputStream(os, 32000);
                try {
                    oos = new ObjectInputStream(bos);
                }
                catch (FileNotFoundException e) {
                    try {
                        bos.close();
                        os.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    this.rwlock.unlock();
                    return false;
                }
                catch (IOException e) {
                    try {
                        bos.close();
                        os.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    this.rwlock.unlock();
                    return false;
                }
                ondiskversion = oos.readInt();
                if (ondiskversion >= 101 && ondiskversion <= 105) break block46;
                System.out.printf("Unknown chunk file format version!\n", new Object[0]);
                oos.close();
                bos.close();
                os.close();
                this.rwlock.unlock();
                return false;
            }
            if (ondiskversion >= 104) {
                this.ownernames = null;
                int olen = oos.readInt();
                String owner = null;
                if (olen > 0) {
                    this.ownernames = new ArrayList<String>();
                    while (olen > 0) {
                        int ilen = oos.readInt();
                        if (ilen > 0) {
                            owner = "";
                            while (ilen > 0) {
                                owner = String.valueOf(owner) + oos.readChar();
                                --ilen;
                            }
                            this.ownernames.add(owner);
                        }
                        --olen;
                    }
                }
            }
            this.chunkX = oos.readInt();
            this.chunkZ = oos.readInt();
            this.dimension = oos.readInt();
            this.isDecorated = oos.readInt();
            this.isChanged = oos.readInt();
            this.isValid = oos.readInt();
            this.must_be_written = oos.readInt();
            if (ondiskversion >= 105) {
                this.b_red = oos.readFloat();
                this.b_green = oos.readFloat();
                this.b_blue = oos.readFloat();
            }
            if ((separator = oos.readInt()) == -1) break block47;
            System.out.printf("Big oops!\n", new Object[0]);
            oos.close();
            bos.close();
            os.close();
            this.rwlock.unlock();
            return false;
        }
        try {
            int indx;
            int curcount;
            if (ondiskversion == 101) {
                while ((separator = oos.readInt()) >= 0) {
                    this.blockdata[separator] = (short[])oos.readObject();
                }
            } else if (ondiskversion == 102) {
                while ((separator = oos.readInt()) >= 0) {
                    this.blockdata[separator] = new short[256];
                    curcount = oos.readInt();
                    int curval = oos.readInt();
                    indx = 0;
                    while (indx < 256) {
                        this.blockdata[separator][indx] = (short)(curval & 0xFFFF);
                        if (indx < 255 && --curcount == 0) {
                            curcount = oos.readInt();
                            curval = oos.readInt();
                        }
                        ++indx;
                    }
                }
            } else {
                while ((separator = oos.readInt()) >= 0) {
                    this.blockdata[separator] = new short[256];
                    curcount = oos.readShort();
                    short curval = oos.readShort();
                    indx = 0;
                    while (indx < 256) {
                        this.blockdata[separator][indx] = (short)(curval & 0xFFFF);
                        curcount = (short)(curcount - 1);
                        if (indx < 255 && curcount == 0) {
                            curcount = oos.readShort();
                            curval = oos.readShort();
                        }
                        indx = (short)(indx + 1);
                    }
                }
            }
            while ((separator = oos.readInt()) >= 0) {
                this.metadata[separator] = (short[])oos.readObject();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                oos.close();
                bos.close();
                os.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.rwlock.unlock();
            return false;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            try {
                oos.close();
                bos.close();
                os.close();
            }
            catch (IOException ez) {
                ez.printStackTrace();
            }
            this.rwlock.unlock();
            return false;
        }
        try {
            oos.close();
            bos.close();
            os.close();
            bos = null;
            oos = null;
            os = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Properties prop = new Properties();
        FileInputStream input = null;
        filepath = String.format("worlds/%s/Dimension-%d/%2x/%d_%d.properties", DangerZone.worldname, this.dimension, this.chunkX + this.chunkZ & 0xFF, this.chunkX, this.chunkZ);
        try {
            input = new FileInputStream(filepath);
            bos = new BufferedInputStream(input, 16000);
            prop.load(bos);
        }
        catch (IOException ex) {
            this.rwlock.unlock();
            return true;
        }
        int entcount = 0;
        while (true) {
            String s = String.format("Entity_%d:", entcount);
            if ((s = prop.getProperty(String.format("%s%s", s, "uniquename"))) == null) break;
            this.must_be_written = 1;
            Entity ent = Entities.spawnEntityByName(s, DangerZone.server_world);
            if (ent != null) {
                s = String.format("Entity_%d:", entcount);
                ent.readSelf(prop, s);
                ent.init();
                if (DangerZone.server.entityManager.addEntity(ent) > 0) {
                    DangerZone.server.sendSpawnEntityToAll(ent);
                }
            }
            ++entcount;
        }
        if (input != null) {
            try {
                bos.close();
                ((InputStream)input).close();
                bos = null;
                input = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.rwlock.unlock();
        return true;
    }

    public void delete() {
        String filepath = new String();
        File f = null;
        this.rwlock.lock();
        filepath = String.format("worlds/%s/Dimension-%d/%2x/%d_%d.dat", DangerZone.worldname, this.dimension, this.chunkX + this.chunkZ & 0xFF, this.chunkX, this.chunkZ);
        f = new File(filepath);
        f.delete();
        this.rwlock.unlock();
    }
}

