/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.items;

import OreSpawn.OreSpawnTrees;
import dangerzone.BreakChecks;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.items.Item;

public class ItemMagicApple
extends Item {
    public ItemMagicApple(String name, String txt) {
        super(name, txt);
        this.maxstack = 1;
    }

    public boolean rightClickOnBlock(Player p, int d, int x, int y, int z, int side) {
        if (p != null && p.world.isServer) {
            OreSpawnTrees tr = new OreSpawnTrees();
            int tree_radius = 6;
            boolean no_critters = true;
            int bid = p.world.getblock(d, x, y, z);
            if (bid != Blocks.grassblock.blockID && bid != Blocks.dirt.blockID) {
                return false;
            }
            int tmp = p.world.rand.nextInt(3);
            int leaf_type = Blocks.leaves.blockID;
            int wood_id = Blocks.log.blockID;
            if (tmp == 1) {
                wood_id = Blocks.willowlog.blockID;
            }
            if (tmp == 2) {
                wood_id = Blocks.redwoodlog.blockID;
            }
            if ((tmp = p.world.rand.nextInt(3)) == 1) {
                leaf_type = Blocks.willowleaves.blockID;
            }
            if (tmp == 2) {
                leaf_type = Blocks.redwoodleaves.blockID;
            }
            if (p.world.rand.nextInt(4) == 1) {
                no_critters = false;
            }
            if (!BreakChecks.canChangeBlock((Entity)p, (int)d, (int)x, (int)y, (int)z, (int)0, (int)0)) {
                return false;
            }
            p.world.setblock(d, x, y, z, Blocks.blockplatinum.blockID);
            Utils.spawnParticlesFromServer((World)p.world, (String)"DangerZone:ParticleSparkle", (int)30, (int)d, (double)((double)x + 0.5), (double)((double)y + (double)1.05f), (double)((double)z + 0.5));
            Utils.spawnParticlesFromServer((World)p.world, (String)"DangerZone:ParticleSmoke", (int)30, (int)d, (double)((double)x + 0.5), (double)((double)y + (double)1.05f), (double)((double)z + 0.5));
            Utils.spawnParticlesFromServer((World)p.world, (String)"DangerZone:ParticleFire", (int)20, (int)d, (double)((double)x + 0.5), (double)((double)y + (double)1.05f), (double)((double)z + 0.5));
            p.world.playSound("DangerZone:large_explosion3", d, (double)x + 0.5, (double)y + (double)1.05f, (double)z + 0.5, 0.25f, 1.0f + (p.world.rand.nextFloat() - p.world.rand.nextFloat()) * 0.3f);
            int rand_treetype = p.world.rand.nextInt(100);
            if (rand_treetype >= 10) {
                if (rand_treetype >= 30) {
                    if (p.world.rand.nextInt(10) == 1) {
                        leaf_type = Blocks.appleleaves.blockID;
                    }
                    tr.MakeBigSquareTree(p.world, p.dimension, x, y, z, wood_id, leaf_type, Blocks.greystone.blockID, tree_radius, no_critters);
                } else {
                    tr.MakeBigCircularTree(p.world, p.dimension, x, y, z, wood_id, leaf_type, Blocks.greystone.blockID, tree_radius, no_critters);
                }
            } else if (rand_treetype == 1) {
                if (p.world.rand.nextInt(5) == 3) {
                    tr.MakeBigSquareTree(p.world, p.dimension, x, y, z, Blocks.blocksunstone.blockID, Blocks.blockemerald.blockID, Blocks.blockdiamond.blockID, tree_radius, no_critters);
                } else {
                    tr.MakeBigSquareTree(p.world, p.dimension, x, y, z, Blocks.blocksilver.blockID, Blocks.blockplatinum.blockID, Blocks.blocklight.blockID, tree_radius, no_critters);
                }
            } else {
                tr.MakeBigRoundTree(p.world, p.dimension, x, y, z, wood_id, leaf_type, tree_radius);
            }
            return true;
        }
        return false;
    }
}

