/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.DoomWorm;
import OreSpawn.entities.WormMedium;
import OreSpawn.entities.WormSmall;
import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlockItem;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import java.util.List;
import java.util.ListIterator;
import org.newdawn.slick.opengl.Texture;

public class WormLarge
extends EntityLiving {
    public boolean oktoattack = false;

    public WormLarge(World w) {
        super(w);
        this.maxrenderdist = 180;
        this.height = 3.1f;
        this.width = 2.25f;
        this.uniquename = "OreSpawn:WormLarge";
        this.moveSpeed = 0.2f;
        this.setMaxHealth(200.0f);
        this.setHealth(200.0f);
        this.setDefense(2.0f);
        this.setAttackDamage(20.0f);
        this.searchDistance = 20.0f;
        this.attackRange = 4.0f;
        this.movefrequency = 55;
        this.setExperience(199);
        this.canSwim = false;
        this.takesFallDamage = false;
        this.ignoreCollisions = true;
        this.setCanDespawn(false);
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = false;
        this.nighttimespawn = false;
        this.nighttimedespawn = false;
        this.tower_defense_enable = false;
    }

    public void doAttack(Entity victim) {
        if (!this.oktoattack) {
            return;
        }
        if (this.world.rand.nextBoolean() && victim.has_inventory && victim instanceof Player) {
            Player p = (Player)victim;
            InventoryContainer ic = null;
            int which = this.world.rand.nextInt(2);
            ic = p.getArmor(which);
            if (ic != null) {
                p.setArmor(which, null);
                this.spititout(ic);
            }
            if (this.world.rand.nextBoolean() && (ic = p.getHotbar(p.gethotbarindex())) != null) {
                p.setHotbar(p.gethotbarindex(), null);
                this.spititout(ic);
            }
        }
        super.doAttack(victim);
    }

    public void doEntityAction(float deltaT) {
        if (this.getBID() == 0) {
            this.setBID(1);
            int i = 0;
            while (i < 20) {
                WormMedium wm;
                WormSmall ws = (WormSmall)this.world.createEntityByName("OreSpawn:WormSmall", this.dimension, this.posx + (double)this.world.rand.nextInt(6) - (double)this.world.rand.nextInt(6), this.posy, this.posz + (double)this.world.rand.nextInt(6) - (double)this.world.rand.nextInt(6));
                if (ws != null) {
                    ws.init();
                    this.world.spawnEntityInWorld((Entity)ws);
                }
                if ((wm = (WormMedium)this.world.createEntityByName("OreSpawn:WormMedium", this.dimension, this.posx + (double)this.world.rand.nextInt(5) - (double)this.world.rand.nextInt(5), this.posy, this.posz + (double)this.world.rand.nextInt(5) - (double)this.world.rand.nextInt(5))) != null) {
                    wm.init();
                    this.world.spawnEntityInWorld((Entity)wm);
                }
                ++i;
            }
        }
        super.doEntityAction(deltaT);
        if (this.getAttacking() && this.timeForMe()) {
            this.takesFallDamage = true;
            this.ignoreCollisions = false;
            this.oktoattack = true;
        } else {
            this.oktoattack = false;
            this.takesFallDamage = false;
            this.ignoreCollisions = true;
            int bid = this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy + 3.75), (int)this.posz);
            this.motiony = bid == Blocks.stone.blockID || bid == Blocks.sand.blockID || bid == Blocks.dirt.blockID || bid == Blocks.grassblock.blockID ? 0.05f : (bid != 0 ? -0.05f : -0.25f);
            this.target = null;
            this.motionz = 0.0f;
            this.motionx = 0.0f;
            this.rotation_yaw_motion = 0.0f;
        }
    }

    private boolean timeForMe() {
        List nearby_list = null;
        nearby_list = DangerZone.server.entityManager.findEntitiesInRange(12.0f, this.dimension, this.posx, this.posy, this.posz);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            Entity e = null;
            ListIterator li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = (Entity)li.next();
                if (e instanceof WormSmall) {
                    return false;
                }
                if (!(e instanceof WormMedium)) continue;
                return false;
            }
        }
        return true;
    }

    private void spititout(InventoryContainer ic) {
        EntityBlockItem e = (EntityBlockItem)this.world.createEntityByName(DangerZone.blockitemname, this.dimension, this.posx + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 4.0f), this.posy + 1.0, this.posz + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 4.0f));
        if (e != null) {
            e.fill(ic);
            e.rotation_pitch = this.world.rand.nextInt(360);
            e.rotation_yaw = this.world.rand.nextInt(360);
            e.rotation_roll = this.world.rand.nextInt(360);
            this.world.spawnEntityInWorld((Entity)e);
        }
    }

    public String getLivingSound() {
        return null;
    }

    public String getHurtSound() {
        return "OreSpawn:alo_hurt";
    }

    public String getDeathSound() {
        return "OreSpawn:alo_death";
    }

    public void doDeathDrops() {
        int howmany = 4 + this.world.rand.nextInt(5);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.moosemeat.itemID, (float)5.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 3 + this.world.rand.nextInt(5);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.moosebone.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.wormtooth.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophywormlarge.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof DoomWorm) {
            return false;
        }
        if (e instanceof WormLarge) {
            return false;
        }
        if (e instanceof WormMedium) {
            return false;
        }
        if (e instanceof WormSmall) {
            return false;
        }
        return e instanceof Player;
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/WormLargetexture.png");
        }
        return this.texture;
    }
}

