/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class WoolyMammoth
extends EntityLiving {
    public WoolyMammoth(World w) {
        super(w);
        this.maxrenderdist = 200;
        this.height = 8.5f;
        this.width = 5.0f;
        this.uniquename = "OreSpawn:WoolyMammoth";
        this.moveSpeed = 0.22f;
        this.setMaxHealth(650.0f);
        this.setHealth(650.0f);
        this.setDefense(2.0f);
        this.setAttackDamage(50.0f);
        this.searchDistance = 24.0f;
        this.attackRange = 4.5f;
        this.movefrequency = 95;
        this.setExperience(960);
        this.canSwim = true;
        this.daytimespawn = true;
        this.daytimedespawn = false;
        this.nighttimespawn = false;
        this.nighttimedespawn = true;
        this.temperament = 1;
        this.enable_hostile = true;
        this.tower_defense_enable = true;
    }

    public void init() {
        super.init();
        this.jumpstrength = 0.45000002f;
    }

    public String getLivingSound() {
        int which = this.world.rand.nextInt(4);
        if (which == 3) {
            return "OreSpawn:Mammoth_living4";
        }
        if (which == 2) {
            return "OreSpawn:Mammoth_living3";
        }
        if (which == 1) {
            return "OreSpawn:Mammoth_living2";
        }
        return "OreSpawn:Mammoth_living1";
    }

    public String getHurtSound() {
        int which = this.world.rand.nextInt(2);
        if (which == 1) {
            return "OreSpawn:Mammoth_hit2";
        }
        return "OreSpawn:Mammoth_hit1";
    }

    public String getDeathSound() {
        return "OreSpawn:Mammoth_death";
    }

    public void doDeathDrops() {
        int howmany = 7 + this.world.rand.nextInt(10);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.moosemeat.itemID, (float)2.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 7 + this.world.rand.nextInt(10);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.moosebone.itemID, (float)2.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(2) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophywoolymammoth.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof WoolyMammoth) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/WoollyMammothtexture.png");
        }
        return this.texture;
    }
}

