/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.particles.Particle;
import org.newdawn.slick.opengl.Texture;

public class Whale
extends EntityLiving {
    public int spoutcounter = 0;

    public Whale(World w) {
        super(w);
        this.maxrenderdist = 190;
        this.height = 3.45f;
        this.width = 3.75f;
        this.uniquename = "OreSpawn:Whale";
        this.moveSpeed = 0.215f;
        this.setMaxHealth(100.0f);
        this.setHealth(100.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(0.0f);
        this.movefrequency = 55;
        this.setExperience(35);
        this.swimoffset = -2.0f;
        this.canSwim = true;
        this.takesFallDamage = true;
        this.canBreateUnderWater = true;
        if (w != null) {
            this.spoutcounter = w.rand.nextInt(1000);
        }
        this.targetLiquidOnly = true;
        this.daytimespawn = true;
        this.nighttimespawn = false;
        this.daytimedespawn = true;
        this.nighttimedespawn = true;
        this.enableBreeding(10);
        this.findbuddydistance = 16;
        this.findbuddyfrequency = 6;
    }

    public void doEntityAction(float deltaT) {
        this.enable_buddy = this.isBaby();
        super.doEntityAction(deltaT);
    }

    public boolean isBuddy(Entity e) {
        return e instanceof Whale;
    }

    public boolean isBreedingFoodForMe(int bid, int iid) {
        if (iid == Items.fishmeat.itemID) {
            return true;
        }
        return iid == OreSpawnMain.crystalapple.itemID;
    }

    public void update(float deltaT) {
        if (!this.world.isServer) {
            ++this.spoutcounter;
            if (this.spoutcounter % 300 > 250) {
                int howmany = 1 + this.world.rand.nextInt(5);
                int i = 0;
                while (i < howmany) {
                    Particle eb = this.world.createParticleByName("DangerZone:ParticleRain", this.dimension, this.posx, this.posy + 1.0, this.posz);
                    if (eb != null) {
                        eb.motiony = 0.25f;
                        eb.motionx = (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.02f;
                        eb.motionz = (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.02f;
                        this.world.spawnParticleInWorld(eb);
                    }
                    ++i;
                }
            }
        }
        super.update(deltaT);
    }

    public String getLivingSound() {
        if (this.world.rand.nextBoolean()) {
            return null;
        }
        return "DangerZone:big_splash";
    }

    public String getHurtSound() {
        return "DangerZone:little_splat";
    }

    public String getDeathSound() {
        return "DangerZone:big_splat";
    }

    public void doDeathDrops() {
        if (this.world.rand.nextInt(6) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophywhale.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        int howmany = 10 + this.world.rand.nextInt(10);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.fishmeat.itemID, (float)4.5f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/Whaletexture.png");
        }
        return this.texture;
    }
}

