/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.EntityLivingDragon;
import dangerzone.DangerZone;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.entities.Entity;
import dangerzone.entities.RenderInfo;
import dangerzone.entities.TargetHelper;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class Vermin
extends EntityLivingDragon {
    float myspeed = 0.0f;
    public float attackRange = 1.5f;
    public int searchcounter = 0;
    public Entity hurtMe = null;
    public Entity targetentity = null;
    public RenderInfo renderdata = new RenderInfo();

    public Vermin(World w) {
        super(w);
        this.maxrenderdist = 110;
        this.uniquename = "OreSpawn:Vermin";
        if (w != null) {
            this.myspeed = 0.22f + this.world.rand.nextFloat() * 0.22f;
        }
        this.takesFallDamage = false;
        this.movefrequency = 65;
        this.canSwim = false;
        this.setExperience(15);
        this.height = 0.55f;
        this.width = 0.65f;
        this.setMaxHealth(10.0f);
        this.setHealth(10.0f);
        this.setDefense(0.75f);
        this.setAttackDamage(2.0f);
        this.searchDistance = 40.0f;
        this.attackRange = 1.5f;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = false;
        this.canFly = true;
        this.setFlying(true);
        this.isImmuneToFire = true;
        this.tower_defense_enable = true;
        this.enable_taming = true;
        this.maxdisttoowner = 20.0f;
    }

    public void doAttackFrom(Entity e, int dt, float pain) {
        this.setStaying(false);
        if (e != null && this.isSuitableTarget(e)) {
            this.hurtMe = e;
        }
        super.doAttackFrom(e, dt, pain);
    }

    public boolean isFoodItem(int iid) {
        if (iid == Items.moosemeat.itemID) {
            return true;
        }
        if (iid == Items.fishmeat.itemID) {
            return true;
        }
        if (iid == Items.goosemeat.itemID) {
            return true;
        }
        return iid == Items.ostrichmeat.itemID;
    }

    public void doEntityAction(float deltaT) {
        if (!this.getStaying()) {
            ++this.searchcounter;
            if (this.searchcounter >= 10) {
                this.searchcounter = this.world.rand.nextInt(4);
                if (this.hurtMe != null && this.hurtMe.deadflag) {
                    this.hurtMe = null;
                }
                if (this.world.rand.nextInt(20) == 1) {
                    this.hurtMe = null;
                }
                this.targetentity = this.hurtMe;
                if (this.targetentity == null) {
                    this.targetentity = this.findSomethingToAttack();
                }
                if (this.targetentity != null) {
                    this.target = new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy, this.targetentity.posz);
                    this.setAttacking(true);
                } else {
                    this.setAttacking(false);
                }
            }
            if (this.targetentity != null && this.world.rand.nextInt(8) == 1 && this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
                float dmg = this.getAttackDamage();
                int dt = 4;
                this.targetentity.doAttackFrom((Entity)this, dt, dmg);
            }
            if (!this.isHurt() && !this.deadflag && this.world.rand.nextInt(100) == 1) {
                this.world.playSound(this.getLivingSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, this.getLivingSoundVolume(), this.getLivingSoundPitch());
            }
        }
    }

    public void onKill(Entity e) {
        this.heal(1.0f);
    }

    public void update(float deltaT) {
        if (this.world.isServer) {
            int bid;
            int keep_trying = 35;
            if (this.target == null) {
                this.target = new TargetHelper(this.posx, this.posy, this.posz);
            }
            int px = (int)this.posx;
            int py = (int)this.posy;
            int pz = (int)this.posz;
            int dxz = 35;
            double dist = 0.0;
            float speedadjust = 1.0f;
            if (this.getOwnerName() != null) {
                this.temperament = 3;
                Entity e = DangerZone.server.entityManager.findPlayerByName(this.getOwnerName());
                if (e != null) {
                    px = (int)e.posx;
                    py = (int)(e.posy + (double)(e.getHeight() / 2.0f));
                    pz = (int)e.posz;
                    dxz = 20;
                    dist = this.getDistanceFromEntity(e);
                    if (dist > (double)this.maxdisttoowner) {
                        speedadjust = 1.75f;
                    }
                    if (dist > (double)(this.maxdisttoowner * 1.5f)) {
                        speedadjust = 2.75f;
                    }
                }
            }
            if (!this.getStaying()) {
                bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz);
                if (bid != 0 || this.world.rand.nextInt(50) == 1 || this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < 3.0) {
                    bid = 1;
                    while (bid != 0 && keep_trying != 0) {
                        this.target.setTarget((double)(px + (this.world.rand.nextInt(dxz) - this.world.rand.nextInt(dxz))), (double)(py + (this.world.rand.nextInt(7) - 2)), (double)(pz + (this.world.rand.nextInt(dxz) - this.world.rand.nextInt(dxz))));
                        bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz);
                        --keep_trying;
                    }
                    this.myspeed = 0.22f + this.world.rand.nextFloat() * 0.22f;
                }
            } else {
                this.myspeed = 0.0f;
            }
            if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0) {
                this.target.setTarget(this.posx + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)), this.posy + (double)(this.world.rand.nextInt(5) + 3), this.posz + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)));
            }
            double dy = this.target.targety - this.posy;
            this.motiony += 0.12f * deltaT;
            if ((dy /= 20.0) > (double)0.2f) {
                dy = 0.2f;
            }
            if (dy < (double)-0.2f) {
                dy = -0.2f;
            }
            this.motiony = (float)((double)this.motiony + dy);
            if (this.motiony > 1.0f) {
                this.motiony = 1.0f;
            }
            if (this.motiony < -1.0f) {
                this.motiony = -1.0f;
            }
            float cdir = (float)Math.toRadians(this.rotation_yaw);
            float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
            float ddiff = tdir - cdir;
            while ((double)ddiff > Math.PI) {
                ddiff = (float)((double)ddiff - Math.PI * 2);
            }
            while ((double)ddiff < -Math.PI) {
                ddiff = (float)((double)ddiff + Math.PI * 2);
            }
            this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 10.0);
            float effectspeed = this.getTotalEffect(1);
            if (effectspeed > 1.0f) {
                speedadjust *= effectspeed;
            }
            if ((effectspeed = this.getTotalEffect(2)) > 1.0f) {
                speedadjust /= effectspeed;
            }
            this.motionx = (float)((double)this.motionx + (double)(this.myspeed * speedadjust) * Math.sin(tdir) * (double)deltaT);
            this.motionz = (float)((double)this.motionz + (double)(this.myspeed * speedadjust) * Math.cos(tdir) * (double)deltaT);
        }
        super.update(deltaT);
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof EntityLivingDragon) {
            return false;
        }
        return this.CanProbablySeeEntity(e);
    }

    public void doDeathDrops() {
        int howmany = 1 + this.world.rand.nextInt(2);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.deadbug.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophyvermin.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/Vermintexture.png");
        }
        return this.texture;
    }

    public String getHurtSound() {
        return "OreSpawn:Varmint_hit";
    }

    public String getDeathSound() {
        return "OreSpawn:Varmint_death";
    }

    public String getLivingSound() {
        if (this.world.rand.nextInt(2) != 1) {
            return null;
        }
        if (this.getOwnerName() != null && this.world.rand.nextInt(2) != 1) {
            return null;
        }
        return "OreSpawn:Varmint_living";
    }

    public float getLivingSoundVolume() {
        if (this.getOwnerName() != null) {
            return 0.25f;
        }
        return 0.5f;
    }
}

