/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.Bird;
import OreSpawn.entities.EntityLivingDragon;
import OreSpawn.entities.Girlfriend;
import OreSpawn.entities.Moth;
import OreSpawn.entities.PowerOrb;
import OreSpawn.entities.TheKing;
import OreSpawn.entities.TheQueenHead;
import OreSpawn.entities.ThrownThunder;
import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Butterfly;
import dangerzone.entities.Entity;
import dangerzone.entities.TargetHelper;
import dangerzone.entities.ThrownFireball;
import dangerzone.items.Items;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.newdawn.slick.opengl.Texture;

public class TheQueen
extends EntityLivingDragon {
    float myspeed = 0.0f;
    private int soundcount = 0;
    private int head1ext = 0;
    private int head2ext = 0;
    private int head3ext = 0;
    private int head1dir = 1;
    private int head2dir = 1;
    private int head3dir = 1;
    public TheQueenHead myhead = null;
    Texture texture2 = null;
    int backoffmode = 0;
    int backoffcounter = 0;

    public TheQueen(World w) {
        super(w);
        this.maxrenderdist = 380;
        this.uniquename = "OreSpawn:TheQueen";
        if (w != null) {
            this.myspeed = 1.65f + this.world.rand.nextFloat() * 0.3f;
        }
        this.takesFallDamage = false;
        this.movefrequency = 65;
        this.canSwim = true;
        this.setExperience(15000);
        this.height = 24.75f;
        this.width = 22.75f;
        this.setMaxHealth(6000.0f);
        this.setHealth(6000.0f);
        this.setDefense(8.0f);
        this.setAttackDamage(220.0f);
        this.searchDistance = 120.0f;
        this.attackRange = 20.0f;
        this.daytimespawn = false;
        this.nighttimespawn = false;
        this.isImmuneToFire = true;
        this.setCanDespawn(false);
        this.ignoreCollisions = true;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = false;
        this.nighttimespawn = false;
        this.nighttimedespawn = false;
        this.canFly = true;
        if (w != null) {
            this.backoffcounter = 50 + w.rand.nextInt(100);
        }
        this.tower_defense_enable = false;
    }

    public void doAttackFrom(Entity e, int dt, float pain) {
        if (dt == 9) {
            return;
        }
        if (dt == 10) {
            return;
        }
        if (dt == 12) {
            return;
        }
        super.doAttackFrom(e, dt, pain);
        if (this.hurtMe != null && this.hurtMe instanceof EntityLivingDragon) {
            this.hurtMe = null;
        }
        this.searchcounter = 10;
    }

    public void setGuardMode() {
        this.setVarInt(21, (int)this.posx);
        this.setVarInt(22, (int)this.posz);
        this.setBID(1);
    }

    public float getPower() {
        return this.getVarFloat(23);
    }

    public void doEntityAction(float deltaT) {
        int bid;
        int i;
        double startz;
        double starty;
        ListIterator li;
        Entity e;
        if (this.getAttacking()) {
            this.setVarFloat(23, this.getVarFloat(23) + 5.0f);
        } else if (this.getVarFloat(23) > 0.0f && this.world.rand.nextInt(10) == 1) {
            this.setVarFloat(23, this.getVarFloat(23) - 1.0f);
        }
        boolean found = false;
        List nearby_list = null;
        nearby_list = DangerZone.server.entityManager.findEntitiesInRange(50.0f, this.dimension, this.posx, this.posy, this.posz);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            e = null;
            Collections.sort(nearby_list, this.TargetSorter);
            li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = (Entity)li.next();
                if (!(e instanceof TheQueenHead)) continue;
                found = true;
                this.myhead = (TheQueenHead)e;
                break;
            }
        }
        if (!found && (e = this.world.createEntityByName("OreSpawn:TheQueenHead", this.dimension, this.posx + (double)((float)Math.sin(Math.toRadians(this.rotation_yaw)) * (this.getWidth() * 3.0f / 2.0f)), this.posy + 15.0, this.posz + (double)((float)Math.cos(Math.toRadians(this.rotation_yaw)) * (this.getWidth() * 3.0f / 2.0f)))) != null) {
            e.init();
            this.world.spawnEntityInWorld(e);
            this.myhead = (TheQueenHead)e;
        }
        if (this.getPower() > 1000.0f) {
            double startx = this.posx + (double)((float)Math.sin(Math.toRadians(this.rotation_yaw)) * this.getWidth());
            starty = this.posy + (double)(this.getHeight() / 2.0f);
            startz = this.posz + (double)((float)Math.cos(Math.toRadians(this.rotation_yaw)) * this.getWidth());
            int howmany = 5 + this.world.rand.nextInt(10);
            i = 0;
            while (i < howmany) {
                PowerOrb e2 = (PowerOrb)this.world.createEntityByName("OreSpawn:PowerOrb", this.dimension, startx, starty, startz);
                if (e2 != null) {
                    e2.init();
                    e2.setBID(1);
                    this.world.spawnEntityInWorld((Entity)e2);
                }
                ++i;
            }
            this.setVarFloat(23, 0.0f);
        }
        if (this.getPower() > 800.0f) {
            double startx = this.posx + (double)((float)Math.sin(Math.toRadians(this.rotation_yaw)) * this.getWidth());
            starty = this.posy + (double)(this.getHeight() / 2.0f);
            startz = this.posz + (double)((float)Math.cos(Math.toRadians(this.rotation_yaw)) * this.getWidth());
            Utils.spawnParticlesFromServer((World)this.world, (String)"DangerZone:ParticleSparkle", (int)5, (int)this.dimension, (double)startx, (double)starty, (double)startz);
        }
        if (this.world.rand.nextInt(10) == 1) {
            this.heal(5.0f);
        }
        --this.backoffcounter;
        if (this.backoffcounter <= 0) {
            if (this.backoffmode == 0) {
                this.targetentity = null;
                this.target = null;
                this.setAttacking(false);
                this.backoffmode = 1;
                this.backoffcounter = 40 + this.world.rand.nextInt(50);
            } else {
                this.backoffmode = 0;
                this.backoffcounter = 50 + this.world.rand.nextInt(100);
            }
        }
        if (this.backoffmode == 0) {
            ++this.searchcounter;
            if (this.searchcounter >= 10) {
                this.searchcounter = this.world.rand.nextInt(4);
                if (this.hurtMe != null && this.hurtMe.deadflag) {
                    this.hurtMe = null;
                }
                if (this.hurtMe != null && this.hurtMe.posy > 300.0) {
                    this.hurtMe = null;
                }
                if (this.world.rand.nextInt(20) == 1) {
                    this.hurtMe = null;
                }
                this.targetentity = this.hurtMe;
                if (this.targetentity == null) {
                    this.targetentity = this.findSomethingToAttack();
                }
                if (this.targetentity != null) {
                    this.target = this.targetentity.isFlying() ? new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy, this.targetentity.posz) : new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy + (double)(this.targetentity.getHeight() * 3.0f / 4.0f), this.targetentity.posz);
                    this.setAttacking(true);
                } else {
                    this.setAttacking(false);
                }
            }
            if (this.targetentity != null && this.world.rand.nextInt(5) == 1) {
                double cdir = Math.toRadians(this.rotation_yaw);
                double tdir = Math.atan2(this.targetentity.posx - this.posx, this.targetentity.posz - this.posz);
                double ddiff = tdir - cdir;
                while (ddiff > Math.PI) {
                    ddiff -= Math.PI * 2;
                }
                while (ddiff < -Math.PI) {
                    ddiff += Math.PI * 2;
                }
                if (Math.abs(ddiff) < 1.0471975511965976) {
                    if (this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
                        float dmg = this.getAttackDamage();
                        int dt = 4;
                        this.targetentity.doAttackFrom((Entity)this, dt, dmg);
                    } else {
                        this.do_a_distance_attack(this.targetentity);
                    }
                }
            }
        }
        ++this.soundcount;
        if (this.soundcount > 18) {
            this.soundcount = 0;
            int which = this.world.rand.nextInt(3);
            if (which == 0) {
                this.world.playSound("OreSpawn:MothraWings1", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
            }
            if (which == 1) {
                this.world.playSound("OreSpawn:MothraWings2", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
            }
            if (which == 2) {
                this.world.playSound("OreSpawn:MothraWings3", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
            }
        }
        if (this.target == null) {
            this.target = new TargetHelper(this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(30) == 1) {
            nearby_list = null;
            nearby_list = DangerZone.server.entityManager.findEntitiesInRange(200.0f, this.dimension, this.posx, this.posy, this.posz);
            if (nearby_list != null && !nearby_list.isEmpty()) {
                e = null;
                Collections.sort(nearby_list, this.TargetSorter);
                li = nearby_list.listIterator();
                while (li.hasNext()) {
                    e = (Entity)li.next();
                    if (!(e instanceof TheKing)) continue;
                    this.target.setTarget(e.posx, e.posy, e.posz);
                    break;
                }
            }
        }
        double px = this.posx;
        double pz = this.posz;
        if (this.getBID() != 0) {
            px = this.getVarInt(21);
            pz = this.getVarInt(22);
        }
        if (this.world.rand.nextInt(300) == 0 || this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < 5.0) {
            int down = 0;
            i = -5;
            while (i <= 5) {
                int j = -5;
                while (j <= 5) {
                    int k = -20;
                    while (k <= 20) {
                        bid = this.world.getblock(this.dimension, (int)this.posx + j, (int)this.posy + k - 15, (int)this.posz + i);
                        down = bid != 0 ? ++down : --down;
                        k += 2;
                    }
                    j += 5;
                }
                i += 5;
            }
            if (down > 10) {
                down = 10;
            }
            if (down < -10) {
                down = -10;
            }
            int xdir = 1;
            int zdir = 1;
            if (this.world.rand.nextBoolean()) {
                xdir = -1;
            }
            if (this.world.rand.nextBoolean()) {
                zdir = -1;
            }
            int newz = this.world.rand.nextInt(200);
            int newx = this.world.rand.nextInt(200);
            this.target.setTarget((double)((int)px + (newx *= xdir)), (double)((int)this.posy + this.world.rand.nextInt(7) - 3 + down / 2), (double)((int)pz + (newz *= zdir)));
            this.myspeed = 1.65f + this.world.rand.nextFloat() * 0.3f;
        }
        if (this.target.targety > 250.0) {
            this.target.targety = 200.0;
        }
        if (this.target.targety < 0.0) {
            this.target.targety = 50.0;
        }
        double dy = this.target.targety - this.posy;
        this.motiony += 0.12f * deltaT;
        if ((dy /= 10.0) > (double)0.2f) {
            dy = 0.2f;
        }
        if (dy < (double)-0.2f) {
            dy = -0.2f;
        }
        this.motiony = (float)((double)this.motiony + dy);
        if (this.motiony > 1.0f) {
            this.motiony = 1.0f;
        }
        if (this.motiony < -1.0f) {
            this.motiony = -1.0f;
        }
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
        float ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        this.rotation_yaw_motion = (float)((double)(ddiff * 180.0f) / Math.PI / 10.0);
        float speedadjust = 1.0f;
        float effectspeed = this.getTotalEffect(1);
        if (effectspeed > 1.0f) {
            speedadjust *= effectspeed;
        }
        if ((effectspeed = this.getTotalEffect(2)) > 1.0f) {
            speedadjust /= effectspeed;
        }
        this.motionx = (float)((double)this.motionx + (double)(this.myspeed * speedadjust) * Math.sin(tdir) * (double)deltaT);
        this.motionz = (float)((double)this.motionz + (double)(this.myspeed * speedadjust) * Math.cos(tdir) * (double)deltaT);
        float spd = (float)Math.sqrt(this.motionx * this.motionx + this.motionz * this.motionz);
        if (spd > this.myspeed) {
            this.motionx *= this.myspeed / spd;
            this.motionz *= this.myspeed / spd;
        }
        if (!this.getAttacking() && this.world.rand.nextInt(20) == 1) {
            int ix = this.world.rand.nextInt(15) - this.world.rand.nextInt(15);
            int iz = this.world.rand.nextInt(15) - this.world.rand.nextInt(15);
            ix += (int)this.posx;
            iz += (int)this.posz;
            i = 5;
            while (i > -20) {
                bid = this.world.getblock(this.dimension, ix, (int)this.posy + i, iz);
                if (bid != 0 && this.world.getblock(this.dimension, ix, (int)this.posy + i + 1, iz) == 0) {
                    if (bid == Blocks.sand.blockID) {
                        this.world.setblockWithPerm((Entity)this, this.dimension, ix, (int)this.posy + i, iz, Blocks.dirt.blockID);
                        break;
                    }
                    if (bid == Blocks.dirt.blockID) {
                        this.world.setblockWithPerm((Entity)this, this.dimension, ix, (int)this.posy + i, iz, Blocks.grassblock.blockID);
                        break;
                    }
                    if (bid != Blocks.grassblock.blockID) break;
                    int which = this.world.rand.nextInt(4);
                    if (which == 0) {
                        this.world.setblockWithPerm((Entity)this, this.dimension, ix, (int)this.posy + i + 1, iz, Blocks.flower_red.blockID);
                    }
                    if (which == 1) {
                        this.world.setblockWithPerm((Entity)this, this.dimension, ix, (int)this.posy + i + 1, iz, Blocks.flower_pink.blockID);
                    }
                    if (which == 2) {
                        this.world.setblockWithPerm((Entity)this, this.dimension, ix, (int)this.posy + i + 1, iz, Blocks.flower_purple.blockID);
                    }
                    if (which != 3) break;
                    this.world.setblockWithPerm((Entity)this, this.dimension, ix, (int)this.posy + i + 1, iz, Blocks.flower_yellow.blockID);
                    break;
                }
                --i;
            }
        }
        if (!this.getAttacking() && this.world.rand.nextInt(50) == 0 && this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy + (double)this.getHeight() + 1.0), (int)this.posz) == 0) {
            if (this.world.isDaytime()) {
                if (this.world.rand.nextBoolean()) {
                    Butterfly e3 = (Butterfly)this.world.createEntityByName("DangerZone:Butterfly", this.dimension, this.posx, this.posy + (double)this.getHeight() + 1.0, this.posz);
                    if (e3 != null) {
                        e3.init();
                        this.world.spawnEntityInWorld((Entity)e3);
                    }
                } else {
                    Bird e4 = (Bird)this.world.createEntityByName("OreSpawn:Bird", this.dimension, this.posx, this.posy + (double)this.getHeight() + 1.0, this.posz);
                    if (e4 != null) {
                        e4.init();
                        this.world.spawnEntityInWorld((Entity)e4);
                    }
                }
            } else {
                Moth e5 = (Moth)this.world.createEntityByName("OreSpawn:Moth", this.dimension, this.posx, this.posy + (double)this.getHeight() + 1.0, this.posz);
                if (e5 != null) {
                    e5.init();
                    this.world.spawnEntityInWorld((Entity)e5);
                }
            }
        }
        if (!(this.isHurt() || this.deadflag || this.getStaying() || this.world.rand.nextInt(100) != 1)) {
            this.world.playSound(this.getLivingSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, this.getLivingSoundVolume(), this.getLivingSoundPitch());
        }
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.getHealth() >= this.getMaxHealth() && this.getBID() == 0) {
            return false;
        }
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof EntityLivingDragon) {
            return false;
        }
        if (this.getBID() != 0 && e.getHorizontalDistanceFromEntity((double)this.getVarInt(21), (double)this.getVarInt(22)) > 256.0) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof Player && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Girlfriend && this.CanProbablySeeEntity(e);
    }

    public void doDeathDrops() {
        int i = 0;
        while (i < 125) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.queenscale.itemID, (float)20.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        Entity e = this.world.createEntityByName("OreSpawn:ThePrincess", this.dimension, this.posx, this.posy, this.posz);
        if (e != null) {
            e.init();
            this.world.spawnEntityInWorld(e);
        }
        Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophythequeen.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        super.doDeathDrops();
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/TheQueentexture.png");
            this.texture2 = TextureMapper.getTexture((String)"orespawnres/skins/TheQueenAngrytexture.png");
        }
        if (this.getAttacking() || this.getHealth() < this.getMaxHealth() || this.getBID() != 0) {
            return this.texture2;
        }
        return this.texture;
    }

    public String getHurtSound() {
        return "OreSpawn:king_hit";
    }

    public String getDeathSound() {
        int which = this.world.rand.nextInt(3);
        if (which == 0) {
            return "DangerZone:large_explosion1";
        }
        if (which == 1) {
            return "DangerZone:large_explosion2";
        }
        return "DangerZone:large_explosion3";
    }

    public String getLivingSound() {
        if (this.world.rand.nextInt(4) != 1) {
            return null;
        }
        return "OreSpawn:king_living";
    }

    public int getHead1Ext() {
        return this.head1ext;
    }

    public int getHead2Ext() {
        return this.head2ext;
    }

    public int getHead3Ext() {
        return this.head3ext;
    }

    public void update(float deltaT) {
        if (!this.world.isServer) {
            int i;
            int howoften = 10;
            int howfar = 2;
            if (this.getAttacking()) {
                howoften = 5;
                howfar = 3;
            }
            if (this.world.rand.nextInt(howoften) == 1) {
                i = this.world.rand.nextInt(3);
                if (i == 0) {
                    this.head1dir = howfar;
                }
                if (i == 1) {
                    this.head1dir = -howfar;
                }
                if (i == 2) {
                    this.head1dir = 0;
                }
            }
            if (this.world.rand.nextInt(howoften) == 1) {
                i = this.world.rand.nextInt(3);
                if (i == 0) {
                    this.head2dir = howfar;
                }
                if (i == 1) {
                    this.head2dir = -howfar;
                }
                if (i == 2) {
                    this.head2dir = 0;
                }
            }
            if (this.world.rand.nextInt(howoften) == 1) {
                i = this.world.rand.nextInt(3);
                if (i == 0) {
                    this.head3dir = howfar;
                }
                if (i == 1) {
                    this.head3dir = -howfar;
                }
                if (i == 2) {
                    this.head3dir = 0;
                }
            }
            this.head1ext += this.head1dir;
            if (this.head1ext < 0) {
                this.head1ext = 0;
            }
            if (this.head1ext > 60) {
                this.head1ext = 60;
            }
            this.head2ext += this.head2dir;
            if (this.head2ext < 0) {
                this.head2ext = 0;
            }
            if (this.head2ext > 60) {
                this.head2ext = 60;
            }
            this.head3ext += this.head3dir;
            if (this.head3ext < 0) {
                this.head3ext = 0;
            }
            if (this.head3ext > 60) {
                this.head3ext = 60;
            }
        }
        super.update(deltaT);
    }

    private void do_a_distance_attack(Entity victim) {
        Object e;
        int i;
        int howmany;
        double startx = this.posx + (double)((float)Math.sin(Math.toRadians(this.rotation_yaw)) * (this.getWidth() * 3.0f / 2.0f));
        double starty = this.posy + (double)this.getHeight();
        double startz = this.posz + (double)((float)Math.cos(Math.toRadians(this.rotation_yaw)) * (this.getWidth() * 3.0f / 2.0f));
        float hdist = (float)Math.sqrt((victim.posx - startx) * (victim.posx - startx) + (victim.posz - startz) * (victim.posz - startz));
        float tdirxz = (float)Math.atan2(victim.posx - startx, victim.posz - startz);
        float tdiry = (float)Math.atan2(starty - (victim.posy + (double)(victim.getHeight() / 2.0f)), hdist);
        int which = this.world.rand.nextInt(2);
        if (which == 0) {
            howmany = 3 + this.world.rand.nextInt(10);
            i = 0;
            while (i < howmany) {
                e = (ThrownFireball)this.world.createEntityByName("DangerZone:ThrownFireball", this.dimension, startx, starty, startz);
                if (e != null) {
                    e.init();
                    e.setBID(0);
                    e.setIID(Items.fireball.itemID);
                    e.thrower = this;
                    e.thrower2 = this.myhead;
                    e.explosive_power = 5.0f;
                    e.setDirectionAndVelocity((float)Math.sin(tdirxz) * (float)Math.cos(tdiry), -((float)Math.sin(tdiry)), (float)Math.cos(tdirxz) * (float)Math.cos(tdiry), 9.5f, 0.2f);
                    this.world.spawnEntityInWorld((Entity)e);
                }
                ++i;
            }
        }
        if (which == 1) {
            howmany = 3 + this.world.rand.nextInt(5);
            i = 0;
            while (i < howmany) {
                e = (ThrownThunder)this.world.createEntityByName("OreSpawn:ThrownThunder", this.dimension, startx, starty, startz);
                if (e != null) {
                    e.init();
                    e.setBID(0);
                    e.setIID(0);
                    e.thrower = this;
                    e.thrower2 = this.myhead;
                    e.setAttackDamage(25.0f);
                    tdiry = (float)Math.atan2(starty - victim.posy, hdist);
                    e.setDirectionAndVelocity((float)Math.sin(tdirxz) * (float)Math.cos(tdiry), -((float)Math.sin(tdiry)), (float)Math.cos(tdirxz) * (float)Math.cos(tdiry), 16.5f, 0.1f);
                    this.world.spawnEntityInWorld((Entity)e);
                }
                ++i;
            }
        }
        this.world.playSound("DangerZone:bow", this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
    }

    public void setBaby(boolean tf) {
    }
}

