/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.Mosquito;
import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.TargetHelper;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class Stinky
extends EntityLiving {
    float myspeed = 0.0f;
    float attackRange;
    int searchcounter;
    Entity hurtMe = null;
    Entity targetentity = null;
    Texture texture2 = null;
    Texture texture3 = null;
    Texture texture4 = null;
    Texture texture5 = null;
    Texture texture6 = null;
    Texture texture7 = null;
    Texture texture8 = null;
    Texture texture9 = null;
    Texture texture10 = null;
    Texture texture11 = null;
    Texture texture12 = null;
    Texture texture13 = null;
    Texture texture14 = null;
    Texture texture15 = null;
    Texture texture16 = null;
    Texture texture17 = null;
    Texture texture18 = null;
    Texture texture19 = null;

    public Stinky(World w) {
        super(w);
        this.maxrenderdist = 140;
        this.uniquename = "OreSpawn:Stinky";
        if (w != null) {
            this.myspeed = 0.25f + this.world.rand.nextFloat() * 0.25f;
        }
        this.takesFallDamage = false;
        this.movefrequency = 65;
        this.setExperience(50);
        this.height = 0.95f;
        this.width = 0.95f;
        this.setMaxHealth(200.0f);
        this.setHealth(200.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(10.0f);
        this.searchDistance = 16.0f;
        this.attackRange = 2.5f;
        this.setBID(-1);
        this.setBID(DangerZone.rand.nextInt(19));
        this.isImmuneToFire = true;
        this.setCanDespawn(false);
        this.canSwim = true;
        this.enable_taming = true;
        this.maxdisttoowner = 18.0f;
        this.enable_followfood = true;
        this.foodsearchDistance = 12;
        this.enable_droppedfood = true;
        this.canFly = true;
    }

    public void doAttackFrom(Entity e, int dt, float pain) {
        this.setFlying(true);
        if (e != this && !DangerZone.playnicely && !(e instanceof Player)) {
            this.hurtMe = e;
        }
        if (dt == 10) {
            return;
        }
        super.doAttackFrom(e, dt, pain);
    }

    public boolean isFoodItem(int iid) {
        return iid == Items.moosemeat.itemID;
    }

    public void doEntityAction(float deltaT) {
        if (!this.isFlying()) {
            super.doEntityAction(deltaT);
            if (!this.getStaying() && this.world.rand.nextInt(15) == 1 && this.findSomethingToAttack() != null) {
                this.setFlying(true);
            }
        } else {
            if (this.getOwnerName() != null) {
                ++this.searchcounter;
                if (this.searchcounter >= 10) {
                    this.searchcounter = this.world.rand.nextInt(4);
                    if (this.hurtMe != null && this.hurtMe.deadflag) {
                        this.hurtMe = null;
                    }
                    if (this.world.rand.nextInt(20) == 1) {
                        this.hurtMe = null;
                    }
                    this.targetentity = this.hurtMe;
                    if (this.targetentity == null) {
                        this.targetentity = this.findSomethingToAttack();
                    }
                    if (this.targetentity != null) {
                        this.target = new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy + (double)(this.targetentity.getHeight() * 3.0f / 4.0f), this.targetentity.posz);
                        this.setAttacking(true);
                    } else {
                        this.setAttacking(false);
                    }
                }
                if (this.targetentity != null && this.world.rand.nextInt(10) == 1 && this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
                    float dmg = this.getAttackDamage();
                    int dt = 4;
                    this.targetentity.doAttackFrom((Entity)this, dt, dmg);
                }
            }
            this.doLookAction();
        }
    }

    public void update(float deltaT) {
        if (this.world.isServer) {
            Entity e;
            int keep_trying = 35;
            double px = this.posx;
            double py = this.posy;
            double pz = this.posz;
            double dist = 0.0;
            int dxz = 25;
            float speedadjust = 1.0f;
            if (this.getOwnerName() != null && (e = DangerZone.server.entityManager.findPlayerByName(this.getOwnerName())) != null) {
                px = e.posx;
                py = e.posy + (double)(e.getHeight() / 2.0f);
                pz = e.posz;
                dxz = 20;
                dist = this.getDistanceFromEntity(e);
                if (dist > (double)this.maxdisttoowner) {
                    speedadjust = 1.75f;
                }
                if (dist > (double)(this.maxdisttoowner * 1.5f)) {
                    speedadjust = 2.75f;
                }
            }
            if (this.getStaying() && this.isFlying()) {
                this.setFlying(false);
            }
            if (this.world.rand.nextInt(500) == 1) {
                this.setBID(this.world.rand.nextInt(19));
            }
            if (this.isFlying()) {
                int bid;
                if (this.target == null) {
                    this.target = new TargetHelper(this.posx, this.posy, this.posz);
                }
                if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0 || this.world.rand.nextInt(50) == 1 || this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < 2.0) {
                    bid = 1;
                    while (bid != 0 && keep_trying != 0) {
                        this.target.setTarget(px + (double)(this.world.rand.nextInt(dxz) - this.world.rand.nextInt(dxz)), py + (double)(this.world.rand.nextInt(8) - 2), pz + (double)(this.world.rand.nextInt(dxz) - this.world.rand.nextInt(dxz)));
                        bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz);
                        --keep_trying;
                    }
                    this.myspeed = 0.25f + this.world.rand.nextFloat() * 0.25f;
                }
                if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0) {
                    this.target.setTarget(this.posx + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)), this.posy + (double)(this.world.rand.nextInt(5) + 3), this.posz + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)));
                }
                double dy = this.target.targety - this.posy;
                this.motiony += 0.12f * deltaT;
                if ((dy /= 20.0) > (double)0.2f) {
                    dy = 0.2f;
                }
                if (dy < (double)-0.2f) {
                    dy = -0.2f;
                }
                this.motiony = (float)((double)this.motiony + dy);
                if (this.motiony > 1.0f) {
                    this.motiony = 1.0f;
                }
                if (this.motiony < -1.0f) {
                    this.motiony = -1.0f;
                }
                float cdir = (float)Math.toRadians(this.rotation_yaw);
                float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
                float ddiff = tdir - cdir;
                while ((double)ddiff > Math.PI) {
                    ddiff = (float)((double)ddiff - Math.PI * 2);
                }
                while ((double)ddiff < -Math.PI) {
                    ddiff = (float)((double)ddiff + Math.PI * 2);
                }
                this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 10.0);
                float effectspeed = this.getTotalEffect(1);
                if (effectspeed > 1.0f) {
                    speedadjust *= effectspeed;
                }
                if ((effectspeed = this.getTotalEffect(2)) > 1.0f) {
                    speedadjust /= effectspeed;
                }
                this.motionx = (float)((double)this.motionx + (double)(this.myspeed * speedadjust) * Math.sin(tdir) * (double)deltaT);
                this.motionz = (float)((double)this.motionz + (double)(this.myspeed * speedadjust) * Math.cos(tdir) * (double)deltaT);
                if (this.world.rand.nextInt(500) == 1) {
                    this.setFlying(false);
                }
            } else if (!this.getStaying()) {
                if (this.world.rand.nextInt(1700) == 1) {
                    this.playburp();
                    this.dropItemFront(0, Items.light.itemID);
                }
                if (this.world.rand.nextInt(2000) == 5) {
                    this.playfart();
                    if (this.getBID() == 0) {
                        this.dropItemRear(0, Items.instability.itemID);
                    }
                    if (this.getBID() == 1) {
                        this.dropItemRear(0, Items.furball.itemID);
                    }
                    if (this.getBID() == 2) {
                        this.dropItemRear(0, Items.appleseed.itemID);
                    }
                    if (this.getBID() == 3) {
                        this.dropItemRear(0, OreSpawnMain.nuggeturanium.itemID);
                    }
                    if (this.getBID() == 4) {
                        this.dropItemRear(Blocks.grass.blockID, 0);
                    }
                    if (this.getBID() == 5) {
                        this.dropItemRear(Blocks.greystone.blockID, 0);
                    }
                    if (this.getBID() == 6) {
                        this.dropItemRear(Blocks.lightstick.blockID, 1);
                    }
                    if (this.getBID() == 7) {
                        this.dropItemRear(0, Items.emerald.itemID);
                    }
                    if (this.getBID() == 8) {
                        this.dropItemRear(0, Items.coingold.itemID);
                    }
                    if (this.getBID() == 9) {
                        this.dropItemRear(0, Items.firestick.itemID);
                    }
                    if (this.getBID() == 10) {
                        this.dropItemRear(0, OreSpawnMain.nuggettitanium.itemID);
                    }
                    if (this.getBID() == 11) {
                        this.dropItemRear(0, Items.coinsilver.itemID);
                    }
                    if (this.getBID() == 12) {
                        this.dropItemRear(0, Items.diamond.itemID);
                    }
                    if (this.getBID() == 13) {
                        this.dropItemRear(Blocks.sand.blockID, 0);
                    }
                    if (this.getBID() == 14) {
                        this.dropItemRear(0, Items.dark.itemID);
                    }
                    if (this.getBID() == 15) {
                        this.dropItemRear(0, Items.moosebone.itemID);
                    }
                    if (this.getBID() == 16) {
                        this.dropItemRear(0, Items.string.itemID);
                    }
                    if (this.getBID() == 17) {
                        this.dropItemRear(0, Items.feather.itemID);
                    }
                    if (this.getBID() == 18) {
                        this.dropItemRear(0, Items.peachseed.itemID);
                    }
                }
                if (this.getOwnerName() != null && (e = DangerZone.server.entityManager.findPlayerByName(this.getOwnerName())) != null && (dist = this.getDistanceFromEntity(e)) > (double)this.maxdisttoowner) {
                    this.setFlying(true);
                }
                if (this.world.rand.nextInt(500) == 1) {
                    this.setFlying(true);
                }
            }
        }
        super.update(deltaT);
    }

    private void playfart() {
        int i = this.world.rand.nextInt(9);
        if (i == 0) {
            this.world.playSound("OreSpawn:fart1", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.25f);
        }
        if (i == 1) {
            this.world.playSound("OreSpawn:fart2", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.25f);
        }
        if (i == 2) {
            this.world.playSound("OreSpawn:fart3", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.25f);
        }
        if (i == 3) {
            this.world.playSound("OreSpawn:fart4", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.25f);
        }
        if (i == 4) {
            this.world.playSound("OreSpawn:fart5", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.25f);
        }
        if (i == 5) {
            this.world.playSound("OreSpawn:fart6", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.25f);
        }
        if (i == 6) {
            this.world.playSound("OreSpawn:fart7", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.25f);
        }
        if (i == 7) {
            this.world.playSound("OreSpawn:fart8", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.25f);
        }
        if (i == 8) {
            this.world.playSound("OreSpawn:fart9", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.25f);
        }
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Stinky) {
            return false;
        }
        if (e instanceof Player) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Mosquito && this.CanProbablySeeEntity(e);
    }

    public void doDeathDrops() {
        Utils.doDropRand((World)this.world, (int)Blocks.flower_red.blockID, (int)0, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        if (this.world.rand.nextInt(5) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophystinky.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/Stinkytexture1.png");
            this.texture2 = TextureMapper.getTexture((String)"orespawnres/skins/Stinkytexture2.png");
            this.texture3 = TextureMapper.getTexture((String)"orespawnres/skins/Stinkytexture3.png");
            this.texture4 = TextureMapper.getTexture((String)"orespawnres/skins/Stinkytexture4.png");
            this.texture5 = TextureMapper.getTexture((String)"orespawnres/skins/Stinkytexture5.png");
            this.texture6 = TextureMapper.getTexture((String)"orespawnres/skins/Stinkytexture6.png");
            this.texture7 = TextureMapper.getTexture((String)"orespawnres/skins/Stinkytexture7.png");
            this.texture8 = TextureMapper.getTexture((String)"orespawnres/skins/Stinkytexture8.png");
            this.texture9 = TextureMapper.getTexture((String)"orespawnres/skins/Stinkytexture9.png");
            this.texture10 = TextureMapper.getTexture((String)"orespawnres/skins/Stinkytexture10.png");
            this.texture11 = TextureMapper.getTexture((String)"orespawnres/skins/Stinkytexture11.png");
            this.texture12 = TextureMapper.getTexture((String)"orespawnres/skins/Stinkytexture12.png");
            this.texture13 = TextureMapper.getTexture((String)"orespawnres/skins/Stinkytexture13.png");
            this.texture14 = TextureMapper.getTexture((String)"orespawnres/skins/Stinkytexture14.png");
            this.texture15 = TextureMapper.getTexture((String)"orespawnres/skins/Stinkytexture15.png");
            this.texture16 = TextureMapper.getTexture((String)"orespawnres/skins/Stinkytexture16.png");
            this.texture17 = TextureMapper.getTexture((String)"orespawnres/skins/Stinkytexture17.png");
            this.texture18 = TextureMapper.getTexture((String)"orespawnres/skins/Stinkytexture18.png");
            this.texture19 = TextureMapper.getTexture((String)"orespawnres/skins/Stinkytexture19.png");
        }
        if (this.getBID() == 1) {
            return this.texture2;
        }
        if (this.getBID() == 2) {
            return this.texture3;
        }
        if (this.getBID() == 3) {
            return this.texture4;
        }
        if (this.getBID() == 4) {
            return this.texture5;
        }
        if (this.getBID() == 5) {
            return this.texture6;
        }
        if (this.getBID() == 6) {
            return this.texture7;
        }
        if (this.getBID() == 7) {
            return this.texture8;
        }
        if (this.getBID() == 8) {
            return this.texture9;
        }
        if (this.getBID() == 9) {
            return this.texture10;
        }
        if (this.getBID() == 10) {
            return this.texture11;
        }
        if (this.getBID() == 11) {
            return this.texture12;
        }
        if (this.getBID() == 12) {
            return this.texture13;
        }
        if (this.getBID() == 13) {
            return this.texture14;
        }
        if (this.getBID() == 14) {
            return this.texture15;
        }
        if (this.getBID() == 15) {
            return this.texture16;
        }
        if (this.getBID() == 16) {
            return this.texture17;
        }
        if (this.getBID() == 17) {
            return this.texture18;
        }
        if (this.getBID() == 18) {
            return this.texture19;
        }
        return this.texture;
    }

    public String getHurtSound() {
        return "OreSpawn:duck_hurt";
    }

    public String getDeathSound() {
        return "OreSpawn:cryo_death";
    }

    public String getLivingSound() {
        return null;
    }

    private void dropItemFront(int blkindex, int itmindex) {
        float f = 0.75f + Math.abs(this.world.rand.nextFloat() * 0.75f);
        Utils.doDropRand((World)this.world, (int)blkindex, (int)itmindex, (float)0.0f, (int)this.dimension, (double)(this.posx + (double)(f * (float)Math.sin(Math.toRadians(this.rotation_yaw_head)))), (double)(this.posy + (double)0.9f), (double)(this.posz + (double)(f * (float)Math.cos(Math.toRadians(this.rotation_yaw_head)))));
    }

    private void dropItemRear(int blkindex, int itmindex) {
        float f = 0.75f + Math.abs(this.world.rand.nextFloat() * 0.55f);
        Utils.doDropRand((World)this.world, (int)blkindex, (int)itmindex, (float)0.0f, (int)this.dimension, (double)(this.posx - (double)(f * (float)Math.sin(Math.toRadians(this.rotation_yaw_head)))), (double)(this.posy + 0.25), (double)(this.posz - (double)(f * (float)Math.cos(Math.toRadians(this.rotation_yaw_head)))));
    }
}

