/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import org.newdawn.slick.opengl.Texture;

public class SkinnyThing
extends EntityLiving {
    public float newangle = 0.0f;

    public SkinnyThing(World w) {
        super(w);
        this.maxrenderdist = 128;
        this.height = 2.9f;
        this.width = 0.85f;
        this.uniquename = "OreSpawn:Skinny Thing";
        this.moveSpeed = 0.25f;
        this.setMaxHealth(25.0f);
        this.setHealth(25.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(4.0f);
        this.searchDistance = 16.0f;
        this.attackRange = 2.5f;
        this.movefrequency = 35;
        this.setExperience(29);
        this.canSwim = false;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = false;
        this.tower_defense_enable = true;
    }

    public float getNewangle() {
        this.newangle += (float)Math.sqrt(this.motionx * this.motionx + this.motiony * this.motiony + this.motionz * this.motionz) * 15.0f;
        while (this.newangle > 360.0f) {
            this.newangle -= 360.0f;
        }
        return (float)Math.toRadians(this.newangle);
    }

    public String getLivingSound() {
        if (this.world.rand.nextBoolean()) {
            return null;
        }
        int bng = this.world.rand.nextInt(4);
        if (bng == 0) {
            return "OreSpawn:honk1";
        }
        if (bng == 1) {
            return "OreSpawn:honk2";
        }
        if (bng == 2) {
            return "OreSpawn:honk3";
        }
        return "OreSpawn:honk4";
    }

    public String getHurtSound() {
        int bng = this.world.rand.nextInt(3);
        if (bng == 0) {
            return "OreSpawn:gurglehit1";
        }
        if (bng == 1) {
            return "OreSpawn:gurglehit2";
        }
        return "OreSpawn:gurglehit3";
    }

    public String getDeathSound() {
        return "OreSpawn:squeeky";
    }

    public void doDeathDrops() {
        Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.poker.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophyskinnything.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof SkinnyThing) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/SkinnyThingtexture.png");
        }
        return this.texture;
    }
}

