/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.AntRobot;
import OreSpawn.entities.Jeffery;
import OreSpawn.entities.RoboBomb;
import OreSpawn.entities.RoboGunner;
import OreSpawn.entities.RoboSniper;
import OreSpawn.entities.RoboWarrior;
import OreSpawn.entities.SpiderRobot;
import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.RenderInfo;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class RoboPounder
extends EntityLiving {
    public RenderInfo renderdata = new RenderInfo();

    public RoboPounder(World w) {
        super(w);
        this.maxrenderdist = 200;
        this.height = 12.75f;
        this.width = 4.75f;
        this.uniquename = "OreSpawn:RoboPounder";
        this.moveSpeed = 0.26f;
        this.setMaxHealth(100.0f);
        this.setHealth(100.0f);
        this.setDefense(4.0f);
        this.setAttackDamage(80.0f);
        this.searchDistance = 26.0f;
        this.attackRange = 6.0f;
        this.movefrequency = 35;
        this.setExperience(190);
        this.canSwim = false;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = false;
        this.tower_defense_enable = true;
    }

    public String getLivingSound() {
        if (this.world.rand.nextBoolean()) {
            return null;
        }
        int which = this.world.rand.nextInt(4);
        if (which == 0) {
            return "OreSpawn:robot_living1";
        }
        if (which == 1) {
            return "OreSpawn:robot_living2";
        }
        if (which == 2) {
            return "OreSpawn:robot_living3";
        }
        return "OreSpawn:robot_living4";
    }

    public String getHurtSound() {
        int which = this.world.rand.nextInt(8);
        if (which == 0) {
            return "OreSpawn:robot_hurt1";
        }
        if (which == 1) {
            return "OreSpawn:robot_hurt2";
        }
        if (which == 2) {
            return "OreSpawn:robot_hurt3";
        }
        if (which == 3) {
            return "OreSpawn:robot_hurt4";
        }
        if (which == 4) {
            return "OreSpawn:robot_hurt5";
        }
        if (which == 5) {
            return "OreSpawn:robot_hurt6";
        }
        if (which == 6) {
            return "OreSpawn:robot_hurt7";
        }
        return "OreSpawn:robot_hurt8";
    }

    public String getDeathSound() {
        int which = this.world.rand.nextInt(6);
        if (which == 0) {
            return "OreSpawn:robot_death1";
        }
        if (which == 1) {
            return "OreSpawn:robot_death2";
        }
        if (which == 2) {
            return "OreSpawn:robot_death3";
        }
        if (which == 3) {
            return "OreSpawn:robot_death4";
        }
        if (which == 4) {
            return "OreSpawn:robot_death5";
        }
        return "OreSpawn:robot_death6";
    }

    public void doDeathDrops() {
        int i = 0;
        while (i < 5) {
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand((World)this.world, (int)0, (int)Items.dark.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand((World)this.world, (int)0, (int)Items.light.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand((World)this.world, (int)0, (int)Items.instability.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand((World)this.world, (int)0, (int)Items.lumpcopper.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand((World)this.world, (int)0, (int)Items.lumptin.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand((World)this.world, (int)0, (int)Items.lumpsilver.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand((World)this.world, (int)0, (int)Items.lumpplatinum.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(8) == 1) {
                Utils.doDropRand((World)this.world, (int)Blocks.blockcopper.blockID, (int)0, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(8) == 1) {
                Utils.doDropRand((World)this.world, (int)Blocks.blocktin.blockID, (int)0, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(8) == 1) {
                Utils.doDropRand((World)this.world, (int)Blocks.blocksilver.blockID, (int)0, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(8) == 1) {
                Utils.doDropRand((World)this.world, (int)Blocks.blockplatinum.blockID, (int)0, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            ++i;
        }
        if (this.world.rand.nextInt(8) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophyrobopounder.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public void doAttack(Entity victim) {
        this.destroyBlocks(victim);
        super.doAttack(victim);
    }

    public void doDistanceAttack(Entity victim) {
        this.destroyNearbyBlocks();
    }

    protected void destroyNearbyBlocks() {
        int i = 0;
        while (i < 50) {
            double z;
            double y;
            double x = this.posx + (double)this.world.rand.nextFloat() * 6.5 - (double)this.world.rand.nextFloat() * 6.5;
            int bid = this.world.getblock(this.dimension, (int)x, (int)(y = this.posy + 0.1 + (double)this.world.rand.nextFloat() * 6.5), (int)(z = this.posz + (double)this.world.rand.nextFloat() * 6.5 - (double)this.world.rand.nextFloat() * 6.5));
            if (bid != Blocks.stopblock.blockID && bid != 0) {
                this.world.setblockWithPerm((Entity)this, this.dimension, (int)x, (int)y, (int)z, 0);
            }
            ++i;
        }
    }

    protected void destroyBlocks(Entity e) {
        int i = 0;
        while (i < 8) {
            double z;
            double y;
            double x = e.posx + (double)this.world.rand.nextFloat() - (double)this.world.rand.nextFloat();
            int bid = this.world.getblock(this.dimension, (int)x, (int)(y = e.posy - 0.75), (int)(z = e.posz + (double)this.world.rand.nextFloat() - (double)this.world.rand.nextFloat()));
            if (bid != Blocks.stopblock.blockID && bid != 0) {
                this.world.setblockWithPerm((Entity)this, this.dimension, (int)x, (int)y, (int)z, 0);
            }
            ++i;
        }
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof RoboBomb) {
            return false;
        }
        if (e instanceof RoboPounder) {
            return false;
        }
        if (e instanceof RoboGunner) {
            return false;
        }
        if (e instanceof RoboWarrior) {
            return false;
        }
        if (e instanceof RoboSniper) {
            return false;
        }
        if (e instanceof Jeffery) {
            return false;
        }
        if (e instanceof AntRobot) {
            return false;
        }
        if (e instanceof SpiderRobot) {
            return false;
        }
        if (e instanceof Player && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e.temperament == 1 && this.CanProbablySeeEntity(e);
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/RoboPoundertexture.png");
        }
        return this.texture;
    }
}

