/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class Peacock
extends EntityLiving {
    public boolean blinkstate = false;
    public Texture texture2 = null;

    public Peacock(World w) {
        super(w);
        this.maxrenderdist = 130;
        this.height = 1.9f;
        this.width = 0.8f;
        this.uniquename = "OreSpawn:Peacock";
        this.moveSpeed = 0.95f;
        this.setMaxHealth(10.0f);
        this.setHealth(10.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(0.0f);
        this.movefrequency = 30;
        this.setExperience(5);
        this.canSwim = true;
        this.enable_avoid = true;
        this.avoiddistance = 32;
        this.daytimespawn = true;
        this.nighttimespawn = false;
        this.daytimedespawn = true;
        this.nighttimedespawn = true;
        this.enableBreeding(10);
        this.findbuddydistance = 16;
        this.findbuddyfrequency = 6;
        this.canridemaglevcart = true;
    }

    public void init() {
        if (this.getBID() == 0 && this.world != null && this.world.isServer) {
            this.setBID(1);
            if (this.world.rand.nextInt(100) == 1) {
                this.setBID(2);
            }
        }
        super.init();
    }

    public void doEntityAction(float deltaT) {
        this.enable_buddy = this.isBaby();
        super.doEntityAction(deltaT);
    }

    public boolean isBuddy(Entity e) {
        return e instanceof Peacock;
    }

    public boolean isBreedingFoodForMe(int bid, int iid) {
        if (iid == Items.corn.itemID) {
            return true;
        }
        return iid == OreSpawnMain.crystalapple.itemID;
    }

    public boolean shouldAvoidEntity(Entity e) {
        return e instanceof Player;
    }

    public String getLivingSound() {
        if (this.world.rand.nextInt(4) != 2) {
            return null;
        }
        return "OreSpawn:peacock_living";
    }

    public String getHurtSound() {
        return "OreSpawn:peacock_hit";
    }

    public String getDeathSound() {
        return "OreSpawn:peacock_dead";
    }

    public void update(float deltaT) {
        if (this.world.isServer && this.world.rand.nextInt(5000) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.eggpeacock.itemID, (float)0.1f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.update(deltaT);
    }

    public boolean getBlink() {
        if (this.blinkstate) {
            if (this.world.rand.nextInt(60) == 1) {
                this.blinkstate = false;
            }
        } else if (this.world.rand.nextInt(180) == 1) {
            this.blinkstate = true;
        }
        return this.blinkstate;
    }

    public void doDeathDrops() {
        Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.peacockmeat.itemID, (float)2.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        int howmany = 2 + this.world.rand.nextInt(4);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.peacockfeather.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophypeacock.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.getBID() == 2) {
            howmany = 40 + this.world.rand.nextInt(10);
            i = 0;
            while (i < howmany) {
                Utils.doDropRand((World)this.world, (int)0, (int)Items.coingold.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
                ++i;
            }
            howmany = 20 + this.world.rand.nextInt(8);
            i = 0;
            while (i < howmany) {
                Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.egggoldcow.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
                ++i;
            }
            howmany = 20 + this.world.rand.nextInt(8);
            i = 0;
            while (i < howmany) {
                Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.yellowapple.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
                ++i;
            }
        }
        super.doDeathDrops();
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/Peacocktexture.png");
            this.texture2 = TextureMapper.getTexture((String)"orespawnres/skins/PeacockGoldentexture.png");
        }
        if (this.getBID() == 2) {
            return this.texture2;
        }
        return this.texture;
    }
}

