/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.UFO;
import OreSpawn.entities.UFOCarrier;
import OreSpawn.entities.UFOFighter;
import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.entities.Entity;
import dangerzone.entities.Martian;
import dangerzone.items.Item;
import dangerzone.items.Items;

public class MyMartian
extends Martian {
    public MyMartian(World w) {
        super(w);
        this.uniquename = "OreSpawn:Martian";
        this.tower_defense_enable = false;
        this.setCanDespawn(false);
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Martian) {
            return false;
        }
        if (e instanceof MyMartian) {
            return false;
        }
        if (e instanceof UFO) {
            return false;
        }
        if (e instanceof UFOCarrier) {
            return false;
        }
        if (e instanceof UFOFighter) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    public void doEntityAction(float deltaT) {
        super.doEntityAction(deltaT);
        double dist = 0.0;
        Player p = DangerZone.server.findNearestPlayer((Entity)this);
        if (p == null) {
            this.deadflag = true;
        } else {
            int ratemul = 1;
            if (this.getAttacking()) {
                ratemul = 5;
            }
            if ((dist = Utils.getHorizontalDistanceBetweenEntities((Entity)this, (Entity)p)) > (double)DangerZone.entityupdatedist) {
                this.deadflag = true;
            } else if (dist > (double)(DangerZone.entityupdatedist / 2)) {
                if (this.world.rand.nextInt(100 * ratemul) == 0) {
                    this.deadflag = true;
                }
            } else if (dist > (double)(DangerZone.entityupdatedist / 4)) {
                if (this.world.rand.nextInt(250 * ratemul) == 0) {
                    this.deadflag = true;
                }
            } else if (dist > (double)(DangerZone.entityupdatedist / 8) && this.world.rand.nextInt(500 * ratemul) == 0) {
                this.deadflag = true;
            }
        }
    }

    public void doTargetPrep(Entity ent) {
        this.enable_hostile = true;
        this.temperament = 1;
        if (ent == null) {
            this.moveSpeed = 0.25f;
            this.setAttacking(false);
        } else if (this.getDistanceFromEntity(ent) > (double)this.attackRange) {
            this.lookAtEntity(ent);
            this.setAttacking(false);
            this.moveSpeed = 0.05f;
        } else {
            this.setAttacking(true);
            this.moveSpeed = 0.25f;
        }
    }

    public void doDistanceAttack(Entity victim) {
        if (this.world.isServer) {
            InventoryContainer ic = this.getHotbar(0);
            if (ic != null && ic.iid == Items.bow.itemID) {
                float dist;
                this.lookAtEntity(victim);
                float fullholdcount = Items.getfullholdcount((int)ic.iid);
                float curcount = this.getRightButtonDownCount();
                if (curcount < 20.0f) {
                    curcount = 20.0f;
                }
                if (curcount > (fullholdcount *= (dist = (float)this.getDistanceFromEntity(victim)) / this.searchDistance)) {
                    Item it = ic.getItem();
                    if (it != null) {
                        it.rightclickup((Entity)this, ic, (int)curcount);
                    }
                    this.setRightButtonDownCount(0.0f);
                }
            }
            if (ic != null && ic.iid == OreSpawnMain.raygun.itemID) {
                this.lookAtEntity(victim);
                Item it = ic.getItem();
                if (it != null && this.world.rand.nextBoolean()) {
                    it.onRightClick((Entity)this, null, ic);
                }
            }
        }
    }
}

