/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.ThrownFireball;
import dangerzone.items.Items;
import dangerzone.threads.LightingThread;
import org.newdawn.slick.opengl.Texture;

public class Kyuubi
extends EntityLiving {
    public Kyuubi(World w) {
        super(w);
        this.maxrenderdist = 150;
        this.height = 1.75f;
        this.width = 0.95f;
        this.uniquename = "OreSpawn:Kyuubi";
        this.moveSpeed = 0.2f;
        this.setMaxHealth(80.0f);
        this.setHealth(80.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(10.0f);
        this.searchDistance = 32.0f;
        this.attackRange = 2.0f;
        this.movefrequency = 45;
        this.setExperience(99);
        this.canSwim = false;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = false;
        this.tower_defense_enable = true;
    }

    public void doDistanceAttack(Entity victim) {
        double startz;
        double starty;
        if (this.world.rand.nextInt(3) == 1) {
            return;
        }
        if (victim == null) {
            return;
        }
        double startx = this.posx + (double)((float)Math.sin(Math.toRadians(this.rotation_yaw_head)) * this.getWidth() * (float)Math.cos(Math.toRadians(this.rotation_pitch_head)));
        ThrownFireball e = (ThrownFireball)this.world.createEntityByName("DangerZone:ThrownFireball", this.dimension, startx, starty = this.posy + (double)(this.getHeight() * 0.9f), startz = this.posz + (double)((float)Math.cos(Math.toRadians(this.rotation_yaw_head)) * this.getWidth() * (float)Math.cos(Math.toRadians(this.rotation_pitch_head))));
        if (e != null) {
            e.init();
            e.setBID(0);
            e.setIID(Items.fireball.itemID);
            e.thrower = this;
            e.explosive_power = 1.0f;
            float hdist = (float)Math.sqrt((victim.posx - startx) * (victim.posx - startx) + (victim.posz - startz) * (victim.posz - startz));
            float tdirxz = (float)Math.atan2(victim.posx - startx, victim.posz - startz);
            float tdiry = (float)Math.atan2(starty - (victim.posy + (double)(victim.getHeight() / 2.0f)), hdist);
            e.setDirectionAndVelocity((float)Math.sin(tdirxz) * (float)Math.cos(tdiry), -((float)Math.sin(tdiry)), (float)Math.cos(tdirxz) * (float)Math.cos(tdiry), 5.5f, 0.2f);
            this.world.spawnEntityInWorld((Entity)e);
        }
        this.world.playSound("DangerZone:bow", this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
    }

    public String getLivingSound() {
        if (this.world.rand.nextBoolean()) {
            return null;
        }
        return "OreSpawn:kyuubi_living";
    }

    public String getHurtSound() {
        return "OreSpawn:alo_hurt";
    }

    public String getDeathSound() {
        return "OreSpawn:alo_death";
    }

    public void doDeathDrops() {
        int howmany = 4 + this.world.rand.nextInt(5);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.moosebone.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 3 + this.world.rand.nextInt(5);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.lumpsilver.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 3 + this.world.rand.nextInt(5);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.fireball.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(8) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophykyuubi.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public void update(float deltaT) {
        if (!this.world.isServer) {
            if (this.world.rand.nextInt(20) == 1) {
                Utils.spawnParticles((World)this.world, (String)"DangerZone:ParticleFire", (int)5, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz, (boolean)false);
            }
            if (this.world.rand.nextInt(20) == 1) {
                Utils.spawnParticles((World)this.world, (String)"DangerZone:ParticleSmoke", (int)5, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz, (boolean)false);
            }
            if (this.world.rand.nextInt(60) == 1) {
                LightingThread.addRequest((int)this.dimension, (int)((int)this.posx), (int)((int)(this.posy + 1.0)), (int)((int)this.posz), (float)0.65f);
            }
        }
        super.update(deltaT);
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Kyuubi) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/Kyuubitexture.png");
        }
        return this.texture;
    }
}

