/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.Squid;
import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.RenderInfo;
import dangerzone.entities.TargetHelper;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class Kraken
extends EntityLiving {
    float myspeed = 0.0f;
    public RenderInfo renderdata = new RenderInfo();
    private boolean isalive = false;
    private Entity caught = null;
    private int newtarget = 0;
    private int release = 0;
    private int long_enough = 1800;
    private int call_reinforcements = 0;
    private boolean hit_by_player = false;
    private int straight_down = 1;
    private int hurt_timer = 0;
    int stuck_count;
    int lx;
    int ly;
    int lz;

    public Kraken(World w) {
        super(w);
        this.maxrenderdist = 280;
        this.uniquename = "OreSpawn:Kraken";
        if (w != null) {
            this.myspeed = 0.3f + this.world.rand.nextFloat() * 0.15f;
        }
        this.takesFallDamage = false;
        this.movefrequency = 65;
        this.canSwim = false;
        this.setExperience(150);
        this.height = 15.75f;
        this.width = 4.75f;
        this.setMaxHealth(1000.0f);
        this.setHealth(1000.0f);
        this.setDefense(2.0f);
        this.setAttackDamage(50.0f);
        this.searchDistance = 128.0f;
        this.attackRange = 10.0f;
        this.setCanDespawn(false);
        this.isImmuneToFire = true;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = false;
        this.canFly = true;
        this.setFlying(true);
        this.tower_defense_enable = false;
    }

    public void doAttackFrom(Entity e, int dt, float pain) {
        if (dt == 9) {
            return;
        }
        if (dt == 12) {
            return;
        }
        if (dt == 10) {
            return;
        }
        if (this.world.rand.nextBoolean() && this.caught != null) {
            this.release = 1;
        }
        super.doAttackFrom(e, dt, pain);
    }

    private boolean canSeeTarget(double px, double py, double pz) {
        return this.CanProbablySee(this.dimension, px, py, pz, (int)Math.sqrt((this.posx - px) * (this.posx - px) + (this.posy - py) * (this.posy - py) + (this.posz - pz) * (this.posz - pz)));
    }

    public void doEntityAction(float deltaT) {
        int i;
        int bid;
        Entity e;
        ++this.searchcounter;
        if (this.searchcounter >= 10) {
            this.searchcounter = this.world.rand.nextInt(4);
            if (this.hurtMe != null && this.hurtMe.deadflag) {
                this.hurtMe = null;
            }
            if (this.world.rand.nextInt(30) == 1) {
                this.hurtMe = null;
            }
            this.targetentity = this.hurtMe;
            if (this.targetentity != null) {
                this.target = new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy + 15.0, this.targetentity.posz);
                this.setAttacking(true);
            } else {
                this.setAttacking(false);
            }
        }
        int keep_trying = 35;
        if (this.target == null) {
            this.target = new TargetHelper(this.posx, this.posy, this.posz);
        }
        if (this.hurt_timer > 0) {
            --this.hurt_timer;
        }
        if (this.long_enough > 0) {
            --this.long_enough;
        }
        if (this.world.rand.nextInt(100) == 1 && !DangerZone.playnicely && (e = this.world.createEntityByName("DangerZone:Lightning", this.dimension, this.posx, this.posy - 16.0, this.posz)) != null) {
            e.init();
            e.setAttackDamage(15.0f);
            this.world.spawnEntityInWorld(e);
        }
        if (!(this.world.rand.nextInt(400) != 1 && DangerZone.thundercount != 0 || DangerZone.playnicely || (e = this.world.createEntityByName("DangerZone:Cloud", this.dimension, this.posx + (double)(this.world.rand.nextInt(64) - this.world.rand.nextInt(64)), 200.0, this.posz + (double)(this.world.rand.nextInt(64) - this.world.rand.nextInt(64)))) == null)) {
            e.init();
            e.setBID(Blocks.cloud_thunder.blockID);
            this.world.spawnEntityInWorld(e);
        }
        ++this.stuck_count;
        if (this.lx != (int)this.posx || this.ly != (int)this.posy || this.lz != (int)this.posz) {
            this.stuck_count = 0;
            this.lx = (int)this.posx;
            this.ly = (int)this.posy;
            this.lz = (int)this.posz;
        }
        if (this.stuck_count > 30 || this.newtarget != 0 || this.world.rand.nextInt(250) == 1 || this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < (double)6.1f) {
            this.newtarget = 0;
            this.stuck_count = 0;
            int ground_dist = 0;
            while (ground_dist < 31) {
                bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy - ground_dist, (int)this.posz);
                if (bid != 0) {
                    this.straight_down = 0;
                    break;
                }
                ++ground_dist;
            }
            ground_dist = 20 - ground_dist;
            bid = 1;
            while (bid != 0 && keep_trying != 0) {
                int zdir = this.world.rand.nextInt(6) + 18;
                int xdir = this.world.rand.nextInt(6) + 18;
                if (this.world.rand.nextInt(2) == 0) {
                    zdir = -zdir;
                }
                if (this.world.rand.nextInt(2) == 0) {
                    xdir = -xdir;
                }
                if (this.straight_down != 0) {
                    xdir = 0;
                    zdir = 0;
                }
                this.target.setTarget((double)((int)this.posx + xdir), (double)((int)this.posy + ground_dist + this.world.rand.nextInt(9) - 6), (double)((int)this.posz + zdir));
                bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz);
                if (bid == 0 && !this.canSeeTarget((int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) {
                    bid = 1;
                }
                --keep_trying;
            }
            this.myspeed = 0.3f + this.world.rand.nextFloat() * 0.15f;
            if (this.long_enough <= 0 || this.posy < 200.0 && this.getHealth() < this.getMaxHealth() / 4.0f) {
                this.target.setTarget((double)((int)this.target.targetx), (double)((int)this.target.targety + 30), (double)((int)this.target.targetz));
                if (this.hit_by_player && this.call_reinforcements == 0 && this.getHealth() < this.getMaxHealth() / 8.0f && this.posy > 130.0) {
                    this.call_reinforcements = 1;
                    i = 0;
                    while (i < 10) {
                        Entity e2 = this.world.createEntityByName("OreSpawn:Kraken", this.dimension, this.posx + (double)this.world.rand.nextInt(10) - (double)this.world.rand.nextInt(10), 190.0, this.posz + (double)this.world.rand.nextInt(10) - (double)this.world.rand.nextInt(10));
                        if (e2 != null) {
                            e2.init();
                            this.world.spawnEntityInWorld(e2);
                        }
                        ++i;
                    }
                }
            }
        }
        if (this.caught == null && this.world.rand.nextInt(8) == 1 && !DangerZone.playnicely) {
            e = null;
            e = this.findSomethingToAttack();
            if (e != null) {
                this.myspeed = 0.3f + this.world.rand.nextFloat() * 0.15f;
                this.target.setTarget((double)((int)e.posx), (double)((int)e.posy + 15), (double)((int)e.posz));
                this.pickItUpMaybe(e);
            }
        }
        if (this.caught != null) {
            if (!this.caught.deadflag) {
                this.target.setTarget((double)((int)this.posx), 210.0, (double)((int)this.posz));
                if (this.posy > 200.0) {
                    this.release = 1;
                }
                if (this.world.rand.nextInt(30) == 1) {
                    this.caught.doAttackFrom((Entity)this, 4, this.getAttackDamage());
                }
                this.caught.motionx = this.motionx;
                this.caught.motionz = this.motionz;
                this.caught.motiony = this.motiony;
                this.caught.posx = this.posx;
                if (this.posy - this.caught.posy > 16.0) {
                    this.caught.motiony = (float)((double)this.caught.motiony + 0.25);
                }
                this.caught.posy = this.posy - 15.0;
                this.caught.posz = this.posz;
                if (this.caught instanceof Player) {
                    Player p = (Player)this.caught;
                    p.server_thread.sendPositionAndVelocityUpdateToPlayer(p);
                }
                if (this.release != 0 || this.world.rand.nextInt(250) == 1) {
                    this.caught = null;
                    this.newtarget = 1;
                    this.release = 0;
                    this.setAttacking(false);
                }
            } else {
                this.caught = null;
                this.newtarget = 1;
                this.release = 0;
                this.setAttacking(false);
            }
        }
        double dy = this.target.targety - this.posy;
        this.motiony += 0.15f * deltaT;
        if ((dy /= 20.0) > (double)0.1f) {
            dy = 0.1f;
        }
        if (dy < (double)-0.1f) {
            dy = -0.1f;
        }
        this.motiony = (float)((double)this.motiony + dy);
        if (this.motiony > 1.0f) {
            this.motiony = 1.0f;
        }
        if (this.motiony < -1.0f) {
            this.motiony = -1.0f;
        }
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
        float ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 10.0);
        float speedadjust = 1.0f;
        float effectspeed = this.getTotalEffect(1);
        if (effectspeed > 1.0f) {
            speedadjust *= effectspeed;
        }
        if ((effectspeed = this.getTotalEffect(2)) > 1.0f) {
            speedadjust /= effectspeed;
        }
        this.motionx = (float)((double)this.motionx + (double)(this.myspeed * speedadjust) * Math.sin(tdir) * (double)deltaT);
        this.motionz = (float)((double)this.motionz + (double)(this.myspeed * speedadjust) * Math.cos(tdir) * (double)deltaT);
        double obstruction_factor = 0.0;
        double dx = 0.0;
        double dz = 0.0;
        int dist = 10;
        int k = -20;
        while (k < 18) {
            i = 1;
            while (i < dist) {
                dx = (double)i * Math.cos(Math.toRadians(this.rotation_yaw + 90.0f));
                bid = this.world.getblock(this.dimension, (int)(this.posx + dx), (int)this.posy + k, (int)(this.posz + (dz = (double)i * Math.sin(Math.toRadians(this.rotation_yaw + 90.0f)))));
                if (bid != 0) {
                    obstruction_factor += 0.1;
                }
                i += 2;
            }
            k += 2;
        }
        this.motiony = (float)((double)this.motiony + obstruction_factor * 0.08);
        this.posy += obstruction_factor * 0.08;
        if (this.posy > 254.0 && this.getCanDespawn()) {
            this.deadflag = true;
        }
        if (!(this.isHurt() || this.deadflag || this.getStaying() || this.world.rand.nextInt(100) != 1)) {
            this.world.playSound(this.getLivingSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, this.getLivingSoundVolume(), this.getLivingSoundPitch());
        }
    }

    private void pickItUpMaybe(Entity par1) {
        if (DangerZone.playnicely) {
            return;
        }
        if (this.caught != null) {
            return;
        }
        double dist = (this.posx - par1.posx) * (this.posx - par1.posx);
        dist += (this.posz - par1.posz) * (this.posz - par1.posz);
        if ((dist += (this.posy - par1.posy - 15.0) * (this.posy - par1.posy - 15.0)) < 40.0) {
            this.caught = par1;
            this.release = 0;
            this.setAttacking(true);
        }
    }

    public void update(float deltaT) {
        this.isalive = true;
        super.update(deltaT);
    }

    public boolean isAlive() {
        return this.isalive;
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Kraken) {
            return false;
        }
        if (e instanceof Squid) {
            return false;
        }
        if (e.getWidth() * e.getHeight() < 1.0f) {
            return false;
        }
        if (e.getRiddenEntity() != null) {
            return false;
        }
        if (e.getRiderEntity() != null) {
            return false;
        }
        if (e instanceof Player && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof EntityLiving && this.CanProbablySeeEntity(e);
    }

    public boolean CanProbablySeeEntity(Entity e) {
        int nblks = (int)this.getDistanceFromEntity(e);
        if (nblks < 1) {
            return true;
        }
        double cx = this.posx;
        double cz = this.posz;
        float startx = (float)cx;
        float starty = (float)(this.posy + 2.0);
        float startz = (float)cz;
        float dx = (float)((e.posx - (double)startx) / (double)nblks);
        float dy = (float)((e.posy + (double)(e.getHeight() * 7.0f / 8.0f) - (double)starty) / (double)nblks);
        float dz = (float)((e.posz - (double)startz) / (double)nblks);
        if ((double)Math.abs(dx) > 1.0) {
            dy /= Math.abs(dx);
            dz /= Math.abs(dx);
            nblks = (int)((float)nblks * Math.abs(dx));
            if (dx > 1.0f) {
                dx = 1.0f;
            }
            if (dx < -1.0f) {
                dx = -1.0f;
            }
        }
        if ((double)Math.abs(dy) > 1.0) {
            dx /= Math.abs(dy);
            dz /= Math.abs(dy);
            nblks = (int)((float)nblks * Math.abs(dy));
            if (dy > 1.0f) {
                dy = 1.0f;
            }
            if (dy < -1.0f) {
                dy = -1.0f;
            }
        }
        if ((double)Math.abs(dz) > 1.0) {
            dy /= Math.abs(dz);
            dx /= Math.abs(dz);
            nblks = (int)((float)nblks * Math.abs(dz));
            if (dz > 1.0f) {
                dz = 1.0f;
            }
            if (dz < -1.0f) {
                dz = -1.0f;
            }
        }
        int i = 0;
        while (i < nblks) {
            if (Blocks.isSolid((int)this.world.getblock(this.dimension, (int)(startx += dx), (int)(starty += dy), (int)(startz += dz)), (World)this.world, (int)this.dimension, (int)((int)startx), (int)((int)starty), (int)((int)startz))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void doDeathDrops() {
        int howmany = 60 + this.world.rand.nextInt(40);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.fishmeat.itemID, (float)12.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 60 + this.world.rand.nextInt(40);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.feather.itemID, (float)20.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 10 + this.world.rand.nextInt(20);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.moosebone.itemID, (float)20.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.krakentooth.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophykraken.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        super.doDeathDrops();
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/Krakentexture.png");
        }
        return this.texture;
    }

    public String getHurtSound() {
        return null;
    }

    public String getDeathSound() {
        return "DangerZone:alo_death";
    }

    public String getLivingSound() {
        if (this.world.rand.nextInt(2) != 1) {
            return null;
        }
        return "OreSpawn:kraken_living";
    }

    public float getLivingSoundVolume() {
        return 2.5f;
    }

    public void setBaby(boolean tf) {
    }
}

