/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class Hydrolisc
extends EntityLiving {
    public Hydrolisc(World w) {
        super(w);
        this.maxrenderdist = 110;
        this.height = 0.75f;
        this.width = 0.95f;
        this.uniquename = "OreSpawn:Hydrolisc";
        this.moveSpeed = 0.25f;
        this.setMaxHealth(100.0f);
        this.setHealth(100.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(0.0f);
        this.movefrequency = 25;
        this.setExperience(25);
        this.setCanDespawn(false);
        this.enable_avoid = true;
        this.avoiddistance = 20;
        this.enable_findfoodblock = true;
        this.foodblockfreq = 30;
        this.foodblockdistxz = 13;
        this.foodblockdisty = 4;
        this.foodblockheal = 1;
        this.foodblockdisteat = 12;
        this.fooddaytimeonly = false;
        this.canSwim = true;
        this.enable_taming = true;
        this.maxdisttoowner = 22.0f;
        this.enable_followfood = true;
        this.foodsearchDistance = 12;
        this.enable_droppedfood = true;
        this.enableBreeding(10);
        this.findbuddydistance = 16;
        this.findbuddyfrequency = 6;
    }

    public boolean isBuddy(Entity e) {
        return e instanceof Hydrolisc;
    }

    public void doEntityAction(float deltaT) {
        this.enable_buddy = this.isBaby();
        super.doEntityAction(deltaT);
        if (this.getOwnerName() != null) {
            Player p = (Player)DangerZone.server.entityManager.findPlayerByName(this.getOwnerName());
            if (p != null && p.getHealth() < p.getMaxHealth() && this.getHealth() - 10.0f > 0.0f) {
                p.heal(1.0f);
                p.server_thread.sendVarFloatUpdate(1, p.getHealth());
                this.heal(-1.0f);
                Utils.spawnParticlesFromServer((World)this.world, (String)"DangerZone:ParticleHappy", (int)20, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
                Utils.spawnParticlesFromServer((World)this.world, (String)"DangerZone:ParticleHappy", (int)20, (int)this.dimension, (double)p.posx, (double)p.posy, (double)p.posz);
            }
            this.avoiddistance = 10;
        }
        if (this.world.rand.nextInt(10) == 1) {
            if (this.getInLiquid()) {
                Utils.spawnParticlesFromServer((World)this.world, (String)"DangerZone:ParticleDroplet", (int)20, (int)this.dimension, (double)this.posx, (double)(this.posy + 1.0), (double)this.posz);
                this.enable_findfoodblock = false;
            } else {
                this.enable_findfoodblock = true;
            }
        }
    }

    public boolean shouldAvoidEntity(Entity e) {
        return e.temperament == 1;
    }

    public boolean isFoodBlock(int bid) {
        return bid == Blocks.water.blockID || bid == Blocks.waterstatic.blockID;
    }

    public boolean isBreedingFoodForMe(int bid, int iid) {
        if (iid == Items.fishmeat.itemID) {
            return true;
        }
        return iid == OreSpawnMain.crystalapple.itemID;
    }

    public boolean isFoodItem(int iid) {
        return iid == Items.fishmeat.itemID;
    }

    public void doEatFoodAction(int d, int x, int y, int z) {
        if (this.getInLiquid() && this.getHealth() < this.getMaxHealth()) {
            this.heal(2.0f);
            Utils.spawnParticlesFromServer((World)this.world, (String)"DangerZone:ParticleHappy", (int)10, (int)this.dimension, (double)this.posx, (double)(this.posy + 1.0), (double)this.posz);
        }
    }

    public String getLivingSound() {
        if (this.getInLiquid()) {
            return "DangerZone:little_splash";
        }
        return null;
    }

    public String getHurtSound() {
        return "OreSpawn:cryo_hurt";
    }

    public String getDeathSound() {
        return "OreSpawn:cryo_death";
    }

    public void doDeathDrops() {
        Utils.doDropRand((World)this.world, (int)Blocks.flower_red.blockID, (int)0, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        Utils.doDropRand((World)this.world, (int)0, (int)Items.fishmeat.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        if (this.world.rand.nextInt(6) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophyhydrolisc.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/Hydrolisctexture.png");
        }
        return this.texture;
    }
}

