/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.blocks;

import OreSpawn.OreSpawnMain;
import dangerzone.BreakChecks;
import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.blocks.ButterflyPlant;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlockItem;

public class ShrinkberryPlant
extends ButterflyPlant {
    public ShrinkberryPlant(String n, String txt) {
        super(n, txt);
        this.breaksound = "DangerZone:leavesbreak";
        this.placesound = "DangerZone:leavesplace";
        this.hitsound = "DangerZone:leaves_hit";
        this.isSolidForRendering = false;
        this.isSolid = false;
        this.hasOwnRenderer = true;
        this.randomtick = true;
        this.isLeaves = true;
        this.maxdamage = 1;
        this.burntime = 10;
        this.showInInventory = false;
    }

    public int getBlockDrop(Player p, World w, int dimension, int x, int y, int z) {
        return 0;
    }

    public int getItemDrop(Player p, World w, int dimension, int x, int y, int z) {
        if (this.blockID == OreSpawnMain.shrinkberry_plant3.blockID) {
            int howmany = 2 + w.rand.nextInt(5);
            int i = 0;
            while (i < howmany) {
                Utils.doDropRand((World)w, (int)0, (int)OreSpawnMain.shrinkberries.itemID, (float)1.0f, (int)dimension, (double)x, (double)(y + 1), (double)z);
                Utils.spawnExperience((int)3, (World)w, (int)dimension, (double)x, (double)(y + 1), (double)z);
                ++i;
            }
        }
        return 0;
    }

    public void notifyNeighborChanged(World w, int d, int x, int y, int z) {
        int bid = w.getblock(d, x, y - 1, z);
        if (bid != Blocks.dirt.blockID) {
            EntityBlockItem e;
            w.setblock(d, x, y, z, 0);
            if (w.rand.nextInt(4) == 1 && (e = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, d, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5)) != null) {
                e.fill((Object)OreSpawnMain.shrinkberry_plant, 1);
                w.spawnEntityInWorld((Entity)e);
            }
        }
    }

    public void tickMe(World w, int d, int x, int y, int z) {
        if (!w.isServer) {
            return;
        }
        if (w.getblock(d, x, y + 1, z) != 0) {
            w.setblock(d, x, y, z, 0);
            return;
        }
        int bid = w.getblock(d, x, y - 1, z);
        if (bid != Blocks.dirt.blockID) {
            w.setblock(d, x, y, z, 0);
            return;
        }
        if (w.isDaytime() && w.rand.nextInt(45) == 1) {
            int growto = 0;
            if (this.blockID == OreSpawnMain.shrinkberry_plant.blockID) {
                growto = OreSpawnMain.shrinkberry_plant1.blockID;
            }
            if (this.blockID == OreSpawnMain.shrinkberry_plant1.blockID) {
                growto = OreSpawnMain.shrinkberry_plant2.blockID;
            }
            if (this.blockID == OreSpawnMain.shrinkberry_plant2.blockID) {
                growto = OreSpawnMain.shrinkberry_plant3.blockID;
            }
            if (growto != 0) {
                if (!BreakChecks.canChangeBlock((World)w, (int)d, (int)x, (int)y, (int)z, (int)d, (int)x, (int)y, (int)z, (int)0, (int)0)) {
                    return;
                }
                w.setblock(d, x, y, z, growto);
            }
        }
    }
}

