/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn;

import OreSpawn.CrystalMaze;
import OreSpawn.OreSpawnDungeons;
import OreSpawn.OreSpawnMain;
import OreSpawn.OreSpawnTrees;
import OreSpawn.entities.ElementDragon;
import dangerzone.DangerZone;
import dangerzone.Dimensions;
import dangerzone.StuffList;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.WorldDecorator;
import dangerzone.biomes.Biome;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;

public class OreSpawnWorldDecorator
extends WorldDecorator {
    public static int recently_placed = 0;

    public void decorate(World world, int dimension, Biome b, int chunkx, int chunkz) {
        int i;
        if (!world.isServer) {
            return;
        }
        if (b == null) {
            return;
        }
        if (recently_placed > 0) {
            --recently_placed;
        }
        if (Dimensions.getName((int)dimension).equals("OreSpawn: Utopia Dimension")) {
            this.addcorn(world, dimension, chunkx << 4, chunkz << 4);
            this.addtomatoes(world, dimension, chunkx << 4, chunkz << 4);
            this.addfireflies(world, dimension, chunkx << 4, chunkz << 4);
            this.addmoths(world, dimension, chunkx << 4, chunkz << 4);
            this.addmoreflowers(world, dimension, chunkx << 4, chunkz << 4);
            this.addmoreveggies(world, dimension, chunkx << 4, chunkz << 4);
            this.addants(world, dimension, chunkx << 4, chunkz << 4);
            this.addduplicatortree(world, dimension, chunkx << 4, chunkz << 4);
            boolean rbd = false;
            rbd = this.addRubyDungeon(world, dimension, chunkx * 16, chunkz * 16);
            if (!rbd) {
                this.addGenericDungeon(world, dimension, chunkx * 16, chunkz * 16);
            }
        }
        if (Dimensions.getName((int)dimension).equals("OreSpawn: Mining Dimension")) {
            if (b.uniquename.equals("OreSpawn:Mining Plains")) {
                this.addtomatoes(world, dimension, chunkx << 4, chunkz << 4);
                this.addfireflies(world, dimension, chunkx << 4, chunkz << 4);
                this.addmoths(world, dimension, chunkx << 4, chunkz << 4);
                this.addmosquitos(world, dimension, chunkx << 4, chunkz << 4);
                this.addmoreveggies(world, dimension, chunkx << 4, chunkz << 4);
                this.addants(world, dimension, chunkx << 4, chunkz << 4);
                this.addduplicatortree(world, dimension, chunkx << 4, chunkz << 4);
            }
            if (recently_placed == 0 && DangerZone.rand.nextInt(95) == 1) {
                i = DangerZone.rand.nextInt(7);
                if (i == 0) {
                    this.addBasiliskMaze(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (i == 1) {
                    this.addKyuubiDungeon(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (i == 2) {
                    this.addBeeHive(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (i == 3) {
                    this.addShadowDungeon(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (i == 4) {
                    this.addAlienWTF(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (i == 5) {
                    this.addEnderKnight(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (i == 6) {
                    this.addLeonNest(world, dimension, chunkx * 16, chunkz * 16);
                }
            } else {
                this.addGenericDungeon(world, dimension, chunkx * 16, chunkz * 16);
            }
            if (recently_placed == 0 && b.uniquename.equals("OreSpawn:Mining Plains")) {
                boolean ahh;
                i = world.rand.nextInt(6);
                if (i == 0) {
                    this.addPlayPool(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (i == 1) {
                    this.addWaterDragonLair(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (i == 2) {
                    this.addGoldFishBowl(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (i == 3) {
                    this.addGirlfriendIsland(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (i == 4) {
                    this.addMonsterIsland(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (i == 5) {
                    this.addFrogPond(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (!(ahh = this.addANest(world, dimension, chunkx * 16, chunkz * 16))) {
                    ahh = this.addHauntedHouse(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (!ahh) {
                    ahh = this.addLeafMonster(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (!ahh) {
                    ahh = this.addSpitBug(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (!ahh) {
                    ahh = this.addIgloo(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (!ahh) {
                    ahh = this.addBouncyCastle(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (!ahh) {
                    ahh = this.addRubberDuckyPond(world, dimension, chunkx * 16, chunkz * 16);
                }
            }
        }
        if (Dimensions.getName((int)dimension).equals("OreSpawn: Robot Dimension")) {
            this.addcorn(world, dimension, chunkx << 4, chunkz << 4);
            this.addfireflies(world, dimension, chunkx << 4, chunkz << 4);
            this.addmoths(world, dimension, chunkx << 4, chunkz << 4);
            this.addmoreveggies(world, dimension, chunkx << 4, chunkz << 4);
            this.addants(world, dimension, chunkx << 4, chunkz << 4);
            this.addGenericDungeon(world, dimension, chunkx * 16, chunkz * 16);
            if (recently_placed == 0) {
                this.addDamselInDistress(world, dimension, chunkx * 16, chunkz * 16);
            }
            if (recently_placed == 0) {
                this.addSpiderHangout(world, dimension, chunkx * 16, chunkz * 16);
            }
            if (recently_placed == 0) {
                this.addRedAntHangout(world, dimension, chunkx * 16, chunkz * 16);
            }
        }
        if (Dimensions.getName((int)dimension).equals("OreSpawn: Danger Dimension")) {
            this.addants(world, dimension, chunkx << 4, chunkz << 4);
            this.addislands(world, dimension, chunkx << 4, chunkz << 4);
            if (recently_placed == 0 && DangerZone.rand.nextInt(100) == 0 && this.D4BigSpaceCheck(world, dimension, chunkx * 16, 7, chunkz * 16)) {
                i = DangerZone.rand.nextInt(23);
                if (i == 0) {
                    this.addD4Castle(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (i == 1) {
                    this.addD4Castle(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (i == 2) {
                    this.addD4EnderCastle(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (i == 3) {
                    this.addD4IncaPyramid(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (i == 4) {
                    this.addD4RobotLab(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (i == 5) {
                    this.addD4Mini(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (i == 6) {
                    this.addD4RubyDungeon(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (i == 7) {
                    this.addD4CephadromeAltar(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (i == 8) {
                    this.addD4Greenhouse(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (i == 9) {
                    this.addD4NightmareRookery(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (i == 10) {
                    this.addD4StinkyHouse(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (i == 11) {
                    this.addD4WhiteHouse(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (i == 12) {
                    this.addPumpkin(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (i == 13) {
                    this.addD4Rainbow(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (i == 14) {
                    this.addEndKnights(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (i == 15) {
                    this.addEndReapers(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (i == 16) {
                    this.addHospital(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (i == 17) {
                    this.addEnderCastle(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (i > 17) {
                    this.addD4GenericDungeon(world, dimension, chunkx * 16, chunkz * 16);
                }
            }
            if ((i = DangerZone.rand.nextInt(300)) == 0) {
                this.addD4CloudShark(world, dimension, chunkx * 16, chunkz * 16);
            }
        }
        if (Dimensions.getName((int)dimension).equals("OreSpawn: Chaos Dimension")) {
            this.addfireflies(world, dimension, chunkx << 4, chunkz << 4);
            this.addmoths(world, dimension, chunkx << 4, chunkz << 4);
            this.addmosquitos(world, dimension, chunkx << 4, chunkz << 4);
            this.addants(world, dimension, chunkx << 4, chunkz << 4);
            this.addduplicatortree(world, dimension, chunkx << 4, chunkz << 4);
        }
        if (Dimensions.getName((int)dimension).equals("OreSpawn: Crystal Dimension")) {
            CrystalMaze cm = new CrystalMaze();
            cm.buildCrystalMaze(world, dimension, chunkx << 4, 25, chunkz << 4);
            this.addcrystaltermites(world, dimension, chunkx << 4, chunkz << 4);
            if (!this.addFairyTree(world, dimension, chunkx * 16, chunkz * 16) && recently_placed == 0) {
                if (!(this.addRotatorStation(world, dimension, chunkx * 16, chunkz * 16) || this.addUrchinSpawner(world, dimension, chunkx * 16, chunkz * 16) || this.addCrystalHauntedHouse(world, dimension, chunkx * 16, chunkz * 16) || this.addRoundRotator(world, dimension, chunkx * 16, chunkz * 16))) {
                    this.addCrystalBattleTower(world, dimension, chunkx * 16, chunkz * 16);
                }
                this.addIrukandji(world, dimension, chunkx * 16, chunkz * 16);
            }
            this.addCrystalChestsAndSpawners(world, dimension, chunkx * 16, chunkz * 16);
            this.addcrystalplants(world, dimension, chunkx * 16, chunkz * 16);
        }
        if (Dimensions.getName((int)dimension).equals("DangerZone: Overworld Dimension")) {
            this.addGenericDungeon(world, dimension, chunkx * 16, chunkz * 16);
            if (recently_placed == 0) {
                boolean ahh = this.addANest(world, dimension, chunkx * 16, chunkz * 16);
                if (!ahh) {
                    ahh = this.addHauntedHouse(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (!ahh) {
                    ahh = this.addLeafMonster(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (!ahh) {
                    ahh = this.addSpitBug(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (!ahh) {
                    ahh = this.addRubberDuckyPond(world, dimension, chunkx * 16, chunkz * 16);
                }
            }
            this.addants(world, dimension, chunkx << 4, chunkz << 4);
        }
        if (Dimensions.getName((int)dimension).equals("DangerZone: Big Round Tree Dimension")) {
            this.addGenericDungeon(world, dimension, chunkx * 16, chunkz * 16);
            this.addants(world, dimension, chunkx << 4, chunkz << 4);
        }
        if (Dimensions.getName((int)dimension).equals("DangerZone: Pathway Dimension")) {
            this.addGenericDungeon(world, dimension, chunkx * 16, chunkz * 16);
            this.addants(world, dimension, chunkx << 4, chunkz << 4);
        }
        if (Dimensions.getName((int)dimension).equals("DangerZone: Rugged Hills Dimension")) {
            if (recently_placed == 0 && b.uniquename.equals("DangerZone:Rugged Plains")) {
                boolean ahh;
                i = world.rand.nextInt(6);
                if (i == 0) {
                    this.addPlayPool(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (i == 1) {
                    this.addWaterDragonLair(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (i == 2) {
                    this.addGoldFishBowl(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (i == 3) {
                    this.addGirlfriendIsland(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (i == 4) {
                    this.addMonsterIsland(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (i == 5) {
                    this.addFrogPond(world, dimension, chunkx * 16, chunkz * 16);
                }
                if (!(ahh = this.addIgloo(world, dimension, chunkx * 16, chunkz * 16))) {
                    ahh = this.addBouncyCastle(world, dimension, chunkx * 16, chunkz * 16);
                }
                this.addants(world, dimension, chunkx << 4, chunkz << 4);
            }
            this.addGenericDungeon(world, dimension, chunkx * 16, chunkz * 16);
        }
        Dimensions.getName((int)dimension).equals("DangerZone: Sky Islands Dimension");
        if (Dimensions.getName((int)dimension).equals("OreSpawn: Doom Dimension")) {
            this.placeDoomNest(world, dimension, chunkx << 4, chunkz << 4);
        }
        if (Dimensions.getName((int)dimension).equals("OreSpawn: Dragon's Lair Dimension")) {
            this.placeFossil(world, dimension, chunkx << 4, chunkz << 4);
            this.placeDrantNest(world, dimension, chunkx << 4, chunkz << 4);
            if (b.uniquename.equals("OreSpawn:Dark Mountains")) {
                this.adddarktree(world, dimension, chunkx << 4, chunkz << 4, 250);
                this.placeFossil(world, dimension, chunkx << 4, chunkz << 4);
                this.placeFossil(world, dimension, chunkx << 4, chunkz << 4);
            }
            if (b.uniquename.equals("OreSpawn:Dark Hills")) {
                this.adddarktree(world, dimension, chunkx << 4, chunkz << 4, 50);
                this.placeFossil(world, dimension, chunkx << 4, chunkz << 4);
            }
            if (b.uniquename.equals("OreSpawn:Dark Plains")) {
                if (world.rand.nextInt(150) == 1) {
                    this.addElementDungeon(world, dimension, chunkx << 4, chunkz << 4);
                }
                this.adddarktree(world, dimension, chunkx << 4, chunkz << 4, 5);
            }
        }
        if (Dimensions.getName((int)dimension).equals("OreSpawn: The Zoo Dimension")) {
            this.addcorn(world, dimension, chunkx << 4, chunkz << 4);
            this.addtomatoes(world, dimension, chunkx << 4, chunkz << 4);
            this.addfireflies(world, dimension, chunkx << 4, chunkz << 4);
            this.addmoths(world, dimension, chunkx << 4, chunkz << 4);
            this.addmoreflowers(world, dimension, chunkx << 4, chunkz << 4);
            this.addmoreveggies(world, dimension, chunkx << 4, chunkz << 4);
            this.addants(world, dimension, chunkx << 4, chunkz << 4);
        }
        if (Dimensions.getName((int)dimension).equals("OreSpawn: Misfit Dimension")) {
            if (b.uniquename.equals("OreSpawn:Misfit Plains")) {
                this.addweeds(world, dimension, chunkx << 4, chunkz << 4, OreSpawnMain.fireweed.blockID);
                this.addfireflies(world, dimension, chunkx << 4, chunkz << 4);
            }
            if (b.uniquename.equals("OreSpawn:Warped Plains")) {
                this.addweeds(world, dimension, chunkx << 4, chunkz << 4, OreSpawnMain.fireweed.blockID);
                this.addweeds(world, dimension, chunkx << 4, chunkz << 4, OreSpawnMain.sickweed.blockID);
                this.addfireflies(world, dimension, chunkx << 4, chunkz << 4);
            }
            if (b.uniquename.equals("OreSpawn:Misfit Fields")) {
                this.addweeds(world, dimension, chunkx << 4, chunkz << 4, OreSpawnMain.speedweed.blockID);
            }
            if (b.uniquename.equals("OreSpawn:Warped Fields")) {
                this.addweeds(world, dimension, chunkx << 4, chunkz << 4, OreSpawnMain.speedweed.blockID);
                this.addweeds(world, dimension, chunkx << 4, chunkz << 4, OreSpawnMain.sickweed.blockID);
            }
            if (b.uniquename.equals("OreSpawn:Misfit Hills")) {
                this.addweeds(world, dimension, chunkx << 4, chunkz << 4, OreSpawnMain.slowweed.blockID);
            }
            if (b.uniquename.equals("OreSpawn:Warped Hills")) {
                this.addweeds(world, dimension, chunkx << 4, chunkz << 4, OreSpawnMain.slowweed.blockID);
                this.addweeds(world, dimension, chunkx << 4, chunkz << 4, OreSpawnMain.sickweed.blockID);
            }
            if (b.uniquename.equals("OreSpawn:Bad Place")) {
                this.addweeds(world, dimension, chunkx << 4, chunkz << 4, OreSpawnMain.slowweed.blockID);
                this.addweeds(world, dimension, chunkx << 4, chunkz << 4, OreSpawnMain.sickweed.blockID);
                this.addweeds(world, dimension, chunkx << 4, chunkz << 4, OreSpawnMain.locoweed.blockID);
                this.addweeds(world, dimension, chunkx << 4, chunkz << 4, OreSpawnMain.fireweed.blockID);
                this.addweeds(world, dimension, chunkx << 4, chunkz << 4, OreSpawnMain.slowweed.blockID);
                this.addweeds(world, dimension, chunkx << 4, chunkz << 4, OreSpawnMain.sickweed.blockID);
                this.addweeds(world, dimension, chunkx << 4, chunkz << 4, OreSpawnMain.locoweed.blockID);
                this.addweeds(world, dimension, chunkx << 4, chunkz << 4, OreSpawnMain.fireweed.blockID);
                this.addmoths(world, dimension, chunkx << 4, chunkz << 4);
                this.addmosquitos(world, dimension, chunkx << 4, chunkz << 4);
            } else {
                this.addants(world, dimension, chunkx << 4, chunkz << 4);
            }
        }
    }

    private void placeDrantNest(World world, int d, int x, int z) {
        if (world.rand.nextInt(32) == 1) {
            int ix = x + world.rand.nextInt(16);
            int iz = z + world.rand.nextInt(16);
            int iy = 150;
            while (iy > 60) {
                if (world.getblock(d, ix, iy, iz) == OreSpawnMain.darkdirt.blockID && world.getblock(d, ix, iy + 1, iz) == 0) {
                    world.setblock(d, ix, iy, iz, OreSpawnMain.drantnest.blockID);
                    break;
                }
                --iy;
            }
        }
    }

    private void placeDoomNest(World world, int d, int x, int z) {
        if (world.rand.nextInt(64) == 1) {
            int ix = x + world.rand.nextInt(16);
            int iz = z + world.rand.nextInt(16);
            int iy = 100;
            while (iy > 30) {
                if (world.getblock(d, ix, iy, iz) == OreSpawnMain.nofallsand.blockID && world.getblock(d, ix, iy + 1, iz) == 0) {
                    world.setblock(d, ix, iy, iz, OreSpawnMain.doomantnest.blockID);
                    break;
                }
                --iy;
            }
        }
    }

    private void addElementDungeon(World world, int d, int x, int z) {
        int ix = x + world.rand.nextInt(16);
        int iz = z + world.rand.nextInt(16);
        int iy = 150;
        while (iy > 60) {
            if (world.getblock(d, ix, iy, iz) == OreSpawnMain.darkdirt.blockID && world.getblock(d, ix, iy + 1, iz) == 0) {
                int i = 0;
                while (i < 20) {
                    world.setblock(d, ix, iy + i + 1, iz, Blocks.greystone2.blockID);
                    ++i;
                }
                OreSpawnDungeons.makeElementDungeon(world, d, ix, iy + 21, iz);
                ElementDragon e = (ElementDragon)world.createEntityByName("OreSpawn:Element Dragon", d, (double)ix, (double)(iy + 26), (double)iz);
                if (e == null) break;
                e.init();
                e.setGuardMode();
                world.spawnEntityInWorld((Entity)e);
                break;
            }
            --iy;
        }
    }

    private void adddarktree(World world, int d, int x, int z, int howoften) {
        if (world.rand.nextInt(howoften) == 1) {
            int ix = x + world.rand.nextInt(16);
            int iz = z + world.rand.nextInt(16);
            int iy = 150;
            while (iy > 60) {
                if (world.getblock(d, ix, iy, iz) == OreSpawnMain.darkdirt.blockID && world.getblock(d, ix, iy + 1, iz) == 0) {
                    OreSpawnTrees tr = new OreSpawnTrees();
                    tr.darkTreeNormal(world, d, ix, iy, iz);
                    break;
                }
                --iy;
            }
        }
    }

    private void placeFossil(World world, int d, int x, int z) {
        int j;
        int ix = x + world.rand.nextInt(16);
        int iz = z + world.rand.nextInt(16);
        int iy = world.rand.nextInt(45);
        int width = 1 + world.rand.nextInt(6);
        int length = 1 + world.rand.nextInt(6);
        int i = -width;
        while (i <= width) {
            j = -length;
            while (j <= length) {
                if ((i == 0 || j == 0) && Blocks.isSolid((int)world.getblock(d, ix + i, iy, iz + j))) {
                    world.setblock(d, ix + i, iy, iz + j, OreSpawnMain.fossilbone.blockID);
                }
                ++j;
            }
            ++i;
        }
        i = width;
        j = length;
        if (i >= j) {
            j = 0;
        } else {
            i = 0;
        }
        if (world.rand.nextBoolean()) {
            i = -i;
            j = -j;
        }
        if (Blocks.isSolid((int)world.getblock(d, ix + i, iy, iz + j))) {
            world.setblock(d, ix + i, iy, iz + j, OreSpawnMain.dragoneyestone.blockID);
        }
    }

    private void addfireflies(World world, int d, int x, int z) {
        if (world.rand.nextInt(100) == 1) {
            int howmany = 1 + world.rand.nextInt(3);
            int m = 0;
            while (m < howmany) {
                int ix = x + world.rand.nextInt(16);
                int iz = x + world.rand.nextInt(16);
                int iy = 150;
                while (iy > 70) {
                    if (world.getblock(d, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(d, ix, iy + 1, iz) == 0) {
                        world.setblock(d, ix, iy + 1, iz, OreSpawnMain.firefly_plant.blockID);
                        break;
                    }
                    --iy;
                }
                ++m;
            }
        }
    }

    private void addmoths(World world, int d, int x, int z) {
        if (world.rand.nextInt(100) == 1) {
            int howmany = 1 + world.rand.nextInt(3);
            int m = 0;
            while (m < howmany) {
                int ix = x + world.rand.nextInt(16);
                int iz = x + world.rand.nextInt(16);
                int iy = 150;
                while (iy > 70) {
                    if (world.getblock(d, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(d, ix, iy + 1, iz) == 0) {
                        world.setblock(d, ix, iy + 1, iz, OreSpawnMain.moth_plant.blockID);
                        break;
                    }
                    --iy;
                }
                ++m;
            }
        }
    }

    private void addmosquitos(World world, int d, int x, int z) {
        if (world.rand.nextInt(100) == 1) {
            int howmany = 1 + world.rand.nextInt(3);
            int m = 0;
            while (m < howmany) {
                int ix = x + world.rand.nextInt(16);
                int iz = x + world.rand.nextInt(16);
                int iy = 150;
                while (iy > 70) {
                    if (world.getblock(d, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(d, ix, iy + 1, iz) == 0) {
                        world.setblock(d, ix, iy + 1, iz, OreSpawnMain.mosquito_plant.blockID);
                        break;
                    }
                    --iy;
                }
                ++m;
            }
        }
    }

    private void addcorn(World world, int d, int x, int z) {
        if (world.rand.nextInt(64) == 1) {
            int howmany = 1 + world.rand.nextInt(5);
            int m = 0;
            while (m < howmany) {
                int ix = x + world.rand.nextInt(16);
                int iz = z + world.rand.nextInt(16);
                int iy = 100;
                while (iy > 50) {
                    if (world.getblock(d, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(d, ix, iy + 1, iz) == 0) {
                        int howhigh = 3 + world.rand.nextInt(6);
                        int i = 0;
                        while (i < howhigh) {
                            if (world.getblock(d, ix, iy + i + 2, iz) != 0) {
                                howhigh = i;
                                break;
                            }
                            world.setblock(d, ix, iy + i + 1, iz, world.rand.nextBoolean() ? Blocks.corn_plant2.blockID : Blocks.corn_plant3.blockID);
                            ++i;
                        }
                        world.setblock(d, ix, iy, iz, Blocks.dirt.blockID);
                        world.setblock(d, ix, iy + howhigh + 1, iz, Blocks.corn_plant.blockID);
                        break;
                    }
                    --iy;
                }
                ++m;
            }
        }
    }

    private void addtomatoes(World world, int d, int x, int z) {
        if (world.rand.nextInt(64) == 1) {
            int howmany = 1 + world.rand.nextInt(5);
            int m = 0;
            while (m < howmany) {
                int ix = x + world.rand.nextInt(16);
                int iz = z + world.rand.nextInt(16);
                int iy = 100;
                while (iy > 50) {
                    if (world.getblock(d, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(d, ix, iy + 1, iz) == 0) {
                        int howhigh = 3 + world.rand.nextInt(3);
                        int i = 0;
                        while (i < howhigh) {
                            if (world.getblock(d, ix, iy + i + 2, iz) != 0) {
                                howhigh = i;
                                break;
                            }
                            world.setblock(d, ix, iy + i + 1, iz, world.rand.nextBoolean() ? OreSpawnMain.tomato_plant2.blockID : OreSpawnMain.tomato_plant3.blockID);
                            ++i;
                        }
                        world.setblock(d, ix, iy, iz, Blocks.dirt.blockID);
                        world.setblock(d, ix, iy + howhigh + 1, iz, OreSpawnMain.tomato_plant.blockID);
                        break;
                    }
                    --iy;
                }
                ++m;
            }
        }
    }

    private void addmoreflowers(World world, int d, int x, int z) {
        if (world.rand.nextInt(16) == 1) {
            int howmany = 1 + world.rand.nextInt(6);
            int what = Blocks.flower_pink.blockID;
            if (world.rand.nextBoolean()) {
                what = Blocks.flower_purple.blockID;
            }
            int m = 0;
            while (m < howmany) {
                int ix = x + world.rand.nextInt(16);
                int iz = z + world.rand.nextInt(16);
                int iy = 120;
                while (iy > 60) {
                    if (world.getblock(d, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(d, ix, iy + 1, iz) == 0) {
                        world.setblock(d, ix, iy + 1, iz, what);
                        break;
                    }
                    --iy;
                }
                ++m;
            }
        }
    }

    private void addweeds(World world, int d, int x, int z, int what) {
        if (world.rand.nextInt(32) == 1) {
            int howmany = 1 + world.rand.nextInt(4);
            int m = 0;
            while (m < howmany) {
                int ix = x + world.rand.nextInt(16);
                int iz = z + world.rand.nextInt(16);
                int iy = 120;
                while (iy > 60) {
                    if (world.getblock(d, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(d, ix, iy + 1, iz) == 0) {
                        world.setblock(d, ix, iy + 1, iz, what);
                        break;
                    }
                    --iy;
                }
                ++m;
            }
        }
    }

    private void addcrystalplants(World world, int d, int x, int z) {
        if (world.rand.nextInt(5) == 1) {
            int howmany = 2 + world.rand.nextInt(8);
            int what = OreSpawnMain.crystalflower_red.blockID;
            int which = world.rand.nextInt(5);
            if (which == 1) {
                what = OreSpawnMain.crystalflower_blue.blockID;
            }
            if (which == 2) {
                what = OreSpawnMain.crystalflower_green.blockID;
            }
            if (which == 3) {
                what = OreSpawnMain.crystalflower_yellow.blockID;
            }
            if (which == 4) {
                what = OreSpawnMain.quinoa_plant.blockID;
            }
            int m = 0;
            while (m < howmany) {
                int ix = x + world.rand.nextInt(16);
                int iz = z + world.rand.nextInt(16);
                int iy = 120;
                while (iy > 60) {
                    if (world.getblock(d, ix, iy, iz) == OreSpawnMain.crystalgrass.blockID && world.getblock(d, ix, iy + 1, iz) == 0) {
                        world.setblock(d, ix, iy + 1, iz, what);
                        break;
                    }
                    --iy;
                }
                ++m;
            }
        }
    }

    private void addmoreveggies(World world, int d, int x, int z) {
        if (world.rand.nextInt(16) == 1) {
            int howmany = 1 + world.rand.nextInt(6);
            int what = world.rand.nextInt(5);
            int bid = Blocks.radish_plant.blockID;
            if (what == 1) {
                bid = Blocks.rice_plant.blockID;
            }
            if (what == 2) {
                bid = OreSpawnMain.lettuce_plant.blockID;
                if (world.rand.nextInt(3) == 1) {
                    bid = OreSpawnMain.lettuce_plant3.blockID;
                }
            }
            if (what == 3) {
                bid = OreSpawnMain.strawberry_plant.blockID;
                if (world.rand.nextInt(3) == 1) {
                    bid = OreSpawnMain.strawberry_plant3.blockID;
                }
            }
            if (what == 4) {
                bid = OreSpawnMain.shrinkberry_plant.blockID;
                if (world.rand.nextInt(3) == 1) {
                    bid = OreSpawnMain.shrinkberry_plant3.blockID;
                }
            }
            int m = 0;
            while (m < howmany) {
                int ix = x + world.rand.nextInt(16);
                int iz = z + world.rand.nextInt(16);
                int iy = 120;
                while (iy > 60) {
                    if (world.getblock(d, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(d, ix, iy + 1, iz) == 0) {
                        world.setblock(d, ix, iy, iz, Blocks.dirt.blockID);
                        world.setblock(d, ix, iy + 1, iz, bid);
                        break;
                    }
                    --iy;
                }
                ++m;
            }
        }
    }

    private void addduplicatortree(World world, int d, int x, int z) {
        if (world.rand.nextInt(100) == 1) {
            int what = OreSpawnMain.MyDT.blockID;
            int ix = x + world.rand.nextInt(16);
            int iz = z + world.rand.nextInt(16);
            int iy = 150;
            while (iy > 60) {
                if (world.getblock(d, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(d, ix, iy + 1, iz) == 0) {
                    world.setblock(d, ix, iy, iz, Blocks.dirt.blockID);
                    world.setblock(d, ix, iy + 1, iz, what);
                    break;
                }
                --iy;
            }
        }
    }

    private void addants(World world, int d, int x, int z) {
        if (world.rand.nextInt(50) == 1) {
            int howmany = 1 + world.rand.nextInt(3);
            int what = OreSpawnMain.brownantnest.blockID;
            int tmp = world.rand.nextInt(8);
            if (tmp == 0) {
                what = OreSpawnMain.brownantnest.blockID;
            }
            if (tmp == 1) {
                what = OreSpawnMain.redantnest.blockID;
            }
            if (tmp == 2) {
                what = OreSpawnMain.robotantnest.blockID;
            }
            if (tmp == 3) {
                what = OreSpawnMain.rainbowantnest.blockID;
            }
            if (tmp == 4) {
                what = OreSpawnMain.unstableantnest.blockID;
            }
            if (tmp == 5) {
                what = OreSpawnMain.termitenest.blockID;
            }
            if (tmp == 6) {
                what = OreSpawnMain.zooantnest.blockID;
            }
            if (tmp == 7) {
                what = OreSpawnMain.misfitantnest.blockID;
            }
            int m = 0;
            while (m < howmany) {
                int ix = x + world.rand.nextInt(16);
                int iz = z + world.rand.nextInt(16);
                int iy = 100;
                while (iy > 4) {
                    if (world.getblock(d, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(d, ix, iy + 1, iz) == 0) {
                        world.setblock(d, ix, iy, iz, what);
                        break;
                    }
                    --iy;
                }
                ++m;
            }
        }
    }

    private void addislands(World world, int d, int x, int z) {
        if (world.rand.nextInt(30) == 1) {
            int ix = x + world.rand.nextInt(16);
            int iz = z + world.rand.nextInt(16);
            int iy = 20;
            while (iy > 4) {
                if (world.getblock(d, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(d, ix, iy + 1, iz) == 0) {
                    world.setblock(d, ix, iy + 1, iz, OreSpawnMain.islandblock.blockID);
                    break;
                }
                --iy;
            }
        }
    }

    private void addcrystaltermites(World world, int d, int x, int z) {
        if (world.rand.nextInt(30) == 1) {
            int howmany = 1 + world.rand.nextInt(3);
            int what = OreSpawnMain.crystaltermitenest.blockID;
            int m = 0;
            while (m < howmany) {
                int ix = x + world.rand.nextInt(16);
                int iz = z + world.rand.nextInt(16);
                int iy = 100;
                while (iy > 4) {
                    if (world.getblock(d, ix, iy, iz) == OreSpawnMain.crystalgrass.blockID && world.getblock(d, ix, iy + 1, iz) == 0) {
                        world.setblock(d, ix, iy, iz, what);
                        break;
                    }
                    --iy;
                }
                ++m;
            }
        }
    }

    public boolean addHauntedHouse(World world, int dim, int chunkX, int chunkZ) {
        if (DangerZone.rand.nextInt(285) != 0) {
            return false;
        }
        int i = 0;
        while (i < 5) {
            int posX = chunkX + DangerZone.rand.nextInt(16);
            int posZ = chunkZ + DangerZone.rand.nextInt(16);
            int posY = 100;
            while (posY > 40) {
                if (world.getblock(dim, posX, posY, posZ) != 0) break;
                if (world.getblock(dim, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                    OreSpawnMain.MyDungeons.makeHauntedHouse(world, dim, posX, posY, posZ);
                    recently_placed = 50;
                    return true;
                }
                --posY;
            }
            ++i;
        }
        return false;
    }

    public boolean addANest(World world, int dim, int chunkX, int chunkZ) {
        if (DangerZone.rand.nextInt(230) != 0) {
            return false;
        }
        int i = 0;
        while (i < 5) {
            int posX = chunkX + DangerZone.rand.nextInt(16);
            int posZ = chunkZ + DangerZone.rand.nextInt(16);
            int posY = 128;
            while (posY > 40) {
                if (world.getblock(dim, posX, posY, posZ) != 0) break;
                if (world.getblock(dim, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                    if (DangerZone.rand.nextInt(2) == 0) {
                        OreSpawnMain.MyDungeons.makeSmallBeeHive(world, dim, posX, posY, posZ);
                    } else {
                        OreSpawnMain.MyDungeons.makeMantisHive(world, dim, posX, posY, posZ);
                    }
                    recently_placed = 50;
                    return true;
                }
                --posY;
            }
            ++i;
        }
        return false;
    }

    public void addPlayPool(World world, int dim, int chunkX, int chunkZ) {
        if (DangerZone.rand.nextInt(350) != 0) {
            return;
        }
        int i = 0;
        while (i < 4) {
            int posX = chunkX + DangerZone.rand.nextInt(16);
            int posZ = chunkZ + DangerZone.rand.nextInt(16);
            int posY = 100;
            while (posY > 40) {
                if (world.getblock(dim, posX, posY, posZ) == 0 && world.getblock(dim, posX, posY - 1, posZ) == Blocks.waterstatic.blockID) {
                    OreSpawnMain.MyDungeons.makePlayPool(world, dim, posX, posY, posZ);
                    recently_placed = 50;
                    return;
                }
                --posY;
            }
            ++i;
        }
    }

    public void addFrogPond(World world, int dim, int chunkX, int chunkZ) {
        if (DangerZone.rand.nextInt(350) != 0) {
            return;
        }
        int i = 0;
        while (i < 4) {
            int posX = chunkX + DangerZone.rand.nextInt(16);
            int posZ = chunkZ + DangerZone.rand.nextInt(16);
            int posY = 100;
            while (posY > 40) {
                if (world.getblock(dim, posX, posY, posZ) == 0 && world.getblock(dim, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                    OreSpawnMain.MyDungeons.makeFrogPond(world, dim, posX, posY - 1, posZ);
                    recently_placed = 50;
                    return;
                }
                --posY;
            }
            ++i;
        }
    }

    public void addGoldFishBowl(World world, int dim, int chunkX, int chunkZ) {
        if (DangerZone.rand.nextInt(350) != 0) {
            return;
        }
        int i = 0;
        while (i < 4) {
            int posX = chunkX + DangerZone.rand.nextInt(16);
            int posZ = chunkZ + DangerZone.rand.nextInt(16);
            int posY = 100;
            while (posY > 40) {
                if (world.getblock(dim, posX, posY, posZ) == 0 && world.getblock(dim, posX, posY - 1, posZ) == Blocks.waterstatic.blockID) {
                    OreSpawnMain.MyDungeons.makeGoldFishBowl(world, dim, posX, posY - 1, posZ);
                    recently_placed = 50;
                    return;
                }
                --posY;
            }
            ++i;
        }
    }

    public boolean addLeafMonster(World world, int dim, int chunkX, int chunkZ) {
        if (DangerZone.rand.nextInt(275) != 0) {
            return false;
        }
        int i = 0;
        while (i < 4) {
            int posX = chunkX + DangerZone.rand.nextInt(16);
            int posZ = chunkZ + DangerZone.rand.nextInt(16);
            int posY = 100;
            while (posY > 40) {
                if (world.getblock(dim, posX, posY, posZ) == 0 && world.getblock(dim, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                    OreSpawnMain.MyDungeons.makeLeafMonsterDungeon(world, dim, posX, posY, posZ);
                    recently_placed = 50;
                    return true;
                }
                --posY;
            }
            ++i;
        }
        return false;
    }

    public boolean addRubberDuckyPond(World world, int dim, int chunkX, int chunkZ) {
        if (DangerZone.rand.nextInt(275) != 0) {
            return false;
        }
        int i = 0;
        while (i < 4) {
            int posX = chunkX + DangerZone.rand.nextInt(16);
            int posZ = chunkZ + DangerZone.rand.nextInt(16);
            int posY = 100;
            while (posY > 40) {
                if (world.getblock(dim, posX, posY, posZ) == 0 && world.getblock(dim, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                    OreSpawnMain.MyDungeons.makeRubberDuckyPond(world, dim, posX, posY, posZ);
                    recently_placed = 50;
                    return true;
                }
                --posY;
            }
            ++i;
        }
        return false;
    }

    public boolean addSpitBug(World world, int dim, int chunkX, int chunkZ) {
        if (DangerZone.rand.nextInt(190) != 0) {
            return false;
        }
        int i = 0;
        while (i < 4) {
            int posX = chunkX + DangerZone.rand.nextInt(16);
            int posZ = chunkZ + DangerZone.rand.nextInt(16);
            int posY = 100;
            while (posY > 40) {
                if (world.getblock(dim, posX, posY, posZ) == 0 && world.getblock(dim, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                    OreSpawnMain.MyDungeons.makeSpitBugLair(world, dim, posX, posY, posZ);
                    recently_placed = 50;
                    return true;
                }
                --posY;
            }
            ++i;
        }
        return false;
    }

    public boolean addIgloo(World world, int dim, int chunkX, int chunkZ) {
        if (DangerZone.rand.nextInt(220) != 0) {
            return false;
        }
        int i = 0;
        while (i < 4) {
            int posX = chunkX + DangerZone.rand.nextInt(16);
            int posZ = chunkZ + DangerZone.rand.nextInt(16);
            int posY = 100;
            while (posY > 40) {
                if (world.getblock(dim, posX, posY, posZ) == 0 && world.getblock(dim, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                    OreSpawnMain.MyDungeons.makeIgloo(world, dim, posX, posY - 2, posZ);
                    recently_placed = 50;
                    return true;
                }
                --posY;
            }
            ++i;
        }
        return false;
    }

    public boolean addBouncyCastle(World world, int dim, int chunkX, int chunkZ) {
        if (DangerZone.rand.nextInt(230) != 0) {
            return false;
        }
        int i = 0;
        while (i < 4) {
            int posX = chunkX + DangerZone.rand.nextInt(16);
            int posZ = chunkZ + DangerZone.rand.nextInt(16);
            int posY = 100;
            while (posY > 40) {
                if (world.getblock(dim, posX, posY, posZ) == 0 && world.getblock(dim, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                    OreSpawnMain.MyDungeons.makeBouncyCastle(world, dim, posX, posY - 1, posZ);
                    recently_placed = 50;
                    return true;
                }
                --posY;
            }
            ++i;
        }
        return false;
    }

    public boolean addDamselInDistress(World world, int dim, int chunkX, int chunkZ) {
        if (DangerZone.rand.nextInt(250) != 0) {
            return false;
        }
        int i = 0;
        while (i < 4) {
            int posX = chunkX + DangerZone.rand.nextInt(16);
            int posZ = chunkZ + DangerZone.rand.nextInt(16);
            int posY = 100;
            while (posY > 40) {
                if (world.getblock(dim, posX, posY, posZ) == 0 && world.getblock(dim, posX, posY - 1, posZ) == Blocks.grassblock.blockID && this.quickSpaceCheck(world, dim, posX, posY - 1, posZ)) {
                    OreSpawnMain.MyDungeons.makeDamselInDistress(world, dim, posX, posY - 1, posZ);
                    recently_placed = 50;
                    return true;
                }
                --posY;
            }
            ++i;
        }
        return false;
    }

    public boolean addSpiderHangout(World world, int dim, int chunkX, int chunkZ) {
        if (DangerZone.rand.nextInt(350) != 0) {
            return false;
        }
        int i = 0;
        while (i < 4) {
            int posX = chunkX + DangerZone.rand.nextInt(16);
            int posZ = chunkZ + DangerZone.rand.nextInt(16);
            int posY = 100;
            while (posY > 40) {
                if (world.getblock(dim, posX, posY, posZ) == 0 && world.getblock(dim, posX, posY - 1, posZ) == Blocks.grassblock.blockID && this.quickSpaceCheck(world, dim, posX, posY - 1, posZ)) {
                    OreSpawnMain.MyDungeons.makeSpiderHangout(world, dim, posX, posY - 1, posZ);
                    recently_placed = 50;
                    return true;
                }
                --posY;
            }
            ++i;
        }
        return false;
    }

    public boolean addRedAntHangout(World world, int dim, int chunkX, int chunkZ) {
        if (DangerZone.rand.nextInt(250) != 0) {
            return false;
        }
        int i = 0;
        while (i < 4) {
            int posX = chunkX + DangerZone.rand.nextInt(16);
            int posZ = chunkZ + DangerZone.rand.nextInt(16);
            int posY = 100;
            while (posY > 40) {
                if (world.getblock(dim, posX, posY, posZ) == 0 && world.getblock(dim, posX, posY - 1, posZ) == Blocks.grassblock.blockID && this.quickSpaceCheck(world, dim, posX, posY - 1, posZ)) {
                    OreSpawnMain.MyDungeons.makeRedAntHangout(world, dim, posX, posY - 1, posZ);
                    recently_placed = 50;
                    return true;
                }
                --posY;
            }
            ++i;
        }
        return false;
    }

    public void addWaterDragonLair(World world, int dim, int chunkX, int chunkZ) {
        if (DangerZone.rand.nextInt(350) != 0) {
            return;
        }
        int i = 0;
        while (i < 4) {
            int posX = chunkX + DangerZone.rand.nextInt(16);
            int posZ = chunkZ + DangerZone.rand.nextInt(16);
            int posY = 100;
            while (posY > 40) {
                if (world.getblock(dim, posX, posY, posZ) == 0 && world.getblock(dim, posX, posY - 1, posZ) == Blocks.waterstatic.blockID) {
                    OreSpawnMain.MyDungeons.makeWaterDragonLair(world, dim, posX, posY - 1, posZ);
                    recently_placed = 50;
                    return;
                }
                --posY;
            }
            ++i;
        }
    }

    public void addGirlfriendIsland(World world, int dim, int chunkX, int chunkZ) {
        if (DangerZone.rand.nextInt(300) != 0) {
            return;
        }
        int i = 0;
        while (i < 4) {
            int posX = chunkX + DangerZone.rand.nextInt(16);
            int posZ = chunkZ + DangerZone.rand.nextInt(16);
            int posY = 100;
            while (posY > 40) {
                if (world.getblock(dim, posX, posY, posZ) == 0 && world.getblock(dim, posX, posY - 1, posZ) == Blocks.waterstatic.blockID) {
                    OreSpawnMain.MyDungeons.makeGirlfriendIsland(world, dim, posX, posY - 1, posZ);
                    recently_placed = 50;
                    return;
                }
                --posY;
            }
            ++i;
        }
    }

    public void addMonsterIsland(World world, int dim, int chunkX, int chunkZ) {
        if (DangerZone.rand.nextInt(300) != 0) {
            return;
        }
        int i = 0;
        while (i < 4) {
            int posX = chunkX + DangerZone.rand.nextInt(16);
            int posZ = chunkZ + DangerZone.rand.nextInt(16);
            int posY = 100;
            while (posY > 40) {
                if (world.getblock(dim, posX, posY, posZ) == 0 && world.getblock(dim, posX, posY - 1, posZ) == Blocks.waterstatic.blockID) {
                    OreSpawnMain.MyDungeons.makeMonsterIsland(world, dim, posX, posY - 1, posZ);
                    recently_placed = 50;
                    return;
                }
                --posY;
            }
            ++i;
        }
    }

    public void addEndKnights(World world, int dim, int chunkX, int chunkZ) {
        if (DangerZone.rand.nextInt(25) != 0) {
            return;
        }
        int i = 0;
        while (i < 3) {
            int posX = chunkX + DangerZone.rand.nextInt(16);
            int posZ = chunkZ + DangerZone.rand.nextInt(16);
            int posY = 20;
            while (posY > 40) {
                if (world.getblock(dim, posX, posY, posZ) == 0 && world.getblock(dim, posX, posY - 1, posZ) == Blocks.grassblock.blockID && this.quickSpaceCheck(world, dim, posX, posY, posZ)) {
                    OreSpawnMain.MyDungeons.makeEnderKnightDungeon(world, dim, posX, posY, posZ);
                    recently_placed = 50;
                    return;
                }
                --posY;
            }
            ++i;
        }
    }

    public void addEndReapers(World world, int dim, int chunkX, int chunkZ) {
        if (DangerZone.rand.nextInt(25) != 0) {
            return;
        }
        int i = 0;
        while (i < 3) {
            int posX = chunkX + DangerZone.rand.nextInt(16);
            int posZ = chunkZ + DangerZone.rand.nextInt(16);
            int posY = 20;
            while (posY > 4) {
                if (world.getblock(dim, posX, posY, posZ) == 0 && world.getblock(dim, posX, posY - 1, posZ) == Blocks.grassblock.blockID && this.quickSpaceCheck(world, dim, posX, posY, posZ)) {
                    OreSpawnMain.MyDungeons.makeEnderReaperGraveyard(world, dim, posX, posY, posZ);
                    recently_placed = 50;
                    return;
                }
                --posY;
            }
            ++i;
        }
    }

    public void addHospital(World world, int dim, int chunkX, int chunkZ) {
        if (DangerZone.rand.nextInt(25) != 0) {
            return;
        }
        int i = 0;
        while (i < 3) {
            int posX = chunkX + DangerZone.rand.nextInt(16);
            int posZ = chunkZ + DangerZone.rand.nextInt(16);
            int posY = 20;
            while (posY > 4) {
                if (world.getblock(dim, posX, posY, posZ) == 0 && world.getblock(dim, posX, posY - 1, posZ) == Blocks.grassblock.blockID && this.quickSpaceCheck(world, dim, posX, posY, posZ)) {
                    OreSpawnMain.MyDungeons.makeEnderDragonHospital(world, dim, posX, posY, posZ);
                    recently_placed = 50;
                    return;
                }
                --posY;
            }
            ++i;
        }
    }

    public void addEnderCastle(World world, int dim, int chunkX, int chunkZ) {
        if (DangerZone.rand.nextInt(50) != 0) {
            return;
        }
        int i = 0;
        while (i < 3) {
            int posX = chunkX + DangerZone.rand.nextInt(16);
            int posZ = chunkZ + DangerZone.rand.nextInt(16);
            int posY = 20;
            while (posY > 4) {
                if (world.getblock(dim, posX, posY, posZ) == 0 && world.getblock(dim, posX, posY - 1, posZ) == Blocks.grassblock.blockID && this.quickBigSpaceCheck(world, dim, posX, posY, posZ)) {
                    OreSpawnMain.MyDungeons.makeEnderCastle(world, dim, posX, posY, posZ);
                    recently_placed = 50;
                    return;
                }
                --posY;
            }
            ++i;
        }
    }

    public boolean addRotatorStation(World world, int dim, int chunkX, int chunkZ) {
        if (DangerZone.rand.nextInt(150) != 0) {
            return false;
        }
        int i = 0;
        while (i < 3) {
            int posX = chunkX + DangerZone.rand.nextInt(16);
            int posZ = chunkZ + DangerZone.rand.nextInt(16);
            int posY = 100;
            while (posY > 50) {
                if (world.getblock(dim, posX, posY, posZ) == 0 && world.getblock(dim, posX, posY - 1, posZ) == OreSpawnMain.crystalgrass.blockID) {
                    OreSpawnMain.MyDungeons.makeRotatorStation(world, dim, posX, posY, posZ);
                    recently_placed = 50;
                    return true;
                }
                --posY;
            }
            ++i;
        }
        return false;
    }

    public boolean addRoundRotator(World world, int dim, int chunkX, int chunkZ) {
        if (DangerZone.rand.nextInt(150) != 0) {
            return false;
        }
        int i = 0;
        while (i < 3) {
            int posX = chunkX + DangerZone.rand.nextInt(16);
            int posZ = chunkZ + DangerZone.rand.nextInt(16);
            int posY = 100;
            while (posY > 50) {
                if (world.getblock(dim, posX, posY, posZ) == 0 && world.getblock(dim, posX, posY - 1, posZ) == OreSpawnMain.crystalgrass.blockID) {
                    OreSpawnMain.MyDungeons.makeRoundRotator(world, dim, posX, posY, posZ);
                    recently_placed = 50;
                    return true;
                }
                --posY;
            }
            ++i;
        }
        return false;
    }

    public boolean addUrchinSpawner(World world, int dim, int chunkX, int chunkZ) {
        if (DangerZone.rand.nextInt(180) != 0) {
            return false;
        }
        int i = 0;
        while (i < 3) {
            int posX = chunkX + DangerZone.rand.nextInt(16);
            int posZ = chunkZ + DangerZone.rand.nextInt(16);
            int posY = 100;
            while (posY > 50) {
                if (world.getblock(dim, posX, posY, posZ) == 0 && world.getblock(dim, posX, posY - 1, posZ) == OreSpawnMain.crystalgrass.blockID) {
                    OreSpawnMain.MyDungeons.makeUrchinSpawner(world, dim, posX, posY, posZ);
                    recently_placed = 50;
                    return true;
                }
                --posY;
            }
            ++i;
        }
        return false;
    }

    public boolean addCrystalHauntedHouse(World world, int dim, int chunkX, int chunkZ) {
        if (DangerZone.rand.nextInt(230) != 0) {
            return false;
        }
        int i = 0;
        while (i < 3) {
            int posX = chunkX + DangerZone.rand.nextInt(16);
            int posZ = chunkZ + DangerZone.rand.nextInt(16);
            int posY = 100;
            while (posY > 50) {
                if (world.getblock(dim, posX, posY, posZ) == 0 && world.getblock(dim, posX, posY - 1, posZ) == OreSpawnMain.crystalgrass.blockID) {
                    OreSpawnMain.MyDungeons.makeCrystalHauntedHouse(world, dim, posX, posY, posZ);
                    recently_placed = 50;
                    return true;
                }
                --posY;
            }
            ++i;
        }
        return false;
    }

    public boolean addCrystalBattleTower(World world, int dim, int chunkX, int chunkZ) {
        if (DangerZone.rand.nextInt(280) != 0) {
            return false;
        }
        int i = 0;
        while (i < 3) {
            int posX = chunkX + DangerZone.rand.nextInt(16);
            int posZ = chunkZ + DangerZone.rand.nextInt(16);
            int posY = 100;
            while (posY > 50) {
                if (world.getblock(dim, posX, posY, posZ) == 0 && world.getblock(dim, posX, posY - 1, posZ) == OreSpawnMain.crystalgrass.blockID) {
                    OreSpawnMain.MyDungeons.makeCrystalBattleTower(world, dim, posX, posY, posZ);
                    recently_placed = 50;
                    return true;
                }
                --posY;
            }
            ++i;
        }
        return false;
    }

    public void addIrukandji(World world, int dim, int chunkX, int chunkZ) {
        if (DangerZone.rand.nextInt(80) != 0) {
            return;
        }
        int i = 0;
        while (i < 3) {
            int posX = chunkX + DangerZone.rand.nextInt(16);
            int posZ = chunkZ + DangerZone.rand.nextInt(16);
            int posY = 100;
            while (posY > 50) {
                if (world.getblock(dim, posX, posY, posZ) == 0 && world.getblock(dim, posX, posY - 1, posZ) == Blocks.waterstatic.blockID) {
                    world.setblock(dim, posX, posY, posZ, OreSpawnMain.irukandjispawner.blockID);
                    return;
                }
                --posY;
            }
            ++i;
        }
    }

    public void addCrystalChestsAndSpawners(World world, int dim, int chunkX, int chunkZ) {
        int bid = 0;
        int i = 0;
        while (i < 3) {
            int posZ;
            int posY;
            int posX = 1 + chunkX + DangerZone.rand.nextInt(14);
            if (world.getblock(dim, posX, posY = 25, posZ = 1 + chunkZ + DangerZone.rand.nextInt(14)) == 0) {
                bid = world.getblock(dim, posX, posY, posZ);
                if (bid != 0) break;
                bid = world.getblock(dim, posX + 1, posY, posZ);
                if (bid == 0) {
                    this.addCrystalChest(world, dim, posX, posY, posZ, 5);
                    break;
                }
                bid = world.getblock(dim, posX - 1, posY, posZ);
                if (bid == 0) {
                    this.addCrystalChest(world, dim, posX, posY, posZ, 4);
                    break;
                }
                bid = world.getblock(dim, posX, posY, posZ + 1);
                if (bid == 0) {
                    this.addCrystalChest(world, dim, posX, posY, posZ, 2);
                    break;
                }
                bid = world.getblock(dim, posX, posY, posZ - 1);
                if (bid != 0) break;
                this.addCrystalChest(world, dim, posX, posY, posZ, 3);
                break;
            }
            ++i;
        }
    }

    public void addCrystalChest(World world, int dim, int x, int y, int z, int dir) {
        int i = world.rand.nextInt(3);
        if (i == 0) {
            Utils.add_chest((World)world, (int)dim, (int)x, (int)y, (int)z, (StuffList[])OreSpawnDungeons.AllTheCrystalStuff);
        } else {
            int t = world.rand.nextInt(2);
            if (t == 0) {
                world.setblock(dim, x, y, z, OreSpawnMain.dungeonbeastspawner.blockID);
            }
            if (t == 1) {
                world.setblock(dim, x, y, z, Blocks.ratspawner.blockID);
            }
        }
    }

    public boolean addFairyTree(World world, int dim, int chunkX, int chunkZ) {
        int posX = chunkX + 8;
        int posZ = chunkZ + 8;
        if (DangerZone.rand.nextInt(5) != 0) {
            return false;
        }
        int posY = 128;
        while (posY > 40) {
            if (world.getblock(dim, posX, posY, posZ) == 0 && world.getblock(dim, posX, posY - 1, posZ) == OreSpawnMain.crystalgrass.blockID) {
                int bid;
                int j;
                int i = -8;
                while (i <= 8) {
                    j = -8;
                    while (j <= 8) {
                        bid = world.getblock(dim, posX + i, posY, posZ + j);
                        if (bid != 0) {
                            return false;
                        }
                        ++j;
                    }
                    ++i;
                }
                i = -2;
                while (i <= 2) {
                    j = -2;
                    while (j <= 2) {
                        bid = world.getblock(dim, posX + i, posY - 1, posZ + j);
                        if (bid != OreSpawnMain.crystalgrass.blockID) {
                            return false;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (DangerZone.rand.nextInt(5) != 1) {
                    OreSpawnTrees.FairyTree(world, dim, posX, posY - 1, posZ);
                } else {
                    OreSpawnTrees.FairyCastleTree(world, dim, posX, posY, posZ);
                }
                recently_placed = 50;
                break;
            }
            --posY;
        }
        return true;
    }

    public boolean addRubyDungeon(World world, int dim, int chunkX, int chunkZ) {
        if (DangerZone.rand.nextInt(15) != 0) {
            return false;
        }
        int i = 0;
        while (i < 8) {
            int posX = chunkX + DangerZone.rand.nextInt(8);
            int posZ = chunkZ + DangerZone.rand.nextInt(8);
            int posY = 50;
            while (posY > 5) {
                if (world.getblock(dim, posX, posY, posZ) == Blocks.oreplatinum.blockID) {
                    OreSpawnMain.MyDungeons.makeRubyBirdDungeon(world, dim, posX, posY, posZ);
                    return true;
                }
                --posY;
            }
            ++i;
        }
        return false;
    }

    public boolean addGenericDungeon(World world, int dim, int chunkX, int chunkZ) {
        if (DangerZone.rand.nextInt(16) != 0) {
            return false;
        }
        int posX = chunkX + DangerZone.rand.nextInt(4);
        int posZ = chunkZ + DangerZone.rand.nextInt(4);
        int posY = 5 + DangerZone.rand.nextInt(40);
        OreSpawnMain.MyDungeons.makeDungeon(world, dim, posX, posY, posZ);
        return true;
    }

    public boolean addBeeHive(World world, int dim, int chunkX, int chunkZ) {
        int lowestY = 128;
        int lowestX = chunkX;
        int lowestZ = chunkZ;
        boolean found = false;
        int i = 0;
        while (i < 16) {
            int j = 0;
            while (j < 16) {
                int posX = chunkX + i;
                int posZ = chunkZ + j;
                int posY = 128;
                while (posY > 30) {
                    if (world.getblock(dim, posX, posY + 1, posZ) == 0 && world.getblock(dim, posX, posY, posZ) == Blocks.grassblock.blockID) {
                        if (posY >= lowestY) break;
                        lowestY = posY;
                        lowestX = posX;
                        lowestZ = posZ;
                        found = true;
                        break;
                    }
                    --posY;
                }
                j += 3;
            }
            i += 3;
        }
        if (found && lowestY > 40) {
            OreSpawnMain.MyDungeons.makeBeeHive(world, dim, lowestX, lowestY + 3, lowestZ);
            recently_placed = 50;
            return true;
        }
        return false;
    }

    public boolean addAlienWTF(World world, int dim, int chunkX, int chunkZ) {
        int lowestY = 128;
        int lowestX = chunkX;
        int lowestZ = chunkZ;
        boolean found = false;
        int i = 0;
        while (i < 16) {
            int j = 0;
            while (j < 16) {
                int posX = chunkX + i;
                int posZ = chunkZ + j;
                int posY = 128;
                while (posY > 30) {
                    if (world.getblock(dim, posX, posY + 1, posZ) == 0 && world.getblock(dim, posX, posY, posZ) == Blocks.grassblock.blockID) {
                        if (posY >= lowestY) break;
                        lowestY = posY;
                        lowestX = posX;
                        lowestZ = posZ;
                        found = true;
                        break;
                    }
                    --posY;
                }
                j += 3;
            }
            i += 3;
        }
        if (found && lowestY > 40) {
            OreSpawnMain.MyDungeons.makeAlienWTFDungeon(world, dim, lowestX, lowestY, lowestZ);
            recently_placed = 50;
            return true;
        }
        return false;
    }

    public boolean addEnderKnight(World world, int dim, int chunkX, int chunkZ) {
        int lowestY = 128;
        int lowestX = chunkX;
        int lowestZ = chunkZ;
        boolean found = false;
        int i = 0;
        while (i < 16) {
            int j = 0;
            while (j < 16) {
                int posX = chunkX + i;
                int posZ = chunkZ + j;
                int posY = 128;
                while (posY > 30) {
                    if (world.getblock(dim, posX, posY + 1, posZ) == 0 && world.getblock(dim, posX, posY, posZ) == Blocks.grassblock.blockID) {
                        if (posY >= lowestY) break;
                        lowestY = posY;
                        lowestX = posX;
                        lowestZ = posZ;
                        found = true;
                        break;
                    }
                    --posY;
                }
                j += 3;
            }
            i += 3;
        }
        if (found && lowestY > 40) {
            OreSpawnMain.MyDungeons.makeEnderKnightDungeon(world, dim, lowestX, lowestY, lowestZ);
            recently_placed = 50;
            return true;
        }
        return false;
    }

    public boolean addLeonNest(World world, int dim, int chunkX, int chunkZ) {
        int highestY = 30;
        int highestX = chunkX;
        int highestZ = chunkZ;
        boolean found = false;
        int i = 0;
        while (i < 16) {
            int j = 0;
            while (j < 16) {
                int posX = chunkX + i;
                int posZ = chunkZ + j;
                int posY = 128;
                while (posY > 80) {
                    if (world.getblock(dim, posX, posY + 1, posZ) == 0 && world.getblock(dim, posX, posY, posZ) == Blocks.grassblock.blockID) {
                        if (posY <= highestY) break;
                        highestY = posY + 1;
                        highestX = posX;
                        highestZ = posZ;
                        found = true;
                        break;
                    }
                    --posY;
                }
                j += 3;
            }
            i += 3;
        }
        if (found && highestY > 80) {
            OreSpawnMain.MyDungeons.makeLeonNest(world, dim, highestX, highestY, highestZ);
            recently_placed = 50;
            return true;
        }
        return false;
    }

    public boolean addShadowDungeon(World world, int dim, int chunkX, int chunkZ) {
        int lowestY = 128;
        int lowestX = chunkX;
        int lowestZ = chunkZ;
        boolean found = false;
        int i = 0;
        while (i < 16) {
            int j = 0;
            while (j < 16) {
                int posX = chunkX + i;
                int posZ = chunkZ + j;
                int posY = 128;
                while (posY > 30) {
                    if (world.getblock(dim, posX, posY + 1, posZ) == 0 && world.getblock(dim, posX, posY, posZ) == Blocks.grassblock.blockID) {
                        if (posY >= lowestY) break;
                        lowestY = posY;
                        lowestX = posX;
                        lowestZ = posZ;
                        found = true;
                        break;
                    }
                    --posY;
                }
                j += 3;
            }
            i += 3;
        }
        if (found && lowestY > 40) {
            OreSpawnMain.MyDungeons.makeShadowDungeon(world, dim, lowestX, lowestY, lowestZ);
            recently_placed = 50;
            return true;
        }
        return false;
    }

    public boolean addD4RubyDungeon(World world, int dim, int chunkX, int chunkZ) {
        int posX = chunkX + DangerZone.rand.nextInt(8);
        int posZ = chunkZ + DangerZone.rand.nextInt(8);
        int posY = 20;
        while (posY > 4) {
            int bid = world.getblock(dim, posX, posY, posZ);
            if (bid == Blocks.grassblock.blockID) {
                OreSpawnMain.MyDungeons.makeRubyBirdDungeon(world, dim, posX, posY, posZ);
                recently_placed = 50;
                return true;
            }
            --posY;
        }
        return false;
    }

    public boolean addD4CephadromeAltar(World world, int dim, int chunkX, int chunkZ) {
        int posX = chunkX + DangerZone.rand.nextInt(8);
        int posZ = chunkZ + DangerZone.rand.nextInt(8);
        int posY = 20;
        while (posY > 4) {
            int bid = world.getblock(dim, posX, posY, posZ);
            if (bid == Blocks.grassblock.blockID) {
                OreSpawnMain.MyDungeons.makeCephadromeAltar(world, dim, posX, posY, posZ);
                recently_placed = 50;
                return true;
            }
            --posY;
        }
        return false;
    }

    public boolean addD4Castle(World world, int dim, int chunkX, int chunkZ) {
        int posX = chunkX + DangerZone.rand.nextInt(8);
        int posZ = chunkZ + DangerZone.rand.nextInt(8);
        int posY = 20;
        while (posY > 4) {
            int bid = world.getblock(dim, posX, posY, posZ);
            if (bid == Blocks.grassblock.blockID) {
                int x = -20;
                while (x < 33) {
                    int z = -4;
                    while (z < 33) {
                        bid = world.getblock(dim, posX + x, posY + 18, posZ + z);
                        if (bid != 0) {
                            return false;
                        }
                        ++z;
                    }
                    ++x;
                }
                if (DangerZone.rand.nextInt(2) == 1) {
                    OreSpawnMain.MyDungeons.makeEnormousCastle(world, dim, posX, posY, posZ);
                } else {
                    OreSpawnMain.MyDungeons.makeEnormousCastleQ(world, dim, posX, posY, posZ);
                }
                recently_placed = 75;
                return true;
            }
            --posY;
        }
        return false;
    }

    public boolean addD4Greenhouse(World world, int dim, int chunkX, int chunkZ) {
        int posX = chunkX + DangerZone.rand.nextInt(8);
        int posZ = chunkZ + DangerZone.rand.nextInt(8);
        int posY = 20;
        while (posY > 4) {
            int bid = world.getblock(dim, posX, posY, posZ);
            if (bid == Blocks.grassblock.blockID) {
                int x = -2;
                while (x < 25) {
                    int z = -4;
                    while (z < 25) {
                        bid = world.getblock(dim, posX + x, posY + 18, posZ + z);
                        if (bid != 0) {
                            return false;
                        }
                        ++z;
                    }
                    ++x;
                }
                OreSpawnMain.MyDungeons.makeGreenhouseDungeon(world, dim, posX, posY, posZ);
                recently_placed = 50;
                return true;
            }
            --posY;
        }
        return false;
    }

    public boolean addD4NightmareRookery(World world, int dim, int chunkX, int chunkZ) {
        int posX = chunkX + DangerZone.rand.nextInt(8);
        int posZ = chunkZ + DangerZone.rand.nextInt(8);
        int posY = 20;
        while (posY > 4) {
            int bid = world.getblock(dim, posX, posY, posZ);
            if (bid == Blocks.grassblock.blockID) {
                int x = -5;
                while (x < 25) {
                    int z = -4;
                    while (z < 5) {
                        bid = world.getblock(dim, posX + x, posY + 18, posZ + z);
                        if (bid != 0) {
                            return false;
                        }
                        ++z;
                    }
                    ++x;
                }
                OreSpawnMain.MyDungeons.makeNightmareRookery(world, dim, posX, posY, posZ);
                recently_placed = 50;
                return true;
            }
            --posY;
        }
        return false;
    }

    public boolean addD4StinkyHouse(World world, int dim, int chunkX, int chunkZ) {
        int posX = chunkX + DangerZone.rand.nextInt(8);
        int posZ = chunkZ + DangerZone.rand.nextInt(8);
        int posY = 20;
        while (posY > 4) {
            int bid = world.getblock(dim, posX, posY, posZ);
            if (bid == Blocks.grassblock.blockID) {
                int x = -8;
                while (x < 20) {
                    int z = -8;
                    while (z < 20) {
                        bid = world.getblock(dim, posX + x, posY + 18, posZ + z);
                        if (bid != 0) {
                            return false;
                        }
                        ++z;
                    }
                    ++x;
                }
                OreSpawnMain.MyDungeons.makeStinkyHouse(world, dim, posX, posY, posZ);
                recently_placed = 50;
                return true;
            }
            --posY;
        }
        return false;
    }

    public boolean addD4WhiteHouse(World world, int dim, int chunkX, int chunkZ) {
        int posX = chunkX + DangerZone.rand.nextInt(8);
        int posZ = chunkZ + DangerZone.rand.nextInt(8);
        int posY = 20;
        while (posY > 4) {
            int bid = world.getblock(dim, posX, posY, posZ);
            if (bid == Blocks.grassblock.blockID) {
                int x = -20;
                while (x < 30) {
                    int z = -20;
                    while (z < 300) {
                        bid = world.getblock(dim, posX + x, posY + 18, posZ + z);
                        if (bid != 0) {
                            return false;
                        }
                        ++z;
                    }
                    ++x;
                }
                OreSpawnMain.MyDungeons.makeWhiteHouse(world, dim, posX, posY, posZ);
                recently_placed = 50;
                return true;
            }
            --posY;
        }
        return false;
    }

    public boolean addD4EnderCastle(World world, int dim, int chunkX, int chunkZ) {
        int posX = chunkX + DangerZone.rand.nextInt(8);
        int posZ = chunkZ + DangerZone.rand.nextInt(8);
        int posY = 20;
        while (posY > 4) {
            int bid = world.getblock(dim, posX, posY, posZ);
            if (bid == Blocks.grassblock.blockID) {
                int x = -5;
                while (x < 25) {
                    int z = -5;
                    while (z < 25) {
                        bid = world.getblock(dim, posX + x, posY + 18, posZ + z);
                        if (bid != 0) {
                            return false;
                        }
                        ++z;
                    }
                    ++x;
                }
                OreSpawnMain.MyDungeons.makeEnderCastle(world, dim, posX, posY, posZ);
                recently_placed = 50;
                return true;
            }
            --posY;
        }
        return false;
    }

    public boolean addD4IncaPyramid(World world, int dim, int chunkX, int chunkZ) {
        int posX = chunkX + DangerZone.rand.nextInt(8);
        int posZ = chunkZ + DangerZone.rand.nextInt(8);
        int posY = 20;
        while (posY > 4) {
            int bid = world.getblock(dim, posX, posY, posZ);
            if (bid == Blocks.grassblock.blockID) {
                int x = -10;
                while (x < 50) {
                    int z = -10;
                    while (z < 40) {
                        bid = world.getblock(dim, posX + x, posY + 18, posZ + z);
                        if (bid != 0) {
                            return false;
                        }
                        ++z;
                    }
                    ++x;
                }
                OreSpawnMain.MyDungeons.makeIncaPyramid(world, dim, posX, posY, posZ);
                recently_placed = 50;
                return true;
            }
            --posY;
        }
        return false;
    }

    public boolean addD4RobotLab(World world, int dim, int chunkX, int chunkZ) {
        int posX = chunkX + DangerZone.rand.nextInt(8);
        int posZ = chunkZ + DangerZone.rand.nextInt(8);
        int posY = 20;
        while (posY > 4) {
            int bid = world.getblock(dim, posX, posY, posZ);
            if (bid == Blocks.grassblock.blockID) {
                int x = -5;
                while (x < 60) {
                    int z = -5;
                    while (z < 70) {
                        bid = world.getblock(dim, posX + x, posY + 4, posZ + z);
                        if (bid != 0 && bid != Blocks.log.blockID && bid != Blocks.appleleaves.blockID && bid != OreSpawnMain.blockscaryleaves.blockID && bid != 0) {
                            return false;
                        }
                        ++z;
                    }
                    ++x;
                }
                OreSpawnMain.MyDungeons.makeRobotLab(world, dim, posX, posY, posZ);
                recently_placed = 50;
                return true;
            }
            --posY;
        }
        return false;
    }

    public boolean addD4Mini(World world, int dim, int chunkX, int chunkZ) {
        int posX = chunkX + DangerZone.rand.nextInt(8);
        int posZ = chunkZ + DangerZone.rand.nextInt(8);
        int posY = 20;
        while (posY > 4) {
            int bid = world.getblock(dim, posX, posY, posZ);
            if (bid == Blocks.grassblock.blockID) {
                OreSpawnMain.MyDungeons.makeMiniDungeon(world, dim, posX, posY, posZ);
                recently_placed = 50;
                return true;
            }
            --posY;
        }
        return false;
    }

    public boolean addPumpkin(World world, int dim, int chunkX, int chunkZ) {
        int posX = chunkX + DangerZone.rand.nextInt(8);
        int posZ = chunkZ + DangerZone.rand.nextInt(8);
        int posY = 20;
        while (posY > 4) {
            int bid = world.getblock(dim, posX, posY, posZ);
            if (bid == Blocks.grassblock.blockID) {
                OreSpawnMain.MyDungeons.makePumpkin(world, dim, posX, posY + 1, posZ);
                recently_placed = 50;
                return true;
            }
            --posY;
        }
        return false;
    }

    public boolean addD4CloudShark(World world, int dim, int chunkX, int chunkZ) {
        int posX = 4 + chunkX + DangerZone.rand.nextInt(8);
        int posZ = 4 + chunkZ + DangerZone.rand.nextInt(8);
        OreSpawnMain.MyDungeons.makeCloudSharkDungeon(world, dim, posX, 150 + world.rand.nextInt(10), posZ);
        return true;
    }

    public boolean addD4Rainbow(World world, int dim, int chunkX, int chunkZ) {
        int posX = 4 + chunkX + DangerZone.rand.nextInt(8);
        int posZ = 4 + chunkZ + DangerZone.rand.nextInt(8);
        OreSpawnMain.MyDungeons.makeRainbow(world, dim, posX, 70 + world.rand.nextInt(20), posZ);
        recently_placed = 50;
        return true;
    }

    public boolean addD4GenericDungeon(World world, int dim, int chunkX, int chunkZ) {
        int posX = chunkX + DangerZone.rand.nextInt(8);
        int posZ = chunkZ + DangerZone.rand.nextInt(8);
        int posY = 20;
        while (posY > 4) {
            int bid = world.getblock(dim, posX, posY, posZ);
            if (bid == Blocks.grassblock.blockID) {
                OreSpawnMain.MyDungeons.makeDungeon(world, dim, posX, posY, posZ);
                recently_placed = 50;
                return true;
            }
            --posY;
        }
        return false;
    }

    public boolean addKingAltar(World world, int dim, int chunkX, int chunkZ) {
        if (DangerZone.rand.nextInt(2000) != 1) {
            return false;
        }
        int i = 0;
        while (i < 8) {
            int posX = 3 + chunkX + DangerZone.rand.nextInt(10);
            int posZ = 3 + chunkZ + DangerZone.rand.nextInt(10);
            int posY = 100;
            while (posY > 50) {
                if (world.getblock(dim, posX, posY, posZ) == 0 && world.getblock(dim, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                    if (!this.quickReallyBigSpaceCheck(world, dim, posX, posY - 1, posZ)) {
                        return false;
                    }
                    if (DangerZone.rand.nextInt(2) == 0) {
                        OreSpawnMain.MyDungeons.makeKingAltar(world, dim, posX, posY - 1, posZ);
                    } else {
                        OreSpawnMain.MyDungeons.makeQueenAltar(world, dim, posX, posY - 1, posZ);
                    }
                    recently_placed = 100;
                    return true;
                }
                --posY;
            }
            ++i;
        }
        return false;
    }

    public void addBasiliskMaze(World world, int dim, int chunkX, int chunkZ) {
        int lowestY = 128;
        int lowestX = chunkX;
        int lowestZ = chunkZ;
        boolean found = false;
        int i = 0;
        while (i < 16) {
            int j = 0;
            while (j < 16) {
                int posX = chunkX + i;
                int posZ = chunkZ + j;
                int posY = 128;
                while (posY > 30) {
                    if (world.getblock(dim, posX, posY + 1, posZ) == 0 && world.getblock(dim, posX, posY, posZ) != 0) {
                        if (posY >= lowestY) break;
                        lowestY = posY;
                        lowestX = posX;
                        lowestZ = posZ;
                        found = true;
                        break;
                    }
                    --posY;
                }
                j += 3;
            }
            i += 3;
        }
        if (found && lowestY > 40) {
            OreSpawnMain.MyDungeons.buildBasiliskMaze(world, dim, lowestX, lowestY - 2, lowestZ);
            recently_placed = 50;
        }
    }

    public void addKyuubiDungeon(World world, int dim, int chunkX, int chunkZ) {
        int lowestY = 128;
        int lowestX = chunkX;
        int lowestZ = chunkZ;
        boolean found = false;
        int i = 0;
        while (i < 16) {
            int j = 0;
            while (j < 16) {
                int posX = chunkX + i;
                int posZ = chunkZ + j;
                int posY = 128;
                while (posY > 30) {
                    if (world.getblock(dim, posX, posY + 1, posZ) == 0 && world.getblock(dim, posX, posY, posZ) != 0) {
                        if (posY >= lowestY) break;
                        lowestY = posY;
                        lowestX = posX;
                        lowestZ = posZ;
                        found = true;
                        break;
                    }
                    --posY;
                }
                j += 3;
            }
            i += 3;
        }
        if (found && lowestY > 40) {
            OreSpawnMain.MyDungeons.makeKyuubiDungeon(world, dim, lowestX, lowestY - 2, lowestZ);
            recently_placed = 50;
        }
    }

    private boolean quickSpaceCheck(World world, int dim, int posX, int posY, int posZ) {
        int i = -2;
        while (i < 10) {
            int k = -2;
            while (k < 10) {
                if (world.getblock(dim, posX + i, posY + 4, posZ + k) != 0) {
                    return false;
                }
                ++k;
            }
            ++i;
        }
        return true;
    }

    private boolean quickBigSpaceCheck(World world, int dim, int posX, int posY, int posZ) {
        int i = -5;
        while (i < 25) {
            int k = -5;
            while (k < 25) {
                if (world.getblock(dim, posX + i, posY + 8, posZ + k) != 0) {
                    return false;
                }
                ++k;
            }
            ++i;
        }
        return true;
    }

    private boolean quickReallyBigSpaceCheck(World world, int dim, int posX, int posY, int posZ) {
        int i = -5;
        while (i < 55) {
            int k = -5;
            while (k < 55) {
                if (world.getblock(dim, posX + i, posY + 8, posZ + k) != 0) {
                    return false;
                }
                ++k;
            }
            ++i;
        }
        return true;
    }

    private boolean D4BigSpaceCheck(World world, int dim, int posX, int posY, int posZ) {
        int i = -25;
        while (i < 40) {
            int k = -25;
            while (k < 30) {
                int bid = world.getblock(dim, posX + i, posY + 4, posZ + k);
                if (bid != 0 && bid != Blocks.log.blockID && bid != OreSpawnMain.blockscaryleaves.blockID && bid != OreSpawnMain.blocknonscaryleaves.blockID) {
                    return false;
                }
                ++k;
            }
            ++i;
        }
        return true;
    }
}

