/*
 * Decompiled with CFR 0.152.
 */
package launcher;

import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import launcher.NSValidator;
import launcher.Runnit;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.openal.AL;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;
import org.newdawn.slick.Color;
import org.newdawn.slick.TrueTypeFont;
import org.newdawn.slick.openal.Audio;
import org.newdawn.slick.openal.AudioLoader;
import org.newdawn.slick.openal.SoundStore;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureLoader;
import org.newdawn.slick.util.ResourceLoader;

public class LauncherMain {
    public static String version_string = "1.6";
    public static int screen_width = 1000;
    public static int screen_height = 600;
    public static String windowTitle = "DangerZone Launcher";
    public static Font awtfont = null;
    public static TrueTypeFont font = null;
    public static Font smallawtfont = null;
    public static TrueTypeFont smallfont = null;
    private static Texture logotexture = null;
    private static Texture buttontexture = null;
    private static Texture runbuttontexture = null;
    private static Texture checktexture = null;
    private static Texture unchecktexture = null;
    private static Texture textinputtexture = null;
    private static Texture pic1 = null;
    private static Texture pic2 = null;
    private static Texture pic3 = null;
    private static Texture pic4 = null;
    private static Texture pic5 = null;
    public static boolean quit = false;
    public static List<ButtonHandler> buttons;
    public static boolean escaped;
    public static boolean entered;
    public static Properties prop;
    public static int picnum;
    public static int picnum_counter;
    public static int errstringcounter;
    public static int client_max_g;
    public static int single_max_g;
    public static int server_max_g;
    public static String server_address;
    public static int server_port;
    public static String nsserver_address;
    public static int nsserver_port;
    public static String server_port_string;
    public static String worldname;
    public static String playername;
    public static String playerpassword;
    public static String alt_texture_path;
    public static int current_screen;
    public static Iterator<ButtonHandler> bb;
    public static Audio popsound;
    public static boolean playernameinput;
    public static boolean serveraddressinput;
    public static boolean newworldinput;
    public static boolean serverportinput;
    public static boolean passwordinput;
    public static int worldliststart;
    public static int numworld;
    public static boolean displaydeleteconfirm;
    public static boolean dodelete;
    public static String newworldname;
    public static String crypted_password;
    public static String errstring;
    private static final Class[] parameters;
    public static String playerstatestring;
    public static volatile boolean do_register;
    public static volatile boolean do_validate;
    public static NSValidator Vserverthread;
    public static volatile boolean name_registered_already;
    public static boolean world_loaded;
    public static String worldfile;
    public static boolean generatecaves;
    public static boolean playnicely;
    public static boolean require_valid_passwords;
    public static long worldseed;
    public static int timetimer;
    public static String todinputstring;
    public static boolean todinput;
    public static int max_players_on_server;
    public static String maxpinputstring;
    public static boolean maxpinput;
    public static int default_privs;
    public static String privsinputstring;
    public static boolean privsinput;
    public static int login_state;

    static {
        escaped = false;
        entered = false;
        prop = new Properties();
        picnum = 0;
        picnum_counter = 0;
        errstringcounter = 0;
        client_max_g = 2;
        single_max_g = 2;
        server_max_g = 2;
        server_address = "127.0.0.1";
        server_port = 18668;
        nsserver_address = "73.173.95.147";
        nsserver_port = 18669;
        server_port_string = "";
        worldname = "my_world";
        playername = "Player";
        playerpassword = "";
        alt_texture_path = "";
        current_screen = 0;
        playernameinput = false;
        serveraddressinput = false;
        newworldinput = false;
        serverportinput = false;
        passwordinput = false;
        worldliststart = 0;
        numworld = 0;
        displaydeleteconfirm = false;
        dodelete = false;
        newworldname = "New World";
        crypted_password = null;
        errstring = null;
        parameters = new Class[]{URL.class};
        playerstatestring = "unknown";
        do_register = false;
        do_validate = false;
        Vserverthread = null;
        name_registered_already = false;
        world_loaded = false;
        worldfile = "";
        generatecaves = true;
        playnicely = false;
        require_valid_passwords = true;
        worldseed = 0L;
        timetimer = 0;
        todinputstring = "";
        todinput = false;
        max_players_on_server = 0;
        maxpinputstring = "";
        maxpinput = false;
        default_privs = 0;
        privsinputstring = "";
        privsinput = false;
        login_state = 0;
    }

    public static void initGL() {
        screen_width = Display.getWidth();
        screen_height = Display.getHeight();
        GL11.glViewport((int)0, (int)0, (int)screen_width, (int)screen_height);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GLU.gluPerspective(45.0f, (float)screen_width / (float)screen_height, 1.0f, 100.0f);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClearDepth((double)1.0);
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)515);
        GL11.glHint((int)3152, (int)4353);
        GL11.glEnable((int)3553);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glEnable((int)3008);
    }

    public static void startGUI() {
        try {
            Display.setDisplayMode((DisplayMode)new DisplayMode(screen_width, screen_height));
            Display.setResizable((boolean)false);
            Display.setVSyncEnabled((boolean)false);
            Display.setTitle((String)windowTitle);
            Display.create();
            Keyboard.create();
            Mouse.create();
            SoundStore.get().init();
            LauncherMain.initGL();
        }
        catch (LWJGLException e1) {
            System.out.printf("Something went horribly wrong with initialization!\n", new Object[0]);
            e1.printStackTrace();
            System.exit(1);
        }
        GL11.glDisable((int)2929);
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)screen_width, (double)0.0, (double)screen_height, (double)-30.0, (double)30.0);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void stopGUI() {
        Mouse.destroy();
        Keyboard.destroy();
        Display.destroy();
        AL.destroy();
    }

    public static void main(String[] args) throws InterruptedException, IOException {
        String curdir = System.getProperty("user.dir");
        File libfile = new File(String.valueOf(curdir) + "/DangerZone_lib/native");
        if (libfile.exists()) {
            System.setProperty("org.lwjgl.librarypath", String.valueOf(curdir) + "/DangerZone_lib/native");
        }
        CodeSource codeSource = LauncherMain.class.getProtectionDomain().getCodeSource();
        try {
            File myfile = new File(codeSource.getLocation().toURI().getPath());
            LauncherMain.addFile(myfile);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LauncherMain.startGUI();
        awtfont = new Font("Times New Roman", 0, 36);
        font = new TrueTypeFont(awtfont, false);
        smallawtfont = new Font("Times New Roman", 0, 24);
        smallfont = new TrueTypeFont(smallawtfont, false);
        try {
            logotexture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("launchres/menus/logo.png"));
            buttontexture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("launchres/menus/button.png"));
            runbuttontexture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("launchres/menus/runbutton.png"));
            checktexture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("launchres/menus/check.png"));
            unchecktexture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("launchres/menus/uncheck.png"));
            textinputtexture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("launchres/menus/textinput.png"));
            pic1 = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("launchres/menus/pic1.png"));
            pic2 = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("launchres/menus/pic2.png"));
            pic3 = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("launchres/menus/pic3.png"));
            pic4 = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("launchres/menus/pic4.png"));
            pic5 = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("launchres/menus/pic5.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            popsound = AudioLoader.getAudio("WAV", ResourceLoader.getResourceAsStream("launchres/sounds/pop.wav"));
        }
        catch (Exception e) {
            popsound = null;
        }
        LauncherMain.readConfig();
        picnum = 0;
        picnum_counter = 0;
        LauncherMain.showLogo();
        LauncherMain.textAt(25.0f, screen_height - 50, "Hi " + playername + "!");
        LauncherMain.textAt(675.0f, screen_height - 50, "Launcher Ver " + version_string);
        Display.update();
        do_validate = true;
        Vserverthread = new NSValidator();
        Thread st = new Thread(Vserverthread);
        st.start();
        Thread.sleep(2000L);
        picnum = 1;
        while (!quit) {
            if (errstring != null && errstringcounter == 0) {
                errstringcounter = 100;
            }
            if (errstringcounter > 0 && --errstringcounter == 0) {
                errstring = null;
            }
            if (++picnum_counter > 250) {
                picnum_counter = 0;
                if (++picnum > 5) {
                    picnum = 1;
                }
            }
            LauncherMain.showLogo();
            if (current_screen == 0) {
                LauncherMain.doHomeScreen();
            }
            if (current_screen == 1) {
                LauncherMain.doMultiPlayerScreen();
            }
            if (current_screen == 2) {
                LauncherMain.doOptionsScreen();
            }
            if (current_screen == 3) {
                LauncherMain.doSinglePlayerScreen();
            }
            if (current_screen == 4) {
                LauncherMain.doMusicScreen();
            }
            if (current_screen == 5) {
                LauncherMain.doWorldEditScreen();
            }
            Display.update();
            Thread.sleep(20L);
            if (Display.isCloseRequested()) {
                quit = true;
                break;
            }
            if (quit) break;
            SoundStore.get().poll(0);
        }
        picnum = 0;
        LauncherMain.showLogo();
        LauncherMain.textAt(10.0f, 10.0f, "Bye!");
        Display.update();
        LauncherMain.writeConfig();
        Thread.sleep(1000L);
        LauncherMain.stopGUI();
        System.exit(0);
    }

    private static void showLogo() {
        GL11.glPushMatrix();
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClear((int)16640);
        GL11.glLoadIdentity();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (picnum == 0) {
            logotexture.bind();
        }
        if (picnum == 1) {
            pic1.bind();
        }
        if (picnum == 2) {
            pic2.bind();
        }
        if (picnum == 3) {
            pic3.bind();
        }
        if (picnum == 4) {
            pic4.bind();
        }
        if (picnum == 5) {
            pic5.bind();
        }
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        float x = 210.0f;
        float y = 200.0f;
        if (picnum > 0) {
            x = 480.0f;
            y = 280.0f;
        }
        GL11.glTranslatef((float)(screen_width / 2), (float)(screen_height / 2), (float)-5.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)x, (float)y, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)(-x), (float)y, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)(-x), (float)(-y), (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)x, (float)(-y), (float)0.0f);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public static void textAt(float xpos, float ypos, String text) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)xpos, (float)(ypos + (float)font.getHeight()), (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        font.drawString(0.0f, 0.0f, text, Color.white);
        GL11.glPopMatrix();
    }

    public static void smalltextAt(float xpos, float ypos, String text) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)xpos, (float)(ypos + (float)smallfont.getHeight()), (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        smallfont.drawString(0.0f, 0.0f, text, Color.white);
        GL11.glPopMatrix();
    }

    public static void errtextAt(float xpos, float ypos, String text) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)xpos, (float)(ypos + (float)font.getHeight()), (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        font.drawString(0.0f, 0.0f, text, Color.red);
        GL11.glPopMatrix();
    }

    public static void drawRectangleWithTexture(Texture t, float xpos, float ypos, float xsize, float ysize) {
        float w = t.getWidth();
        float h = t.getHeight();
        t.bind();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)xpos, (float)ypos, (float)0.0f);
        GL11.glScalef((float)(xsize / t.getWidth()), (float)(ysize / t.getHeight()), (float)1.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)w, (float)0.0f);
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)h);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)w, (float)h);
        GL11.glVertex3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public static String getTextChar() {
        boolean caps = false;
        escaped = false;
        entered = false;
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            caps = true;
        }
        while (Keyboard.next()) {
            int currk;
            if (Keyboard.getEventKey() == 1 && Keyboard.isKeyDown((int)1)) {
                escaped = true;
            }
            if (Keyboard.getEventKey() == 28 && Keyboard.isKeyDown((int)28)) {
                entered = true;
            }
            if (!Keyboard.isKeyDown((int)(currk = Keyboard.getEventKey()))) continue;
            switch (currk) {
                case 211: {
                    return "delete";
                }
                case 14: {
                    return "delete";
                }
                case 11: {
                    if (caps) {
                        return ")";
                    }
                    return "0";
                }
                case 2: {
                    if (caps) {
                        return "!";
                    }
                    return "1";
                }
                case 3: {
                    if (caps) {
                        return "@";
                    }
                    return "2";
                }
                case 4: {
                    if (caps) {
                        return "#";
                    }
                    return "3";
                }
                case 5: {
                    if (caps) {
                        return "$";
                    }
                    return "4";
                }
                case 6: {
                    if (caps) {
                        return "%";
                    }
                    return "5";
                }
                case 7: {
                    if (caps) {
                        return "^";
                    }
                    return "6";
                }
                case 8: {
                    if (caps) {
                        return "&";
                    }
                    return "7";
                }
                case 9: {
                    if (caps) {
                        return "*";
                    }
                    return "8";
                }
                case 10: {
                    if (caps) {
                        return "(";
                    }
                    return "9";
                }
                case 30: {
                    if (caps) {
                        return "A";
                    }
                    return "a";
                }
                case 48: {
                    if (caps) {
                        return "B";
                    }
                    return "b";
                }
                case 46: {
                    if (caps) {
                        return "C";
                    }
                    return "c";
                }
                case 32: {
                    if (caps) {
                        return "D";
                    }
                    return "d";
                }
                case 18: {
                    if (caps) {
                        return "E";
                    }
                    return "e";
                }
                case 33: {
                    if (caps) {
                        return "F";
                    }
                    return "f";
                }
                case 34: {
                    if (caps) {
                        return "G";
                    }
                    return "g";
                }
                case 35: {
                    if (caps) {
                        return "H";
                    }
                    return "h";
                }
                case 23: {
                    if (caps) {
                        return "I";
                    }
                    return "i";
                }
                case 36: {
                    if (caps) {
                        return "J";
                    }
                    return "j";
                }
                case 37: {
                    if (caps) {
                        return "K";
                    }
                    return "k";
                }
                case 38: {
                    if (caps) {
                        return "L";
                    }
                    return "l";
                }
                case 50: {
                    if (caps) {
                        return "M";
                    }
                    return "m";
                }
                case 49: {
                    if (caps) {
                        return "N";
                    }
                    return "n";
                }
                case 24: {
                    if (caps) {
                        return "O";
                    }
                    return "o";
                }
                case 25: {
                    if (caps) {
                        return "P";
                    }
                    return "p";
                }
                case 16: {
                    if (caps) {
                        return "Q";
                    }
                    return "q";
                }
                case 19: {
                    if (caps) {
                        return "R";
                    }
                    return "r";
                }
                case 31: {
                    if (caps) {
                        return "S";
                    }
                    return "s";
                }
                case 20: {
                    if (caps) {
                        return "T";
                    }
                    return "t";
                }
                case 22: {
                    if (caps) {
                        return "U";
                    }
                    return "u";
                }
                case 47: {
                    if (caps) {
                        return "V";
                    }
                    return "v";
                }
                case 17: {
                    if (caps) {
                        return "W";
                    }
                    return "w";
                }
                case 45: {
                    if (caps) {
                        return "X";
                    }
                    return "x";
                }
                case 21: {
                    if (caps) {
                        return "Y";
                    }
                    return "y";
                }
                case 44: {
                    if (caps) {
                        return "Z";
                    }
                    return "z";
                }
                case 52: {
                    if (caps) {
                        return ">";
                    }
                    return ".";
                }
                case 51: {
                    if (caps) {
                        return "<";
                    }
                    return ",";
                }
                case 53: {
                    if (caps) {
                        return "?";
                    }
                    return "/";
                }
                case 39: {
                    if (caps) {
                        return ":";
                    }
                    return ";";
                }
                case 40: {
                    if (caps) {
                        return "\"";
                    }
                    return "'";
                }
                case 15: 
                case 57: {
                    return " ";
                }
                case 43: {
                    if (caps) {
                        return "|";
                    }
                    return "\\";
                }
                case 26: {
                    if (caps) {
                        return "{";
                    }
                    return "[";
                }
                case 27: {
                    if (caps) {
                        return "}";
                    }
                    return "]";
                }
                case 12: {
                    if (caps) {
                        return "_";
                    }
                    return "-";
                }
                case 13: {
                    if (caps) {
                        return "+";
                    }
                    return "=";
                }
            }
        }
        return null;
    }

    public static String getNumericChar() {
        escaped = false;
        entered = false;
        while (Keyboard.next()) {
            int currk;
            if (Keyboard.getEventKey() == 1 && Keyboard.isKeyDown((int)1)) {
                escaped = true;
            }
            if (Keyboard.getEventKey() == 28 && Keyboard.isKeyDown((int)28)) {
                entered = true;
            }
            if (!Keyboard.isKeyDown((int)(currk = Keyboard.getEventKey()))) continue;
            switch (currk) {
                case 211: {
                    return "delete";
                }
                case 14: {
                    return "delete";
                }
                case 11: {
                    return "0";
                }
                case 2: {
                    return "1";
                }
                case 3: {
                    return "2";
                }
                case 4: {
                    return "3";
                }
                case 5: {
                    return "4";
                }
                case 6: {
                    return "5";
                }
                case 7: {
                    return "6";
                }
                case 8: {
                    return "7";
                }
                case 9: {
                    return "8";
                }
                case 10: {
                    return "9";
                }
            }
        }
        return null;
    }

    private static void readConfig() {
        FileInputStream input = null;
        server_address = "127.0.0.1";
        server_port = 18668;
        nsserver_address = "73.173.95.147";
        nsserver_port = 18669;
        worldname = "my_world";
        playername = "Player";
        alt_texture_path = "";
        crypted_password = "";
        name_registered_already = false;
        try {
            input = new FileInputStream("DangerZone.properties");
            prop.load(input);
            server_address = LauncherMain.getPropertyString(prop, "ServerAddress", "127.0.0.1");
            server_port = LauncherMain.getPropertyInt(prop, "ServerPort", 0, Integer.MAX_VALUE, 18668);
            nsserver_address = LauncherMain.getPropertyString(prop, "NameServerAddress", "73.173.95.147");
            nsserver_port = LauncherMain.getPropertyInt(prop, "NameServerPort", 0, Integer.MAX_VALUE, 18669);
            worldname = LauncherMain.getPropertyString(prop, "WorldName", "my_world");
            playername = LauncherMain.getPropertyString(prop, "Playername", "Player");
            alt_texture_path = LauncherMain.getPropertyString(prop, "AltTextureDir", "");
            crypted_password = LauncherMain.getPropertyString(prop, "CryptedPassword", "");
            name_registered_already = LauncherMain.getPropertyBoolean(prop, "Registered", false);
            client_max_g = LauncherMain.getPropertyInt(prop, "ClientMaxG", 1, 16, 2);
            single_max_g = LauncherMain.getPropertyInt(prop, "SingleMaxG", 1, 16, 2);
            server_max_g = LauncherMain.getPropertyInt(prop, "ServerMaxG", 1, 16, 2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (input != null) {
            try {
                ((InputStream)input).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void writeConfig() {
        FileOutputStream output = null;
        try {
            output = new FileOutputStream("DangerZone.properties");
            prop.setProperty("ServerAddress", server_address);
            prop.setProperty("ServerPort", String.format("%d", server_port));
            prop.setProperty("NameServerAddress", nsserver_address);
            prop.setProperty("NameServerPort", String.format("%d", nsserver_port));
            prop.setProperty("WorldName", worldname);
            prop.setProperty("Playername", playername);
            prop.setProperty("AltTextureDir", alt_texture_path);
            prop.setProperty("CryptedPassword", crypted_password);
            prop.setProperty("Registered", name_registered_already ? "true" : "false");
            prop.setProperty("ClientMaxG", String.format("%d", client_max_g));
            prop.setProperty("SingleMaxG", String.format("%d", single_max_g));
            prop.setProperty("ServerMaxG", String.format("%d", server_max_g));
            prop.store(output, null);
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        if (output != null) {
            try {
                ((OutputStream)output).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void doHomeScreen() {
        LauncherMain.textAt(25.0f, screen_height - 55, "Hi " + playername + "!");
        buttons = new ArrayList<ButtonHandler>();
        buttons.add(new ButtonHandler(25, screen_height - 155, 105, 45, runbuttontexture, "PLAY", 1));
        LauncherMain.textAt(150.0f, screen_height - 155, ": " + worldname);
        String plst = String.format("Login Status: %s", playerstatestring);
        LauncherMain.textAt(25.0f, screen_height - 95, plst);
        buttons.add(new ButtonHandler(25, 50, 215, 45, buttontexture, "Multi-Player", 2));
        buttons.add(new ButtonHandler(25, 100, 275, 45, buttontexture, "World Selection", 5));
        buttons.add(new ButtonHandler(25, 150, 485, 45, buttontexture, "Login and Name Registration", 3));
        buttons.add(new ButtonHandler(screen_width - 250, 50, 215, 45, buttontexture, "Music Credits", 22));
        if (login_state == 0) {
            do_validate = true;
        }
        bb = buttons.iterator();
        while (bb.hasNext()) {
            bb.next().draw();
        }
        while (Keyboard.next()) {
            if (Keyboard.getEventKey() == 1 && Keyboard.isKeyDown((int)1) && Keyboard.getEventKeyState()) {
                quit = true;
                break;
            }
            if (Keyboard.getEventKey() == 45 && Keyboard.isKeyDown((int)45) && Keyboard.getEventKeyState()) {
                quit = true;
                break;
            }
            if (Keyboard.getEventKey() != 16 || !Keyboard.isKeyDown((int)16) || !Keyboard.getEventKeyState()) continue;
            quit = true;
            break;
        }
        while (Mouse.next()) {
            int clickx = Mouse.getEventX();
            int clicky = Mouse.getEventY();
            if (!Mouse.getEventButtonState() || Mouse.getEventButton() < 0) continue;
            bb = buttons.iterator();
            ButtonHandler fb = null;
            while (bb.hasNext()) {
                ButtonHandler mb = bb.next();
                if (clickx < mb.x || clickx > mb.x + mb.xsize || clicky < mb.y || clicky > mb.y + mb.ysize) continue;
                fb = mb;
                break;
            }
            if (Mouse.getEventButton() == 0 && fb != null) {
                fb.leftclickhandler();
            }
            if (Mouse.getEventButton() != 1 || fb == null) continue;
            fb.rightclickhandler();
        }
    }

    public static void doMusicScreen() {
        buttons = new ArrayList<ButtonHandler>();
        buttons.add(new ButtonHandler(25, screen_height - 55, 125, 45, buttontexture, "Back", 4));
        LauncherMain.textAt(25.0f, screen_height - 150, "Music Credits:");
        LauncherMain.smalltextAt(100.0f, screen_height - 250, "https://machinimasound.com");
        LauncherMain.smalltextAt(100.0f, screen_height - 300, "Licensed under Creative Commons Attribution 4.0 International");
        LauncherMain.smalltextAt(100.0f, screen_height - 350, "(http://creativecommons.org/licenses/by/4.0/)");
        LauncherMain.smalltextAt(100.0f, screen_height - 400, "Authors: Machinimasound, Jens Kiilstofte, Per Kiilstofte, Aaron Spencer");
        bb = buttons.iterator();
        while (bb.hasNext()) {
            bb.next().draw();
        }
        while (Mouse.next()) {
            int clickx = Mouse.getEventX();
            int clicky = Mouse.getEventY();
            if (!Mouse.getEventButtonState() || Mouse.getEventButton() < 0) continue;
            bb = buttons.iterator();
            ButtonHandler fb = null;
            while (bb.hasNext()) {
                ButtonHandler mb = bb.next();
                if (clickx < mb.x || clickx > mb.x + mb.xsize || clicky < mb.y || clicky > mb.y + mb.ysize) continue;
                fb = mb;
                break;
            }
            if (Mouse.getEventButton() == 0 && fb != null) {
                fb.leftclickhandler();
            }
            if (Mouse.getEventButton() != 1 || fb == null) continue;
            fb.rightclickhandler();
        }
    }

    public static void doOptionsScreen() {
        int i;
        String newstring;
        buttons = new ArrayList<ButtonHandler>();
        buttons.add(new ButtonHandler(25, screen_height - 55, 125, 45, buttontexture, "Back", 4));
        if (errstring != null) {
            LauncherMain.errtextAt(25.0f, screen_height - 555, errstring);
        }
        LauncherMain.textAt(25.0f, screen_height - 155, "Player Name:");
        buttons.add(new ButtonHandler(225, screen_height - 155, 325, 45, textinputtexture, playername, 7, playernameinput ? 1.0f : 0.25f));
        LauncherMain.textAt(25.0f, screen_height - 205, "Password:");
        buttons.add(new ButtonHandler(225, screen_height - 205, 325, 45, textinputtexture, playerpassword, 19, passwordinput ? 1.0f : 0.25f));
        LauncherMain.textAt(25.0f, screen_height - 255, "Login State:");
        if (playerstatestring != null) {
            LauncherMain.textAt(225.0f, screen_height - 255, playerstatestring);
        }
        buttons.add(new ButtonHandler(25, screen_height - 355, 250, 45, runbuttontexture, "Login/Validate", 20));
        if (!name_registered_already) {
            buttons.add(new ButtonHandler(25, screen_height - 405, 475, 45, runbuttontexture, "Register New Name/Password", 21));
        }
        bb = buttons.iterator();
        while (bb.hasNext()) {
            bb.next().draw();
        }
        String s = LauncherMain.getTextChar();
        if (playernameinput) {
            if (entered) {
                playernameinput = false;
            }
            if (escaped) {
                playernameinput = false;
            }
            if (s != null) {
                if (!s.equals("delete")) {
                    if (!s.equals(" ") && playername.length() < 16) {
                        playername = String.valueOf(playername) + s;
                    }
                } else if (playername.length() > 0) {
                    newstring = new String();
                    i = 0;
                    while (i < playername.length() - 1) {
                        newstring = String.valueOf(newstring) + playername.charAt(i);
                        ++i;
                    }
                    playername = newstring;
                }
            }
        }
        if (passwordinput) {
            if (entered) {
                passwordinput = false;
                if (name_registered_already) {
                    do_validate = true;
                } else {
                    do_register = true;
                }
            }
            if (escaped) {
                passwordinput = false;
            }
            if (s != null) {
                if (!s.equals("delete")) {
                    if (playerpassword.length() < 16) {
                        playerpassword = String.valueOf(playerpassword) + s;
                    }
                } else if (playerpassword.length() > 0) {
                    newstring = new String();
                    i = 0;
                    while (i < playerpassword.length() - 1) {
                        newstring = String.valueOf(newstring) + playerpassword.charAt(i);
                        ++i;
                    }
                    playerpassword = newstring;
                }
            }
        }
        errstring = null;
        if (login_state != 1) {
            if (playerpassword.length() < 4) {
                errstring = "Password must be > 3 characters";
            }
            if (playerpassword.length() > 16) {
                errstring = "Password must be < 17 characters";
            }
            if (playername.length() < 4) {
                errstring = "Name must be > 3 characters";
            }
            if (playername.length() > 16) {
                errstring = "Name must be < 17 characters";
            }
        }
        while (Mouse.next()) {
            int clickx = Mouse.getEventX();
            int clicky = Mouse.getEventY();
            if (!Mouse.getEventButtonState() || Mouse.getEventButton() < 0) continue;
            bb = buttons.iterator();
            ButtonHandler fb = null;
            while (bb.hasNext()) {
                ButtonHandler mb = bb.next();
                if (clickx < mb.x || clickx > mb.x + mb.xsize || clicky < mb.y || clicky > mb.y + mb.ysize) continue;
                fb = mb;
                break;
            }
            if (Mouse.getEventButton() == 0 && fb != null) {
                fb.leftclickhandler();
            }
            if (Mouse.getEventButton() != 1 || fb == null) continue;
            fb.rightclickhandler();
        }
    }

    public static void doMultiPlayerScreen() {
        int i;
        String newstring;
        buttons = new ArrayList<ButtonHandler>();
        buttons.add(new ButtonHandler(25, screen_height - 55, 125, 45, buttontexture, "Back", 4));
        LauncherMain.textAt(25.0f, screen_height - 155, "Server Address:");
        buttons.add(new ButtonHandler(325, screen_height - 155, 325, 45, textinputtexture, server_address, 8, serveraddressinput ? 1.0f : 0.25f));
        LauncherMain.textAt(25.0f, screen_height - 205, "Server Port:");
        server_port_string = String.format("%d", server_port);
        buttons.add(new ButtonHandler(325, screen_height - 205, 325, 45, textinputtexture, server_port_string, 9, serverportinput ? 1.0f : 0.25f));
        buttons.add(new ButtonHandler(25, screen_height - 305, 325, 45, runbuttontexture, "START A SERVER", 10));
        buttons.add(new ButtonHandler(25, screen_height - 255, 400, 45, runbuttontexture, "CONNECT TO SERVER", 11));
        bb = buttons.iterator();
        while (bb.hasNext()) {
            bb.next().draw();
        }
        String s = LauncherMain.getTextChar();
        if (serveraddressinput) {
            if (entered) {
                serveraddressinput = false;
                if (server_address.length() <= 0) {
                    server_address = "127.0.0.1";
                }
            }
            if (escaped) {
                serveraddressinput = false;
            }
            if (s != null) {
                if (!s.equals("delete")) {
                    if (server_address.length() < 24) {
                        server_address = String.valueOf(server_address) + s;
                    }
                } else if (server_address.length() > 0) {
                    newstring = new String();
                    i = 0;
                    while (i < server_address.length() - 1) {
                        newstring = String.valueOf(newstring) + server_address.charAt(i);
                        ++i;
                    }
                    server_address = newstring;
                }
            }
        }
        if (serverportinput) {
            if (entered) {
                serverportinput = false;
                if (server_port_string.length() <= 0) {
                    server_port_string = "18668";
                }
            }
            if (escaped) {
                serverportinput = false;
            }
            if (s != null) {
                if (!s.equals("delete")) {
                    if (server_port_string.length() < 6) {
                        server_port_string = String.valueOf(server_port_string) + s;
                    }
                } else if (server_port_string.length() > 0) {
                    newstring = new String();
                    i = 0;
                    while (i < server_port_string.length() - 1) {
                        newstring = String.valueOf(newstring) + server_port_string.charAt(i);
                        ++i;
                    }
                    server_port_string = newstring;
                }
            }
            if (server_port_string.length() > 0) {
                server_port = Integer.parseInt(server_port_string);
            }
        }
        while (Mouse.next()) {
            int clickx = Mouse.getEventX();
            int clicky = Mouse.getEventY();
            if (!Mouse.getEventButtonState() || Mouse.getEventButton() < 0) continue;
            bb = buttons.iterator();
            ButtonHandler fb = null;
            while (bb.hasNext()) {
                ButtonHandler mb = bb.next();
                if (clickx < mb.x || clickx > mb.x + mb.xsize || clicky < mb.y || clicky > mb.y + mb.ysize) continue;
                fb = mb;
                break;
            }
            if (Mouse.getEventButton() == 0 && fb != null) {
                fb.leftclickhandler();
            }
            if (Mouse.getEventButton() != 1 || fb == null) continue;
            fb.rightclickhandler();
        }
    }

    public static void removedir(String dir) {
        File[] files;
        File[] fileArray = files = new File(dir).listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                LauncherMain.removedir(String.valueOf(dir) + "/" + file.getName());
            } else {
                file.delete();
            }
            ++n2;
        }
        File curdir = new File(dir);
        curdir.delete();
    }

    public static void doSinglePlayerScreen() {
        String curdir = System.getProperty("user.dir");
        File[] files = new File(String.valueOf(curdir) + "/worlds").listFiles();
        String currworldname = "";
        int newnumworld = 0;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                if (worldliststart == newnumworld) {
                    currworldname = file.getName();
                }
                ++newnumworld;
            }
            ++n2;
        }
        if (worldliststart >= newnumworld) {
            worldliststart = 0;
        }
        numworld = newnumworld;
        buttons = new ArrayList<ButtonHandler>();
        buttons.add(new ButtonHandler(25, screen_height - 55, 125, 45, buttontexture, "Back", 4));
        LauncherMain.textAt(25.0f, screen_height - 155, "World:");
        LauncherMain.textAt(175.0f, screen_height - 155, currworldname);
        if (currworldname != "") {
            worldname = currworldname;
        }
        buttons.add(new ButtonHandler(175, screen_height - 205, 100, 45, buttontexture, "Next", 12));
        buttons.add(new ButtonHandler(300, screen_height - 205, 100, 45, buttontexture, "Prev", 13));
        buttons.add(new ButtonHandler(425, screen_height - 205, 150, 45, buttontexture, "Edit", 23));
        buttons.add(new ButtonHandler(625, screen_height - 205, 150, 45, buttontexture, "Delete", 15));
        buttons.add(new ButtonHandler(25, screen_height - 305, 150, 45, buttontexture, "Create", 14));
        buttons.add(new ButtonHandler(225, screen_height - 305, 325, 45, textinputtexture, newworldname, 18, newworldinput ? 1.0f : 0.25f));
        if (displaydeleteconfirm) {
            LauncherMain.textAt(200.0f, screen_height - 375, "Delete: " + worldname);
            LauncherMain.textAt(200.0f, screen_height - 425, "Are you sure?");
            buttons.add(new ButtonHandler(425, screen_height - 425, 45, 45, checktexture, "", 16));
            buttons.add(new ButtonHandler(475, screen_height - 425, 45, 45, unchecktexture, "", 17));
        }
        bb = buttons.iterator();
        while (bb.hasNext()) {
            bb.next().draw();
        }
        String s = LauncherMain.getTextChar();
        if (newworldinput) {
            if (entered) {
                newworldinput = false;
                if (newworldname.length() <= 0) {
                    newworldname = "New World";
                }
            }
            if (escaped) {
                newworldinput = false;
            }
            if (s != null) {
                if (!s.equals("delete")) {
                    if (newworldname.length() < 24) {
                        newworldname = String.valueOf(newworldname) + s;
                    }
                } else if (newworldname.length() > 0) {
                    String newstring = new String();
                    int i = 0;
                    while (i < newworldname.length() - 1) {
                        newstring = String.valueOf(newstring) + newworldname.charAt(i);
                        ++i;
                    }
                    newworldname = newstring;
                }
            }
        }
        while (Mouse.next()) {
            int clickx = Mouse.getEventX();
            int clicky = Mouse.getEventY();
            if (!Mouse.getEventButtonState() || Mouse.getEventButton() < 0) continue;
            bb = buttons.iterator();
            ButtonHandler fb = null;
            while (bb.hasNext()) {
                ButtonHandler mb = bb.next();
                if (clickx < mb.x || clickx > mb.x + mb.xsize || clicky < mb.y || clicky > mb.y + mb.ysize) continue;
                fb = mb;
                break;
            }
            if (Mouse.getEventButton() == 0 && fb != null) {
                fb.leftclickhandler();
            }
            if (Mouse.getEventButton() != 1 || fb == null) continue;
            fb.rightclickhandler();
        }
    }

    public static void doWorldEditScreen() {
        String curdir = System.getProperty("user.dir");
        worldfile = String.valueOf(curdir) + "/worlds/" + worldname + "/world.dat";
        buttons = new ArrayList<ButtonHandler>();
        buttons.add(new ButtonHandler(25, screen_height - 55, 125, 45, buttontexture, "Back", 4));
        LauncherMain.textAt(25.0f, screen_height - 155, "World:");
        LauncherMain.textAt(175.0f, screen_height - 155, worldname);
        if (!world_loaded) {
            LauncherMain.loadWorld(worldfile);
        }
        LauncherMain.textAt(50.0f, screen_height - 205, "Cave Generation:");
        buttons.add(new ButtonHandler(425, screen_height - 205, 45, 45, generatecaves ? checktexture : unchecktexture, "", 24));
        LauncherMain.textAt(50.0f, screen_height - 255, "Play Nicely:");
        buttons.add(new ButtonHandler(425, screen_height - 255, 45, 45, playnicely ? checktexture : unchecktexture, "", 25));
        LauncherMain.textAt(50.0f, screen_height - 305, "Time of Day:");
        buttons.add(new ButtonHandler(425, screen_height - 305, 100, 45, textinputtexture, todinputstring, 27, todinput ? 1.0f : 0.25f));
        buttons.add(new ButtonHandler(50, screen_height - 515, 125, 45, buttontexture, "SAVE", 30));
        String s = LauncherMain.getNumericChar();
        if (todinput) {
            if (entered) {
                todinput = false;
                if (todinputstring.length() <= 0) {
                    todinputstring = "0";
                }
            }
            if (escaped) {
                todinput = false;
            }
            if (s != null) {
                if (!s.equals("delete")) {
                    if (todinputstring.length() < 4) {
                        todinputstring = String.valueOf(todinputstring) + s;
                    }
                } else if (todinputstring.length() > 0) {
                    String newstring = new String();
                    int i = 0;
                    while (i < todinputstring.length() - 1) {
                        newstring = String.valueOf(newstring) + todinputstring.charAt(i);
                        ++i;
                    }
                    todinputstring = newstring;
                }
            }
            if (todinputstring.length() > 0) {
                timetimer = Integer.parseInt(todinputstring);
            }
        }
        bb = buttons.iterator();
        while (bb.hasNext()) {
            bb.next().draw();
        }
        while (Mouse.next()) {
            int clickx = Mouse.getEventX();
            int clicky = Mouse.getEventY();
            if (!Mouse.getEventButtonState() || Mouse.getEventButton() < 0) continue;
            bb = buttons.iterator();
            ButtonHandler fb = null;
            while (bb.hasNext()) {
                ButtonHandler mb = bb.next();
                if (clickx < mb.x || clickx > mb.x + mb.xsize || clicky < mb.y || clicky > mb.y + mb.ysize) continue;
                fb = mb;
                break;
            }
            if (Mouse.getEventButton() == 0 && fb != null) {
                fb.leftclickhandler();
            }
            if (Mouse.getEventButton() != 1 || fb == null) continue;
            fb.rightclickhandler();
        }
    }

    public static int getPropertyInt(Properties prop, String propname, int min, int max, int dflt) {
        int retval = dflt;
        String s = prop.getProperty(propname);
        if (s != null) {
            retval = Integer.parseInt(s);
            if (retval < min) {
                retval = min;
            }
            if (retval > max) {
                retval = max;
            }
        }
        return retval;
    }

    public static long getPropertyLong(Properties prop, String propname, long min, long max, long dflt) {
        long retval = dflt;
        String s = prop.getProperty(propname);
        if (s != null) {
            retval = Long.parseLong(s);
            if (retval < min) {
                retval = min;
            }
            if (retval > max) {
                retval = max;
            }
        }
        return retval;
    }

    public static float getPropertyFloat(Properties prop, String propname, float min, float max, float dflt) {
        float retval = dflt;
        String s = prop.getProperty(propname);
        if (s != null) {
            retval = Float.parseFloat(s);
            if (retval < min) {
                retval = min;
            }
            if (retval > max) {
                retval = max;
            }
        }
        return retval;
    }

    public static double getPropertyDouble(Properties prop, String propname, double min, double max, double dflt) {
        double retval = dflt;
        String s = prop.getProperty(propname);
        if (s != null) {
            retval = Double.parseDouble(s);
            if (retval < min) {
                retval = min;
            }
            if (retval > max) {
                retval = max;
            }
        }
        return retval;
    }

    public static boolean getPropertyBoolean(Properties prop, String propname, boolean dflt) {
        boolean retval = dflt;
        String s = prop.getProperty(propname);
        if (s != null) {
            retval = Boolean.parseBoolean(s);
        }
        return retval;
    }

    public static String getPropertyString(Properties prop, String propname, String dflt) {
        String retval = dflt;
        String s = prop.getProperty(propname);
        if (s != null) {
            retval = s;
        }
        return retval;
    }

    public static void addFile(File f) throws IOException {
        LauncherMain.addURL(f.toURI().toURL());
    }

    public static void addURL(URL u) throws IOException {
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", parameters);
            method.setAccessible(true);
            method.invoke((Object)sysloader, u);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IOException("Error, could not add URL to system classloader");
        }
    }

    public static void doCryptPassword() {
        int namelen = playername.length();
        int passlen = playerpassword.length();
        String dzstring = "DangerZone is the best!";
        int dzstlen = dzstring.length();
        String hashbackstring = "abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        int hashbacklen = hashbackstring.length();
        int[] nameint = new int[32];
        int[] passint = new int[32];
        int[] dzstint = new int[32];
        int[] cryptint = new int[32];
        if (namelen < 4 || passlen < 4) {
            errstring = "password encryption failure";
            return;
        }
        String tstring = playername.toLowerCase();
        byte[] asbytes = tstring.getBytes();
        int i = 0;
        while (i < 32) {
            nameint[i] = asbytes[i % namelen];
            ++i;
        }
        asbytes = playerpassword.getBytes();
        i = 0;
        while (i < 32) {
            passint[i] = asbytes[i % passlen];
            ++i;
        }
        asbytes = dzstring.getBytes();
        i = 0;
        while (i < 32) {
            dzstint[i] = asbytes[i % dzstlen];
            ++i;
        }
        i = 0;
        while (i < 32) {
            cryptint[i] = nameint[i] * passint[31 - i];
            int n = i;
            cryptint[n] = cryptint[n] / 8;
            int n2 = i;
            cryptint[n2] = cryptint[n2] * dzstint[i];
            int n3 = i;
            cryptint[n3] = cryptint[n3] / 4;
            int n4 = i;
            cryptint[n4] = cryptint[n4] + (nameint[i] ^ passint[i] ^ dzstint[i]);
            ++i;
        }
        i = 0;
        while (i < 32) {
            int n = i;
            cryptint[n] = cryptint[n] & 0xFFF;
            int j = cryptint[i];
            cryptint[i] = cryptint[cryptint[i] % 32];
            cryptint[cryptint[i] % 32] = j;
            ++i;
        }
        crypted_password = "";
        i = 0;
        while (i < 32) {
            crypted_password = String.valueOf(crypted_password) + hashbackstring.charAt(cryptint[i] % hashbacklen);
            ++i;
        }
    }

    public static void loadWorld(String worldname) {
        FileInputStream input = null;
        Properties worldprop = new Properties();
        generatecaves = true;
        playnicely = false;
        require_valid_passwords = true;
        default_privs = 0;
        max_players_on_server = 10;
        timetimer = 0;
        worldseed = System.currentTimeMillis();
        try {
            input = new FileInputStream(worldname);
            worldprop.load(input);
            timetimer = LauncherMain.getPropertyInt(worldprop, "TimeOfDay", 0, Integer.MAX_VALUE, 0);
            generatecaves = LauncherMain.getPropertyBoolean(worldprop, "CaveGeneration", true);
            playnicely = LauncherMain.getPropertyBoolean(worldprop, "PlayNicely", false);
            require_valid_passwords = LauncherMain.getPropertyBoolean(worldprop, "RequireValidPassword", true);
            default_privs = LauncherMain.getPropertyInt(worldprop, "DefaultPrivs", Integer.MIN_VALUE, Integer.MAX_VALUE, 0);
            max_players_on_server = LauncherMain.getPropertyInt(worldprop, "MaxPlayers", 2, 255, 10);
            worldseed = LauncherMain.getPropertyLong(worldprop, "WorldSeed", Long.MIN_VALUE, Long.MAX_VALUE, worldseed);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        todinputstring = String.format("%d", timetimer);
        privsinputstring = String.format("%d", default_privs);
        maxpinputstring = String.format("%d", max_players_on_server);
        if (input != null) {
            try {
                ((InputStream)input).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        world_loaded = true;
    }

    public static void saveWorld(String worldname) {
        Properties worldprop = new Properties();
        OutputStream output = null;
        File f = new File(worldname);
        f.getParentFile().mkdirs();
        try {
            worldprop.setProperty("TimeOfDay", String.format("%d", timetimer));
            worldprop.setProperty("CaveGeneration", String.format("%s", generatecaves ? "true" : "false"));
            worldprop.setProperty("PlayNicely", String.format("%s", playnicely ? "true" : "false"));
            worldprop.setProperty("RequireValidPassword", String.format("%s", require_valid_passwords ? "true" : "false"));
            worldprop.setProperty("DefaultPrivs", String.format("%d", default_privs));
            worldprop.setProperty("MaxPlayers", String.format("%d", max_players_on_server));
            worldprop.setProperty("WorldSeed", String.format("%d", worldseed));
            output = new FileOutputStream(worldname);
            worldprop.store(output, null);
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        if (output != null) {
            try {
                output.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static class ButtonHandler {
        Texture t;
        int x;
        int y;
        int xsize;
        int ysize;
        String s;
        int which;
        float transp;

        public ButtonHandler(int xpos, int ypos, int bxsize, int bysize, Texture tx, String ot, int b) {
            this.x = xpos;
            this.y = ypos;
            this.xsize = bxsize;
            this.ysize = bysize;
            this.t = tx;
            this.s = ot;
            this.which = b;
            this.transp = 1.0f;
        }

        public ButtonHandler(int xpos, int ypos, int bxsize, int bysize, Texture tx, String ot, int b, float tr) {
            this.x = xpos;
            this.y = ypos;
            this.xsize = bxsize;
            this.ysize = bysize;
            this.t = tx;
            this.s = ot;
            this.which = b;
            this.transp = tr;
        }

        public void leftclickhandler() {
            String where;
            ArrayList<String> cmdarray;
            String curdir;
            popsound.playAsSoundEffect(1.0f, 1.0f, false);
            if (this.which == 1) {
                curdir = System.getProperty("user.dir");
                cmdarray = new ArrayList<String>();
                try {
                    cmdarray.add(Runnit.getJreExecutable().toString());
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    return;
                }
                LauncherMain.writeConfig();
                where = String.valueOf(curdir) + "/GameRunner.jar";
                cmdarray.add("-jar");
                cmdarray.add(where);
                cmdarray.add("singleplayer");
                cmdarray.add("-singleplayer");
                cmdarray.add("--singleplayer");
                try {
                    Runnit.launch("singleplayer", cmdarray);
                }
                catch (IOException | InterruptedException e) {
                    e.printStackTrace();
                }
                LauncherMain.stopGUI();
                System.exit(0);
            }
            if (this.which == 2) {
                current_screen = 1;
            }
            if (this.which == 3) {
                current_screen = 2;
            }
            if (this.which == 4) {
                if (current_screen == 5) {
                    current_screen = 3;
                    world_loaded = false;
                    todinput = false;
                    privsinput = false;
                    maxpinput = false;
                } else {
                    current_screen = 0;
                }
                playernameinput = false;
                serveraddressinput = false;
                serverportinput = false;
                displaydeleteconfirm = false;
                newworldinput = false;
                passwordinput = false;
            }
            if (this.which == 5) {
                current_screen = 3;
            }
            if (this.which == 7) {
                playernameinput = true;
                passwordinput = false;
            }
            if (this.which == 8) {
                serveraddressinput = true;
                serverportinput = false;
            }
            if (this.which == 9) {
                serverportinput = true;
                serveraddressinput = false;
            }
            if (this.which == 10) {
                curdir = System.getProperty("user.dir");
                cmdarray = new ArrayList();
                try {
                    cmdarray.add(Runnit.getJreExecutable().toString());
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    return;
                }
                LauncherMain.writeConfig();
                where = String.valueOf(curdir) + "/GameRunner.jar";
                cmdarray.add("-jar");
                cmdarray.add(where);
                cmdarray.add("server");
                cmdarray.add("-server");
                cmdarray.add("--server");
                try {
                    Runnit.launch("server", cmdarray);
                }
                catch (IOException | InterruptedException e) {
                    e.printStackTrace();
                    return;
                }
                LauncherMain.stopGUI();
                System.exit(0);
            }
            if (this.which == 11) {
                curdir = System.getProperty("user.dir");
                cmdarray = new ArrayList();
                try {
                    cmdarray.add(Runnit.getJreExecutable().toString());
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    return;
                }
                LauncherMain.writeConfig();
                where = String.valueOf(curdir) + "/GameRunner.jar";
                cmdarray.add("-jar");
                cmdarray.add(where);
                cmdarray.add("client");
                cmdarray.add("-client");
                cmdarray.add("--client");
                try {
                    Runnit.launch("client", cmdarray);
                }
                catch (IOException | InterruptedException e) {
                    e.printStackTrace();
                    return;
                }
                LauncherMain.stopGUI();
                System.exit(0);
            }
            if (this.which == 12) {
                if (++worldliststart >= numworld) {
                    worldliststart = numworld - 1;
                }
                if (worldliststart < 0) {
                    worldliststart = 0;
                }
            }
            if (this.which == 13 && --worldliststart < 0) {
                worldliststart = 0;
            }
            if (this.which == 14) {
                boolean files;
                newworldinput = false;
                if (newworldname != null && newworldname != "" && !newworldname.contains("..") && (files = new File(String.valueOf(curdir = System.getProperty("user.dir")) + "/worlds/" + newworldname).mkdirs())) {
                    newworldname = "New World";
                }
            }
            if (this.which == 15) {
                displaydeleteconfirm = true;
            }
            if (this.which == 16) {
                displaydeleteconfirm = false;
                if (worldname != null && worldname != "" && !worldname.contains("..")) {
                    curdir = System.getProperty("user.dir");
                    LauncherMain.removedir(String.valueOf(curdir) + "/worlds/" + worldname);
                }
            }
            if (this.which == 17) {
                displaydeleteconfirm = false;
            }
            if (this.which == 18) {
                newworldinput = true;
            }
            if (this.which == 19) {
                passwordinput = true;
                playernameinput = false;
            }
            if (this.which == 20) {
                if (playerpassword.length() >= 4 && playerpassword.length() <= 16 && playername.length() >= 4 && playername.length() <= 16) {
                    crypted_password = "";
                    LauncherMain.doCryptPassword();
                    playerpassword = "******";
                }
                passwordinput = false;
                playernameinput = false;
                do_validate = true;
                do_register = false;
            }
            if (this.which == 21) {
                if (playerpassword.length() >= 4 && playerpassword.length() <= 16 && playername.length() >= 4 && playername.length() <= 16) {
                    crypted_password = "";
                    LauncherMain.doCryptPassword();
                    playerpassword = "******";
                }
                passwordinput = false;
                playernameinput = false;
                do_validate = false;
                do_register = true;
            }
            if (this.which == 22) {
                current_screen = 4;
            }
            if (this.which == 23) {
                current_screen = 5;
            }
            if (this.which == 24) {
                boolean bl = generatecaves = !generatecaves;
            }
            if (this.which == 25) {
                boolean bl = playnicely = !playnicely;
            }
            if (this.which == 26) {
                boolean bl = require_valid_passwords = !require_valid_passwords;
            }
            if (this.which == 27) {
                todinput = true;
                privsinput = false;
                maxpinput = false;
            }
            if (this.which == 28) {
                privsinput = true;
                todinput = false;
                maxpinput = false;
            }
            if (this.which == 29) {
                maxpinput = true;
                todinput = false;
                privsinput = false;
            }
            if (this.which == 30) {
                LauncherMain.saveWorld(worldfile);
            }
        }

        public void rightclickhandler() {
        }

        public void draw() {
            if (this.t != null) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.transp);
                LauncherMain.drawRectangleWithTexture(this.t, this.x, this.y, this.xsize, this.ysize);
            }
            if (this.s != null && !this.s.equals("")) {
                LauncherMain.textAt(this.x + 6, this.y, this.s);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }
}

