/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.threads;

import dangerzone.DangerZone;
import dangerzone.ListInt;
import dangerzone.entities.Entity;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class EntityUpdateLoop
implements Runnable {
    public List<ListInt> entity_list;
    public Entity[] entities;
    public Lock entity_list_lock = new ReentrantLock();

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        lasttime = System.currentTimeMillis();
        loop_interval = DangerZone.entityupdaterate;
        inext = 0;
        this.entities = new Entity[DangerZone.max_entities];
        this.entity_list = new ArrayList<ListInt>();
        ent = null;
        usedist = DangerZone.entityupdatedist;
        block2: while (true) {
            if (DangerZone.gameover != 0) {
                return;
            }
            currtime = System.currentTimeMillis();
            tlong = currtime - lasttime;
            if ((tlong = loop_interval - tlong) < 0L) {
                tlong = 0L;
            }
            if (tlong > loop_interval) {
                tlong = loop_interval;
            }
            if (tlong > 0L) {
                try {
                    Thread.sleep(tlong);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                    System.exit(1);
                }
                currtime = System.currentTimeMillis();
            }
            tlong = currtime - lasttime;
            lasttime = currtime;
            deltaT = tlong;
            if (deltaT < 16.0f) {
                deltaT = 16.0f;
            }
            if (deltaT > 200.0f) {
                deltaT = 200.0f;
            }
            deltaT /= (float)loop_interval;
            usedist = DangerZone.renderdistance + 4;
            if (usedist > 24) {
                usedist = 24;
            }
            usedist *= 16;
            inext = 0;
            inext = 0;
            while (true) {
                if (inext >= DangerZone.max_entities) continue block2;
                ent = this.entities[inext];
                if (DangerZone.new_dimension == 0 && !DangerZone.dimension_change_in_progress) ** break;
                continue block2;
                if (ent != null) {
                    ++ent.stray_entity_ticker;
                    if (ent.deadflag && !ent.isDying()) {
                        this.removeEntityByID(inext);
                    } else if (ent.dimension == DangerZone.player.dimension && ent.stray_entity_ticker < 300 && ent.getHorizontalDistanceFromEntity(DangerZone.player) < (double)usedist) {
                        if (ent.entityID != DangerZone.player.entityID) {
                            ent.smoothMotion();
                            ent.update(deltaT);
                        }
                    } else {
                        if (ent.deadflag || ent.stray_entity_ticker > 300 || ent.dimension != DangerZone.player.dimension) {
                            this.removeEntityByID(ent.entityID);
                        }
                        ent.setMotion();
                    }
                }
                if (inext % 10 == 0) {
                    Thread.yield();
                }
                ++inext;
            }
            break;
        }
    }

    public void addEntity(Entity e, int entytid) {
        if (entytid < 0 || entytid >= DangerZone.max_entities) {
            return;
        }
        this.entity_list_lock.lock();
        if (this.entities[entytid] != null) {
            this.removeEntityByID(entytid);
        }
        this.entities[entytid] = e;
        e.entityID = entytid;
        this.entity_list.add(new ListInt(entytid));
        this.entity_list_lock.unlock();
    }

    public void removeEntityByID(int eid) {
        this.entity_list_lock.lock();
        Iterator<ListInt> ii = this.entity_list.iterator();
        while (ii.hasNext()) {
            ListInt st = ii.next();
            if (this.entities[st.index] == null || this.entities[st.index].entityID != eid) continue;
            ii.remove();
            this.entities[st.index] = null;
            break;
        }
        this.entity_list_lock.unlock();
    }

    public Entity findEntityByID(int eid) {
        if (eid < 0 || eid >= DangerZone.max_entities) {
            return null;
        }
        return this.entities[eid];
    }

    public List<Entity> findEntitiesInRange(float range, int dim, double x, double y, double z) {
        this.entity_list_lock.lock();
        ArrayList<Entity> retlist = new ArrayList<Entity>();
        for (ListInt st : this.entity_list) {
            if (this.entities[st.index] == null || this.entities[st.index].dimension != dim) continue;
            double dx = x - this.entities[st.index].posx;
            double dy = y - this.entities[st.index].posy;
            double dz = z - this.entities[st.index].posz;
            if (!((dx = Math.sqrt(dx * dx + dy * dy + dz * dz)) < (double)range)) continue;
            retlist.add(this.entities[st.index]);
        }
        this.entity_list_lock.unlock();
        return retlist;
    }
}

