/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.BreakChecks;
import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlock;
import dangerzone.entities.EntityFire;
import dangerzone.entities.ThrownBlockItem;
import java.util.List;
import java.util.ListIterator;

public class ThrownInstability
extends ThrownBlockItem {
    public float explosive_power = 1.0f;

    public ThrownInstability(World w) {
        super(w);
        this.uniquename = "DangerZone:ThrownInstability";
        this.setAttackDamage(10.0f);
    }

    @Override
    public void doSpecialEffects(double x, double y, double z) {
        int pfreq = 40;
        if (this.explosive_power >= 10.0f) {
            pfreq = 20;
        }
        if (this.explosive_power >= 100.0f) {
            pfreq = 10;
        }
        if (this.explosive_power >= 1000.0f) {
            pfreq = 5;
        }
        if (this.world.rand.nextInt(pfreq) == 0) {
            Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleFire", this.world.rand.nextInt(3) + 2, this.dimension, x, y, z);
        }
        if (this.world.rand.nextInt(pfreq) == 0) {
            Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleSmoke", this.world.rand.nextInt(3) + 2, this.dimension, x, y, z);
        }
    }

    @Override
    public void doHitSomething(boolean hb, double x, double y, double z, boolean he, Entity ent) {
        double fz;
        double fy;
        double fx;
        float dr;
        double dir;
        int which;
        if (this.explosive_power < 0.01f) {
            return;
        }
        if (he && ent != null) {
            ent.doAttackFromCustom(this.thrower, 9, this.getAttackDamage() * this.explosive_power, false);
            float dir2 = (float)Math.atan2(ent.posz - z, ent.posx - x);
            float hdist = (float)Math.sqrt((ent.posx - x) * (ent.posx - x) + (ent.posz - z) * (ent.posz - z));
            float ydir = (float)Math.atan2(ent.posy + (double)(ent.getHeight() / 2.0f) - y, hdist);
            float knockback = this.explosive_power / 2.0f;
            knockback /= ent.getWidth() * ent.getHeight();
            if (knockback > 10.0f) {
                knockback = 10.0f;
            }
            ent.motionx = (float)((double)ent.motionx + Math.cos(dir2) * (double)knockback * Math.cos(ydir));
            ent.motionz = (float)((double)ent.motionz + Math.sin(dir2) * (double)knockback * Math.cos(ydir));
            ent.motiony = (float)((double)ent.motiony + (double)knockback * Math.sin(ydir));
            if (ent instanceof Player) {
                Player pl = (Player)ent;
                pl.server_thread.sendVelocityUpdateToPlayer(ent.motionx, ent.motiony, ent.motionz);
            }
        }
        if (this.explosive_power < 50.0f) {
            which = this.world.rand.nextInt(5);
            if (which == 0) {
                this.world.playSound("DangerZone:small_explosion1", this.dimension, this.posx + (double)this.motionx, this.posy + (double)this.motiony, this.posz + (double)this.motionz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
            }
            if (which == 1) {
                this.world.playSound("DangerZone:small_explosion2", this.dimension, this.posx + (double)this.motionx, this.posy + (double)this.motiony, this.posz + (double)this.motionz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
            }
            if (which == 2) {
                this.world.playSound("DangerZone:small_explosion3", this.dimension, this.posx + (double)this.motionx, this.posy + (double)this.motiony, this.posz + (double)this.motionz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
            }
            if (which == 3) {
                this.world.playSound("DangerZone:small_explosion4", this.dimension, this.posx + (double)this.motionx, this.posy + (double)this.motiony, this.posz + (double)this.motionz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
            }
            if (which == 4) {
                this.world.playSound("DangerZone:small_explosion5", this.dimension, this.posx + (double)this.motionx, this.posy + (double)this.motiony, this.posz + (double)this.motionz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
            }
        } else {
            which = this.world.rand.nextInt(3);
            if (which == 0) {
                this.world.playSound("DangerZone:large_explosion1", this.dimension, this.posx + (double)this.motionx, this.posy + (double)this.motiony, this.posz + (double)this.motionz, 2.5f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
            }
            if (which == 1) {
                this.world.playSound("DangerZone:large_explosion2", this.dimension, this.posx + (double)this.motionx, this.posy + (double)this.motiony, this.posz + (double)this.motionz, 2.5f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
            }
            if (which == 2) {
                this.world.playSound("DangerZone:large_explosion3", this.dimension, this.posx + (double)this.motionx, this.posy + (double)this.motiony, this.posz + (double)this.motionz, 2.5f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
            }
        }
        float raydist = (float)Math.sqrt(this.explosive_power);
        float curdist = 0.0f;
        int nray = (int)(this.explosive_power * 30.0f);
        int spk = 2;
        if (this.explosive_power >= 10.0f) {
            spk = 10;
        }
        if (this.explosive_power >= 100.0f) {
            spk = 50;
        }
        if (this.explosive_power >= 1000.0f) {
            spk = 250;
        }
        if (this.explosive_power >= 5000.0f) {
            spk = 2000;
        }
        if (this.explosive_power >= 5000.0f) {
            raydist *= 0.75f;
            nray *= 2;
        }
        int i = 0;
        while (i < nray) {
            int bid;
            int iz;
            int iy;
            int ix;
            dir = Math.toRadians(this.world.rand.nextDouble() * 360.0);
            double xzscale = Math.toRadians(this.world.rand.nextDouble() * 360.0);
            double dx = Math.cos(dir);
            double dz = Math.sin(dir);
            double dy = Math.cos(xzscale) / 2.0;
            xzscale = Math.abs(Math.sin(xzscale));
            dx *= xzscale;
            dz *= xzscale;
            float raypower = this.explosive_power * 40.0f;
            float powerlost = 0.0f;
            int lz = 0;
            int ly = 0;
            int lx = 0;
            dr = this.explosive_power < 500.0f ? raydist + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.2f * raydist : raydist + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.1f * raydist;
            curdist = i;
            curdist /= (float)nray;
            curdist *= dr;
            while (curdist < dr) {
                fx = this.posx + (double)this.motionx + dx * (double)curdist;
                fy = this.posy + (double)this.motiony + dy * (double)curdist;
                fz = this.posz + (double)this.motionz + dz * (double)curdist;
                ix = (int)fx;
                iy = (int)fy;
                iz = (int)fz;
                if (ix != lx || iy != ly || iz != lz) {
                    lx = ix;
                    ly = iy;
                    lz = iz;
                    bid = this.world.getblock(this.dimension, ix, iy, iz);
                    if (bid != 0) {
                        float powerleft = raypower * (dr - curdist) / dr;
                        if ((powerleft -= powerlost) <= 0.0f) break;
                        if (powerleft > (float)Blocks.getMinDamage(bid) && powerleft > (float)Blocks.getMaxDamage(bid)) {
                            if (BreakChecks.canChangeBlock(this.thrower, this.dimension, ix, iy, iz, 0, 0) || BreakChecks.canChangeBlock(this.thrower2, this.dimension, ix, iy, iz, 0, 0)) {
                                if (this.explosive_power > 500.0f && curdist / dr < 0.9f) {
                                    this.world.setblockandmetanonotify(this.dimension, ix, iy, iz, 0, 0);
                                } else {
                                    this.world.setblockandmeta(this.dimension, ix, iy, iz, 0, 0);
                                }
                                if (this.world.rand.nextInt(spk * 2) == 0) {
                                    int ibid = Blocks.getBlockDrop(bid, null, this.world, this.dimension, ix, iy, iz);
                                    int iiid = Blocks.getItemDrop(bid, null, this.world, this.dimension, ix, iy, iz);
                                    Utils.doDropRand(this.world, ibid, iiid, 1.0f, this.dimension, ix, iy, iz);
                                }
                            }
                            if (this.world.rand.nextInt(spk) == 0) {
                                Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleSmoke", this.world.rand.nextInt(3) + 3, this.dimension, fx, fy, fz);
                            }
                        }
                        powerlost += (float)Blocks.getMaxDamage(bid);
                    }
                    if (this.world.rand.nextInt(spk) == 0) {
                        Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleSparkle", 1, this.dimension, fx, fy, fz);
                    }
                }
                curdist += 0.1701f;
            }
            if (powerlost == 0.0f) {
                lz = 0;
                ly = 0;
                lx = 0;
                while (curdist < dr * 2.0f) {
                    fx = this.posx + (double)this.motionx + dx * (double)curdist;
                    fy = this.posy + (double)this.motiony + dy * (double)curdist;
                    fz = this.posz + (double)this.motionz + dz * (double)curdist;
                    ix = (int)fx;
                    iy = (int)fy;
                    iz = (int)fz;
                    if (ix != lx || iy != ly || iz != lz) {
                        lx = ix;
                        ly = iy;
                        lz = iz;
                        bid = this.world.getblock(this.dimension, ix, iy, iz);
                        if (bid != 0) {
                            EntityFire eb;
                            if (Blocks.getBurnTime(bid) <= 0 || this.world.rand.nextInt(5) != 1 || (eb = (EntityFire)this.world.createEntityByName("DangerZone:Fire", this.dimension, (double)ix + 0.5, (double)iy - 0.0625, (double)iz + 0.5)) == null) break;
                            eb.init();
                            eb.started_by = this.thrower;
                            this.world.spawnEntityInWorld(eb);
                            break;
                        }
                    }
                    curdist += 0.3301f;
                }
            }
            ++i;
        }
        dr = raydist * 2.0f;
        List<Entity> nearby_list = null;
        Entity enthit = null;
        nearby_list = DangerZone.server.entityManager.findEntitiesInRange(16.0f + dr, this.dimension, this.posx, this.posy, this.posz);
        ListIterator<Entity> li = nearby_list.listIterator();
        while (li.hasNext()) {
            enthit = li.next();
            if (enthit == this || enthit.canthitme) continue;
            fx = this.posx + (double)this.motionx - enthit.posx;
            fy = this.posy + (double)this.motiony - enthit.posy;
            fz = this.posz + (double)this.motionz - enthit.posz;
            curdist = (float)Math.sqrt(fx * fx + fy * fy + fz * fz);
            if ((curdist -= enthit.getWidth() / 2.0f) < enthit.getWidth() / 2.0f) {
                curdist = enthit.getWidth() / 2.0f;
            }
            if (curdist < 1.0f) {
                curdist = 1.0f;
            }
            if (!(curdist < dr)) continue;
            if (!(enthit instanceof EntityBlock)) {
                enthit.doSetOnFire(50);
                enthit.doAttackFromCustom(this.thrower, 9, this.getAttackDamage() * this.explosive_power / (curdist * curdist), false);
            }
            float knockback = this.explosive_power / 4.0f;
            knockback /= enthit.getWidth() * enthit.getHeight();
            if ((knockback /= curdist) > 10.0f) {
                knockback = 10.0f;
            }
            dir = Math.atan2(enthit.posz - z, enthit.posx - x);
            float hdist = (float)Math.sqrt((enthit.posx - x) * (enthit.posx - x) + (enthit.posz - z) * (enthit.posz - z));
            float ydir = (float)Math.atan2(enthit.posy + (double)(enthit.getHeight() / 2.0f) - y, hdist);
            enthit.motionx = (float)((double)enthit.motionx + Math.cos(dir) * (double)knockback * Math.cos(ydir));
            enthit.motionz = (float)((double)enthit.motionz + Math.sin(dir) * (double)knockback * Math.cos(ydir));
            enthit.motiony = (float)((double)enthit.motiony + (double)knockback * Math.sin(ydir));
            if (!(enthit instanceof Player)) continue;
            Player pl = (Player)enthit;
            pl.server_thread.sendVelocityUpdateToPlayer(enthit.motionx, enthit.motiony, enthit.motionz);
        }
    }
}

