/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.entities.BetterFish;
import dangerzone.entities.Entity;
import dangerzone.entities.Minnow;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class Piranah
extends BetterFish {
    public Piranah(World w) {
        super(w);
        this.uniquename = "DangerZone:Piranah";
        this.maxrenderdist = 100;
        this.height = 0.95f;
        this.width = 0.45f;
        this.moveSpeed = 0.28f;
        this.setMaxHealth(5.0f);
        this.setHealth(5.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(2.0f);
        this.movefrequency = 60;
        this.setExperience(5);
        this.daytimespawn = true;
        this.nighttimespawn = false;
        this.daytimedespawn = false;
        this.nighttimedespawn = true;
        this.myspeed = this.moveSpeed;
        this.searchDistance = 32.0f;
        this.enable_hostile = true;
        this.temperament = 1;
    }

    @Override
    public void doDeathDrops() {
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand(this.world, 0, Items.trophypiranah.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        Utils.doDropRand(this.world, 0, Items.fishmeat.itemID, 1.5f, this.dimension, this.posx, this.posy, this.posz);
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Piranah) {
            return false;
        }
        int blk = this.world.getblock(e.dimension, (int)e.posx, (int)e.posy, (int)e.posz);
        if (blk != Blocks.waterstatic.blockID) {
            return false;
        }
        if (e instanceof Player && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Minnow && this.CanProbablySeeEntity(e);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/PiranahTexture.png");
        }
        return this.texture;
    }
}

