/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.entities.BetterFish;
import dangerzone.entities.Entity;
import dangerzone.entities.Minnow;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class HammerheadShark
extends BetterFish {
    public HammerheadShark(World w) {
        super(w);
        this.uniquename = "DangerZone:Hammerhead Shark";
        this.maxrenderdist = 200;
        this.height = 1.15f;
        this.width = 1.15f;
        this.moveSpeed = 0.36f;
        this.setMaxHealth(250.0f);
        this.setHealth(250.0f);
        this.setDefense(3.5f);
        this.setAttackDamage(50.0f);
        this.movefrequency = 50;
        this.setExperience(750);
        this.daytimespawn = true;
        this.nighttimespawn = false;
        this.daytimedespawn = false;
        this.nighttimedespawn = true;
        this.myspeed = this.moveSpeed;
        this.searchDistance = 50.0f;
        this.enable_hostile = true;
        this.temperament = 1;
        this.attackRange = 3.0f;
    }

    @Override
    public String getLivingSound() {
        if (this.world.rand.nextBoolean()) {
            return null;
        }
        return "DangerZone:big_splash";
    }

    @Override
    public String getHurtSound() {
        return "DangerZone:big_splat";
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:big_splat";
    }

    @Override
    public void doDeathDrops() {
        if (this.world.rand.nextInt(5) == 1) {
            Utils.doDropRand(this.world, 0, Items.trophyhammerhead.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        int i = 0;
        while (i < 10) {
            Utils.doDropRand(this.world, 0, Items.fishmeat.itemID, 3.5f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(5) == 1) {
            Utils.doDropRand(this.world, 0, Items.sharkfin.itemID, 3.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        if (this.world.rand.nextInt(3) == 1) {
            Utils.doDropRand(this.world, 0, Items.sharktooth.itemID, 3.0f, this.dimension, this.posx, this.posy, this.posz);
        }
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof HammerheadShark) {
            return false;
        }
        int blk = this.world.getblock(e.dimension, (int)e.posx, (int)e.posy, (int)e.posz);
        if (blk != Blocks.waterstatic.blockID) {
            return false;
        }
        if (e instanceof Player && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Minnow && this.CanProbablySeeEntity(e);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/Hammerheadtexture.png");
        }
        return this.texture;
    }
}

