/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.Goose;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class Gosling
extends EntityLiving {
    public int timetogrow = 2000;

    public Gosling(World w) {
        super(w);
        this.maxrenderdist = 120;
        this.height = 0.45f;
        this.width = 0.25f;
        this.uniquename = "DangerZone:Gosling";
        this.moveSpeed = 0.175f;
        this.setMaxHealth(2.0f);
        this.setHealth(2.0f);
        this.setDefense(0.5f);
        this.setAttackDamage(0.0f);
        this.movefrequency = 25;
        this.setExperience(2);
        this.canSwim = true;
        this.swimoffset = -0.2f;
        this.setCanDespawn(false);
        this.takesFallDamage = false;
        this.setOnGround(true);
        this.setBaby(true);
        this.enable_buddy = true;
        this.findbuddydistance = 16;
        this.findbuddyfrequency = 5;
        this.tower_defense_enable = false;
    }

    @Override
    public void init() {
        super.init();
        this.timetogrow = 2000 + this.world.rand.nextInt(2000);
    }

    @Override
    public String getLivingSound() {
        return "DangerZone:goose_living";
    }

    @Override
    public float getLivingSoundPitch() {
        return 2.5f;
    }

    @Override
    public float getLivingSoundVolume() {
        return 0.5f;
    }

    @Override
    public String getHurtSound() {
        return "DangerZone:goose_hit";
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:goose_death";
    }

    @Override
    public void doDeathDrops() {
        if (this.world.rand.nextInt(20) == 1) {
            Utils.doDropRand(this.world, 0, Items.trophygosling.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        Utils.doDropRand(this.world, 0, Items.feather.itemID, 1.5f, this.dimension, this.posx, this.posy, this.posz);
    }

    @Override
    public void update(float deltaT) {
        if (!this.world.isServer && this.world.rand.nextInt(50) == 1) {
            this.madtimer = this.world.rand.nextInt(25);
        }
        if (this.world.isServer) {
            --this.timetogrow;
            if (this.timetogrow <= 0) {
                this.deadflag = true;
                Entity newme = this.world.createEntityByName("DangerZone:Goose", this.dimension, this.posx, this.posy, this.posz);
                if (newme != null) {
                    newme.init();
                    this.world.spawnEntityInWorld(newme);
                    this.world.playSound("DangerZone:pop", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
                }
            }
        }
        super.update(deltaT);
    }

    @Override
    public boolean isBuddy(Entity e) {
        return e instanceof Goose;
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/Goslingtexture.png");
        }
        return this.texture;
    }
}

