/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.TargetHelper;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class Goose
extends EntityLiving {
    public float myspeed;

    public Goose(World w) {
        super(w);
        this.maxrenderdist = 120;
        this.height = 1.25f;
        this.width = 0.75f;
        this.uniquename = "DangerZone:Goose";
        this.moveSpeed = 0.1f;
        this.setMaxHealth(10.0f);
        this.setHealth(10.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(0.0f);
        this.movefrequency = 55;
        this.setExperience(14);
        this.canSwim = true;
        this.swimoffset = -0.75f;
        this.setCanDespawn(false);
        this.takesFallDamage = false;
        this.setOnGround(true);
        this.enableFollowHeldFood(12);
        this.enableBreeding(10);
        if (w != null) {
            this.myspeed = 0.32f + w.rand.nextFloat() * 0.1f;
        }
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    public String getLivingSound() {
        return "DangerZone:goose_living";
    }

    @Override
    public String getHurtSound() {
        return "DangerZone:goose_hit";
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:goose_death";
    }

    @Override
    public boolean isFoodItem(int foodid) {
        return foodid == Items.corn.itemID;
    }

    @Override
    public boolean isMate(Entity e) {
        return e instanceof Goose;
    }

    @Override
    public void makeBaby(Entity p1, Entity p2) {
        Entity newme = this.world.createEntityByName("DangerZone:Gosling", p1.dimension, (p1.posx + p2.posx) / 2.0, (p1.posy + p2.posy) / 2.0, (p1.posz + p2.posz) / 2.0);
        if (newme != null) {
            newme.init();
            this.world.spawnEntityInWorld(newme);
            this.world.playSound("DangerZone:pop", this.dimension, (p1.posx + p2.posx) / 2.0, (p1.posy + p2.posy) / 2.0, (p1.posz + p2.posz) / 2.0, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
        }
    }

    @Override
    public void doDeathDrops() {
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand(this.world, 0, Items.trophygoose.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        Utils.doDropRand(this.world, 0, Items.goosemeat.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        int i = 1 + this.world.rand.nextInt(4);
        int j = 0;
        while (j < i) {
            Utils.doDropRand(this.world, 0, Items.feather.itemID, 1.5f, this.dimension, this.posx, this.posy, this.posz);
            ++j;
        }
        if (this.world.rand.nextInt(1000) == 42) {
            j = 0;
            while (j < 1000) {
                Utils.doDropRand(this.world, 0, Items.feather.itemID, 3.5f, this.dimension, this.posx, this.posy, this.posz);
                ++j;
            }
        }
    }

    @Override
    public void update(float deltaT) {
        if (this.world.isServer && this.world.rand.nextInt(5000) == 1) {
            Utils.doDropRand(this.world, 0, Items.egggosling.itemID, 0.1f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.update(deltaT);
    }

    @Override
    public void doEntityAction(float deltaT) {
        int bid;
        if (!this.isSwarming()) {
            super.doEntityAction(deltaT);
            return;
        }
        int keep_trying = 20;
        if (this.target == null) {
            this.target = new TargetHelper(this.posx, this.posy, this.posz);
        }
        this.canFly = true;
        this.setFlying(true);
        this.do_swarm_despawn();
        if (!this.isHurt() && !this.deadflag && this.world.rand.nextInt(50) == 1) {
            this.world.playSound(this.getLivingSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, this.getLivingSoundVolume(), this.getLivingSoundPitch());
        }
        if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) == 0 && this.wouldBump(this.posx + (double)(this.motionx * deltaT), this.posy + (double)(this.motiony * deltaT) + (double)(this.getHeight() / 2.0f), this.posz + (double)(this.motionz * deltaT), this.getWidth())) {
            bid = 1;
        }
        if (bid != 0 || this.world.rand.nextInt(50) == 1 || this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < 2.0) {
            int updown = 5;
            int k = 1;
            while (k < 15) {
                bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy - k, (int)this.posz);
                if (bid != 0) {
                    updown = -1;
                    break;
                }
                ++k;
            }
            bid = 1;
            while (bid != 0 && keep_trying != 0) {
                if (this.isSwarming()) {
                    this.target.setTarget(this.posx + (double)this.world.rand.nextInt(20), this.posy + (double)(this.world.rand.nextInt(7) - updown), this.posz + (double)this.world.rand.nextInt(20));
                } else {
                    this.target.setTarget(this.posx + (double)this.world.rand.nextInt(15) - (double)this.world.rand.nextInt(15), this.posy + (double)(this.world.rand.nextInt(7) - updown), this.posz + (double)this.world.rand.nextInt(15) - (double)this.world.rand.nextInt(15));
                }
                bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz);
                if (bid == 0 && !this.CanProbablySee(this.dimension, this.target.targetx, this.target.targety, this.target.targetz, (int)Math.sqrt((this.posx - this.target.targetx) * (this.posx - this.target.targetx) + (this.posz - this.target.targetz) * (this.posz - this.target.targetz) + (this.posy - this.target.targety) * (this.posy - this.target.targety)))) {
                    bid = 1;
                }
                --keep_trying;
                this.myspeed = 0.3f + this.world.rand.nextFloat() * 0.1f;
            }
        }
        if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0) {
            this.target.setTarget(this.posx + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)), this.posy + (double)(this.world.rand.nextInt(5) + 3), this.posz + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)));
        }
        float dy = (float)(this.target.targety - this.posy);
        this.motiony += 0.12f * deltaT;
        if ((dy /= 20.0f) > 0.2f) {
            dy = 0.2f;
        }
        if (dy < -0.2f) {
            dy = -0.2f;
        }
        this.motiony += dy;
        if (this.motiony > 1.0f) {
            this.motiony = 1.0f;
        }
        if (this.motiony < -1.0f) {
            this.motiony = -1.0f;
        }
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
        float ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 10.0);
        float speedadjust = 1.0f;
        float effectspeed = this.getTotalEffect(1);
        if (effectspeed > 1.0f) {
            speedadjust *= effectspeed;
        }
        if ((effectspeed = this.getTotalEffect(2)) > 1.0f) {
            speedadjust /= effectspeed;
        }
        this.motionx = (float)((double)this.motionx + (double)(this.myspeed * speedadjust) * Math.sin(tdir) * (double)deltaT);
        this.motionz = (float)((double)this.motionz + (double)(this.myspeed * speedadjust) * Math.cos(tdir) * (double)deltaT);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/Goosetexture.png");
        }
        return this.texture;
    }
}

