/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlock;
import dangerzone.entities.EntityCloud;
import dangerzone.entities.EntityExplosiveBlock;
import dangerzone.entities.EntityLiving;
import dangerzone.particles.Particle;
import org.newdawn.slick.opengl.Texture;

public class EntityVolcano
extends Entity {
    int flowrate = 50;
    int flowcount = 0;
    int flowdir = 1;

    public EntityVolcano(World w) {
        super(w);
        this.maxrenderdist = 12;
        this.height = 1.0f;
        this.width = 1.0f;
        this.uniquename = "DangerZone:Volcano";
        this.canthitme = true;
        this.ignoreCollisions = true;
    }

    @Override
    public void init() {
    }

    @Override
    public void update(float deltaT) {
        float flowheight = 1.75f + this.world.rand.nextFloat() * 0.5f;
        int useflow = this.flowrate - this.flowcount;
        if (useflow < 2) {
            useflow = 2;
        }
        this.flowcount += this.flowdir;
        if (this.flowcount > this.flowrate) {
            this.flowdir = -1;
        }
        if (this.flowdir < 0 && this.flowcount <= 0) {
            this.flowrate = this.world.rand.nextInt(100);
            this.flowdir = 1;
            this.flowcount = 1;
        }
        if (this.world.isServer) {
            Entity eb;
            int meta;
            int bidtospout;
            boolean found = false;
            if (this.world.rand.nextInt(useflow) == 1) {
                bidtospout = Blocks.lavafiller.blockID;
                meta = 1 + this.world.rand.nextInt(15);
                eb = (EntityBlock)this.world.createEntityByName("DangerZone:EntityBlock", this.dimension, this.posx + 0.5, this.posy + 1.25, this.posz + 0.5);
                if (eb != null) {
                    ((EntityLiving)eb).init();
                    eb.setBID(bidtospout);
                    eb.setIID(meta);
                    if (this.world.rand.nextBoolean()) {
                        eb.setOnFire(this.world.rand.nextInt(30));
                    }
                    ((EntityBlock)eb).motiony = flowheight + DangerZone.rand.nextFloat() * flowheight;
                    ((EntityBlock)eb).motionx = (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * flowheight;
                    ((EntityBlock)eb).motionz = (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * flowheight;
                    this.world.spawnEntityInWorld(eb);
                }
            }
            if (this.world.rand.nextInt(useflow) == 1) {
                bidtospout = Blocks.lava.blockID;
                meta = 1 + this.world.rand.nextInt(15);
                eb = (EntityBlock)this.world.createEntityByName("DangerZone:EntityBlock", this.dimension, this.posx + 0.5, this.posy + 1.25, this.posz + 0.5);
                if (eb != null) {
                    ((EntityLiving)eb).init();
                    eb.setBID(bidtospout);
                    eb.setIID(meta);
                    if (this.world.rand.nextBoolean()) {
                        eb.setOnFire(this.world.rand.nextInt(30));
                    }
                    ((EntityBlock)eb).motiony = flowheight + DangerZone.rand.nextFloat() * flowheight;
                    ((EntityBlock)eb).motionx = (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * flowheight;
                    ((EntityBlock)eb).motionz = (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * flowheight;
                    this.world.spawnEntityInWorld(eb);
                }
            }
            if (this.world.rand.nextInt(useflow) == 1) {
                bidtospout = Blocks.stone.blockID;
                meta = 0;
                eb = (EntityBlock)this.world.createEntityByName("DangerZone:EntityBlock", this.dimension, this.posx + 0.5, this.posy + 1.25, this.posz + 0.5);
                if (eb != null) {
                    ((EntityLiving)eb).init();
                    eb.setBID(bidtospout);
                    eb.setIID(meta);
                    if (this.world.rand.nextBoolean()) {
                        eb.setOnFire(this.world.rand.nextInt(10));
                    }
                    ((EntityBlock)eb).motiony = flowheight + DangerZone.rand.nextFloat() * flowheight;
                    ((EntityBlock)eb).motionx = (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * flowheight;
                    ((EntityBlock)eb).motionz = (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * flowheight;
                    this.world.spawnEntityInWorld(eb);
                }
            }
            if (this.world.rand.nextInt(useflow) == 1) {
                bidtospout = Blocks.greystone.blockID;
                meta = 0;
                eb = (EntityBlock)this.world.createEntityByName("DangerZone:EntityBlock", this.dimension, this.posx + 0.5, this.posy + 1.25, this.posz + 0.5);
                if (eb != null) {
                    ((EntityLiving)eb).init();
                    eb.setBID(bidtospout);
                    eb.setIID(meta);
                    if (this.world.rand.nextBoolean()) {
                        eb.setOnFire(this.world.rand.nextInt(10));
                    }
                    ((EntityBlock)eb).motiony = flowheight + DangerZone.rand.nextFloat() * flowheight;
                    ((EntityBlock)eb).motionx = (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * flowheight;
                    ((EntityBlock)eb).motionz = (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * flowheight;
                    this.world.spawnEntityInWorld(eb);
                }
            }
            if (this.world.rand.nextInt(useflow * 4) == 1) {
                bidtospout = Blocks.orediamond.blockID;
                meta = 0;
                eb = (EntityBlock)this.world.createEntityByName("DangerZone:EntityBlock", this.dimension, this.posx + 0.5, this.posy + 1.25, this.posz + 0.5);
                if (eb != null) {
                    ((EntityLiving)eb).init();
                    eb.setBID(bidtospout);
                    eb.setIID(meta);
                    if (this.world.rand.nextBoolean()) {
                        eb.setOnFire(this.world.rand.nextInt(10));
                    }
                    ((EntityBlock)eb).motiony = flowheight + DangerZone.rand.nextFloat() * flowheight / 2.0f;
                    ((EntityBlock)eb).motionx = (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * flowheight / 2.0f;
                    ((EntityBlock)eb).motionz = (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * flowheight / 2.0f;
                    this.world.spawnEntityInWorld(eb);
                }
            }
            if (this.world.rand.nextInt(useflow * 4) == 1) {
                bidtospout = Blocks.blockinstability_large.blockID;
                meta = 0;
                eb = (EntityExplosiveBlock)this.world.createEntityByName("DangerZone:EntityExplosiveBlock", this.dimension, this.posx + 0.5, this.posy + 1.25, this.posz + 0.5);
                if (eb != null) {
                    ((EntityLiving)eb).init();
                    eb.setBID(bidtospout);
                    eb.setIID(meta);
                    if (this.world.rand.nextBoolean()) {
                        eb.setOnFire(this.world.rand.nextInt(10));
                    }
                    eb.setAttackDamage(1 + this.world.rand.nextInt(10));
                    ((EntityExplosiveBlock)eb).motiony = flowheight + DangerZone.rand.nextFloat() * flowheight / 2.0f;
                    ((EntityExplosiveBlock)eb).motionx = (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * flowheight / 2.0f;
                    ((EntityExplosiveBlock)eb).motionz = (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * flowheight / 2.0f;
                    this.world.spawnEntityInWorld(eb);
                }
            }
            if (this.world.rand.nextInt(100) == 1 && (eb = (EntityCloud)this.world.createEntityByName("DangerZone:Cloud", this.dimension, this.posx + 0.5, 200.0, this.posz + 0.5)) != null) {
                ((EntityCloud)eb).init();
                eb.setBID(Blocks.cloud_thunder.blockID);
                this.world.spawnEntityInWorld(eb);
            }
            int i = -2;
            while (i <= 2 && !found) {
                int k = -2;
                while (k <= 2 && !found) {
                    if (this.world.getblock(this.dimension, (int)this.posx + i, (int)this.posy, (int)this.posz + k) != 0) {
                        found = true;
                    }
                    ++k;
                }
                ++i;
            }
            if (found) {
                this.posy += 1.0;
                if (this.posy > 200.0) {
                    this.deadflag = true;
                }
            } else {
                this.posy -= (double)0.1f;
            }
        } else {
            Particle eb;
            int i;
            int howmany;
            if (this.world.rand.nextInt(useflow) == 1) {
                howmany = 3 + this.world.rand.nextInt(9);
                i = 0;
                while (i < howmany) {
                    eb = this.world.createParticleByName("DangerZone:ParticleSmoke", this.dimension, this.posx + 0.5 + (double)(this.world.rand.nextFloat() - this.world.rand.nextFloat()), this.posy, this.posz + 0.5 + (double)(this.world.rand.nextFloat() - this.world.rand.nextFloat()));
                    if (eb != null) {
                        eb.motiony = this.world.rand.nextFloat() * 0.25f;
                        eb.motionx = (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.02f;
                        eb.motionz = (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.02f;
                        this.world.spawnParticleInWorld(eb);
                    }
                    ++i;
                }
            }
            if (this.world.rand.nextInt(useflow * 2) == 1) {
                howmany = 3 + this.world.rand.nextInt(9);
                i = 0;
                while (i < howmany) {
                    eb = this.world.createParticleByName("DangerZone:ParticleFire", this.dimension, this.posx + 0.5 + (double)(this.world.rand.nextFloat() - this.world.rand.nextFloat()), this.posy, this.posz + 0.5 + (double)(this.world.rand.nextFloat() - this.world.rand.nextFloat()));
                    if (eb != null) {
                        eb.motiony = this.world.rand.nextFloat() * 0.25f;
                        eb.motionx = (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.02f;
                        eb.motionz = (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.02f;
                        this.world.spawnParticleInWorld(eb);
                    }
                    ++i;
                }
            }
        }
        super.update(deltaT);
    }

    @Override
    public boolean getCanSpawnHereNow(World w, int dimension, int x, int y, int z) {
        return true;
    }

    @Override
    public Texture getTexture() {
        return null;
    }
}

