/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlockItem;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.ThrownBlockItem;
import dangerzone.items.Items;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.newdawn.slick.opengl.Texture;

public class EntityMagic
extends ThrownBlockItem {
    public float spin = 0.0f;
    double oposx;
    double oposy;
    double oposz;
    public Texture texture_black;
    public Texture texture_white;
    public Texture texture_orange;
    public Texture texture_yellow;
    public Texture texture_blue;
    public Texture texture_purple;
    public Texture texture_green;
    public Texture texture_red;
    int mycolor = 0;
    float omx;
    float omy;
    float omz = 0.0f;
    List<Entity> enchanted_list = null;

    public EntityMagic(World w) {
        super(w);
        this.setAttackDamage(100.0f);
        this.uniquename = "DangerZone:EntityMagic";
        this.maxrenderdist = 200;
        this.oposx = 0.0;
        this.oposy = 0.0;
        this.oposz = 0.0;
        this.deathtimer = 15;
        if (w != null) {
            this.mycolor = w.rand.nextInt(8);
        }
        this.enchanted_list = new ArrayList<Entity>();
    }

    @Override
    public float getWidth() {
        return this.getScale();
    }

    @Override
    public float getHeight() {
        return this.getScale();
    }

    @Override
    public void doEntityAction(float deltaT) {
        if (this.getBID() != 0) {
            if (this.omx == 0.0f && this.omy == 0.0f && this.omz == 0.0f) {
                this.omx = this.motionx;
                this.omy = this.motiony;
                this.omz = this.motionz;
                this.motionz = 0.0f;
                this.motiony = 0.0f;
                this.motionx = 0.0f;
                this.deathtimer = 30;
                this.oposx = this.posx;
                this.oposy = this.posy;
                this.oposz = this.posz;
                this.world.playSound("DangerZone:magic1", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
            }
            --this.deathtimer;
            if (this.deathtimer <= 0) {
                this.deadflag = true;
                return;
            }
            if (this.deathtimer < 16) {
                this.motionx = this.omx;
                this.motiony = this.omy;
                this.motionz = this.omz;
                this.doFindThings(deltaT, true);
            } else {
                EntityMagic e = (EntityMagic)this.world.createEntityByName("DangerZone:EntityMagic", this.dimension, this.oposx, this.oposy, this.oposz);
                if (e != null) {
                    e.init();
                    e.setIID(this.getIID());
                    e.setVarInt(3, this.getVarInt(3));
                    e.thrower = this;
                    e.motionx = this.omx + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.15f;
                    e.motiony = this.omy + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.15f;
                    e.motionz = this.omz + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.15f;
                    this.world.spawnEntityInWorld(e);
                }
            }
        } else {
            this.doFindThings(deltaT, false);
            --this.deathtimer;
            if (this.deathtimer <= 0) {
                this.deadflag = true;
            }
        }
    }

    public void doFindThings(float deltaT, boolean enchant) {
        float dist = (float)Math.sqrt(this.motionx * deltaT * this.motionx * deltaT + this.motiony * deltaT * this.motiony * deltaT + this.motionz * deltaT * this.motionz * deltaT);
        float blockdist = 0.0f;
        float edist = 0.0f;
        ArrayList<Entity> hit_list = null;
        List<Entity> nearby_list = null;
        Entity enthit = null;
        Entity henthit = null;
        boolean doit = true;
        nearby_list = DangerZone.server.entityManager.findALLEntitiesInRange(16.0f + dist, this.dimension, this.posx, this.posy, this.posz);
        hit_list = new ArrayList<Entity>();
        double fx = this.posx;
        double fy = this.posy;
        double fz = this.posz;
        while (dist > 0.0f && blockdist < dist) {
            fx = this.posx + (double)(this.motionx * deltaT * blockdist / dist);
            fy = this.posy + (double)(this.motiony * deltaT * blockdist / dist);
            fz = this.posz + (double)(this.motionz * deltaT * blockdist / dist);
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                enthit = li.next();
                if (!(enthit instanceof EntityBlockItem) && (this.getIID() >= 0 || !(enthit instanceof EntityLiving) || enthit == this.thrower) || !(fy > enthit.posy - (double)(this.getWidth() / 2.0f)) || !(fy < enthit.posy + (double)enthit.getHeight() + (double)(this.getWidth() / 2.0f))) continue;
                edist = (float)enthit.getHorizontalDistanceFromEntity(fx, fz);
                edist -= this.getWidth() / 2.0f;
                if (!((edist -= enthit.getWidth() / 2.0f) < 0.0f)) continue;
                doit = true;
                ListIterator hli = hit_list.listIterator();
                while (hli.hasNext()) {
                    henthit = (Entity)hli.next();
                    if (henthit != enthit) continue;
                    doit = false;
                    break;
                }
                if (!doit) continue;
                if (enchant) {
                    this.doEnchantSomething(false, fx, fy, fz, true, enthit);
                } else {
                    this.doHitSomething(false, fx, fy, fz, true, enthit);
                }
                hit_list.add(enthit);
            }
            this.doSpecialEffects(fx, fy, fz);
            blockdist += 0.25f;
        }
    }

    @Override
    public void doHitSomething(boolean hb, double x, double y, double z, boolean he, Entity ent) {
        Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleSparkle", 10, ent.dimension, ent.posx, ent.posy, ent.posz);
    }

    public void doEnchantSomething(boolean hb, double x, double y, double z, boolean he, Entity ent) {
        if (this.getIID() < 0) {
            if (this.getVarInt(3) != 0) {
                Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleHappy", 50, ent.dimension, ent.posx, ent.posy, ent.posz);
                ent.heal(ent.getMaxHealth() / 3.0f);
            } else {
                Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleDeath", 50, ent.dimension, ent.posx, ent.posy, ent.posz);
                float eh = ent.getHealth() / 8.0f;
                if (eh < 20.0f) {
                    eh = 20.0f;
                }
                ent.doAttackFromCustom(this.thrower, 14, eh, false);
            }
        } else {
            Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleSparkle", 50, ent.dimension, ent.posx, ent.posy, ent.posz);
            InventoryContainer ic = ent.getInventory(0);
            if (ic.bid == 0 && ic.iid != 0 && Items.getMaxStack(ic.iid) == 1) {
                Entity henthit = null;
                ListIterator<Entity> hli = this.enchanted_list.listIterator();
                while (hli.hasNext()) {
                    henthit = hli.next();
                    if (henthit != ent) continue;
                    return;
                }
                ic.addAttribute(this.getIID(), this.getVarInt(2));
                this.world.playSound("DangerZone:magic2", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
            }
        }
    }

    public float getDensity() {
        float d = 1.5f / this.getScale();
        if (d > 1.0f) {
            d = 1.0f;
        }
        return d;
    }

    @Override
    public float getSpinz() {
        this.spin += 5.0f;
        return this.spin;
    }

    @Override
    public float getScale() {
        double d3;
        double d2;
        double d1;
        float scale;
        if (this.oposx == 0.0) {
            this.oposx = this.posx;
            this.oposy = this.posy;
            this.oposz = this.posz;
        }
        if ((scale = (float)Math.sqrt((d1 = this.oposx - this.posx) * d1 + (d2 = this.oposy - this.posy) * d2 + (d3 = this.oposz - this.posz) * d3)) < 2.0f) {
            scale = 2.0f;
        }
        if (this.getIID() < 0) {
            return scale / 10.0f;
        }
        return scale / 20.0f;
    }

    @Override
    public Texture getTexture() {
        if (this.getBID() != 0) {
            return null;
        }
        if (this.getIID() < 0) {
            this.mycolor = this.getVarInt(3) == 0 ? 7 : 6;
        }
        if (this.mycolor == 0) {
            if (this.texture_black == null) {
                this.texture_black = TextureMapper.getTexture("res/skins/magic_black.png");
            }
            return this.texture_black;
        }
        if (this.mycolor == 1) {
            if (this.texture_white == null) {
                this.texture_white = TextureMapper.getTexture("res/skins/magic_white.png");
            }
            return this.texture_white;
        }
        if (this.mycolor == 2) {
            if (this.texture_orange == null) {
                this.texture_orange = TextureMapper.getTexture("res/skins/magic_orange.png");
            }
            return this.texture_orange;
        }
        if (this.mycolor == 3) {
            if (this.texture_yellow == null) {
                this.texture_yellow = TextureMapper.getTexture("res/skins/magic_yellow.png");
            }
            return this.texture_yellow;
        }
        if (this.mycolor == 4) {
            if (this.texture_blue == null) {
                this.texture_blue = TextureMapper.getTexture("res/skins/magic_blue.png");
            }
            return this.texture_blue;
        }
        if (this.mycolor == 5) {
            if (this.texture_purple == null) {
                this.texture_purple = TextureMapper.getTexture("res/skins/magic_purple.png");
            }
            return this.texture_purple;
        }
        if (this.mycolor == 6) {
            if (this.texture_green == null) {
                this.texture_green = TextureMapper.getTexture("res/skins/magic_green.png");
            }
            return this.texture_green;
        }
        if (this.mycolor == 7) {
            if (this.texture_red == null) {
                this.texture_red = TextureMapper.getTexture("res/skins/magic_red.png");
            }
            return this.texture_red;
        }
        return null;
    }
}

