/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.Dimensions;
import dangerzone.Player;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.particles.ParticleRain;
import java.util.List;
import java.util.ListIterator;
import org.newdawn.slick.opengl.Texture;

public class EntityCloud
extends Entity {
    float py;
    float px;
    float pz;
    int[] parts;

    public EntityCloud(World w) {
        super(w);
        this.maxrenderdist = 512;
        this.height = 1.0f;
        this.width = 1.0f;
        this.uniquename = "DangerZone:Cloud";
        this.canthitme = true;
        this.py = 0.0f;
        this.px = (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * 0.1f;
        this.pz = (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * 0.1f;
        this.setBID(Blocks.cloud_light.blockID);
        this.parts = new int[32];
        this.always_draw = true;
        this.ignoreCollisions = true;
    }

    @Override
    public void init() {
        int k = 0;
        while (k < 10) {
            int i = 0;
            while (i < 32) {
                int j = 0;
                while (j < 32) {
                    int ic;
                    int iz;
                    int ix = i - 16;
                    if (ix < 0) {
                        ix = -ix;
                    }
                    if ((iz = j - 16) < 0) {
                        iz = -iz;
                    }
                    if ((ic = ix * ix + iz * iz) <= 2) {
                        this.setpart(i, j, true);
                    } else if (this.world.rand.nextInt(ic) == 0) {
                        this.setpart(i, j, true);
                    }
                    ++j;
                }
                ++i;
            }
            ++k;
        }
        this.posy = 190 + this.world.rand.nextInt(10) - this.world.rand.nextInt(10);
        this.posy += (double)(this.world.rand.nextFloat() - this.world.rand.nextFloat());
    }

    private void setpart(int i, int j, boolean b) {
        if (i < 0 || i > 31) {
            return;
        }
        if (j < 0 || j > 31) {
            return;
        }
        int val = 1 << i;
        if (b) {
            int n = j;
            this.parts[n] = this.parts[n] | val;
        } else {
            int n = j;
            this.parts[n] = this.parts[n] & ~val;
        }
    }

    public boolean getpart(int i, int j) {
        if (i < 0 || i > 31) {
            return false;
        }
        if (j < 0 || j > 31) {
            return false;
        }
        int val = 1 << i;
        return (this.parts[j] & val) == val;
    }

    @Override
    public void update(float deltaT) {
        if (this.world.isServer) {
            Entity e;
            int mybid;
            Player p;
            this.motiony = this.py;
            this.motionx = this.px;
            this.motionz = this.pz;
            this.rotation_yaw_motion = 0.0f;
            this.rotation_pitch_motion = 0.0f;
            this.rotation_roll_motion = 0.0f;
            this.rotation_pitch = 0.0f;
            this.rotation_yaw = 0.0f;
            this.rotation_roll = 0.0f;
            if (this.getCanDespawn() && ((p = DangerZone.server.findNearestPlayer(this)) == null || this.getHorizontalDistanceFromEntity(p) > (double)(DangerZone.entityupdatedist - 8))) {
                this.setBID(0);
            }
            if ((mybid = this.getBID()) == 0 || this.deadflag || !Dimensions.DimensionArray[this.dimension].cloud_enable) {
                this.deadflag = true;
                return;
            }
            if (mybid == Blocks.cloud_thunder.blockID && Dimensions.DimensionArray[this.dimension].lightning_enable && this.world.rand.nextInt(100) == 0) {
                int i = (int)this.posy;
                while (i > 0) {
                    if (this.world.getblock(this.dimension, (int)this.posx, i, (int)this.posz) != 0) {
                        e = this.world.createEntityByName("DangerZone:Lightning", this.dimension, this.posx, i, this.posz);
                        if (e == null) break;
                        e.init();
                        e.setAttackDamage(5.0f);
                        this.world.spawnEntityInWorld(e);
                        break;
                    }
                    --i;
                }
            }
            if (this.world.rand.nextInt(4000) == 1) {
                this.px = (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * 0.1f;
                this.pz = (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * 0.1f;
                if (mybid == Blocks.cloud_thunder.blockID) {
                    this.setBID(Blocks.cloud_rain.blockID);
                } else if (mybid == Blocks.cloud_rain.blockID) {
                    this.setBID(Blocks.cloud_light.blockID);
                } else {
                    this.setBID(0);
                    this.deadflag = true;
                }
            } else if (this.world.rand.nextInt(20) == 1) {
                List<Entity> nearby_list = null;
                nearby_list = DangerZone.server.entityManager.findALLEntitiesInRange(32.0f, this.dimension, this.posx, this.posy, this.posz);
                if (nearby_list != null && !nearby_list.isEmpty()) {
                    e = null;
                    ListIterator<Entity> li = nearby_list.listIterator();
                    while (li.hasNext()) {
                        e = li.next();
                        if (e == this || !(e instanceof EntityCloud) || !this.world.rand.nextBoolean()) continue;
                        if (mybid == Blocks.cloud_thunder.blockID) {
                            if (e.getBID() == Blocks.cloud_thunder.blockID) break;
                            e.setBID(0);
                            e.deadflag = true;
                            break;
                        }
                        if (mybid == Blocks.cloud_rain.blockID) {
                            if (e.getBID() == Blocks.cloud_thunder.blockID) {
                                this.setBID(0);
                                this.deadflag = true;
                            } else if (e.getBID() == Blocks.cloud_rain.blockID) {
                                if (Dimensions.DimensionArray[this.dimension].lightning_enable && this.world.rand.nextBoolean()) {
                                    this.setBID(Blocks.cloud_thunder.blockID);
                                }
                                e.setBID(0);
                                e.deadflag = true;
                            } else {
                                e.setBID(0);
                                e.deadflag = true;
                            }
                        } else if (e.getBID() == Blocks.cloud_thunder.blockID) {
                            this.setBID(0);
                            this.deadflag = true;
                        } else if (e.getBID() == Blocks.cloud_rain.blockID) {
                            this.setBID(0);
                            this.deadflag = true;
                        } else {
                            if (Dimensions.DimensionArray[this.dimension].rain_enable && this.world.rand.nextBoolean()) {
                                this.setBID(Blocks.cloud_rain.blockID);
                            }
                            e.setBID(0);
                            e.deadflag = true;
                        }
                        break;
                    }
                }
            }
        } else {
            int mybid = this.getBID();
            if (DangerZone.show_rain && (mybid == Blocks.cloud_rain.blockID && this.world.rand.nextInt(8) == 1 || mybid == Blocks.cloud_thunder.blockID)) {
                int i = 0;
                while (i < 4) {
                    double px = this.posx + (double)((DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * 16.0f);
                    double pz = this.posz + (double)((DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * 16.0f);
                    double py = this.posy + (double)DangerZone.rand.nextFloat() - 1.5;
                    ParticleRain pr = (ParticleRain)this.world.createParticleByName("DangerZone:ParticleRain", this.dimension, px, py, pz);
                    if (pr != null) {
                        this.world.spawnParticleInWorld(pr);
                    }
                    ++i;
                }
            }
        }
        if (this.getBID() == Blocks.cloud_thunder.blockID) {
            if (this.world.isServer) {
                if (DangerZone.thundercount < 50) {
                    DangerZone.thundercount += 2;
                }
            } else if (DangerZone.thundercount < 300) {
                DangerZone.thundercount += 2;
            }
        }
        super.update(deltaT);
    }

    @Override
    public boolean getCanSpawnHereNow(World w, int dimension, int x, int y, int z) {
        return true;
    }

    @Override
    public Texture getTexture() {
        return null;
    }
}

