/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.blocks;

import dangerzone.DangerZone;
import dangerzone.StitchedTexture;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import dangerzone.entities.EntityBlock;
import dangerzone.entities.EntityBlockItem;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class WaterCannon
extends Block {
    Texture ttop = null;
    Texture tbottom = null;
    Texture tleft = null;
    String topname;
    String bottomname;
    String leftname;
    StitchedTexture sttop = new StitchedTexture();
    StitchedTexture stbottom = new StitchedTexture();
    StitchedTexture stleft = new StitchedTexture();

    public WaterCannon(String n, String txttop, String txt2, String txt3) {
        super(n, "");
        this.isStone = true;
        this.maxdamage = 20;
        this.mindamage = 10;
        this.breaksound = "DangerZone:stonebreak";
        this.placesound = "DangerZone:stoneplace";
        this.hitsound = "DangerZone:stonehit";
        this.topname = txttop;
        this.bottomname = txt3;
        this.leftname = txt2;
        this.alwaystick = true;
        this.showTop = true;
        this.hasFront = true;
    }

    @Override
    public void tickMe(World w, int d, int x, int y, int z) {
        boolean spout = false;
        int bidtospout = Blocks.water.blockID;
        if (Blocks.isLiquid(w.getblock(d, x + 1, y, z))) {
            bidtospout = w.getblock(d, x + 1, y, z);
            spout = true;
        }
        if (Blocks.isLiquid(w.getblock(d, x - 1, y, z))) {
            bidtospout = w.getblock(d, x - 1, y, z);
            spout = true;
        }
        if (Blocks.isLiquid(w.getblock(d, x, y, z + 1))) {
            bidtospout = w.getblock(d, x, y, z + 1);
            spout = true;
        }
        if (Blocks.isLiquid(w.getblock(d, x, y, z - 1))) {
            bidtospout = w.getblock(d, x, y, z - 1);
            spout = true;
        }
        if (Blocks.isLiquid(w.getblock(d, x, y - 1, z))) {
            bidtospout = w.getblock(d, x, y - 1, z);
            spout = true;
        }
        if (spout) {
            EntityBlockItem e;
            int meta = w.getblockmeta(d, x, y, z);
            float dz = 0.0f;
            float dx = 0.0f;
            if ((meta &= 0x3000) == 0) {
                dx = 0.0f;
                dz = -1.0f;
            }
            if (meta == 4096) {
                dx = -1.0f;
                dz = 0.0f;
            }
            if (meta == 8192) {
                dx = 0.0f;
                dz = 1.0f;
            }
            if (meta == 12288) {
                dx = 1.0f;
                dz = 0.0f;
            }
            meta = 1 + w.rand.nextInt(15);
            EntityBlock eb = (EntityBlock)w.createEntityByName("DangerZone:EntityBlock", d, (double)x + 0.5, (double)y + 1.25, (double)z + 0.5);
            if (eb != null) {
                eb.init();
                eb.setBID(bidtospout);
                eb.setIID(meta);
                eb.motiony = 1.75f + w.rand.nextFloat() / 4.0f;
                eb.motionx = dx * 1.75f + (w.rand.nextFloat() - w.rand.nextFloat()) * 0.125f;
                eb.motionz = dz * 1.75f + (w.rand.nextFloat() - w.rand.nextFloat()) * 0.125f;
                w.spawnEntityInWorld(eb);
            }
            int howmany = 10 + w.rand.nextInt(10);
            Utils.spawnParticlesFromServer(w, "DangerZone:ParticleWaterSpout", howmany, d, (double)x + 0.5, (double)y + (double)1.1f, (double)z + 0.5);
            w.playSound("DangerZone:bow", d, x, y, z, 0.5f, 0.75f);
            if (w.rand.nextInt(500) == 1 && (e = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, d, (double)x + 0.5, (double)y + (double)1.1f, (double)z + 0.5)) != null) {
                e.fill(Items.fishmeat, 1);
                e.rotation_pitch = w.rand.nextInt(360);
                e.rotation_yaw = w.rand.nextInt(360);
                e.rotation_roll = w.rand.nextInt(360);
                e.motiony = 1.25f + DangerZone.rand.nextFloat() / 2.0f;
                e.motionx = dx * 1.75f + (w.rand.nextFloat() - w.rand.nextFloat()) * 0.125f;
                e.motionz = dz * 1.75f + (w.rand.nextFloat() - w.rand.nextFloat()) * 0.125f;
                w.spawnEntityInWorld(e);
            }
        }
    }

    @Override
    public Texture getTexture(int side) {
        if (this.ttop == null) {
            this.ttop = this.initBlockTexture(this.topname);
        }
        if (this.tbottom == null) {
            this.tbottom = this.initBlockTexture(this.bottomname);
        }
        if (this.tleft == null) {
            this.tleft = this.initBlockTexture(this.leftname);
        }
        if (side == 0) {
            return this.ttop;
        }
        if (side == 5) {
            return this.tbottom;
        }
        if (side == 3) {
            return this.tleft;
        }
        if (side == 4) {
            return this.tleft;
        }
        if (side == 1) {
            return this.tleft;
        }
        if (side == 2) {
            return this.tleft;
        }
        return null;
    }

    @Override
    public StitchedTexture getStitchedTexture(int side) {
        if (side == 0) {
            return this.sttop;
        }
        if (side == 5) {
            return this.stbottom;
        }
        if (side == 3) {
            return this.stleft;
        }
        if (side == 4) {
            return this.stleft;
        }
        if (side == 1) {
            return this.stleft;
        }
        return this.stleft;
    }

    @Override
    public String getStitchedTextureName(int side) {
        if (side == 0) {
            return this.topname;
        }
        if (side == 5) {
            return this.bottomname;
        }
        if (side == 3) {
            return this.leftname;
        }
        if (side == 4) {
            return this.leftname;
        }
        if (side == 1) {
            return this.leftname;
        }
        return this.leftname;
    }
}

