/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.blocks;

import dangerzone.BreakChecks;
import dangerzone.StitchedTexture;
import dangerzone.World;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlockItem;
import dangerzone.entities.EntityExp;
import org.newdawn.slick.opengl.Texture;

public class WaterAnd
extends Block {
    Texture ttop = null;
    Texture tbottom = null;
    Texture tleft = null;
    Texture tfront = null;
    String topname;
    String bottomname;
    String leftname;
    String frontname;
    StitchedTexture sttop = new StitchedTexture();
    StitchedTexture stbottom = new StitchedTexture();
    StitchedTexture stleft = new StitchedTexture();
    StitchedTexture stfront = new StitchedTexture();

    public WaterAnd(String n) {
        super(n, "");
        this.isStone = true;
        this.maxdamage = 20;
        this.mindamage = 10;
        this.breaksound = "DangerZone:stonebreak";
        this.placesound = "DangerZone:stoneplace";
        this.hitsound = "DangerZone:stonehit";
        this.topname = "res/blocks/waterand.png";
        this.bottomname = "res/blocks/waterpump.png";
        this.leftname = "res/blocks/waterpumpleftright.png";
        this.frontname = "res/blocks/waterspoutside.png";
        this.alwaystick = true;
        this.hasFront = true;
        this.showTop = true;
    }

    @Override
    public void tickMe(World w, int d, int x, int y, int z) {
        int bid2;
        int bid;
        int meta = w.getblockmeta(d, x, y, z);
        if ((meta &= 0x3000) == 0) {
            bid = w.getblock(d, x + 1, y, z + 1);
            bid2 = w.getblock(d, x - 1, y, z + 1);
            if (Blocks.isLiquid(bid) && Blocks.isLiquid(bid2)) {
                this.fillit(w, d, x, y, z - 1);
            }
        }
        if (meta == 4096) {
            bid = w.getblock(d, x + 1, y, z + 1);
            bid2 = w.getblock(d, x + 1, y, z - 1);
            if (Blocks.isLiquid(bid) && Blocks.isLiquid(bid2)) {
                this.fillit(w, d, x - 1, y, z);
            }
        }
        if (meta == 8192) {
            bid = w.getblock(d, x + 1, y, z - 1);
            bid2 = w.getblock(d, x - 1, y, z - 1);
            if (Blocks.isLiquid(bid) && Blocks.isLiquid(bid2)) {
                this.fillit(w, d, x, y, z + 1);
            }
        }
        if (meta == 12288) {
            bid = w.getblock(d, x - 1, y, z + 1);
            bid2 = w.getblock(d, x - 1, y, z - 1);
            if (Blocks.isLiquid(bid) && Blocks.isLiquid(bid2)) {
                this.fillit(w, d, x + 1, y, z);
            }
        }
    }

    public boolean fillit(World w, int d, int x, int y, int z) {
        int bid = w.getblock(d, x, y, z);
        if (bid == 0 || Blocks.isLiquid(bid) || Blocks.isLeaves(bid)) {
            if (!BreakChecks.canChangeBlock(w, d, x, y, z, d, x, y, z, Blocks.water.blockID, 1)) {
                return false;
            }
            w.setblockandmeta(d, x, y, z, Blocks.water.blockID, 1);
            return true;
        }
        return false;
    }

    public boolean isSuitableTarget(Entity e) {
        if (e instanceof EntityExp) {
            return true;
        }
        return e instanceof EntityBlockItem;
    }

    @Override
    public Texture getTexture(int side) {
        if (this.ttop == null) {
            this.ttop = this.initBlockTexture(this.topname);
        }
        if (this.tbottom == null) {
            this.tbottom = this.initBlockTexture(this.bottomname);
        }
        if (this.tleft == null) {
            this.tleft = this.initBlockTexture(this.leftname);
        }
        if (this.tfront == null) {
            this.tfront = this.initBlockTexture(this.frontname);
        }
        if (side == 0) {
            return this.ttop;
        }
        if (side == 5) {
            return this.tleft;
        }
        if (side == 3) {
            return this.tleft;
        }
        if (side == 4) {
            return this.tleft;
        }
        if (side == 1) {
            return this.tfront;
        }
        if (side == 2) {
            return this.tbottom;
        }
        return null;
    }

    @Override
    public StitchedTexture getStitchedTexture(int side) {
        if (side == 0) {
            return this.sttop;
        }
        if (side == 5) {
            return this.stleft;
        }
        if (side == 3) {
            return this.stleft;
        }
        if (side == 4) {
            return this.stleft;
        }
        if (side == 1) {
            return this.stfront;
        }
        return this.stbottom;
    }

    @Override
    public String getStitchedTextureName(int side) {
        if (side == 0) {
            return this.topname;
        }
        if (side == 5) {
            return this.leftname;
        }
        if (side == 3) {
            return this.leftname;
        }
        if (side == 4) {
            return this.leftname;
        }
        if (side == 1) {
            return this.frontname;
        }
        return this.bottomname;
    }
}

