/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.blocks;

import dangerzone.StitchedTexture;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import org.newdawn.slick.opengl.Texture;

public class BlockWaterLight
extends Block {
    Texture ttop = null;
    Texture tbottom = null;
    Texture tleft = null;
    String topname;
    String bottomname;
    String leftname;
    StitchedTexture sttop = new StitchedTexture();
    StitchedTexture stbottom = new StitchedTexture();
    StitchedTexture stleft = new StitchedTexture();

    public BlockWaterLight(String n, String txttop, String txt2, String txt3, float li) {
        super(n, "");
        this.isStone = true;
        this.maxdamage = 20;
        this.mindamage = 10;
        this.breaksound = "DangerZone:stonebreak";
        this.placesound = "DangerZone:stoneplace";
        this.hitsound = "DangerZone:stonehit";
        this.topname = txttop;
        this.bottomname = txt3;
        this.leftname = txt2;
        this.alwaystick = true;
        this.brightness = li;
    }

    @Override
    public void tickMe(World w, int d, int x, int y, int z) {
        boolean spout = false;
        if (Blocks.isLiquid(w.getblock(d, x + 1, y, z))) {
            spout = true;
        }
        if (Blocks.isLiquid(w.getblock(d, x - 1, y, z))) {
            spout = true;
        }
        if (Blocks.isLiquid(w.getblock(d, x, y, z + 1))) {
            spout = true;
        }
        if (Blocks.isLiquid(w.getblock(d, x, y, z - 1))) {
            spout = true;
        }
        if (Blocks.isLiquid(w.getblock(d, x, y - 1, z))) {
            spout = true;
        }
        if (spout) {
            w.setblockandmeta(d, x, y, z, this.blockID, 1);
            if (this.brightness > 0.0f) {
                Utils.spawnParticlesFromServer(w, "DangerZone:ParticleSparkle", 1 + w.rand.nextInt(10), d, (double)x + 0.5, (double)y + (double)1.1f, (double)z + 0.5);
            } else {
                Utils.spawnParticlesFromServer(w, "DangerZone:ParticleSmoke", 1 + w.rand.nextInt(10), d, (double)x + 0.5, (double)y + (double)1.1f, (double)z + 0.5);
            }
        } else {
            w.setblockandmeta(d, x, y, z, this.blockID, 0);
        }
    }

    @Override
    public float getBrightness(World w, int d, int x, int y, int z) {
        if ((w.getblockmeta(d, x, y, z) & 1) != 1) {
            return 0.0f;
        }
        return this.brightness;
    }

    @Override
    public Texture getTexture(int side) {
        if (this.ttop == null) {
            this.ttop = this.initBlockTexture(this.topname);
        }
        if (this.tbottom == null) {
            this.tbottom = this.initBlockTexture(this.bottomname);
        }
        if (this.tleft == null) {
            this.tleft = this.initBlockTexture(this.leftname);
        }
        if (side == 0) {
            return this.ttop;
        }
        if (side == 5) {
            return this.tbottom;
        }
        if (side == 3) {
            return this.tleft;
        }
        if (side == 4) {
            return this.tleft;
        }
        if (side == 1) {
            return this.tleft;
        }
        if (side == 2) {
            return this.tleft;
        }
        return null;
    }

    @Override
    public StitchedTexture getStitchedTexture(int side) {
        if (side == 0) {
            return this.sttop;
        }
        if (side == 5) {
            return this.stbottom;
        }
        if (side == 3) {
            return this.stleft;
        }
        if (side == 4) {
            return this.stleft;
        }
        if (side == 1) {
            return this.stleft;
        }
        return this.stleft;
    }

    @Override
    public String getStitchedTextureName(int side) {
        if (side == 0) {
            return this.topname;
        }
        if (side == 5) {
            return this.bottomname;
        }
        if (side == 3) {
            return this.leftname;
        }
        if (side == 4) {
            return this.leftname;
        }
        if (side == 1) {
            return this.leftname;
        }
        return this.leftname;
    }
}

