/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.biomes;

import dangerzone.Chunk;
import dangerzone.DangerZone;
import dangerzone.Fastmath;
import dangerzone.Ores;
import dangerzone.World;
import dangerzone.biomes.Biome;
import dangerzone.biomes.Trees;
import dangerzone.blocks.Blocks;
import java.util.Random;

public class RuggedBiome
extends Biome {
    Trees tr = new Trees();
    float[] biomefloats = null;
    float[] biomeoffs;
    float[] biomescalex;
    float[] biomescalez;
    int[] biomepwrs;
    int[] biomept;
    int biolen = 100;
    public float hilliness = 2.5f;
    public float roughness = 0.25f;

    public RuggedBiome(String n) {
        super(n);
    }

    public void genarrays() {
        this.biomefloats = new float[this.biolen];
        this.biomeoffs = new float[this.biolen];
        this.biomescalex = new float[this.biolen];
        this.biomescalez = new float[this.biolen];
        this.biomepwrs = new int[this.biolen];
        this.biomept = new int[this.biolen];
        int i = this.biomefloats.length;
        Random myrand = DangerZone.server_world != null ? new Random(DangerZone.server_world.worldseed + this.bioRand) : new Random(this.bioRand);
        int j = 0;
        while (j < i) {
            if (myrand.nextInt(3) != 0) {
                this.biomefloats[j] = this.hilliness / 2.0f + myrand.nextFloat() * this.hilliness;
                this.biomescalex[j] = 0.1f + myrand.nextFloat();
                this.biomescalez[j] = 0.1f + myrand.nextFloat();
            } else {
                this.biomefloats[j] = (0.1f + myrand.nextFloat()) * this.roughness;
                this.biomescalex[j] = (0.1f + myrand.nextFloat()) * 15.0f;
                this.biomescalez[j] = (0.1f + myrand.nextFloat()) * 15.0f;
            }
            this.biomeoffs[j] = myrand.nextFloat() * 3.1415f;
            this.biomepwrs[j] = 1 + myrand.nextInt(6);
            this.biomept[j] = myrand.nextInt(2);
            ++j;
        }
    }

    public int genvalue(int dx, int dz) {
        int val = 0;
        int iters = this.biomefloats.length;
        float fval = 1.0f;
        int i = 0;
        while (i < iters) {
            fval = this.biomept[i] == 0 ? (fval += this.getoneval(i, dx, dz)) : (fval -= this.getoneval(i, dx, dz));
            ++i;
        }
        val = (int)fval;
        return val;
    }

    public float getoneval(int index, int dx, int dz) {
        float tval = (float)Fastmath.sin((double)this.biomeoffs[index] + Math.toRadians((float)dz * this.biomescalez[index]));
        float fval = (float)Fastmath.sin((double)this.biomeoffs[index] + Math.toRadians((float)dx * this.biomescalex[index]));
        tval = fval = (tval + fval) / 2.0f;
        int i = 0;
        while (i < this.biomepwrs[index]) {
            fval *= tval;
            ++i;
        }
        return fval *= this.biomefloats[index];
    }

    @Override
    public void generateheightmaps(World w, int d, Chunk c, int cx, int cz, int[][] dirtheight, int[][] stoneheight, int[][] baseheight) {
        int dx = (cx << 4) + (int)(w.worldseed & 0xFFFFL);
        int dz = (cz << 4) + (int)(w.worldseed >> 16 & 0xFFFFL);
        if (this.biomefloats == null) {
            this.genarrays();
        }
        int i = 0;
        while (i < 16) {
            int k = 0;
            while (k < 16) {
                float t = this.genvalue(dx + i, dz + k);
                if ((t += (float)this.avgheight) < 0.0f) {
                    t = 0.0f;
                }
                if (t > 255.0f) {
                    t = 255.0f;
                }
                stoneheight[i][k] = (int)t;
                t = (150.0f - t) / 40.0f;
                dirtheight[i][k] = (int)t + stoneheight[i][k] + 1;
                if (dirtheight[i][k] < 0) {
                    dirtheight[i][k] = 0;
                }
                if (dirtheight[i][k] > 255) {
                    dirtheight[i][k] = 255;
                }
                if (stoneheight[i][k] < this.waterlevel + 10 && stoneheight[i][k] >= this.waterlevel) {
                    t = t * (float)(stoneheight[i][k] - this.waterlevel) / 10.0f;
                    dirtheight[i][k] = (int)t + stoneheight[i][k] + 1;
                    if (dirtheight[i][k] < 0) {
                        dirtheight[i][k] = 0;
                    }
                    if (dirtheight[i][k] > 255) {
                        dirtheight[i][k] = 255;
                    }
                }
                baseheight[i][k] = 0;
                ++k;
            }
            ++i;
        }
    }

    @Override
    public void generate(World w, int d, Chunk c, int cx, int cz, int[][] dirtheight, int[][] stoneheight, int[][] lm3) {
        int waterlevel = 60;
        int j = 0;
        while (j < 250) {
            int i = 0;
            while (i < 16) {
                int k = 0;
                while (k < 16) {
                    if (j < stoneheight[i][k]) {
                        c.setblock(i, j, k, Blocks.stone.blockID);
                    } else if (j <= waterlevel) {
                        c.setblock(i, j, k, Blocks.waterstatic.blockID);
                        if (j == waterlevel && c.getblock(i, j - 1, k) == Blocks.stone.blockID) {
                            c.setblock(i, j - 1, k, Blocks.sand.blockID);
                        }
                    } else {
                        if (j < dirtheight[i][k] && c.getblock(i, j - 1, k) != 0 && c.getblock(i, j - 1, k) != Blocks.waterstatic.blockID && j < 150) {
                            c.setblock(i, j, k, Blocks.dirt.blockID);
                        }
                        if (j == dirtheight[i][k] && c.getblock(i, j - 1, k) == Blocks.dirt.blockID && j < 130) {
                            c.setblock(i, j, k, Blocks.grassblock.blockID);
                            c.setblockmeta(i, j, k, w.rand.nextInt(4) << 12);
                        }
                    }
                    if (j == 0) {
                        c.setblock(i, j, k, Blocks.stopblock.blockID);
                    }
                    ++k;
                }
                ++i;
            }
            ++j;
        }
        Ores.generate(w, d, this, c, cx, cz);
    }

    @Override
    public void decorate(World world, int d, Chunk c, int chunkx, int chunkz) {
        this.tr.addGenericTrees(world, d, chunkx << 4, chunkz << 4);
        this.tr.addGrass(world, d, chunkx << 4, chunkz << 4, c);
    }
}

