/*
 * Decompiled with CFR 0.152.
 */
package dangerzone;

import dangerzone.Chunk;
import dangerzone.DangerZone;
import dangerzone.World;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ServerChunkCache {
    public Lock lock = new ReentrantLock();
    public Lock slowlock = new ReentrantLock();
    private int hashwidth = 512;
    private int hashmask = 511;
    private int[] sizes = new int[this.hashwidth];
    private int startsize = 128;
    public Chunk[][] chunkhash = new Chunk[this.hashwidth][];
    public Chunk lastchunk = null;
    public int nextclean = 0;

    public ServerChunkCache() {
        int i = 0;
        while (i < this.hashwidth) {
            this.sizes[i] = this.startsize;
            this.chunkhash[i] = new Chunk[this.startsize];
            int j = 0;
            while (j < this.startsize) {
                this.chunkhash[i][j] = null;
                ++j;
            }
            ++i;
        }
    }

    private Chunk findChunk(int dimension, int x, int y, int z) {
        int i = x >> 4;
        int j = z >> 4;
        if (this.lastchunk != null && dimension == this.lastchunk.dimension && i == this.lastchunk.chunkX && j == this.lastchunk.chunkZ) {
            return this.lastchunk;
        }
        int h = i * 16 + j & this.hashmask;
        int k = 0;
        while (k < this.sizes[h]) {
            if (this.chunkhash[h][k] == null) {
                return null;
            }
            if (this.chunkhash[h][k].dimension == dimension && this.chunkhash[h][k].chunkX == i && this.chunkhash[h][k].chunkZ == j) {
                this.lastchunk = this.chunkhash[h][k];
                if (k > 0) {
                    this.chunkhash[h][k] = this.chunkhash[h][k - 1];
                    this.chunkhash[h][k - 1] = this.lastchunk;
                }
                return this.lastchunk;
            }
            ++k;
        }
        return null;
    }

    private Chunk findChunkUnlocked(int dimension, int x, int y, int z) {
        int i = x >> 4;
        int j = z >> 4;
        Chunk t = this.lastchunk;
        if (t != null && dimension == t.dimension && i == t.chunkX && j == t.chunkZ) {
            return t;
        }
        int h = i * 16 + j & this.hashmask;
        int k = 0;
        while (k < this.sizes[h]) {
            if (this.chunkhash[h][k] == null) {
                return null;
            }
            if (this.chunkhash[h][k].dimension == dimension && this.chunkhash[h][k].chunkX == i && this.chunkhash[h][k].chunkZ == j) {
                return this.chunkhash[h][k];
            }
            ++k;
        }
        return null;
    }

    public boolean chunkExists(int dimension, int x, int y, int z) {
        int i = x >> 4;
        int j = z >> 4;
        this.lock.lock();
        if (this.lastchunk != null && dimension == this.lastchunk.dimension && i == this.lastchunk.chunkX && j == this.lastchunk.chunkZ) {
            this.lock.unlock();
            return true;
        }
        int h = i * 16 + j & this.hashmask;
        int k = 0;
        while (k < this.sizes[h]) {
            if (this.chunkhash[h][k] == null) {
                this.lock.unlock();
                return false;
            }
            if (this.chunkhash[h][k].dimension == dimension && this.chunkhash[h][k].chunkX == i && this.chunkhash[h][k].chunkZ == j) {
                this.lock.unlock();
                return true;
            }
            ++k;
        }
        this.lock.unlock();
        return false;
    }

    public void releaseAllVBOs() {
        Chunk c = null;
        this.lock.lock();
        int i = 0;
        while (i < this.hashwidth) {
            int j = 0;
            while (j < this.sizes[i]) {
                c = this.chunkhash[i][j];
                if (c == null) break;
                DangerZone.wr.deleteVBOlist(c.VBOids);
                c.VBOids = new long[20];
                ++j;
            }
            ++i;
        }
        this.lock.unlock();
    }

    public Chunk getChunk(World w, int dimension, int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return null;
        }
        this.lock.lock();
        Chunk t = this.findChunk(dimension, x, y, z);
        this.lock.unlock();
        return t;
    }

    public Chunk getDecoratedChunkForRenderer(int d, int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return null;
        }
        this.lock.lock();
        Chunk t = this.findChunk(d, x, y, z);
        this.lock.unlock();
        return t;
    }

    public List<String> getChunkOwners(int d, int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return null;
        }
        this.lock.lock();
        Chunk t = this.findChunk(d, x, y, z);
        this.lock.unlock();
        if (t != null) {
            return t.ownernames;
        }
        return null;
    }

    public void setChunkOwners(int d, int x, int y, int z, List<String> newowners) {
        if (x < 0 || y < 0 || z < 0) {
            return;
        }
        this.lock.lock();
        Chunk t = this.findChunk(d, x, y, z);
        this.lock.unlock();
        if (t != null) {
            t.setowners(newowners);
            if (DangerZone.server != null) {
                DangerZone.server.sendChunkMetaUpdateToAll(t);
            }
        }
    }

    public Chunk getDecoratedChunk(int d, int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return null;
        }
        this.lock.lock();
        Chunk t = this.findChunk(d, x, y, z);
        if (t != null) {
            if (t.isDecorated != 0) {
                this.lock.unlock();
                return t;
            }
            this.lock.unlock();
            this.slowlock.lock();
            if (t.isValid == 0 && !t.readFromDisk()) {
                t.generate(DangerZone.server_world, d, x, y, z);
            }
            if (t.isDecorated == 0) {
                t.decorate(DangerZone.server_world, d, x, y, z);
            }
            this.slowlock.unlock();
            return t;
        }
        t = DangerZone.chunkwriter.getChunk(d, x >> 4, z >> 4);
        if (t == null) {
            t = new Chunk(d, x, y, z);
        }
        this.addCacheChunk(t);
        this.lock.unlock();
        this.slowlock.lock();
        if (t.isValid == 0 && !t.readFromDisk()) {
            t.generate(DangerZone.server_world, d, x, y, z);
        }
        if (t.isDecorated == 0) {
            t.decorate(DangerZone.server_world, d, x, y, z);
        }
        this.slowlock.unlock();
        return t;
    }

    public short[] getDecoratedChunkLevelData(int d, int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return null;
        }
        this.lock.lock();
        Chunk t = this.findChunk(d, x, y, z);
        if (t != null) {
            if (t.isDecorated != 0) {
                this.lock.unlock();
                return t.blockdata[y];
            }
            this.lock.unlock();
            this.slowlock.lock();
            if (t.isValid == 0 && !t.readFromDisk()) {
                t.generate(DangerZone.server_world, d, x, y, z);
            }
            if (t.isDecorated == 0) {
                t.decorate(DangerZone.server_world, d, x, y, z);
            }
            this.slowlock.unlock();
            return t.blockdata[y];
        }
        t = DangerZone.chunkwriter.getChunk(d, x >> 4, z >> 4);
        if (t == null) {
            t = new Chunk(d, x, y, z);
        }
        this.addCacheChunk(t);
        this.lock.unlock();
        this.slowlock.lock();
        if (t.isValid == 0 && !t.readFromDisk()) {
            t.generate(DangerZone.server_world, d, x, y, z);
        }
        if (t.isDecorated == 0) {
            t.decorate(DangerZone.server_world, d, x, y, z);
        }
        this.slowlock.unlock();
        return t.blockdata[y];
    }

    public long[] getDecoratedChunkVBOids(int d, int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return null;
        }
        this.lock.lock();
        Chunk t = this.findChunk(d, x, y, z);
        this.lock.unlock();
        if (t == null) {
            return null;
        }
        if (t.isDecorated != 0) {
            return t.VBOids;
        }
        return null;
    }

    public short[] getDecoratedChunkMetaData(int d, int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return null;
        }
        this.lock.lock();
        Chunk t = this.findChunk(d, x, y, z);
        if (t != null) {
            if (t.isDecorated != 0) {
                this.lock.unlock();
                return t.metadata[y];
            }
            this.lock.unlock();
            this.slowlock.lock();
            if (t.isValid == 0 && !t.readFromDisk()) {
                t.generate(DangerZone.server_world, d, x, y, z);
            }
            if (t.isDecorated == 0) {
                t.decorate(DangerZone.server_world, d, x, y, z);
            }
            this.slowlock.unlock();
            return t.metadata[y];
        }
        t = DangerZone.chunkwriter.getChunk(d, x >> 4, z >> 4);
        if (t == null) {
            t = new Chunk(d, x, y, z);
        }
        this.addCacheChunk(t);
        this.lock.unlock();
        this.slowlock.lock();
        if (t.isValid == 0 && !t.readFromDisk()) {
            t.generate(DangerZone.server_world, d, x, y, z);
        }
        if (t.isDecorated == 0) {
            t.decorate(DangerZone.server_world, d, x, y, z);
        }
        this.slowlock.unlock();
        return t.metadata[y];
    }

    public short[] getDecoratedChunkDrawn(int d, int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return null;
        }
        this.lock.lock();
        Chunk t = this.findChunk(d, x, y, z);
        this.lock.unlock();
        if (t == null) {
            return null;
        }
        if (t.isDecorated != 0) {
            return t.drawn;
        }
        return null;
    }

    public short[] getDecoratedChunkLightmap(int d, int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return null;
        }
        Chunk t = this.findChunkUnlocked(d, x, y, z);
        if (t == null) {
            return null;
        }
        if (t.isDecorated != 0) {
            if (t.lightmap == null) {
                return null;
            }
            return t.lightmap[y];
        }
        return null;
    }

    public void clearDecoratedChunkLightmap(int d, int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return;
        }
        this.lock.lock();
        Chunk t = this.findChunk(d, x, y, z);
        this.lock.unlock();
        if (t == null) {
            return;
        }
        if (t.isDecorated != 0) {
            if (t.lightmap == null) {
                return;
            }
            t.lightmap[y] = null;
            return;
        }
    }

    public void setDecoratedChunkLightmap(int d, int x, int y, int z, float v) {
        if (x < 0 || y < 0 || z < 0) {
            return;
        }
        this.lock.lock();
        Chunk t = this.findChunk(d, x, y, z);
        this.lock.unlock();
        if (t == null) {
            return;
        }
        if (t.isDecorated != 0) {
            if (t.lightmap == null) {
                t.lightmap = new short[256][];
            }
            if (t.lightmap[y] == null) {
                t.lightmap[y] = new short[256];
            }
            int m = x & 0xF;
            int n = z & 0xF;
            float tmp = v * 1000.0f;
            t.lightmap[y][m * 16 + n] = (short)tmp;
            return;
        }
    }

    public void addCacheChunk(Chunk c) {
        Chunk t = this.findChunk(c.dimension, c.chunkX << 4, 0, c.chunkZ << 4);
        if (t != null) {
            return;
        }
        int h = c.chunkX * 16 + c.chunkZ & this.hashmask;
        int i = 0;
        while (i < this.sizes[h]) {
            if (i == this.sizes[h] - 1) {
                int oldsize = this.sizes[h];
                int newsize = oldsize + 100;
                Chunk[] newlist = new Chunk[newsize];
                int k = 0;
                while (k < newsize) {
                    newlist[k] = null;
                    ++k;
                }
                k = 0;
                while (k < oldsize) {
                    newlist[k] = this.chunkhash[h][k];
                    ++k;
                }
                k = 0;
                while (k < oldsize) {
                    this.chunkhash[h][k] = null;
                    ++k;
                }
                this.chunkhash[h] = newlist;
                this.sizes[h] = newsize;
            }
            if (this.chunkhash[h][i] == null) {
                this.chunkhash[h][i] = c;
                return;
            }
            ++i;
        }
    }

    public void cleanCacheRow(boolean should_flush) {
        this.lock.lock();
        this.lastchunk = null;
        int disttoclean = DangerZone.entityupdatedist + 32;
        int i = 0;
        while (i < this.sizes[this.nextclean] && !DangerZone.dimension_change_in_progress) {
            if (this.chunkhash[this.nextclean][i] == null) break;
            if (DangerZone.server.findNearestPlayerDistToHere(this.chunkhash[this.nextclean][i].dimension, this.chunkhash[this.nextclean][i].chunkX << 4, this.chunkhash[this.nextclean][i].chunkZ << 4) > (double)disttoclean) {
                int h = i;
                DangerZone.chunkwriter.addChunk(this.chunkhash[this.nextclean][h]);
                if (DangerZone.wr != null) {
                    DangerZone.wr.deleteVBOlist(this.chunkhash[this.nextclean][h].VBOids);
                }
                while (h + 1 < this.sizes[this.nextclean]) {
                    this.chunkhash[this.nextclean][h] = this.chunkhash[this.nextclean][h + 1];
                    if (this.chunkhash[this.nextclean][h] != null) {
                        ++h;
                        continue;
                    }
                    break;
                }
            } else if (this.chunkhash[this.nextclean][i].must_be_written != 0 && should_flush) {
                DangerZone.chunkwriter.addChunkKeep(this.chunkhash[this.nextclean][i]);
            }
            ++i;
        }
        ++this.nextclean;
        if (this.nextclean > this.hashmask) {
            this.nextclean = 0;
        }
        this.lock.unlock();
    }

    public int getBlock(World w, int d, int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return 0;
        }
        if (y > 255) {
            return 0;
        }
        Chunk t = this.lastchunk;
        if (t != null && t.isValid != 0 && t.dimension == d && x >> 4 == t.chunkX && z >> 4 == t.chunkZ) {
            return t.getblock(x, y, z);
        }
        this.lock.lock();
        t = this.findChunk(d, x, y, z);
        if (t != null) {
            if (t.isValid != 0) {
                this.lock.unlock();
                return t.getblock(x, y, z);
            }
            this.lock.unlock();
            this.slowlock.lock();
            if (t.isValid == 0 && !t.readFromDisk()) {
                t.generate(DangerZone.server_world, d, x, y, z);
            }
            this.slowlock.unlock();
            return t.getblock(x, y, z);
        }
        t = DangerZone.chunkwriter.getChunk(d, x >> 4, z >> 4);
        if (t == null) {
            t = new Chunk(d, x, y, z);
        }
        this.addCacheChunk(t);
        this.lock.unlock();
        this.slowlock.lock();
        if (t.isValid == 0 && !t.readFromDisk()) {
            t.generate(DangerZone.server_world, d, x, y, z);
        }
        this.slowlock.unlock();
        return t.getblock(x, y, z);
    }

    public int getBlockTry(int d, int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return 0;
        }
        if (y > 255) {
            return 0;
        }
        Chunk t = this.lastchunk;
        if (t != null && t.isValid != 0 && t.dimension == d && x >> 4 == t.chunkX && z >> 4 == t.chunkZ) {
            return t.getblock(x, y, z);
        }
        this.lock.lock();
        t = this.findChunk(d, x, y, z);
        if (t != null && t.isValid != 0 && t.isDecorated != 0) {
            this.lock.unlock();
            return t.getblock(x, y, z);
        }
        this.lock.unlock();
        return 0;
    }

    public int getBlockmeta(World w, int d, int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return 0;
        }
        if (y > 255) {
            return 0;
        }
        Chunk t = this.lastchunk;
        if (t != null && t.isValid != 0 && t.dimension == d && x >> 4 == t.chunkX && z >> 4 == t.chunkZ) {
            return t.getblockmeta(x, y, z);
        }
        this.lock.lock();
        t = this.findChunk(d, x, y, z);
        if (t != null) {
            if (t.isValid != 0) {
                int b = t.getblockmeta(x, y, z);
                this.lock.unlock();
                return b;
            }
            this.lock.unlock();
            this.slowlock.lock();
            if (t.isValid == 0 && !t.readFromDisk()) {
                t.generate(DangerZone.server_world, d, x, y, z);
            }
            this.slowlock.unlock();
            int b = t.getblockmeta(x, y, z);
            return b;
        }
        t = DangerZone.chunkwriter.getChunk(d, x >> 4, z >> 4);
        if (t == null) {
            t = new Chunk(d, x, y, z);
        }
        this.addCacheChunk(t);
        this.lock.unlock();
        this.slowlock.lock();
        if (t.isValid == 0 && !t.readFromDisk()) {
            t.generate(DangerZone.server_world, d, x, y, z);
        }
        this.slowlock.unlock();
        int b = t.getblockmeta(x, y, z);
        return b;
    }

    public void setBlock(World w, int d, int x, int y, int z, int id, int meta) {
        if (x < 0 || y < 0 || z < 0) {
            return;
        }
        if (y > 255) {
            return;
        }
        Chunk t = this.lastchunk;
        if (t != null && t.isValid != 0 && t.dimension == d && x >> 4 == t.chunkX && z >> 4 == t.chunkZ) {
            int b = t.getblock(x, y, z);
            int m = t.getblockmeta(x, y, z);
            if (id == b && meta == m) {
                return;
            }
            if (id != b) {
                t.setblock(x, y, z, id);
            }
            if (meta != m) {
                t.setblockmeta(x, y, z, meta);
            }
            if (!(DangerZone.start_client || t.amDecorating || t.amGenerating)) {
                DangerZone.server.sendBlockToAll(d, x, y, z, id, meta);
            }
            return;
        }
        this.lock.lock();
        t = this.findChunk(d, x, y, z);
        if (t != null) {
            if (t.isValid != 0) {
                this.lock.unlock();
                int b = t.getblock(x, y, z);
                int m = t.getblockmeta(x, y, z);
                if (id == b && meta == m) {
                    return;
                }
                if (id != b) {
                    t.setblock(x, y, z, id);
                }
                if (meta != m) {
                    t.setblockmeta(x, y, z, meta);
                }
                if (!(DangerZone.start_client || t.amDecorating || t.amGenerating)) {
                    DangerZone.server.sendBlockToAll(d, x, y, z, id, meta);
                }
                return;
            }
            this.lock.unlock();
            this.slowlock.lock();
            if (t.isValid == 0 && !t.readFromDisk()) {
                t.generate(DangerZone.server_world, d, x, y, z);
            }
            this.slowlock.unlock();
            int b = t.getblock(x, y, z);
            int m = t.getblockmeta(x, y, z);
            if (id == b && meta == m) {
                return;
            }
            if (id != b) {
                t.setblock(x, y, z, id);
            }
            if (meta != m) {
                t.setblockmeta(x, y, z, meta);
            }
            if (!DangerZone.start_client) {
                DangerZone.server.sendBlockToAll(d, x, y, z, id, meta);
            }
            return;
        }
        t = DangerZone.chunkwriter.getChunk(d, x >> 4, z >> 4);
        if (t == null) {
            t = new Chunk(d, x, y, z);
        }
        this.addCacheChunk(t);
        this.lock.unlock();
        this.slowlock.lock();
        if (t.isValid == 0 && !t.readFromDisk()) {
            t.generate(DangerZone.server_world, d, x, y, z);
        }
        this.slowlock.unlock();
        int b = t.getblock(x, y, z);
        int m = t.getblockmeta(x, y, z);
        if (id == b && meta == m) {
            return;
        }
        if (id != b) {
            t.setblock(x, y, z, id);
        }
        if (meta != m) {
            t.setblockmeta(x, y, z, meta);
        }
        if (!DangerZone.start_client) {
            DangerZone.server.sendBlockToAll(d, x, y, z, id, meta);
        }
    }

    public boolean isDecorated(int d, int x, int y, int z) {
        boolean retflag = false;
        if (x < 0 || y < 0 || z < 0) {
            return retflag;
        }
        this.lock.lock();
        Chunk t = this.findChunk(d, x, y, z);
        if (t != null && t.isValid != 0 && t.isDecorated != 0) {
            retflag = true;
        }
        this.lock.unlock();
        return retflag;
    }

    public void shutdown() {
        this.lock.lock();
        int i = 0;
        while (i < this.hashwidth) {
            int j = 0;
            while (j < this.sizes[i]) {
                Chunk t = this.chunkhash[i][j];
                if (t != null && t.isValid != 0) {
                    t.saveToDisk(false);
                }
                ++j;
            }
            ++i;
        }
    }

    public void rebuildChunk(int d, int x, int y, int z) {
        Chunk t;
        if (x < 0 || y < 0 || z < 0) {
            return;
        }
        this.lock.lock();
        boolean removed = false;
        int i = x >> 4;
        int j = z >> 4;
        int h = i * 16 + j & this.hashmask;
        int k = 0;
        while (k < this.sizes[h]) {
            if (this.chunkhash[h][k] == null) break;
            if (this.chunkhash[h][k].dimension == d && this.chunkhash[h][k].chunkX == i && this.chunkhash[h][k].chunkZ == j) {
                t = this.chunkhash[h][k];
                if (t.ownernames != null) break;
                t.delete();
                removed = true;
                if (DangerZone.wr != null) {
                    DangerZone.wr.deleteVBOlist(t.VBOids);
                }
                j = k;
                while (j + 1 < this.sizes[h]) {
                    this.chunkhash[h][j] = this.chunkhash[h][j + 1];
                    if (this.chunkhash[h][j] == null) break;
                    ++j;
                }
                this.lastchunk = null;
                break;
            }
            ++k;
        }
        this.lock.unlock();
        if (removed && (t = this.getDecoratedChunk(d, x, y, z)) != null) {
            DangerZone.server.sendChunkToAll(t);
        }
    }
}

