/*
 * Decompiled with CFR 0.152.
 */
package dangerzone;

import dangerzone.DangerZone;
import dangerzone.Dimensions;
import dangerzone.StuffList;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.WorldDecorator;
import dangerzone.biomes.Biome;
import dangerzone.biomes.Trees;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.items.Items;

public class DZWorldDecorator
extends WorldDecorator {
    public static StuffList[] things = new StuffList[]{new StuffList(Items.coinsilver, 5, 25, 75), new StuffList(Items.coingold, 3, 15, 65), new StuffList(Items.coinplatinum, 1, 5, 55), new StuffList(Items.diamond, 1, 5, 5), new StuffList(Items.emerald, 1, 5, 5), new StuffList(Items.bloodstone, 1, 5, 5), new StuffList(Items.sunstone, 1, 5, 5), new StuffList(Items.scubatanks, 1, 2, 55), new StuffList(Items.scubamask, 1, 2, 55), new StuffList(Items.woodenaxe, 1, 1, 25), new StuffList(Items.woodenshovel, 1, 1, 25), new StuffList(Items.woodenhoe, 1, 1, 25), new StuffList(Items.woodenpickaxe, 1, 1, 25), new StuffList(Items.woodensword, 1, 1, 25), new StuffList(Items.silveraxe, 1, 1, 20), new StuffList(Items.silvershovel, 1, 1, 20), new StuffList(Items.silverhoe, 1, 1, 20), new StuffList(Items.silverpickaxe, 1, 1, 20), new StuffList(Items.silversword, 1, 1, 20), new StuffList(Items.tinsword, 1, 1, 20), new StuffList(Items.tinaxe, 1, 1, 20), new StuffList(Items.tinshovel, 1, 1, 20), new StuffList(Items.tinhoe, 1, 1, 20), new StuffList(Items.tinpickaxe, 1, 1, 20), new StuffList(Items.coppersword, 1, 1, 20), new StuffList(Items.copperaxe, 1, 1, 20), new StuffList(Items.coppershovel, 1, 1, 20), new StuffList(Items.copperhoe, 1, 1, 20), new StuffList(Items.copperpickaxe, 1, 1, 20), new StuffList(Items.platinumaxe, 1, 1, 15), new StuffList(Items.platinumshovel, 1, 1, 15), new StuffList(Items.platinumhoe, 1, 1, 15), new StuffList(Items.platinumpickaxe, 1, 1, 15), new StuffList(Items.platinumsword, 1, 1, 15), new StuffList(Items.furball, 1, 16, 65), new StuffList(Items.furball, 1, 16, 65), new StuffList(Items.furball, 1, 16, 65), new StuffList(Items.furball, 1, 16, 65), new StuffList(Items.instability, 1, 16, 25), new StuffList(Items.instabilitylarge, 1, 16, 20), new StuffList(Items.instabilityhuge, 1, 16, 15), new StuffList(Items.corn, 1, 16, 45), new StuffList(Items.corn, 1, 16, 45), new StuffList(Items.radish, 1, 16, 45), new StuffList(Items.radish, 1, 16, 45), new StuffList(Items.moosemeat, 1, 16, 45), new StuffList(Items.moosemeat_cooked, 1, 16, 35), new StuffList(Items.moosebone, 1, 16, 45), new StuffList(Items.goosemeat, 1, 16, 45), new StuffList(Items.goosemeat_cooked, 1, 16, 35), new StuffList(Items.feather, 1, 16, 45), new StuffList(Items.ostrichmeat, 1, 16, 35), new StuffList(Items.ostrichmeat_cooked, 1, 16, 45), new StuffList(Items.silverhelmet, 1, 1, 20), new StuffList(Items.silverchestplate, 1, 1, 20), new StuffList(Items.silverleggings, 1, 1, 20), new StuffList(Items.silverboots, 1, 1, 20), new StuffList(Items.platinumhelmet, 1, 1, 15), new StuffList(Items.platinumchestplate, 1, 1, 15), new StuffList(Items.platinumleggings, 1, 1, 15), new StuffList(Items.platinumboots, 1, 1, 15), new StuffList(Items.copperhelmet, 1, 1, 20), new StuffList(Items.copperchestplate, 1, 1, 20), new StuffList(Items.copperleggings, 1, 1, 20), new StuffList(Items.copperboots, 1, 1, 20), new StuffList(Items.tinhelmet, 1, 1, 20), new StuffList(Items.tinchestplate, 1, 1, 20), new StuffList(Items.tinleggings, 1, 1, 20), new StuffList(Items.tinboots, 1, 1, 20), new StuffList(Items.firestick, 1, 1, 45), new StuffList(Items.deadbug, 1, 16, 45), new StuffList(Items.peachseed, 1, 16, 45), new StuffList(Items.appleseed, 1, 16, 45), new StuffList(Items.cherryseed, 1, 16, 45), new StuffList(Items.dark, 1, 16, 25), new StuffList(Items.light, 1, 16, 25), new StuffList(Items.bottle, 1, 16, 45), new StuffList(Items.experiencebottle, 1, 16, 45), new StuffList(Items.bread, 1, 16, 45), new StuffList(Items.rice, 1, 16, 45), new StuffList(Items.scubatanks, 1, 1, 55), new StuffList(Items.scubamask, 1, 1, 55), new StuffList(Items.eggbutterfly, 1, 6, 15), new StuffList(Items.eggghost, 1, 6, 15), new StuffList(Items.eggghostskelly, 1, 6, 15), new StuffList(Items.eggrat, 1, 6, 15), new StuffList(Items.eggcockroach, 1, 6, 15), new StuffList(Items.eggmoose, 1, 6, 15), new StuffList(Items.egggoose, 1, 6, 15), new StuffList(Items.egggosling, 1, 6, 15), new StuffList(Items.eggostrich, 1, 6, 15), new StuffList(Items.eggsparklemuffin, 1, 6, 15), new StuffList(Items.eggskeletorus, 1, 6, 15), new StuffList(Items.egganteater, 1, 6, 15), new StuffList(Items.eggvampire, 1, 6, 15), new StuffList(Items.eggthecount, 1, 6, 15), new StuffList(Items.eggwerewolf, 1, 6, 15), new StuffList(Items.eggvixen, 1, 6, 15), new StuffList(Items.frog_speed1, 1, 6, 15), new StuffList(Items.frog_slowness1, 1, 6, 15), new StuffList(Items.frog_speed2, 1, 6, 15), new StuffList(Items.frog_slowness2, 1, 6, 15), new StuffList(Items.frog_speed3, 1, 6, 15), new StuffList(Items.frog_slowness3, 1, 6, 15), new StuffList(Items.frog_strength1, 1, 6, 15), new StuffList(Items.frog_weakness1, 1, 6, 15), new StuffList(Items.frog_strength2, 1, 6, 15), new StuffList(Items.frog_weakness2, 1, 6, 15), new StuffList(Items.frog_strength3, 1, 6, 15), new StuffList(Items.frog_weakness3, 1, 6, 15), new StuffList(Items.frog_regen1, 1, 6, 15), new StuffList(Items.frog_poison1, 1, 6, 15), new StuffList(Items.frog_regen2, 1, 6, 15), new StuffList(Items.frog_poison2, 1, 6, 15), new StuffList(Items.frog_regen3, 1, 6, 15), new StuffList(Items.frog_poison3, 1, 6, 15), new StuffList(Items.frog_confusion1, 1, 6, 15), new StuffList(Items.frog_confusion2, 1, 6, 15), new StuffList(Items.frog_confusion3, 1, 6, 15), new StuffList(Items.frog_morph1, 1, 6, 15), new StuffList(Items.frog_morph2, 1, 6, 15), new StuffList(Items.frog_morph3, 1, 6, 15), new StuffList(Blocks.stone, 1, 5, 10), new StuffList(Blocks.greystone, 1, 5, 10), new StuffList(Blocks.lightstick, 1, 16, 60), new StuffList(Blocks.darkstick, 1, 16, 10), new StuffList(Blocks.blocklight, 1, 1, 5), new StuffList(Blocks.blockdark, 1, 1, 5), new StuffList(Blocks.blocksilver, 1, 1, 5), new StuffList(Blocks.blockcopper, 1, 1, 15), new StuffList(Blocks.blocktin, 1, 1, 15), new StuffList(Blocks.blockplatinum, 1, 1, 5), new StuffList(Blocks.oresilver, 5, 10, 15), new StuffList(Blocks.oreplatinum, 5, 10, 10), new StuffList(Blocks.log, 5, 10, 25), new StuffList(Blocks.willowlog, 5, 10, 25), new StuffList(Blocks.redwoodlog, 5, 10, 25), new StuffList(Blocks.stopblock, 1, 5, 10)};
    public static StuffList[] martian_things = new StuffList[]{new StuffList(Items.coinsilver, 5, 64, 75), new StuffList(Items.coingold, 3, 32, 65), new StuffList(Items.coinplatinum, 1, 16, 55), new StuffList(Items.diamond, 1, 16, 5), new StuffList(Items.emerald, 1, 32, 5), new StuffList(Items.bloodstone, 1, 5, 5), new StuffList(Items.sunstone, 1, 5, 5), new StuffList(Items.frog_speed3, 1, 6, 15), new StuffList(Items.frog_slowness3, 1, 6, 15), new StuffList(Items.frog_strength3, 1, 6, 15), new StuffList(Items.frog_weakness3, 1, 6, 15), new StuffList(Items.frog_regen3, 1, 6, 15), new StuffList(Items.frog_poison3, 1, 6, 15), new StuffList(Items.frog_confusion3, 1, 6, 15), new StuffList(Items.frog_morph3, 1, 6, 15), new StuffList(Items.instabilitylarge, 1, 16, 15), new StuffList(Items.instabilityhuge, 1, 8, 15), new StuffList(Items.scrollaccuracyIV, 1, 8, 15), new StuffList(Items.scrolldamageIV, 1, 8, 15), new StuffList(Items.scrolldurabilityIV, 1, 8, 15), new StuffList(Items.scrollreachIV, 1, 8, 15), new StuffList(Items.scrollspamIV, 1, 8, 15), new StuffList(Items.scrollaccuracyV, 1, 4, 15), new StuffList(Items.scrolldamageV, 1, 4, 15), new StuffList(Items.scrolldurabilityV, 1, 4, 15), new StuffList(Items.scrollreachV, 1, 4, 15), new StuffList(Items.scrollspamV, 1, 4, 15), new StuffList(Items.scrollharm, 1, 16, 15), new StuffList(Items.scrollheal, 1, 16, 15), new StuffList(Items.drone, 1, 4, 15), new StuffList(Items.drone_motor, 1, 8, 15), new StuffList(Items.drone_body, 1, 8, 15), new StuffList(Items.drone_camera, 1, 8, 15)};
    private Trees tr = null;

    @Override
    public void decorate(World world, int dimension, Biome b, int chunkx, int chunkz) {
        int posY;
        int posX;
        int what;
        int iy;
        int bid;
        int iz;
        int m;
        int which;
        int iz2;
        int m2;
        if (!world.isServer) {
            return;
        }
        if (b == null) {
            return;
        }
        if (this.tr == null) {
            this.tr = new Trees();
        }
        if (b.should_add_caves) {
            double starty = 10.0f + world.rand.nextFloat() * 60.0f;
            double startx = world.rand.nextFloat() * 16.0f;
            double startz = world.rand.nextFloat() * 16.0f;
            this.add_cave(world, dimension, chunkx, chunkz, 0, 4.0f, 100.0f, startx += (double)(chunkx << 4), starty, startz += (double)(chunkz << 4));
        }
        if (b.should_add_dungeons) {
            this.add_dungeon(world, dimension, chunkx, chunkz);
        }
        if (b.should_add_roaches && world.rand.nextInt(40) == 1) {
            int howmany = 1 + world.rand.nextInt(3);
            m2 = 0;
            while (m2 < howmany) {
                int ix = (chunkx << 4) + world.rand.nextInt(16);
                iz2 = (chunkz << 4) + world.rand.nextInt(16);
                int iy2 = 150;
                while (iy2 > 60) {
                    if (world.getblock(dimension, ix, iy2, iz2) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy2 + 1, iz2) == 0) {
                        world.setblock(dimension, ix, iy2, iz2, Blocks.roachnest.blockID);
                        break;
                    }
                    --iy2;
                }
                ++m2;
            }
        }
        if (b.should_add_butterflies && world.rand.nextInt(50) == 1) {
            int howmany = 1 + world.rand.nextInt(3);
            m2 = 0;
            while (m2 < howmany) {
                int ix = (chunkx << 4) + world.rand.nextInt(16);
                iz2 = (chunkz << 4) + world.rand.nextInt(16);
                int iy3 = 150;
                while (iy3 > 70) {
                    if (world.getblock(dimension, ix, iy3, iz2) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy3 + 1, iz2) == 0) {
                        world.setblock(dimension, ix, iy3 + 1, iz2, Blocks.butterfly_plant.blockID);
                        break;
                    }
                    --iy3;
                }
                ++m2;
            }
        }
        if (b.should_add_flowers && world.rand.nextInt(12) == 1) {
            int howmany = 1 + world.rand.nextInt(5);
            m2 = 0;
            while (m2 < howmany) {
                int ix = (chunkx << 4) + world.rand.nextInt(16);
                iz2 = (chunkz << 4) + world.rand.nextInt(16);
                int iy4 = 165;
                while (iy4 > 60) {
                    if (world.getblock(dimension, ix, iy4, iz2) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy4 + 1, iz2) == 0) {
                        world.setblock(dimension, ix, iy4 + 1, iz2, Blocks.flower_red.blockID);
                        break;
                    }
                    --iy4;
                }
                ++m2;
            }
        }
        if (b.should_add_flowers && world.rand.nextInt(12) == 1) {
            int howmany = 1 + world.rand.nextInt(6);
            m2 = 0;
            while (m2 < howmany) {
                int ix = (chunkx << 4) + world.rand.nextInt(16);
                iz2 = (chunkz << 4) + world.rand.nextInt(16);
                int iy5 = 180;
                while (iy5 > 60) {
                    if (world.getblock(dimension, ix, iy5, iz2) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy5 + 1, iz2) == 0) {
                        world.setblock(dimension, ix, iy5 + 1, iz2, Blocks.flower_yellow.blockID);
                        break;
                    }
                    --iy5;
                }
                ++m2;
            }
        }
        if (b.should_add_waterplants && world.rand.nextInt(4) == 1) {
            int howmany = 5 + world.rand.nextInt(12);
            which = world.rand.nextInt(16);
            int planttype = Blocks.reefgrass.blockID;
            switch (which) {
                case 0: {
                    planttype = Blocks.redcoral.blockID;
                    break;
                }
                case 1: {
                    planttype = Blocks.reefgrass.blockID;
                    break;
                }
                case 2: {
                    planttype = Blocks.redreefgrass.blockID;
                    break;
                }
                case 3: {
                    planttype = Blocks.yellowcoral.blockID;
                    break;
                }
                case 4: {
                    planttype = Blocks.bluecoral.blockID;
                    break;
                }
                case 5: {
                    planttype = Blocks.firecoral.blockID;
                    break;
                }
                case 6: {
                    planttype = Blocks.redfancoral.blockID;
                    break;
                }
                case 7: {
                    planttype = Blocks.blackfancoral.blockID;
                    break;
                }
                case 8: {
                    planttype = Blocks.seaweed.blockID;
                    break;
                }
                case 9: {
                    planttype = Blocks.yellowseaweed.blockID;
                    break;
                }
                case 10: {
                    planttype = Blocks.brownseaweed.blockID;
                    break;
                }
                case 11: {
                    planttype = Blocks.kelp.blockID;
                    break;
                }
                default: {
                    planttype = Blocks.reefgrass.blockID;
                }
            }
            if (planttype == Blocks.reefgrass.blockID) {
                howmany += 16;
            }
            if (planttype == Blocks.redreefgrass.blockID) {
                howmany += 10;
            }
            m = 0;
            while (m < howmany) {
                int ix = (chunkx << 4) + world.rand.nextInt(16);
                iz = (chunkz << 4) + world.rand.nextInt(16);
                bid = 0;
                iy = 80;
                while (iy > 10) {
                    bid = world.getblock(dimension, ix, iy, iz);
                    if (bid != 0 && bid != Blocks.waterstatic.blockID) {
                        if (bid != Blocks.stone.blockID || world.getblock(dimension, ix, iy + 1, iz) != Blocks.waterstatic.blockID || world.getblock(dimension, ix, iy + 2, iz) != Blocks.waterstatic.blockID) break;
                        if (world.rand.nextInt(200) == 5) {
                            world.setblocknonotify(dimension, ix, iy + 1, iz, Blocks.fishnursery.blockID);
                            break;
                        }
                        world.setblocknonotify(dimension, ix, iy + 1, iz, planttype);
                        break;
                    }
                    --iy;
                }
                ++m;
            }
        } else if (b.should_add_waterplants && world.rand.nextInt(10) == 1) {
            int howmany = 5 + world.rand.nextInt(6);
            which = world.rand.nextInt(6);
            int planttype = Blocks.tallseaweed.blockID;
            switch (which) {
                case 0: {
                    planttype = Blocks.tallseaweed.blockID;
                    break;
                }
                case 1: {
                    planttype = Blocks.browntallseaweed.blockID;
                    break;
                }
                case 2: {
                    planttype = Blocks.yellowtallseaweed.blockID;
                    break;
                }
                case 3: {
                    planttype = Blocks.tallkelp.blockID;
                    break;
                }
                default: {
                    planttype = Blocks.tallseaweed.blockID;
                }
            }
            m = 0;
            while (m < howmany) {
                int ix = (chunkx << 4) + world.rand.nextInt(16);
                iz = (chunkz << 4) + world.rand.nextInt(16);
                bid = 0;
                iy = 80;
                block31: while (iy > 10) {
                    bid = world.getblock(dimension, ix, iy, iz);
                    if (bid != 0 && bid != Blocks.waterstatic.blockID) {
                        if (bid != Blocks.stone.blockID || world.getblock(dimension, ix, iy + 1, iz) != Blocks.waterstatic.blockID || world.getblock(dimension, ix, iy + 2, iz) != Blocks.waterstatic.blockID) break;
                        while (world.getblock(dimension, ix, iy + 2, iz) == Blocks.waterstatic.blockID) {
                            world.setblocknonotify(dimension, ix, iy + 1, iz, planttype);
                            ++iy;
                            if (world.rand.nextInt(50) == 1) break block31;
                        }
                        break;
                    }
                    --iy;
                }
                ++m;
            }
        }
        if (Dimensions.getName(dimension).equals("DangerZone: Overworld Dimension")) {
            int howmany = 0;
            what = world.rand.nextInt(6);
            howmany = world.rand.nextInt(4);
            if (what != 0) {
                howmany *= 2;
            }
            if (b.uniquename.equals("DangerZone:Overworld Tall Forest")) {
                what = 0;
            } else if (b.uniquename.equals("DangerZone:Overworld Tall Willow Forest")) {
                what = 1;
            } else if (b.uniquename.equals("DangerZone:Overworld Scraggly Forest")) {
                what = 2;
            } else if (world.rand.nextInt(5) != 0) {
                howmany = 0;
            }
            int cx = chunkx << 4;
            int cz = chunkz << 4;
            int i = 0;
            while (i < howmany) {
                int posX2 = cx + world.rand.nextInt(16);
                int posZ = cz + world.rand.nextInt(16);
                int posY2 = 128;
                while (posY2 > 40) {
                    if (world.getblock(dimension, posX2, posY2, posZ) == 0 && world.getblock(dimension, posX2, posY2 - 1, posZ) == Blocks.grassblock.blockID) {
                        if (what == 0) {
                            this.tr.TallWoodTree(world, dimension, posX2, posY2, posZ);
                            break;
                        }
                        if (what == 1) {
                            this.tr.TallWillowTree(world, dimension, posX2, posY2, posZ);
                            break;
                        }
                        this.tr.ScragglyRedwoodTree(world, dimension, posX2, posY2, posZ);
                        break;
                    }
                    --posY2;
                }
                ++i;
            }
        }
        if ((Dimensions.getName(dimension).equals("DangerZone: Overworld Dimension") || Dimensions.getName(dimension).equals("DangerZone: Rugged Hills Dimension")) && world.rand.nextInt(64) == 1) {
            int howmany = 1 + world.rand.nextInt(5);
            m2 = 0;
            while (m2 < howmany) {
                int ix = (chunkx << 4) + world.rand.nextInt(16);
                iz2 = (chunkz << 4) + world.rand.nextInt(16);
                int iy6 = 100;
                while (iy6 > 50) {
                    if (world.getblock(dimension, ix, iy6, iz2) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy6 + 1, iz2) == 0) {
                        int howhigh = 2 + world.rand.nextInt(4);
                        int i = 0;
                        while (i < howhigh) {
                            if (world.getblock(dimension, ix, iy6 + i + 2, iz2) != 0) {
                                howhigh = i;
                                break;
                            }
                            world.setblock(dimension, ix, iy6 + i + 1, iz2, world.rand.nextBoolean() ? Blocks.corn_plant2.blockID : Blocks.corn_plant3.blockID);
                            ++i;
                        }
                        world.setblock(dimension, ix, iy6, iz2, Blocks.dirt.blockID);
                        world.setblock(dimension, ix, iy6 + howhigh + 1, iz2, Blocks.corn_plant.blockID);
                        break;
                    }
                    --iy6;
                }
                ++m2;
            }
        }
        if (Dimensions.getName(dimension).equals("DangerZone: Big Round Tree Dimension")) {
            if (b.uniquename.equals("DangerZone:Big Trees") && !this.tr.addGenericTrees(world, dimension, chunkx << 4, chunkz << 4)) {
                this.tr.addTrees(world, dimension, chunkx << 4, chunkz << 4);
            }
            if (b.uniquename.equals("DangerZone:Big Trees Flower") && !this.tr.addBigRoundLightTree(world, dimension, chunkx << 4, chunkz << 4)) {
                this.tr.addFlowerTrees(world, dimension, chunkx << 4, chunkz << 4);
            }
            if (b.uniquename.equals("DangerZone:Big Trees Flower Two") && !this.tr.addBigRoundLightTree(world, dimension, chunkx << 4, chunkz << 4)) {
                this.tr.addFlowerTwoTrees(world, dimension, chunkx << 4, chunkz << 4);
                this.addMartianHabitat(world, dimension, chunkx << 4, chunkz << 4);
            }
            if (world.rand.nextInt(7) == 1) {
                int howmany = 2 + world.rand.nextInt(5);
                m2 = 0;
                while (m2 < howmany) {
                    int ix = (chunkx << 4) + world.rand.nextInt(16);
                    iz2 = (chunkz << 4) + world.rand.nextInt(16);
                    int iy7 = 100;
                    while (iy7 > 50) {
                        if (world.getblock(dimension, ix, iy7, iz2) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy7 + 1, iz2) == 0) {
                            world.setblock(dimension, ix, iy7 + 1, iz2, Blocks.flower_pink.blockID);
                            break;
                        }
                        --iy7;
                    }
                    ++m2;
                }
            }
            if (world.rand.nextInt(64) == 1) {
                int howmany = 1 + world.rand.nextInt(5);
                m2 = 0;
                while (m2 < howmany) {
                    int ix = (chunkx << 4) + world.rand.nextInt(16);
                    iz2 = (chunkz << 4) + world.rand.nextInt(16);
                    int iy8 = 100;
                    while (iy8 > 50) {
                        if (world.getblock(dimension, ix, iy8, iz2) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy8 + 1, iz2) == 0) {
                            world.setblock(dimension, ix, iy8, iz2, Blocks.dirt.blockID);
                            if (world.rand.nextInt(3) == 0) {
                                world.setblock(dimension, ix, iy8 + 1, iz2, Blocks.radish_plant.blockID);
                                break;
                            }
                            world.setblock(dimension, ix, iy8 + 1, iz2, Blocks.radish_plant3.blockID);
                            break;
                        }
                        --iy8;
                    }
                    ++m2;
                }
            }
        }
        if (Dimensions.getName(dimension).equals("DangerZone: Pathway Dimension")) {
            if (b.uniquename.equals("DangerZone:Pathway")) {
                this.tr.addGenericTrees(world, dimension, chunkx << 4, chunkz << 4);
                if (world.rand.nextInt(3) == 0) {
                    int howmany = 0;
                    what = world.rand.nextInt(3);
                    howmany = world.rand.nextInt(6);
                    int i = 0;
                    while (i < howmany) {
                        posX = (chunkx << 4) + world.rand.nextInt(16);
                        int posZ = (chunkz << 4) + world.rand.nextInt(16);
                        posY = 90;
                        while (posY > 50) {
                            if (world.getblock(dimension, posX, posY, posZ) == 0 && world.getblock(dimension, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                                if (what == 0) {
                                    this.tr.makeFruitTree(world, dimension, posX, posY - 1, posZ, Blocks.cherryleaves.blockID);
                                    break;
                                }
                                if (what != 1) break;
                                this.tr.makeFruitTree(world, dimension, posX, posY - 1, posZ, Blocks.appleleaves.blockID);
                                break;
                            }
                            --posY;
                        }
                        ++i;
                    }
                }
            }
            if (b.uniquename.equals("DangerZone:Pathway Forest")) {
                this.tr.addForestTrees(world, dimension, chunkx << 4, chunkz << 4);
            }
            if (b.uniquename.equals("DangerZone:Pathway Umbrella Forest")) {
                this.tr.addUmbrellaTrees(world, dimension, chunkx << 4, chunkz << 4);
            }
            if (b.uniquename.equals("DangerZone:Pathway Bulb Forest")) {
                this.tr.addBulbTrees(world, dimension, chunkx << 4, chunkz << 4);
            }
            if (b.uniquename.equals("DangerZone:Pathway Loop Forest")) {
                this.tr.addlooplowspiralTree(world, dimension, chunkx << 4, chunkz << 4);
            }
            if (b.uniquename.equals("DangerZone:Pathway Loop Forest II")) {
                this.tr.addloopTree(world, dimension, chunkx << 4, chunkz << 4);
            }
            if (world.rand.nextInt(8) == 1) {
                int howmany = 2 + world.rand.nextInt(6);
                m2 = 0;
                while (m2 < howmany) {
                    int ix = (chunkx << 4) + world.rand.nextInt(16);
                    iz2 = (chunkz << 4) + world.rand.nextInt(16);
                    int iy9 = 100;
                    while (iy9 > 50) {
                        if (world.getblock(dimension, ix, iy9, iz2) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy9 + 1, iz2) == 0) {
                            world.setblock(dimension, ix, iy9 + 1, iz2, Blocks.flower_purple.blockID);
                            break;
                        }
                        --iy9;
                    }
                    ++m2;
                }
            }
            if (world.rand.nextInt(64) == 1) {
                int howmany = 1 + world.rand.nextInt(5);
                m2 = 0;
                while (m2 < howmany) {
                    int ix = (chunkx << 4) + world.rand.nextInt(16);
                    iz2 = (chunkz << 4) + world.rand.nextInt(16);
                    int iy10 = 100;
                    while (iy10 > 50) {
                        if (world.getblock(dimension, ix, iy10, iz2) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy10 + 1, iz2) == 0) {
                            world.setblock(dimension, ix, iy10, iz2, Blocks.dirt.blockID);
                            if (world.rand.nextInt(3) != 0) {
                                world.setblock(dimension, ix, iy10 + 1, iz2, Blocks.rice_plant.blockID);
                                break;
                            }
                            world.setblock(dimension, ix, iy10 + 1, iz2, Blocks.rice_plant3.blockID);
                            break;
                        }
                        --iy10;
                    }
                    ++m2;
                }
            }
        }
        if (Dimensions.getName(dimension).equals("DangerZone: Rugged Hills Dimension")) {
            int posY3;
            int posZ;
            int i;
            if (world.rand.nextInt(18) == 1) {
                int howmany = 2 + world.rand.nextInt(6);
                m2 = 0;
                while (m2 < howmany) {
                    int ix = (chunkx << 4) + world.rand.nextInt(16);
                    iz2 = (chunkz << 4) + world.rand.nextInt(16);
                    int iy11 = 100;
                    while (iy11 > 50) {
                        if (world.getblock(dimension, ix, iy11, iz2) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy11 + 1, iz2) == 0) {
                            world.setblock(dimension, ix, iy11 + 1, iz2, Blocks.flower_purple.blockID);
                            break;
                        }
                        --iy11;
                    }
                    ++m2;
                }
            }
            if (world.rand.nextInt(100) == 1) {
                int howmany = 1 + world.rand.nextInt(5);
                m2 = 0;
                while (m2 < howmany) {
                    int ix = (chunkx << 4) + world.rand.nextInt(16);
                    iz2 = (chunkz << 4) + world.rand.nextInt(16);
                    int iy12 = 100;
                    while (iy12 > 50) {
                        if (world.getblock(dimension, ix, iy12, iz2) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy12 + 1, iz2) == 0) {
                            world.setblock(dimension, ix, iy12, iz2, Blocks.dirt.blockID);
                            if (world.rand.nextInt(3) != 0) {
                                world.setblock(dimension, ix, iy12 + 1, iz2, Blocks.rice_plant.blockID);
                                break;
                            }
                            world.setblock(dimension, ix, iy12 + 1, iz2, Blocks.rice_plant3.blockID);
                            break;
                        }
                        --iy12;
                    }
                    ++m2;
                }
            }
            int howoften = 30;
            int howmany = 1;
            if (b.uniquename.equals("DangerZone:Rugged Hills") && world.rand.nextInt(howoften) == 0) {
                int what2 = world.rand.nextInt(3);
                i = 0;
                while (i < howmany) {
                    int posX3 = (chunkx << 4) + world.rand.nextInt(16);
                    posZ = (chunkz << 4) + world.rand.nextInt(16);
                    posY3 = 90;
                    while (posY3 > 50) {
                        if (world.getblock(dimension, posX3, posY3, posZ) == 0 && world.getblock(dimension, posX3, posY3 - 1, posZ) == Blocks.grassblock.blockID) {
                            if (what2 == 0) {
                                this.tr.makeFruitTree(world, dimension, posX3, posY3 - 1, posZ, Blocks.peachleaves.blockID);
                                break;
                            }
                            if (what2 != 1) break;
                            this.tr.makeFruitTree(world, dimension, posX3, posY3 - 1, posZ, Blocks.appleleaves.blockID);
                            break;
                        }
                        --posY3;
                    }
                    ++i;
                }
            }
            if (b.uniquename.equals("DangerZone:Rugged Plains")) {
                howoften = 8;
                howmany = 1 + world.rand.nextInt(3);
                if (world.rand.nextInt(howoften) == 0) {
                    int what3 = world.rand.nextInt(3);
                    i = 0;
                    while (i < howmany) {
                        int posX4 = (chunkx << 4) + world.rand.nextInt(16);
                        posZ = (chunkz << 4) + world.rand.nextInt(16);
                        posY3 = 90;
                        while (posY3 > 50) {
                            if (world.getblock(dimension, posX4, posY3, posZ) == 0 && world.getblock(dimension, posX4, posY3 - 1, posZ) == Blocks.grassblock.blockID) {
                                if (what3 == 0) {
                                    this.tr.makeFruitTree(world, dimension, posX4, posY3 - 1, posZ, Blocks.peachleaves.blockID);
                                    break;
                                }
                                if (what3 != 1) break;
                                this.tr.makeFruitTree(world, dimension, posX4, posY3 - 1, posZ, Blocks.appleleaves.blockID);
                                break;
                            }
                            --posY3;
                        }
                        ++i;
                    }
                }
            }
            if (b.uniquename.equals("DangerZone:Rugged Plains II")) {
                howoften = 3;
                howmany = 1;
                if (world.rand.nextInt(howoften) == 0) {
                    int what4 = world.rand.nextInt(3);
                    i = 0;
                    while (i < howmany) {
                        int posX5 = (chunkx << 4) + world.rand.nextInt(16);
                        posZ = (chunkz << 4) + world.rand.nextInt(16);
                        posY3 = 90;
                        while (posY3 > 50) {
                            if (world.getblock(dimension, posX5, posY3, posZ) == 0 && world.getblock(dimension, posX5, posY3 - 1, posZ) == Blocks.grassblock.blockID) {
                                if (what4 == 0) {
                                    this.tr.bowlTree(world, dimension, posX5, posY3 - 1, posZ);
                                    break;
                                }
                                if (what4 != 1) break;
                                this.tr.doublebowlTree(world, dimension, posX5, posY3 - 1, posZ);
                                break;
                            }
                            --posY3;
                        }
                        ++i;
                    }
                }
            }
            if (b.uniquename.equals("DangerZone:Rugged Plains Desert")) {
                this.tr.addScrubTrees(world, dimension, chunkx << 4, chunkz << 4);
            }
        }
        if (Dimensions.getName(dimension).equals("DangerZone: Sky Islands Dimension")) {
            int howmany = 0;
            int howoften = 8;
            howmany = world.rand.nextInt(3);
            if (world.rand.nextInt(howoften) == 0) {
                int i = 0;
                while (i < howmany) {
                    posX = (chunkx << 4) + world.rand.nextInt(16);
                    int posZ = (chunkz << 4) + world.rand.nextInt(16);
                    posY = 220;
                    while (posY > 100) {
                        if (world.getblock(dimension, posX, posY, posZ) == 0 && world.getblock(dimension, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                            this.tr.vaseTree(world, dimension, posX, posY - 1, posZ);
                            break;
                        }
                        --posY;
                    }
                    ++i;
                }
            }
        }
    }

    public void add_cave(World world, int dimension, int chunkx, int chunkz, int recur, float mxw, float mxlen, double startx, double starty, double startz) {
        if (!DangerZone.generatecaves) {
            return;
        }
        if (recur > 2) {
            return;
        }
        if (mxw < 0.0f) {
            return;
        }
        if (mxlen < 10.0f) {
            return;
        }
        if (recur == 0 && world.rand.nextInt(32 + (chunkx & 0x3F) * 8 + (chunkz & 0x3F) * 8) != 0) {
            return;
        }
        double dxz = world.rand.nextFloat() * 360.0f;
        double dy = (world.rand.nextFloat() - world.rand.nextFloat()) * 25.0f;
        double ddxz = world.rand.nextFloat() - world.rand.nextFloat();
        double ddy = world.rand.nextFloat() - world.rand.nextFloat();
        ddxz *= 2.0;
        double width = 2.0f + world.rand.nextFloat() * mxw;
        double length = mxlen + world.rand.nextFloat() * mxlen;
        double curx = startx;
        double cury = starty;
        double curz = startz;
        int i = 0;
        while ((double)i < length) {
            double currentwidth;
            if (cury > 35.0) {
                if (dy > 0.0) {
                    dy = -dy;
                }
                if (ddy > 0.0) {
                    ddy = -ddy;
                }
            }
            if (cury < 0.0) {
                if (dy < 0.0) {
                    dy = -dy;
                }
                if (ddy < 0.0) {
                    ddy = -ddy;
                }
            }
            if (world.rand.nextInt(25) == 1) {
                this.add_cave(world, dimension, chunkx, chunkz, recur + 1, mxw - 1.0f, (float)(length / 2.0), curx, cury, curz);
            }
            if ((currentwidth = (double)((float)Math.sin((double)i / length * Math.PI)) * width) > 1.0) {
                int da = 10;
                if (currentwidth < 4.0) {
                    da = 15;
                }
                if (currentwidth > 6.0) {
                    da = 5;
                }
                double dirang = (float)Math.toRadians(dxz - 90.0);
                double dirax = (float)Math.cos(dirang);
                double diraz = (float)Math.sin(dirang);
                int j = 0;
                while (j < 360) {
                    double currad = 0.0;
                    double ty = (float)Math.sin(Math.toRadians(j));
                    double tt = (float)Math.cos(Math.toRadians(j));
                    double tx = (float)(dirax * tt);
                    double tz = (float)(diraz * tt);
                    while (currad < currentwidth) {
                        int bid;
                        if ((int)(cury + ty * (currad += (double)0.2f)) <= 0 || !Blocks.isSolid(bid = world.getblock(dimension, (int)(curx + tx * currad), (int)(cury + ty * currad), (int)(curz + tz * currad)))) continue;
                        world.setblocknonotify(dimension, (int)(curx + tx * currad), (int)(cury + ty * currad), (int)(curz + tz * currad), 0);
                    }
                    j += da;
                }
            }
            curx += Math.cos(Math.toRadians(dxz));
            curz += Math.sin(Math.toRadians(dxz));
            dxz += ddxz;
            cury += Math.sin(Math.toRadians(dy));
            dy += ddy;
            if (world.rand.nextInt(20) == 1) {
                dy = (world.rand.nextFloat() - world.rand.nextFloat()) * 25.0f;
                ddy = world.rand.nextFloat() - world.rand.nextFloat();
            }
            if (world.rand.nextInt(50) == 1) {
                dxz += (double)(world.rand.nextFloat() * 45.0f);
                ddxz = world.rand.nextFloat() - world.rand.nextFloat();
                ddxz *= 2.0;
            }
            ++i;
        }
        Thread.yield();
    }

    public void add_dungeon(World world, int dimension, int chunkx, int chunkz) {
        int bid;
        if (world.rand.nextInt(64) != 0) {
            return;
        }
        int x = chunkx << 4;
        int z = chunkz << 4;
        int width = 11;
        int xoff = world.rand.nextInt(16);
        int zoff = world.rand.nextInt(16);
        int yoff = world.rand.nextInt(40) + 5;
        if (!Blocks.isSolid(world.getblock(dimension, x + xoff, yoff - 1, z + zoff))) {
            return;
        }
        if (!Blocks.isSolid(world.getblock(dimension, x + xoff + width, yoff - 1, z + zoff))) {
            return;
        }
        if (!Blocks.isSolid(world.getblock(dimension, x + xoff, yoff - 1, z + zoff + width))) {
            return;
        }
        if (!Blocks.isSolid(world.getblock(dimension, x + xoff + width, yoff - 1, z + zoff + width))) {
            return;
        }
        int i = 0;
        while (i < width) {
            int j = 0;
            while (j < 5) {
                int k = 0;
                while (k < width) {
                    bid = 0;
                    if (i == 0 || i == 10) {
                        bid = Blocks.greystone.blockID;
                    }
                    if (j == 0 || j == 4) {
                        bid = Blocks.greystone.blockID;
                    }
                    if (k == 0 || k == 10) {
                        bid = Blocks.greystone.blockID;
                    }
                    world.setblocknonotify(dimension, x + xoff + i, yoff + j, z + zoff + k, bid);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        int type = world.rand.nextInt(4);
        bid = Blocks.ratspawner.blockID;
        if (type == 1) {
            bid = Blocks.werewolfspawner.blockID;
        }
        if (type == 2) {
            bid = Blocks.vampirespawner.blockID;
        }
        if (type == 3) {
            bid = Blocks.snarlerspawner.blockID;
        }
        world.setblock(dimension, x + xoff + 5, yoff + 1, z + zoff + 5, bid);
        Utils.add_chest(world, dimension, x + xoff + 5, yoff + 1, z + zoff + 1, things);
    }

    public void addMartianHabitat(World w, int d, int cx, int cz) {
        if (w.rand.nextInt(8) != 0) {
            return;
        }
        if ((cx & 0x3F) != 0) {
            return;
        }
        if ((cz & 0x3F) != 0) {
            return;
        }
        int iy = 100;
        while (iy > 50) {
            int bid = w.getblock(d, cx, iy, cz);
            if (bid == Blocks.stone.blockID) {
                w.setblock(d, cx, iy + 1, cz, Blocks.lightstick.blockID);
                this.buildHabitat(w, d, cx, iy, cz);
                break;
            }
            if (bid != 0) break;
            --iy;
        }
    }

    public void buildHabitat(World w, int d, int cx, int cy, int cz) {
        int level = 40 - w.rand.nextInt(20);
        int iz = 0;
        int iy = 0;
        while (cy - iy > level) {
            int j = 0;
            while (j < 3) {
                int i = 0;
                while (i < 2) {
                    w.setblock(d, cx + i, cy - iy + j, cz + iz, 0);
                    ++i;
                }
                ++j;
            }
            ++iz;
            ++iy;
        }
        this.buildBigRoom(w, d, cx, level, cz + iz + 6, false, false, false, true);
    }

    public void buildBigRoom(World w, int d, int cx, int cy, int cz, boolean fxp, boolean fxm, boolean fzp, boolean fzm) {
        int dy;
        int k;
        int width = 6;
        if (w.getblock(d, cx, cy, cz) == Blocks.chest.blockID) {
            return;
        }
        int i = -width;
        while (i <= width) {
            k = -width;
            while (k <= width) {
                int j = 0;
                while (j < 3) {
                    w.setblock(d, cx + i, cy + j, cz + k, 0);
                    ++j;
                }
                ++k;
            }
            ++i;
        }
        if (!Blocks.isSolid(w.getblock(d, cx, cy - 1, cz))) {
            return;
        }
        Utils.add_chest(w, d, cx, cy, cz, martian_things);
        i = -2;
        while (i <= 2) {
            k = -2;
            while (k <= 2) {
                if ((k == -2 || k == 2 || i == -2 || i == 2) && Blocks.isSolid(w.getblock(d, cx + i, cy - 1, cz + k))) {
                    switch (w.rand.nextInt(8)) {
                        case 0: {
                            w.setblock(d, cx + i, cy, cz + k, Blocks.workbench.blockID);
                            break;
                        }
                        case 1: {
                            w.setblock(d, cx + i, cy, cz + k, Blocks.desk.blockID);
                            break;
                        }
                        case 2: {
                            w.setblock(d, cx + i, cy, cz + k, Blocks.furnace.blockID);
                            break;
                        }
                        default: {
                            Entity e = w.createEntityByName("DangerZone:Martian", d, cx + i, cy, cz + k);
                            if (e == null) break;
                            e.init();
                            w.spawnEntityInWorld(e);
                        }
                    }
                }
                ++k;
            }
            ++i;
        }
        if (!fxp && w.rand.nextBoolean()) {
            int n = dy = w.rand.nextBoolean() ? 0 : -1;
            if (w.getblock(d, cx + 16, cy + dy * 16, cz) != 0) {
                this.buildConnection(w, d, cx + width, cy, cz, 1, dy, 0);
            }
        }
        if (!fxm && w.rand.nextBoolean()) {
            int n = dy = w.rand.nextBoolean() ? 0 : -1;
            if (w.getblock(d, cx - 16, cy + dy * 16, cz) != 0) {
                this.buildConnection(w, d, cx - width, cy, cz, -1, dy, 0);
            }
        }
        if (!fzp && w.rand.nextBoolean()) {
            int n = dy = w.rand.nextBoolean() ? 0 : -1;
            if (w.getblock(d, cx, cy + dy * 16, cz + 16) != 0) {
                this.buildConnection(w, d, cx, cy, cz + width, 0, dy, 1);
            }
        }
        if (!fzm && w.rand.nextBoolean()) {
            int n = dy = w.rand.nextBoolean() ? 0 : -1;
            if (w.getblock(d, cx, cy + dy * 16, cz - 16) != 0) {
                this.buildConnection(w, d, cx, cy, cz - width, 0, dy, -1);
            }
        }
    }

    public void buildConnection(World w, int d, int cx, int cy, int cz, int dx, int dy, int dz) {
        int ix = cx;
        int iz = cz;
        int iy = cy;
        int ddz = 0;
        int ddx = 0;
        if (dx == 0) {
            ddx = 1;
        }
        if (dz == 0) {
            ddz = 1;
        }
        int i = 0;
        while (i <= 16) {
            ix = cx + dx * i;
            iz = cz + dz * i;
            iy = cy + dy * i;
            if (iy <= 1) {
                return;
            }
            int j = 0;
            while (j < 3) {
                int k = 0;
                while (k < 2) {
                    w.setblock(d, ix + ddx * k, iy + j, iz + ddz * k, 0);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        boolean fzm = false;
        boolean fzp = false;
        boolean fxm = false;
        boolean fxp = false;
        if (dx > 0) {
            fxm = true;
        }
        if (dx < 0) {
            fxp = true;
        }
        if (dz > 0) {
            fzm = true;
        }
        if (dz < 0) {
            fzp = true;
        }
        this.buildBigRoom(w, d, ix + dx * 6, iy, iz + dz * 6, fxp, fxm, fzp, fzm);
    }
}

