/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.threads;

import dangerzone.Chunk;
import dangerzone.DangerZone;
import dangerzone.Ores;
import dangerzone.StitchedTexture;
import dangerzone.VBOBuffer;
import dangerzone.World;
import dangerzone.WorldRenderer;
import dangerzone.WorldRendererUtils;
import dangerzone.blocks.Blocks;

public class VBODataBuilderThread
implements Runnable {
    public World world = null;
    public int blockrenderwidth = 16;
    private static StitchedTexture st_last = null;
    private static VBOBuffer v_last = null;
    public static float cbr;
    public static float cbg;
    public static float cbb;
    public static float sunpostop;
    public static float sunposleft;
    public static float sunposright;
    private StitchedTexture[] rot_st = new StitchedTexture[6];
    private float[][] tcoords = new float[6][8];
    private float brightness_red;
    private float brightness_green;
    private float brightness_blue;
    private volatile boolean take_a_break = false;

    public VBODataBuilderThread(World w) {
        this.world = w;
    }

    @Override
    public void run() {
        long currtime;
        int torender = 0;
        double pi = 3.1415926545;
        float dist = 0.0f;
        float f5yaw = 0.0f;
        int avefps = 60;
        int renderclosedelta = 16;
        boolean allhere = false;
        this.brightness_blue = 0.0f;
        this.brightness_green = 0.0f;
        this.brightness_red = 0.0f;
        long lasttime = currtime = System.currentTimeMillis();
        while (DangerZone.gameover == 0) {
            torender = DangerZone.player.rotation_pitch_head < 45.0f || DangerZone.player.rotation_pitch_head > 315.0f ? DangerZone.renderdistance : DangerZone.renderdistance - 2;
            if (torender < 3) {
                torender = 3;
            }
            f5yaw = DangerZone.f5_front ? 180.0f : 0.0f;
            int pd = DangerZone.player.dimension;
            double px = DangerZone.player.posx;
            double py = DangerZone.player.posy;
            double pz = DangerZone.player.posz;
            double tod = this.world.getTimeOfDay();
            if (tod > (double)(this.world.getLengthOfDay() / 2)) {
                tod -= (double)(this.world.getLengthOfDay() / 2);
            }
            sunpostop = (float)((double)0.8f + (double)0.2f * Math.sin(Math.toRadians(360.0 * (tod /= (double)this.world.getLengthOfDay()))));
            sunposleft = (float)((double)0.8f + (double)0.2f * Math.sin(Math.toRadians(360.0 * tod + 90.0)));
            sunposright = (float)((double)0.8f + (double)0.2f * Math.sin(Math.toRadians(360.0 * tod - 90.0)));
            int i = -torender;
            while (i <= torender) {
                int j = -torender;
                while (j <= torender) {
                    block27: {
                        int should_check;
                        double rdd;
                        double rhdir;
                        double rr;
                        block28: {
                            if (!(Math.sqrt(i * i + j * j) <= (double)torender)) break block27;
                            if (Math.abs(i) <= 1 && Math.abs(j) <= 1) break block28;
                            dist = (float)Math.sqrt(i * i + j * j);
                            rr = (float)Math.atan2(j * 16, i * 16);
                            rdd = Math.abs(rr - (rhdir = Math.toRadians((this.getRotationYawHead() + f5yaw - 90.0f) % 360.0f))) % (pi * 2.0);
                            if (rdd > pi) {
                                rdd -= pi * 2.0;
                            }
                            rdd = Math.abs(rdd);
                            if ((DangerZone.player.rotation_pitch_head < 45.0f || DangerZone.player.rotation_pitch_head > 315.0f) && (dist > 8.0f && rdd > pi / 3.0 * (double)DangerZone.fieldOfView / 45.0 || dist > 4.0f && rdd > pi / 2.0 * (double)DangerZone.fieldOfView / 45.0 || dist > 1.0f && rdd > pi * 3.0 / 4.0 * (double)DangerZone.fieldOfView / 45.0 && !DangerZone.f5_front && !DangerZone.f5_back)) break block27;
                            should_check = 1;
                            if (this.world.rand.nextInt((int)(dist / 2.0f) + 2) != 0) {
                                should_check = 0;
                            }
                            this.take_a_break = false;
                            allhere = true;
                            if (!this.world.chunkcache.chunkExists(pd, (i - 1) * 16 + (int)px, 0, j * 16 + (int)pz)) {
                                this.world.chunkcache.getDecoratedChunk(pd, (i - 1) * 16 + (int)px, 0, j * 16 + (int)pz);
                                allhere = false;
                            }
                            if (!this.world.chunkcache.chunkExists(pd, (i + 1) * 16 + (int)px, 0, j * 16 + (int)pz)) {
                                this.world.chunkcache.getDecoratedChunk(pd, (i + 1) * 16 + (int)px, 0, j * 16 + (int)pz);
                                allhere = false;
                            }
                            if (!this.world.chunkcache.chunkExists(pd, i * 16 + (int)px, 0, (j - 1) * 16 + (int)pz)) {
                                this.world.chunkcache.getDecoratedChunk(pd, i * 16 + (int)px, 0, (j - 1) * 16 + (int)pz);
                                allhere = false;
                            }
                            if (!this.world.chunkcache.chunkExists(pd, i * 16 + (int)px, 0, (j + 1) * 16 + (int)pz)) {
                                this.world.chunkcache.getDecoratedChunk(pd, i * 16 + (int)px, 0, (j + 1) * 16 + (int)pz);
                                allhere = false;
                            }
                            if (allhere) {
                                if (this.renderChunk(this.world, i, j, torender, should_check, 1, pd, px, py, pz)) {
                                    this.renderChunk(this.world, i, j, torender, should_check, 2, pd, px, py, pz);
                                }
                            } else {
                                this.take_a_break = true;
                            }
                            if (this.take_a_break) {
                                try {
                                    Thread.sleep(2L);
                                    if (DangerZone.wr.fps < 40) {
                                        Thread.sleep(2L);
                                    }
                                    if (DangerZone.wr.fps < 20) {
                                        Thread.sleep(4L);
                                    }
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        if ((currtime = System.currentTimeMillis()) - lasttime > (long)renderclosedelta) {
                            lasttime = currtime;
                            int ci = -1;
                            while (ci <= 1) {
                                int cj = -1;
                                while (cj <= 1) {
                                    rr = (float)Math.atan2(cj * 16, ci * 16);
                                    rdd = Math.abs(rr - (rhdir = Math.toRadians((this.getRotationYawHead() + f5yaw - 90.0f) % 360.0f))) % (pi * 2.0);
                                    if (rdd > pi) {
                                        rdd -= pi * 2.0;
                                    }
                                    rdd = Math.abs(rdd);
                                    should_check = 1;
                                    if (this.renderChunk(this.world, ci, cj, torender, should_check, 1, pd, px, py, pz)) {
                                        this.renderChunk(this.world, ci, cj, torender, should_check, 2, pd, px, py, pz);
                                    }
                                    ++cj;
                                }
                                ++ci;
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
            if ((avefps = (avefps * 3 + DangerZone.wr.fps) / 4) < 1) {
                avefps = 1;
            }
            if (avefps > 60) {
                avefps = 60;
            }
            renderclosedelta = 2000 / avefps;
        }
    }

    private float getRotationYawHead() {
        return DangerZone.player.rotation_yaw_head;
    }

    private boolean renderChunk(World world, int xrel, int zrel, int torender, int shouldcheck, int renderlevel, int pd, double px, double py, double pz) {
        short[] leveldata = null;
        short[] levelmetadata = null;
        short[] prevleveldata = null;
        short[] nextleveldata = null;
        short[] cfrontleveldata = null;
        boolean cfrontleveldatavalid = false;
        short[] cbackleveldata = null;
        boolean cbackleveldatavalid = false;
        short[] cleftleveldata = null;
        boolean cleftleveldatavalid = false;
        short[] crightleveldata = null;
        boolean crightleveldatavalid = false;
        int starty = 0;
        float[] lightmap = null;
        boolean focused = false;
        boolean drew_something = false;
        boolean leveldatainvalid = true;
        VBOBuffer v = null;
        boolean bidSolid = false;
        int drawwidth = 8;
        boolean defective = false;
        if (DangerZone.f5_front || DangerZone.f5_back) {
            drawwidth = 16;
        }
        cbb = 0.0f;
        cbg = 0.0f;
        cbr = 0.0f;
        int xpos = xrel * 16 + (int)px;
        int zpos = zrel * 16 + (int)pz;
        int chunkX = xpos >> 4;
        int chunkZ = zpos >> 4;
        int x = chunkX * 16;
        int z = chunkZ * 16;
        float dist = (float)Math.sqrt(xrel * xrel + zrel * zrel);
        Chunk c = world.chunkcache.getDecoratedChunk(pd, xpos, 0, zpos);
        if (c == null) {
            return false;
        }
        WorldRenderer.VBOlistlock.lock();
        int itemp = 0;
        while (itemp <= 20) {
            if (c.VBOids[itemp] <= 0L) break;
            v = WorldRenderer.VBOmap.get(c.VBOids[itemp]);
            if (v != null) {
                if (v.vbostate == 2) {
                    WorldRenderer.VBOlistlock.unlock();
                    return false;
                }
            } else {
                defective = true;
            }
            ++itemp;
        }
        itemp = 0;
        while (itemp <= 20) {
            if (c.VBOids[itemp] <= 0L) break;
            v = WorldRenderer.VBOmap.get(c.VBOids[itemp]);
            if (v != null) {
                v.reset();
            } else {
                defective = true;
            }
            ++itemp;
        }
        if (defective) {
            DangerZone.wr.deleteVBOlist(c.VBOids);
            c.VBOids = new long[20];
        }
        WorldRenderer.VBOlistlock.unlock();
        if (!defective && dist > 2.0f) {
            if (c.VBOids[0] > 0L) {
                if (renderlevel < 2) {
                    if (world.rand.nextInt((int)(dist / 2.0f) + 1) != 0) {
                        return false;
                    }
                } else {
                    shouldcheck = 1;
                }
            } else {
                shouldcheck = 1;
            }
        }
        if (defective) {
            shouldcheck = 1;
        }
        st_last = null;
        v_last = null;
        int j = starty = DangerZone.mindrawlevel;
        while (j < 256) {
            this.recalcBrightness(pd, j);
            this.setVBOBrightness(0.0f);
            crightleveldatavalid = false;
            cleftleveldatavalid = false;
            cbackleveldatavalid = false;
            cfrontleveldatavalid = false;
            if (c.redraw == 0 && shouldcheck == 0 && c.drawn[j] == 0) {
                leveldatainvalid = true;
            } else {
                if (!leveldatainvalid) {
                    if (j < 255) {
                        if (j > 0) {
                            prevleveldata = leveldata;
                            leveldata = nextleveldata;
                            nextleveldata = c.blockdata[j + 1];
                        } else {
                            prevleveldata = null;
                            leveldata = c.blockdata[j];
                            nextleveldata = c.blockdata[j + 1];
                        }
                    } else {
                        prevleveldata = leveldata;
                        leveldata = nextleveldata;
                        nextleveldata = null;
                    }
                } else {
                    prevleveldata = null;
                    if (j > 0) {
                        prevleveldata = c.blockdata[j - 1];
                    }
                    leveldata = c.blockdata[j];
                    nextleveldata = null;
                    if (j < 255) {
                        nextleveldata = c.blockdata[j + 1];
                    }
                    leveldatainvalid = false;
                }
                if (leveldata == null) {
                    c.drawn[j] = 0;
                } else {
                    levelmetadata = c.metadata[j];
                    lightmap = null;
                    if (c.lightmap != null) {
                        lightmap = c.lightmap[j];
                    }
                    drew_something = false;
                    this.setVBOBrightness(0.0f);
                    int i = 0;
                    while (i < 16) {
                        int k = 0;
                        while (k < 16) {
                            short bid = leveldata[i * 16 + k];
                            if (bid > 0 && bid < 2048 && Blocks.BlockArray[bid] != null) {
                                short meta = 0;
                                if (levelmetadata != null) {
                                    meta = levelmetadata[i * 16 + k];
                                }
                                int sides = 0;
                                bidSolid = Blocks.isSolidForRender(bid);
                                if (DangerZone.all_sides || x + i > (int)px - drawwidth) {
                                    if (i > 0) {
                                        if (this.shouldRenderSide(bid, bidSolid, leveldata[(i - 1) * 16 + k])) {
                                            sides |= 1;
                                        }
                                    } else {
                                        if (!cleftleveldatavalid) {
                                            cleftleveldata = world.chunkcache.getDecoratedChunkLevelData(pd, x + i - 1, j, z + k);
                                            cleftleveldatavalid = true;
                                        }
                                        if (cleftleveldata != null) {
                                            if (this.shouldRenderSide(bid, bidSolid, cleftleveldata[(i - 1 & 0xF) * 16 + k])) {
                                                sides |= 1;
                                            }
                                        } else {
                                            sides |= 1;
                                        }
                                    }
                                }
                                if (DangerZone.all_sides || x + i < (int)px + drawwidth) {
                                    if (i < 15) {
                                        if (this.shouldRenderSide(bid, bidSolid, leveldata[(i + 1) * 16 + k])) {
                                            sides |= 2;
                                        }
                                    } else {
                                        if (!crightleveldatavalid) {
                                            crightleveldata = world.chunkcache.getDecoratedChunkLevelData(pd, x + i + 1, j, z + k);
                                            crightleveldatavalid = true;
                                        }
                                        if (crightleveldata != null) {
                                            if (this.shouldRenderSide(bid, bidSolid, crightleveldata[(i + 1 & 0xF) * 16 + k])) {
                                                sides |= 2;
                                            }
                                        } else {
                                            sides |= 2;
                                        }
                                    }
                                }
                                if (DangerZone.all_sides || z + k > (int)pz - drawwidth) {
                                    if (k > 0) {
                                        if (this.shouldRenderSide(bid, bidSolid, leveldata[i * 16 + (k - 1)])) {
                                            sides |= 4;
                                        }
                                    } else {
                                        if (!cbackleveldatavalid) {
                                            cbackleveldata = world.chunkcache.getDecoratedChunkLevelData(pd, x + i, j, z + k - 1);
                                            cbackleveldatavalid = true;
                                        }
                                        if (cbackleveldata != null) {
                                            if (this.shouldRenderSide(bid, bidSolid, cbackleveldata[i * 16 + (k - 1 & 0xF)])) {
                                                sides |= 4;
                                            }
                                        } else {
                                            sides |= 4;
                                        }
                                    }
                                }
                                if (DangerZone.all_sides || z + k < (int)pz + drawwidth) {
                                    if (k < 15) {
                                        if (this.shouldRenderSide(bid, bidSolid, leveldata[i * 16 + (k + 1)])) {
                                            sides |= 8;
                                        }
                                    } else {
                                        if (!cfrontleveldatavalid) {
                                            cfrontleveldata = world.chunkcache.getDecoratedChunkLevelData(pd, x + i, j, z + k + 1);
                                            cfrontleveldatavalid = true;
                                        }
                                        if (cfrontleveldata != null) {
                                            if (this.shouldRenderSide(bid, bidSolid, cfrontleveldata[i * 16 + (k + 1 & 0xF)])) {
                                                sides |= 8;
                                            }
                                        } else {
                                            sides |= 8;
                                        }
                                    }
                                }
                                if (DangerZone.all_sides || j > (int)py - drawwidth) {
                                    if (prevleveldata == null) {
                                        sides |= 0x10;
                                    } else if (this.shouldRenderSide(bid, bidSolid, prevleveldata[i * 16 + k])) {
                                        sides |= 0x10;
                                    }
                                }
                                if (j < 255) {
                                    if (DangerZone.all_sides || j < (int)py + drawwidth + 2) {
                                        if (nextleveldata == null) {
                                            sides |= 0x20;
                                        } else if (this.shouldRenderSide(bid, bidSolid, nextleveldata[i * 16 + k])) {
                                            sides |= 0x20;
                                        }
                                    }
                                } else {
                                    sides |= 0x20;
                                }
                                if (WorldRenderer.focus_damage != 0.0f && x + i > WorldRenderer.focus_x - 2 && x + i < WorldRenderer.focus_x + 2 && z + k > WorldRenderer.focus_z - 2 && z + k < WorldRenderer.focus_z + 2 && j > WorldRenderer.focus_y - 2 && j < WorldRenderer.focus_y + 2 && !Blocks.isLiquid(bid)) {
                                    sides = 255;
                                }
                                if (DangerZone.view_ores && dist < 4.0f && bid != Blocks.dirt.blockID && bid != Blocks.sand.blockID && Ores.isOre(bid)) {
                                    sides = 255;
                                }
                                if (Blocks.isLiquid(bid) && (nextleveldata == null || !Blocks.isLiquid(nextleveldata[i * 16 + k])) && (meta & 0xF) != 0) {
                                    sides |= 0x20;
                                }
                                if (sides != 0) {
                                    drew_something = true;
                                    focused = false;
                                    if (j == WorldRenderer.focus_y && x + i == WorldRenderer.focus_x && z + k == WorldRenderer.focus_z) {
                                        focused = true;
                                    }
                                    if (lightmap != null) {
                                        this.setVBOBrightness(lightmap[i * 16 + k]);
                                    }
                                    if (Blocks.renderAllSides(bid)) {
                                        sides = 255;
                                    }
                                    if (!focused || focused && WorldRenderer.focus_damage == 0.0f) {
                                        if (Blocks.hasOwnRenderer(bid)) {
                                            Blocks.renderMeToVBO(c.VBOids, DangerZone.wr, world, pd, x + i, j, z + k, bid, meta, sides, focused, i * this.blockrenderwidth, j * this.blockrenderwidth, k * this.blockrenderwidth);
                                        } else if (Blocks.isLiquid(bid)) {
                                            float brbr;
                                            int xcount = 1;
                                            boolean checkit = false;
                                            float brbl = brbr = (float)(meta & 0xF);
                                            float brfr = brbr;
                                            float brfl = brbr;
                                            if ((meta & 0xF) != 0) {
                                                checkit = true;
                                            }
                                            if ((sides & 0x20) == 32 && Blocks.alwaystick(bid)) {
                                                checkit = true;
                                            }
                                            if (checkit) {
                                                int xbid = world.chunkcache.getBlock(world, pd, x + i - 1, j, z + k);
                                                if (Blocks.isLiquid(xbid)) {
                                                    brfl += (float)(world.chunkcache.getBlockmeta(world, pd, x + i - 1, j, z + k) & 0xF);
                                                    ++xcount;
                                                }
                                                if (Blocks.isLiquid(xbid = world.chunkcache.getBlock(world, pd, x + i - 1, j, z + k + 1))) {
                                                    brfl += (float)(world.chunkcache.getBlockmeta(world, pd, x + i - 1, j, z + k + 1) & 0xF);
                                                    ++xcount;
                                                }
                                                if (Blocks.isLiquid(xbid = world.chunkcache.getBlock(world, pd, x + i, j, z + k + 1))) {
                                                    brfl += (float)(world.chunkcache.getBlockmeta(world, pd, x + i, j, z + k + 1) & 0xF);
                                                    ++xcount;
                                                }
                                                if ((brfl /= (float)xcount) > 15.0f) {
                                                    brfl = 15.0f;
                                                }
                                                xcount = 1;
                                                xbid = world.chunkcache.getBlock(world, pd, x + i + 1, j, z + k);
                                                if (Blocks.isLiquid(xbid)) {
                                                    brfr += (float)(world.chunkcache.getBlockmeta(world, pd, x + i + 1, j, z + k) & 0xF);
                                                    ++xcount;
                                                }
                                                if (Blocks.isLiquid(xbid = world.chunkcache.getBlock(world, pd, x + i + 1, j, z + k + 1))) {
                                                    brfr += (float)(world.chunkcache.getBlockmeta(world, pd, x + i + 1, j, z + k + 1) & 0xF);
                                                    ++xcount;
                                                }
                                                if (Blocks.isLiquid(xbid = world.chunkcache.getBlock(world, pd, x + i, j, z + k + 1))) {
                                                    brfr += (float)(world.chunkcache.getBlockmeta(world, pd, x + i, j, z + k + 1) & 0xF);
                                                    ++xcount;
                                                }
                                                if ((brfr /= (float)xcount) > 15.0f) {
                                                    brfr = 15.0f;
                                                }
                                                xcount = 1;
                                                xbid = world.chunkcache.getBlock(world, pd, x + i - 1, j, z + k);
                                                if (Blocks.isLiquid(xbid)) {
                                                    brbl += (float)(world.chunkcache.getBlockmeta(world, pd, x + i - 1, j, z + k) & 0xF);
                                                    ++xcount;
                                                }
                                                if (Blocks.isLiquid(xbid = world.chunkcache.getBlock(world, pd, x + i - 1, j, z + k - 1))) {
                                                    brbl += (float)(world.chunkcache.getBlockmeta(world, pd, x + i - 1, j, z + k - 1) & 0xF);
                                                    ++xcount;
                                                }
                                                if (Blocks.isLiquid(xbid = world.chunkcache.getBlock(world, pd, x + i, j, z + k - 1))) {
                                                    brbl += (float)(world.chunkcache.getBlockmeta(world, pd, x + i, j, z + k - 1) & 0xF);
                                                    ++xcount;
                                                }
                                                if ((brbl /= (float)xcount) > 15.0f) {
                                                    brbl = 15.0f;
                                                }
                                                xcount = 1;
                                                xbid = world.chunkcache.getBlock(world, pd, x + i + 1, j, z + k);
                                                if (Blocks.isLiquid(xbid)) {
                                                    brbr += (float)(world.chunkcache.getBlockmeta(world, pd, x + i + 1, j, z + k) & 0xF);
                                                    ++xcount;
                                                }
                                                if (Blocks.isLiquid(xbid = world.chunkcache.getBlock(world, pd, x + i + 1, j, z + k - 1))) {
                                                    brbr += (float)(world.chunkcache.getBlockmeta(world, pd, x + i + 1, j, z + k - 1) & 0xF);
                                                    ++xcount;
                                                }
                                                if (Blocks.isLiquid(xbid = world.chunkcache.getBlock(world, pd, x + i, j, z + k - 1))) {
                                                    brbr += (float)(world.chunkcache.getBlockmeta(world, pd, x + i, j, z + k - 1) & 0xF);
                                                    ++xcount;
                                                }
                                                if ((brbr /= (float)xcount) > 15.0f) {
                                                    brbr = 15.0f;
                                                }
                                                if ((brfl != 0.0f || brbl != 0.0f) && Blocks.isLiquid(world.chunkcache.getBlock(world, pd, x + i - 1, j, z + k)) && Blocks.isLiquid(world.chunkcache.getBlock(world, pd, x + i - 1, j + 1, z + k))) {
                                                    brbl = 0.0f;
                                                    brfl = 0.0f;
                                                }
                                                if ((brfr != 0.0f || brbr != 0.0f) && Blocks.isLiquid(world.chunkcache.getBlock(world, pd, x + i + 1, j, z + k)) && Blocks.isLiquid(world.chunkcache.getBlock(world, pd, x + i + 1, j + 1, z + k))) {
                                                    brbr = 0.0f;
                                                    brfr = 0.0f;
                                                }
                                                if ((brbl != 0.0f || brbr != 0.0f) && Blocks.isLiquid(world.chunkcache.getBlock(world, pd, x + i, j, z + k - 1)) && Blocks.isLiquid(world.chunkcache.getBlock(world, pd, x + i, j + 1, z + k - 1))) {
                                                    brbr = 0.0f;
                                                    brbl = 0.0f;
                                                }
                                                if ((brfl != 0.0f || brfr != 0.0f) && Blocks.isLiquid(world.chunkcache.getBlock(world, pd, x + i, j, z + k + 1)) && Blocks.isLiquid(world.chunkcache.getBlock(world, pd, x + i, j + 1, z + k + 1))) {
                                                    brfr = 0.0f;
                                                    brfl = 0.0f;
                                                }
                                                if (brfl != 0.0f && Blocks.isLiquid(world.chunkcache.getBlock(world, pd, x + i - 1, j, z + k + 1)) && Blocks.isLiquid(world.chunkcache.getBlock(world, pd, x + i - 1, j + 1, z + k + 1))) {
                                                    brfl = 0.0f;
                                                }
                                                if (brfr != 0.0f && Blocks.isLiquid(world.chunkcache.getBlock(world, pd, x + i + 1, j, z + k + 1)) && Blocks.isLiquid(world.chunkcache.getBlock(world, pd, x + i + 1, j + 1, z + k + 1))) {
                                                    brfr = 0.0f;
                                                }
                                                if (brbl != 0.0f && Blocks.isLiquid(world.chunkcache.getBlock(world, pd, x + i - 1, j, z + k - 1)) && Blocks.isLiquid(world.chunkcache.getBlock(world, pd, x + i - 1, j + 1, z + k - 1))) {
                                                    brbl = 0.0f;
                                                }
                                                if (brbr != 0.0f && Blocks.isLiquid(world.chunkcache.getBlock(world, pd, x + i + 1, j, z + k - 1)) && Blocks.isLiquid(world.chunkcache.getBlock(world, pd, x + i + 1, j + 1, z + k - 1))) {
                                                    brbr = 0.0f;
                                                }
                                                if (Blocks.isLiquid(world.chunkcache.getBlock(world, pd, x + i, j + 1, z + k))) {
                                                    brbr = 0.0f;
                                                    brbl = 0.0f;
                                                    brfr = 0.0f;
                                                    brfl = 0.0f;
                                                }
                                            }
                                            this.drawLiquidTexturedCubeToVBO(c.VBOids, sides, bid, meta, i * this.blockrenderwidth, j * this.blockrenderwidth, k * this.blockrenderwidth, brfl, brfr, brbl, brbr, Blocks.isTranslucentForRender(bid));
                                        } else {
                                            this.drawTexturedCubeToVBO(c.VBOids, sides, bid, meta, i * this.blockrenderwidth, j * this.blockrenderwidth, k * this.blockrenderwidth);
                                        }
                                    }
                                }
                            }
                            ++k;
                        }
                        ++i;
                    }
                    c.drawn[j] = drew_something ? (short)1 : 0;
                }
            }
            ++j;
        }
        c.redraw = 0;
        boolean doitagain = false;
        WorldRenderer.VBOlistlock.lock();
        itemp = 0;
        while (itemp <= 20) {
            if (c.VBOids[itemp] <= 0L) break;
            v = WorldRenderer.VBOmap.get(c.VBOids[itemp]);
            if (v != null && v.finishDraw()) {
                doitagain = true;
            }
            ++itemp;
        }
        WorldRenderer.VBOlistlock.unlock();
        if (!doitagain) {
            this.take_a_break = true;
        }
        return doitagain;
    }

    private boolean shouldRenderSide(int bid, boolean thisIsSolid, int thatbid) {
        if (thatbid == 0) {
            return true;
        }
        boolean thatIsSolid = Blocks.isSolidForRender(thatbid);
        if (thisIsSolid && thatIsSolid) {
            return false;
        }
        if (thisIsSolid && !thatIsSolid) {
            return true;
        }
        if (!thisIsSolid && !thatIsSolid && bid == thatbid) {
            return false;
        }
        if (!thisIsSolid && thatIsSolid) {
            return false;
        }
        return !Blocks.isLiquid(bid) || !Blocks.isLiquid(thatbid);
    }

    public void drawTexturedCubeToVBO(long[] chunkvbos, int sides, int bid, int meta, int xo, int yo, int zo) {
        boolean tr = Blocks.isTranslucentForRender(bid);
        if ((meta & 0xFC00) != 0) {
            this.drawRotatedTexturedCubeToVBO(chunkvbos, sides, bid, meta, xo, yo, zo, tr);
            return;
        }
        VBOBuffer v = null;
        StitchedTexture st = null;
        float brw = this.blockrenderwidth / 2;
        if (Blocks.renderSmaller(bid)) {
            brw -= 0.01f;
        }
        if ((sides & 0x20) != 0 && (v = VBODataBuilderThread.findOrMakeVBOForTexture(chunkvbos, st = VBODataBuilderThread.findVBOtextureforblockside(0, bid), tr)) != null) {
            v.addVertexInfoToVBO(brw + (float)xo, brw + (float)yo, -brw + (float)zo, st.xoffsetmax, st.yoffsetmin, cbr * sunpostop, cbg * sunpostop, cbb * sunpostop);
            v.addVertexInfoToVBO(-brw + (float)xo, brw + (float)yo, -brw + (float)zo, st.xoffsetmin, st.yoffsetmin, cbr * sunpostop, cbg * sunpostop, cbb * sunpostop);
            v.addVertexInfoToVBO(-brw + (float)xo, brw + (float)yo, brw + (float)zo, st.xoffsetmin, st.yoffsetmax, cbr * sunpostop, cbg * sunpostop, cbb * sunpostop);
            v.addVertexInfoToVBO(brw + (float)xo, brw + (float)yo, brw + (float)zo, st.xoffsetmax, st.yoffsetmax, cbr * sunpostop, cbg * sunpostop, cbb * sunpostop);
        }
        if ((sides & 0x10) != 0 && (v = VBODataBuilderThread.findOrMakeVBOForTexture(chunkvbos, st = VBODataBuilderThread.findVBOtextureforblockside(5, bid), tr)) != null) {
            v.addVertexInfoToVBO(brw + (float)xo, -brw + (float)yo, brw + (float)zo, st.xoffsetmax, st.yoffsetmin, cbr * 0.6f, cbg * 0.6f, cbb * 0.6f);
            v.addVertexInfoToVBO(-brw + (float)xo, -brw + (float)yo, brw + (float)zo, st.xoffsetmin, st.yoffsetmin, cbr * 0.6f, cbg * 0.6f, cbb * 0.6f);
            v.addVertexInfoToVBO(-brw + (float)xo, -brw + (float)yo, -brw + (float)zo, st.xoffsetmin, st.yoffsetmax, cbr * 0.6f, cbg * 0.6f, cbb * 0.6f);
            v.addVertexInfoToVBO(brw + (float)xo, -brw + (float)yo, -brw + (float)zo, st.xoffsetmax, st.yoffsetmax, cbr * 0.6f, cbg * 0.6f, cbb * 0.6f);
        }
        if ((sides & 8) != 0 && (v = VBODataBuilderThread.findOrMakeVBOForTexture(chunkvbos, st = VBODataBuilderThread.findVBOtextureforblockside(1, bid), tr)) != null) {
            v.addVertexInfoToVBO(brw + (float)xo, brw + (float)yo, brw + (float)zo, st.xoffsetmax, st.yoffsetmin, cbr * sunposleft, cbg * sunposleft, cbb * sunposleft);
            v.addVertexInfoToVBO(-brw + (float)xo, brw + (float)yo, brw + (float)zo, st.xoffsetmin, st.yoffsetmin, cbr * sunposleft, cbg * sunposleft, cbb * sunposleft);
            v.addVertexInfoToVBO(-brw + (float)xo, -brw + (float)yo, brw + (float)zo, st.xoffsetmin, st.yoffsetmax, cbr * sunposleft, cbg * sunposleft, cbb * sunposleft);
            v.addVertexInfoToVBO(brw + (float)xo, -brw + (float)yo, brw + (float)zo, st.xoffsetmax, st.yoffsetmax, cbr * sunposleft, cbg * sunposleft, cbb * sunposleft);
        }
        if ((sides & 4) != 0 && (v = VBODataBuilderThread.findOrMakeVBOForTexture(chunkvbos, st = VBODataBuilderThread.findVBOtextureforblockside(2, bid), tr)) != null) {
            v.addVertexInfoToVBO(-brw + (float)xo, brw + (float)yo, -brw + (float)zo, st.xoffsetmax, st.yoffsetmin, cbr * sunposright, cbg * sunposright, cbb * sunposright);
            v.addVertexInfoToVBO(brw + (float)xo, brw + (float)yo, -brw + (float)zo, st.xoffsetmin, st.yoffsetmin, cbr * sunposright, cbg * sunposright, cbb * sunposright);
            v.addVertexInfoToVBO(brw + (float)xo, -brw + (float)yo, -brw + (float)zo, st.xoffsetmin, st.yoffsetmax, cbr * sunposright, cbg * sunposright, cbb * sunposright);
            v.addVertexInfoToVBO(-brw + (float)xo, -brw + (float)yo, -brw + (float)zo, st.xoffsetmax, st.yoffsetmax, cbr * sunposright, cbg * sunposright, cbb * sunposright);
        }
        if ((sides & 1) != 0 && (v = VBODataBuilderThread.findOrMakeVBOForTexture(chunkvbos, st = VBODataBuilderThread.findVBOtextureforblockside(3, bid), tr)) != null) {
            v.addVertexInfoToVBO(-brw + (float)xo, brw + (float)yo, brw + (float)zo, st.xoffsetmax, st.yoffsetmin, cbr * 0.9f, cbg * 0.9f, cbb * 0.9f);
            v.addVertexInfoToVBO(-brw + (float)xo, brw + (float)yo, -brw + (float)zo, st.xoffsetmin, st.yoffsetmin, cbr * 0.9f, cbg * 0.9f, cbb * 0.9f);
            v.addVertexInfoToVBO(-brw + (float)xo, -brw + (float)yo, -brw + (float)zo, st.xoffsetmin, st.yoffsetmax, cbr * 0.9f, cbg * 0.9f, cbb * 0.9f);
            v.addVertexInfoToVBO(-brw + (float)xo, -brw + (float)yo, brw + (float)zo, st.xoffsetmax, st.yoffsetmax, cbr * 0.9f, cbg * 0.9f, cbb * 0.9f);
        }
        if ((sides & 2) != 0 && (v = VBODataBuilderThread.findOrMakeVBOForTexture(chunkvbos, st = VBODataBuilderThread.findVBOtextureforblockside(4, bid), tr)) != null) {
            v.addVertexInfoToVBO(brw + (float)xo, brw + (float)yo, -brw + (float)zo, st.xoffsetmax, st.yoffsetmin, cbr * 0.8f, cbg * 0.8f, cbb * 0.8f);
            v.addVertexInfoToVBO(brw + (float)xo, brw + (float)yo, brw + (float)zo, st.xoffsetmin, st.yoffsetmin, cbr * 0.8f, cbg * 0.8f, cbb * 0.8f);
            v.addVertexInfoToVBO(brw + (float)xo, -brw + (float)yo, brw + (float)zo, st.xoffsetmin, st.yoffsetmax, cbr * 0.8f, cbg * 0.8f, cbb * 0.8f);
            v.addVertexInfoToVBO(brw + (float)xo, -brw + (float)yo, -brw + (float)zo, st.xoffsetmax, st.yoffsetmax, cbr * 0.8f, cbg * 0.8f, cbb * 0.8f);
        }
    }

    public void drawLiquidTexturedCubeToVBO(long[] chunkvbos, int sides, int bid, int meta, int xo, int yo, int zo, float inbrfl, float inbrfr, float inbrbl, float inbrbr, boolean tr) {
        VBOBuffer v = null;
        StitchedTexture st = null;
        int brw = this.blockrenderwidth / 2;
        float brfl = (float)brw - inbrfl;
        float brfr = (float)brw - inbrfr;
        float brbl = (float)brw - inbrbl;
        float brbr = (float)brw - inbrbr;
        if ((sides & 0x20) != 0 && (v = VBODataBuilderThread.findOrMakeVBOForTexture(chunkvbos, st = VBODataBuilderThread.findVBOtextureforblockside(0, bid), tr)) != null) {
            v.addVertexInfoToVBO(brw + xo, brbr + (float)yo, -brw + zo, st.xoffsetmax, st.yoffsetmin, cbr, cbg, cbb);
            v.addVertexInfoToVBO(-brw + xo, brbl + (float)yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, cbr, cbg, cbb);
            v.addVertexInfoToVBO(-brw + xo, brfl + (float)yo, brw + zo, st.xoffsetmin, st.yoffsetmax, cbr, cbg, cbb);
            v.addVertexInfoToVBO(brw + xo, brfr + (float)yo, brw + zo, st.xoffsetmax, st.yoffsetmax, cbr, cbg, cbb);
        }
        if ((sides & 0x10) != 0 && (v = VBODataBuilderThread.findOrMakeVBOForTexture(chunkvbos, st = VBODataBuilderThread.findVBOtextureforblockside(5, bid), tr)) != null) {
            v.addVertexInfoToVBO(brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmin, cbr, cbg, cbb);
            v.addVertexInfoToVBO(-brw + xo, -brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmin, cbr, cbg, cbb);
            v.addVertexInfoToVBO(-brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, cbr, cbg, cbb);
            v.addVertexInfoToVBO(brw + xo, -brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmax, cbr, cbg, cbb);
        }
        if ((sides & 8) != 0 && (v = VBODataBuilderThread.findOrMakeVBOForTexture(chunkvbos, st = VBODataBuilderThread.findVBOtextureforblockside(1, bid), tr)) != null) {
            v.addVertexInfoToVBO(brw + xo, brfr + (float)yo, brw + zo, st.xoffsetmax, st.yoffsetmin, cbr, cbg, cbb);
            v.addVertexInfoToVBO(-brw + xo, brfl + (float)yo, brw + zo, st.xoffsetmin, st.yoffsetmin, cbr, cbg, cbb);
            v.addVertexInfoToVBO(-brw + xo, -brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmax, cbr, cbg, cbb);
            v.addVertexInfoToVBO(brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, cbr, cbg, cbb);
        }
        if ((sides & 4) != 0 && (v = VBODataBuilderThread.findOrMakeVBOForTexture(chunkvbos, st = VBODataBuilderThread.findVBOtextureforblockside(2, bid), tr)) != null) {
            v.addVertexInfoToVBO(-brw + xo, brbl + (float)yo, -brw + zo, st.xoffsetmax, st.yoffsetmin, cbr, cbg, cbb);
            v.addVertexInfoToVBO(brw + xo, brbr + (float)yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, cbr, cbg, cbb);
            v.addVertexInfoToVBO(brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, cbr, cbg, cbb);
            v.addVertexInfoToVBO(-brw + xo, -brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmax, cbr, cbg, cbb);
        }
        if ((sides & 1) != 0 && (v = VBODataBuilderThread.findOrMakeVBOForTexture(chunkvbos, st = VBODataBuilderThread.findVBOtextureforblockside(3, bid), tr)) != null) {
            v.addVertexInfoToVBO(-brw + xo, brfl + (float)yo, brw + zo, st.xoffsetmax, st.yoffsetmin, cbr, cbg, cbb);
            v.addVertexInfoToVBO(-brw + xo, brbl + (float)yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, cbr, cbg, cbb);
            v.addVertexInfoToVBO(-brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, cbr, cbg, cbb);
            v.addVertexInfoToVBO(-brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, cbr, cbg, cbb);
        }
        if ((sides & 2) != 0 && (v = VBODataBuilderThread.findOrMakeVBOForTexture(chunkvbos, st = VBODataBuilderThread.findVBOtextureforblockside(4, bid), tr)) != null) {
            v.addVertexInfoToVBO(brw + xo, brbr + (float)yo, -brw + zo, st.xoffsetmax, st.yoffsetmin, cbr, cbg, cbb);
            v.addVertexInfoToVBO(brw + xo, brfr + (float)yo, brw + zo, st.xoffsetmin, st.yoffsetmin, cbr, cbg, cbb);
            v.addVertexInfoToVBO(brw + xo, -brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmax, cbr, cbg, cbb);
            v.addVertexInfoToVBO(brw + xo, -brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmax, cbr, cbg, cbb);
        }
    }

    private void rotate90(float[] coords) {
        float tmp1 = coords[7];
        float tmp2 = coords[6];
        coords[7] = coords[5];
        coords[6] = coords[4];
        coords[5] = coords[3];
        coords[4] = coords[2];
        coords[3] = coords[1];
        coords[2] = coords[0];
        coords[1] = tmp1;
        coords[0] = tmp2;
    }

    private void rotate180(float[] coords) {
        this.rotate90(coords);
        this.rotate90(coords);
    }

    private void rotate270(float[] coords) {
        float tmp1 = coords[0];
        float tmp2 = coords[1];
        coords[0] = coords[2];
        coords[1] = coords[3];
        coords[2] = coords[4];
        coords[3] = coords[5];
        coords[4] = coords[6];
        coords[5] = coords[7];
        coords[6] = tmp1;
        coords[7] = tmp2;
    }

    public void drawRotatedTexturedCubeToVBO(long[] chunkvbos, int sides, int bid, int meta, int xo, int yo, int zo, boolean tr) {
        VBOBuffer v = null;
        int stp = 0;
        int sbm = 5;
        int sf = 1;
        int sb = 2;
        int sl = 3;
        int sr = 4;
        int tmp = 0;
        while (tmp < 6) {
            this.rot_st[tmp] = VBODataBuilderThread.findVBOtextureforblockside(tmp, bid);
            this.tcoords[tmp][0] = this.rot_st[tmp].xoffsetmax;
            this.tcoords[tmp][1] = this.rot_st[tmp].yoffsetmin;
            this.tcoords[tmp][2] = this.rot_st[tmp].xoffsetmin;
            this.tcoords[tmp][3] = this.rot_st[tmp].yoffsetmin;
            this.tcoords[tmp][4] = this.rot_st[tmp].xoffsetmin;
            this.tcoords[tmp][5] = this.rot_st[tmp].yoffsetmax;
            this.tcoords[tmp][6] = this.rot_st[tmp].xoffsetmax;
            this.tcoords[tmp][7] = this.rot_st[tmp].yoffsetmax;
            ++tmp;
        }
        if ((meta & 0xC000) == 0) {
            if ((meta & 0x3000) == 0) {
                if ((meta & 0xC00) != 0) {
                    if ((meta & 0xC00) == 1024) {
                        stp = 4;
                        sbm = 3;
                        sf = 1;
                        sb = 2;
                        sr = 5;
                        sl = 0;
                        this.rotate90(this.tcoords[1]);
                        this.rotate270(this.tcoords[2]);
                        this.rotate90(this.tcoords[0]);
                        this.rotate90(this.tcoords[5]);
                        this.rotate90(this.tcoords[3]);
                        this.rotate90(this.tcoords[4]);
                    } else if ((meta & 0xC00) == 2048) {
                        stp = 5;
                        sbm = 0;
                        sf = 1;
                        sb = 2;
                        sr = 3;
                        sl = 4;
                        this.rotate180(this.tcoords[1]);
                        this.rotate180(this.tcoords[2]);
                        this.rotate180(this.tcoords[0]);
                        this.rotate180(this.tcoords[5]);
                        this.rotate180(this.tcoords[3]);
                        this.rotate180(this.tcoords[4]);
                    } else if ((meta & 0xC00) == 3072) {
                        stp = 3;
                        sbm = 4;
                        sf = 1;
                        sb = 2;
                        sr = 0;
                        sl = 5;
                        this.rotate270(this.tcoords[1]);
                        this.rotate90(this.tcoords[2]);
                        this.rotate270(this.tcoords[0]);
                        this.rotate270(this.tcoords[5]);
                        this.rotate270(this.tcoords[3]);
                        this.rotate270(this.tcoords[4]);
                    }
                }
            } else if ((meta & 0x3000) == 4096) {
                if ((meta & 0xC00) == 0) {
                    stp = 0;
                    sbm = 5;
                    sf = 3;
                    sb = 4;
                    sr = 1;
                    sl = 2;
                    this.rotate90(this.tcoords[0]);
                    this.rotate90(this.tcoords[5]);
                } else if ((meta & 0xC00) == 1024) {
                    stp = 4;
                    sbm = 3;
                    sf = 0;
                    sb = 5;
                    sr = 1;
                    sl = 2;
                    this.rotate90(this.tcoords[1]);
                    this.rotate270(this.tcoords[2]);
                    this.rotate90(this.tcoords[0]);
                    this.rotate90(this.tcoords[5]);
                    this.rotate180(this.tcoords[4]);
                } else if ((meta & 0xC00) == 2048) {
                    stp = 5;
                    sbm = 0;
                    sf = 4;
                    sb = 3;
                    sr = 1;
                    sl = 2;
                    this.rotate180(this.tcoords[1]);
                    this.rotate180(this.tcoords[2]);
                    this.rotate90(this.tcoords[0]);
                    this.rotate270(this.tcoords[5]);
                    this.rotate180(this.tcoords[3]);
                    this.rotate180(this.tcoords[4]);
                } else if ((meta & 0xC00) == 3072) {
                    stp = 3;
                    sbm = 4;
                    sf = 5;
                    sb = 0;
                    sr = 1;
                    sl = 2;
                    this.rotate270(this.tcoords[1]);
                    this.rotate90(this.tcoords[2]);
                    this.rotate270(this.tcoords[0]);
                    this.rotate270(this.tcoords[5]);
                    this.rotate180(this.tcoords[4]);
                }
            } else if ((meta & 0x3000) == 8192) {
                if ((meta & 0xC00) == 0) {
                    stp = 0;
                    sbm = 5;
                    sf = 2;
                    sb = 1;
                    sr = 3;
                    sl = 4;
                    this.rotate180(this.tcoords[0]);
                    this.rotate180(this.tcoords[5]);
                } else if ((meta & 0xC00) == 1024) {
                    stp = 4;
                    sbm = 3;
                    sf = 2;
                    sb = 1;
                    sr = 0;
                    sl = 5;
                    this.rotate90(this.tcoords[1]);
                    this.rotate270(this.tcoords[2]);
                    this.rotate90(this.tcoords[0]);
                    this.rotate90(this.tcoords[5]);
                    this.rotate270(this.tcoords[3]);
                    this.rotate270(this.tcoords[4]);
                } else if ((meta & 0xC00) == 2048) {
                    stp = 5;
                    sbm = 0;
                    sf = 2;
                    sb = 1;
                    sr = 4;
                    sl = 3;
                    this.rotate180(this.tcoords[1]);
                    this.rotate180(this.tcoords[2]);
                    this.rotate180(this.tcoords[3]);
                    this.rotate180(this.tcoords[4]);
                } else if ((meta & 0xC00) == 3072) {
                    stp = 3;
                    sbm = 4;
                    sf = 2;
                    sb = 1;
                    sr = 5;
                    sl = 0;
                    this.rotate270(this.tcoords[1]);
                    this.rotate90(this.tcoords[2]);
                    this.rotate270(this.tcoords[0]);
                    this.rotate270(this.tcoords[5]);
                    this.rotate90(this.tcoords[3]);
                    this.rotate90(this.tcoords[4]);
                }
            } else if ((meta & 0x3000) == 12288) {
                if ((meta & 0xC00) == 0) {
                    stp = 0;
                    sbm = 5;
                    sf = 4;
                    sb = 3;
                    sr = 2;
                    sl = 1;
                    this.rotate270(this.tcoords[0]);
                    this.rotate270(this.tcoords[5]);
                } else if ((meta & 0xC00) == 1024) {
                    stp = 4;
                    sbm = 3;
                    sf = 5;
                    sb = 0;
                    sr = 2;
                    sl = 1;
                    this.rotate90(this.tcoords[0]);
                    this.rotate90(this.tcoords[1]);
                    this.rotate270(this.tcoords[2]);
                    this.rotate180(this.tcoords[3]);
                    this.rotate90(this.tcoords[5]);
                } else if ((meta & 0xC00) == 2048) {
                    stp = 5;
                    sbm = 0;
                    sf = 3;
                    sb = 4;
                    sr = 2;
                    sl = 1;
                    this.rotate270(this.tcoords[0]);
                    this.rotate180(this.tcoords[1]);
                    this.rotate180(this.tcoords[2]);
                    this.rotate180(this.tcoords[3]);
                    this.rotate180(this.tcoords[4]);
                    this.rotate90(this.tcoords[5]);
                } else if ((meta & 0xC00) == 3072) {
                    stp = 3;
                    sbm = 0;
                    sf = 0;
                    sb = 5;
                    sr = 2;
                    sl = 3;
                    this.rotate270(this.tcoords[0]);
                    this.rotate180(this.tcoords[1]);
                    this.rotate90(this.tcoords[2]);
                    this.rotate270(this.tcoords[5]);
                }
            }
        } else if ((meta & 0xC000) == 16384) {
            if ((meta & 0x3000) == 0) {
                if ((meta & 0xC00) == 0) {
                    stp = 2;
                    sbm = 1;
                    sf = 0;
                    sb = 5;
                    sr = 4;
                    sl = 3;
                    this.rotate180(this.tcoords[2]);
                    this.rotate270(this.tcoords[3]);
                    this.rotate90(this.tcoords[4]);
                    this.rotate180(this.tcoords[5]);
                } else if ((meta & 0xC00) == 1024) {
                    stp = 2;
                    sbm = 1;
                    sf = 4;
                    sb = 3;
                    sr = 5;
                    sl = 0;
                    this.rotate90(this.tcoords[1]);
                    this.rotate90(this.tcoords[2]);
                    this.rotate270(this.tcoords[3]);
                    this.rotate90(this.tcoords[4]);
                    this.rotate180(this.tcoords[5]);
                } else if ((meta & 0xC00) == 2048) {
                    stp = 2;
                    sbm = 1;
                    sf = 5;
                    sb = 0;
                    sr = 3;
                    sl = 4;
                    this.rotate180(this.tcoords[1]);
                    this.rotate270(this.tcoords[3]);
                    this.rotate90(this.tcoords[4]);
                    this.rotate180(this.tcoords[5]);
                } else if ((meta & 0xC00) == 3072) {
                    stp = 2;
                    sbm = 1;
                    sf = 3;
                    sb = 4;
                    sr = 0;
                    sl = 5;
                    this.rotate270(this.tcoords[1]);
                    this.rotate270(this.tcoords[2]);
                    this.rotate270(this.tcoords[3]);
                    this.rotate90(this.tcoords[4]);
                    this.rotate180(this.tcoords[5]);
                }
            } else if ((meta & 0x3000) == 4096) {
                if ((meta & 0xC00) == 0) {
                    stp = 4;
                    sbm = 3;
                    sf = 0;
                    sb = 5;
                    sr = 1;
                    sl = 2;
                    this.rotate90(this.tcoords[0]);
                    this.rotate90(this.tcoords[1]);
                    this.rotate270(this.tcoords[2]);
                    this.rotate180(this.tcoords[4]);
                    this.rotate90(this.tcoords[5]);
                } else if ((meta & 0xC00) == 1024) {
                    stp = 5;
                    sbm = 0;
                    sf = 4;
                    sb = 3;
                    sr = 1;
                    sl = 2;
                    this.rotate90(this.tcoords[0]);
                    this.rotate180(this.tcoords[1]);
                    this.rotate180(this.tcoords[2]);
                    this.rotate180(this.tcoords[3]);
                    this.rotate180(this.tcoords[4]);
                    this.rotate270(this.tcoords[5]);
                } else if ((meta & 0xC00) == 2048) {
                    stp = 3;
                    sbm = 4;
                    sf = 5;
                    sb = 0;
                    sr = 1;
                    sl = 2;
                    this.rotate270(this.tcoords[0]);
                    this.rotate270(this.tcoords[1]);
                    this.rotate90(this.tcoords[2]);
                    this.rotate180(this.tcoords[4]);
                    this.rotate270(this.tcoords[5]);
                } else if ((meta & 0xC00) == 3072) {
                    stp = 0;
                    sbm = 5;
                    sf = 3;
                    sb = 4;
                    sr = 1;
                    sl = 2;
                    this.rotate90(this.tcoords[0]);
                    this.rotate270(this.tcoords[5]);
                }
            } else if ((meta & 0x3000) == 8192) {
                if ((meta & 0xC00) == 0) {
                    stp = 1;
                    sbm = 2;
                    sf = 0;
                    sb = 5;
                    sr = 3;
                    sl = 4;
                    this.rotate180(this.tcoords[0]);
                    this.rotate180(this.tcoords[1]);
                    this.rotate90(this.tcoords[3]);
                    this.rotate270(this.tcoords[4]);
                } else if ((meta & 0xC00) == 1024) {
                    stp = 1;
                    sbm = 2;
                    sf = 4;
                    sb = 3;
                    sr = 0;
                    sl = 5;
                    this.rotate180(this.tcoords[0]);
                    this.rotate270(this.tcoords[1]);
                    this.rotate270(this.tcoords[2]);
                    this.rotate90(this.tcoords[3]);
                    this.rotate270(this.tcoords[4]);
                } else if ((meta & 0xC00) == 2048) {
                    stp = 1;
                    sbm = 2;
                    sf = 5;
                    sb = 0;
                    sr = 4;
                    sl = 3;
                    this.rotate180(this.tcoords[0]);
                    this.rotate180(this.tcoords[2]);
                    this.rotate90(this.tcoords[3]);
                    this.rotate270(this.tcoords[4]);
                } else if ((meta & 0xC00) == 3072) {
                    stp = 1;
                    sbm = 2;
                    sf = 3;
                    sb = 4;
                    sr = 5;
                    sl = 0;
                    this.rotate180(this.tcoords[0]);
                    this.rotate90(this.tcoords[1]);
                    this.rotate90(this.tcoords[2]);
                    this.rotate90(this.tcoords[3]);
                    this.rotate270(this.tcoords[4]);
                }
            } else if ((meta & 0x3000) == 12288) {
                if ((meta & 0xC00) == 0) {
                    stp = 3;
                    sbm = 4;
                    sf = 0;
                    sb = 5;
                    sr = 2;
                    sl = 1;
                    this.rotate270(this.tcoords[0]);
                    this.rotate270(this.tcoords[1]);
                    this.rotate90(this.tcoords[2]);
                    this.rotate180(this.tcoords[3]);
                    this.rotate270(this.tcoords[5]);
                } else if ((meta & 0xC00) == 1024) {
                    stp = 0;
                    sbm = 5;
                    sf = 4;
                    sb = 3;
                    sr = 2;
                    sl = 1;
                    this.rotate270(this.tcoords[0]);
                    this.rotate90(this.tcoords[5]);
                } else if ((meta & 0xC00) == 2048) {
                    stp = 4;
                    sbm = 3;
                    sf = 5;
                    sb = 0;
                    sr = 2;
                    sl = 1;
                    this.rotate90(this.tcoords[0]);
                    this.rotate90(this.tcoords[1]);
                    this.rotate270(this.tcoords[2]);
                    this.rotate180(this.tcoords[3]);
                    this.rotate90(this.tcoords[5]);
                } else if ((meta & 0xC00) == 3072) {
                    stp = 5;
                    sbm = 0;
                    sf = 3;
                    sb = 4;
                    sr = 2;
                    sl = 1;
                    this.rotate270(this.tcoords[0]);
                    this.rotate180(this.tcoords[1]);
                    this.rotate180(this.tcoords[2]);
                    this.rotate180(this.tcoords[3]);
                    this.rotate180(this.tcoords[4]);
                    this.rotate90(this.tcoords[5]);
                }
            }
        } else if ((meta & 0xC000) == 32768) {
            if ((meta & 0x3000) == 0) {
                if ((meta & 0xC00) == 0) {
                    stp = 5;
                    sbm = 0;
                    sf = 2;
                    sb = 1;
                    sr = 4;
                    sl = 3;
                    this.rotate180(this.tcoords[1]);
                    this.rotate180(this.tcoords[2]);
                    this.rotate180(this.tcoords[3]);
                    this.rotate180(this.tcoords[4]);
                } else if ((meta & 0xC00) == 1024) {
                    stp = 3;
                    sbm = 4;
                    sf = 2;
                    sb = 1;
                    sr = 5;
                    sl = 0;
                    this.rotate270(this.tcoords[0]);
                    this.rotate270(this.tcoords[1]);
                    this.rotate90(this.tcoords[2]);
                    this.rotate90(this.tcoords[3]);
                    this.rotate90(this.tcoords[4]);
                    this.rotate270(this.tcoords[5]);
                } else if ((meta & 0xC00) == 2048) {
                    stp = 0;
                    sbm = 5;
                    sf = 2;
                    sb = 1;
                    sr = 3;
                    sl = 4;
                    this.rotate180(this.tcoords[0]);
                    this.rotate180(this.tcoords[5]);
                } else if ((meta & 0xC00) == 3072) {
                    stp = 4;
                    sbm = 3;
                    sf = 2;
                    sb = 1;
                    sr = 0;
                    sl = 5;
                    this.rotate90(this.tcoords[0]);
                    this.rotate90(this.tcoords[1]);
                    this.rotate270(this.tcoords[2]);
                    this.rotate270(this.tcoords[3]);
                    this.rotate270(this.tcoords[4]);
                    this.rotate90(this.tcoords[5]);
                }
            } else if ((meta & 0x3000) == 4096) {
                if ((meta & 0xC00) == 0) {
                    stp = 5;
                    sbm = 0;
                    sf = 4;
                    sb = 3;
                    sr = 1;
                    sl = 2;
                    this.rotate90(this.tcoords[0]);
                    this.rotate180(this.tcoords[1]);
                    this.rotate180(this.tcoords[2]);
                    this.rotate180(this.tcoords[3]);
                    this.rotate180(this.tcoords[4]);
                    this.rotate270(this.tcoords[5]);
                } else if ((meta & 0xC00) == 1024) {
                    stp = 3;
                    sbm = 4;
                    sf = 5;
                    sb = 0;
                    sr = 1;
                    sl = 2;
                    this.rotate270(this.tcoords[0]);
                    this.rotate270(this.tcoords[1]);
                    this.rotate90(this.tcoords[2]);
                    this.rotate180(this.tcoords[4]);
                    this.rotate270(this.tcoords[5]);
                } else if ((meta & 0xC00) == 2048) {
                    stp = 0;
                    sbm = 5;
                    sf = 3;
                    sb = 4;
                    sr = 1;
                    sl = 2;
                    this.rotate90(this.tcoords[0]);
                    this.rotate270(this.tcoords[5]);
                } else if ((meta & 0xC00) == 3072) {
                    stp = 4;
                    sbm = 3;
                    sf = 0;
                    sb = 5;
                    sr = 1;
                    sl = 2;
                    this.rotate90(this.tcoords[0]);
                    this.rotate90(this.tcoords[1]);
                    this.rotate270(this.tcoords[2]);
                    this.rotate180(this.tcoords[4]);
                    this.rotate90(this.tcoords[5]);
                }
            } else if ((meta & 0x3000) == 8192) {
                if ((meta & 0xC00) == 0) {
                    stp = 5;
                    sbm = 0;
                    sf = 1;
                    sb = 2;
                    sr = 3;
                    sl = 4;
                    this.rotate180(this.tcoords[0]);
                    this.rotate180(this.tcoords[1]);
                    this.rotate180(this.tcoords[2]);
                    this.rotate180(this.tcoords[3]);
                    this.rotate180(this.tcoords[4]);
                    this.rotate180(this.tcoords[5]);
                } else if ((meta & 0xC00) == 1024) {
                    stp = 3;
                    sbm = 4;
                    sf = 1;
                    sb = 2;
                    sr = 0;
                    sl = 5;
                    this.rotate270(this.tcoords[0]);
                    this.rotate270(this.tcoords[1]);
                    this.rotate90(this.tcoords[2]);
                    this.rotate270(this.tcoords[3]);
                    this.rotate270(this.tcoords[4]);
                    this.rotate270(this.tcoords[5]);
                } else if ((meta & 0xC00) == 2048) {
                    stp = 0;
                    sbm = 5;
                    sf = 1;
                    sb = 2;
                    sr = 4;
                    sl = 3;
                } else if ((meta & 0xC00) == 3072) {
                    stp = 4;
                    sbm = 3;
                    sf = 1;
                    sb = 2;
                    sr = 5;
                    sl = 0;
                    this.rotate90(this.tcoords[0]);
                    this.rotate90(this.tcoords[1]);
                    this.rotate270(this.tcoords[2]);
                    this.rotate90(this.tcoords[3]);
                    this.rotate90(this.tcoords[4]);
                    this.rotate90(this.tcoords[5]);
                }
            } else if ((meta & 0x3000) == 12288) {
                if ((meta & 0xC00) == 0) {
                    stp = 5;
                    sbm = 0;
                    sf = 3;
                    sb = 4;
                    sr = 2;
                    sl = 1;
                    this.rotate270(this.tcoords[0]);
                    this.rotate180(this.tcoords[1]);
                    this.rotate180(this.tcoords[2]);
                    this.rotate180(this.tcoords[3]);
                    this.rotate180(this.tcoords[4]);
                    this.rotate90(this.tcoords[5]);
                } else if ((meta & 0xC00) == 1024) {
                    stp = 3;
                    sbm = 4;
                    sf = 0;
                    sb = 5;
                    sr = 2;
                    sl = 1;
                    this.rotate270(this.tcoords[0]);
                    this.rotate270(this.tcoords[1]);
                    this.rotate90(this.tcoords[2]);
                    this.rotate180(this.tcoords[3]);
                    this.rotate270(this.tcoords[5]);
                } else if ((meta & 0xC00) == 2048) {
                    stp = 0;
                    sbm = 5;
                    sf = 4;
                    sb = 3;
                    sr = 2;
                    sl = 1;
                    this.rotate270(this.tcoords[0]);
                    this.rotate90(this.tcoords[5]);
                } else if ((meta & 0xC00) == 3072) {
                    stp = 4;
                    sbm = 3;
                    sf = 5;
                    sb = 0;
                    sr = 2;
                    sl = 1;
                    this.rotate90(this.tcoords[0]);
                    this.rotate90(this.tcoords[1]);
                    this.rotate270(this.tcoords[2]);
                    this.rotate180(this.tcoords[3]);
                    this.rotate90(this.tcoords[5]);
                }
            }
        } else if ((meta & 0xC000) == 49152) {
            if ((meta & 0x3000) == 0) {
                if ((meta & 0xC00) == 0) {
                    stp = 1;
                    sbm = 2;
                    sf = 5;
                    sb = 0;
                    sr = 4;
                    sl = 3;
                    this.rotate180(this.tcoords[0]);
                    this.rotate180(this.tcoords[2]);
                    this.rotate90(this.tcoords[3]);
                    this.rotate270(this.tcoords[4]);
                } else if ((meta & 0xC00) == 1024) {
                    stp = 1;
                    sbm = 2;
                    sf = 3;
                    sb = 4;
                    sr = 5;
                    sl = 0;
                    this.rotate180(this.tcoords[0]);
                    this.rotate90(this.tcoords[1]);
                    this.rotate90(this.tcoords[2]);
                    this.rotate90(this.tcoords[3]);
                    this.rotate270(this.tcoords[4]);
                } else if ((meta & 0xC00) == 2048) {
                    stp = 1;
                    sbm = 2;
                    sf = 0;
                    sb = 5;
                    sr = 3;
                    sl = 4;
                    this.rotate180(this.tcoords[0]);
                    this.rotate180(this.tcoords[1]);
                    this.rotate90(this.tcoords[3]);
                    this.rotate270(this.tcoords[4]);
                } else if ((meta & 0xC00) == 3072) {
                    stp = 1;
                    sbm = 2;
                    sf = 4;
                    sb = 3;
                    sr = 0;
                    sl = 5;
                    this.rotate180(this.tcoords[0]);
                    this.rotate270(this.tcoords[1]);
                    this.rotate270(this.tcoords[2]);
                    this.rotate90(this.tcoords[3]);
                    this.rotate270(this.tcoords[4]);
                }
            } else if ((meta & 0x3000) == 4096) {
                if ((meta & 0xC00) == 0) {
                    stp = 3;
                    sbm = 4;
                    sf = 5;
                    sb = 0;
                    sr = 1;
                    sl = 2;
                    this.rotate270(this.tcoords[0]);
                    this.rotate270(this.tcoords[1]);
                    this.rotate90(this.tcoords[2]);
                    this.rotate180(this.tcoords[4]);
                    this.rotate270(this.tcoords[5]);
                } else if ((meta & 0xC00) == 1024) {
                    stp = 0;
                    sbm = 5;
                    sf = 3;
                    sb = 4;
                    sr = 1;
                    sl = 2;
                    this.rotate90(this.tcoords[0]);
                    this.rotate270(this.tcoords[5]);
                } else if ((meta & 0xC00) == 2048) {
                    stp = 4;
                    sbm = 3;
                    sf = 0;
                    sb = 5;
                    sr = 1;
                    sl = 2;
                    this.rotate90(this.tcoords[0]);
                    this.rotate90(this.tcoords[1]);
                    this.rotate270(this.tcoords[2]);
                    this.rotate180(this.tcoords[4]);
                    this.rotate90(this.tcoords[5]);
                } else if ((meta & 0xC00) == 3072) {
                    stp = 5;
                    sbm = 0;
                    sf = 4;
                    sb = 3;
                    sr = 1;
                    sl = 2;
                    this.rotate90(this.tcoords[0]);
                    this.rotate180(this.tcoords[1]);
                    this.rotate180(this.tcoords[2]);
                    this.rotate180(this.tcoords[3]);
                    this.rotate180(this.tcoords[4]);
                    this.rotate270(this.tcoords[5]);
                }
            } else if ((meta & 0x3000) == 8192) {
                if ((meta & 0xC00) == 0) {
                    stp = 2;
                    sbm = 1;
                    sf = 5;
                    sb = 0;
                    sr = 3;
                    sl = 4;
                    this.rotate180(this.tcoords[1]);
                    this.rotate270(this.tcoords[3]);
                    this.rotate90(this.tcoords[4]);
                    this.rotate180(this.tcoords[5]);
                } else if ((meta & 0xC00) == 1024) {
                    stp = 2;
                    sbm = 1;
                    sf = 3;
                    sb = 4;
                    sr = 0;
                    sl = 5;
                    this.rotate270(this.tcoords[1]);
                    this.rotate270(this.tcoords[2]);
                    this.rotate270(this.tcoords[3]);
                    this.rotate90(this.tcoords[4]);
                    this.rotate180(this.tcoords[5]);
                } else if ((meta & 0xC00) == 2048) {
                    stp = 2;
                    sbm = 1;
                    sf = 0;
                    sb = 5;
                    sr = 4;
                    sl = 3;
                    this.rotate180(this.tcoords[2]);
                    this.rotate270(this.tcoords[3]);
                    this.rotate90(this.tcoords[4]);
                    this.rotate180(this.tcoords[5]);
                } else if ((meta & 0xC00) == 3072) {
                    stp = 2;
                    sbm = 1;
                    sf = 4;
                    sb = 3;
                    sr = 5;
                    sl = 0;
                    this.rotate90(this.tcoords[1]);
                    this.rotate90(this.tcoords[2]);
                    this.rotate270(this.tcoords[3]);
                    this.rotate90(this.tcoords[4]);
                    this.rotate180(this.tcoords[5]);
                }
            } else if ((meta & 0x3000) == 12288) {
                if ((meta & 0xC00) == 0) {
                    stp = 4;
                    sbm = 3;
                    sf = 5;
                    sb = 0;
                    sr = 2;
                    sl = 1;
                    this.rotate90(this.tcoords[0]);
                    this.rotate90(this.tcoords[1]);
                    this.rotate270(this.tcoords[2]);
                    this.rotate180(this.tcoords[3]);
                    this.rotate90(this.tcoords[5]);
                } else if ((meta & 0xC00) == 1024) {
                    stp = 5;
                    sbm = 0;
                    sf = 3;
                    sb = 4;
                    sr = 2;
                    sl = 1;
                    this.rotate270(this.tcoords[0]);
                    this.rotate180(this.tcoords[1]);
                    this.rotate180(this.tcoords[2]);
                    this.rotate180(this.tcoords[3]);
                    this.rotate180(this.tcoords[4]);
                    this.rotate90(this.tcoords[5]);
                } else if ((meta & 0xC00) == 2048) {
                    stp = 3;
                    sbm = 4;
                    sf = 0;
                    sb = 5;
                    sr = 2;
                    sl = 1;
                    this.rotate270(this.tcoords[0]);
                    this.rotate270(this.tcoords[1]);
                    this.rotate90(this.tcoords[2]);
                    this.rotate180(this.tcoords[3]);
                    this.rotate270(this.tcoords[5]);
                } else if ((meta & 0xC00) == 3072) {
                    stp = 0;
                    sbm = 5;
                    sf = 4;
                    sb = 3;
                    sr = 2;
                    sl = 1;
                    this.rotate270(this.tcoords[0]);
                    this.rotate90(this.tcoords[5]);
                }
            }
        }
        float brw = this.blockrenderwidth / 2;
        if (Blocks.renderSmaller(bid)) {
            brw -= 0.01f;
        }
        if ((sides & 0x20) != 0 && (v = VBODataBuilderThread.findOrMakeVBOForTexture(chunkvbos, this.rot_st[stp], tr)) != null) {
            v.addVertexInfoToVBO(brw + (float)xo, brw + (float)yo, -brw + (float)zo, this.tcoords[stp][0], this.tcoords[stp][1], cbr * sunpostop, cbg * sunpostop, cbb * sunpostop);
            v.addVertexInfoToVBO(-brw + (float)xo, brw + (float)yo, -brw + (float)zo, this.tcoords[stp][2], this.tcoords[stp][3], cbr * sunpostop, cbg * sunpostop, cbb * sunpostop);
            v.addVertexInfoToVBO(-brw + (float)xo, brw + (float)yo, brw + (float)zo, this.tcoords[stp][4], this.tcoords[stp][5], cbr * sunpostop, cbg * sunpostop, cbb * sunpostop);
            v.addVertexInfoToVBO(brw + (float)xo, brw + (float)yo, brw + (float)zo, this.tcoords[stp][6], this.tcoords[stp][7], cbr * sunpostop, cbg * sunpostop, cbb * sunpostop);
        }
        if ((sides & 0x10) != 0 && (v = VBODataBuilderThread.findOrMakeVBOForTexture(chunkvbos, this.rot_st[sbm], tr)) != null) {
            v.addVertexInfoToVBO(brw + (float)xo, -brw + (float)yo, brw + (float)zo, this.tcoords[sbm][0], this.tcoords[sbm][1], cbr * 0.6f, cbg * 0.6f, cbb * 0.6f);
            v.addVertexInfoToVBO(-brw + (float)xo, -brw + (float)yo, brw + (float)zo, this.tcoords[sbm][2], this.tcoords[sbm][3], cbr * 0.6f, cbg * 0.6f, cbb * 0.6f);
            v.addVertexInfoToVBO(-brw + (float)xo, -brw + (float)yo, -brw + (float)zo, this.tcoords[sbm][4], this.tcoords[sbm][5], cbr * 0.6f, cbg * 0.6f, cbb * 0.6f);
            v.addVertexInfoToVBO(brw + (float)xo, -brw + (float)yo, -brw + (float)zo, this.tcoords[sbm][6], this.tcoords[sbm][7], cbr * 0.6f, cbg * 0.6f, cbb * 0.6f);
        }
        if ((sides & 8) != 0 && (v = VBODataBuilderThread.findOrMakeVBOForTexture(chunkvbos, this.rot_st[sf], tr)) != null) {
            v.addVertexInfoToVBO(brw + (float)xo, brw + (float)yo, brw + (float)zo, this.tcoords[sf][0], this.tcoords[sf][1], cbr * sunposleft, cbg * sunposleft, cbb * sunposleft);
            v.addVertexInfoToVBO(-brw + (float)xo, brw + (float)yo, brw + (float)zo, this.tcoords[sf][2], this.tcoords[sf][3], cbr * sunposleft, cbg * sunposleft, cbb * sunposleft);
            v.addVertexInfoToVBO(-brw + (float)xo, -brw + (float)yo, brw + (float)zo, this.tcoords[sf][4], this.tcoords[sf][5], cbr * sunposleft, cbg * sunposleft, cbb * sunposleft);
            v.addVertexInfoToVBO(brw + (float)xo, -brw + (float)yo, brw + (float)zo, this.tcoords[sf][6], this.tcoords[sf][7], cbr * sunposleft, cbg * sunposleft, cbb * sunposleft);
        }
        if ((sides & 4) != 0 && (v = VBODataBuilderThread.findOrMakeVBOForTexture(chunkvbos, this.rot_st[sb], tr)) != null) {
            v.addVertexInfoToVBO(-brw + (float)xo, brw + (float)yo, -brw + (float)zo, this.tcoords[sb][0], this.tcoords[sb][1], cbr * sunposright, cbg * sunposright, cbb * sunposright);
            v.addVertexInfoToVBO(brw + (float)xo, brw + (float)yo, -brw + (float)zo, this.tcoords[sb][2], this.tcoords[sb][3], cbr * sunposright, cbg * sunposright, cbb * sunposright);
            v.addVertexInfoToVBO(brw + (float)xo, -brw + (float)yo, -brw + (float)zo, this.tcoords[sb][4], this.tcoords[sb][5], cbr * sunposright, cbg * sunposright, cbb * sunposright);
            v.addVertexInfoToVBO(-brw + (float)xo, -brw + (float)yo, -brw + (float)zo, this.tcoords[sb][6], this.tcoords[sb][7], cbr * sunposright, cbg * sunposright, cbb * sunposright);
        }
        if ((sides & 1) != 0 && (v = VBODataBuilderThread.findOrMakeVBOForTexture(chunkvbos, this.rot_st[sl], tr)) != null) {
            v.addVertexInfoToVBO(-brw + (float)xo, brw + (float)yo, brw + (float)zo, this.tcoords[sl][0], this.tcoords[sl][1], cbr * 0.9f, cbg * 0.9f, cbb * 0.9f);
            v.addVertexInfoToVBO(-brw + (float)xo, brw + (float)yo, -brw + (float)zo, this.tcoords[sl][2], this.tcoords[sl][3], cbr * 0.9f, cbg * 0.9f, cbb * 0.9f);
            v.addVertexInfoToVBO(-brw + (float)xo, -brw + (float)yo, -brw + (float)zo, this.tcoords[sl][4], this.tcoords[sl][5], cbr * 0.9f, cbg * 0.9f, cbb * 0.9f);
            v.addVertexInfoToVBO(-brw + (float)xo, -brw + (float)yo, brw + (float)zo, this.tcoords[sl][6], this.tcoords[sl][7], cbr * 0.9f, cbg * 0.9f, cbb * 0.9f);
        }
        if ((sides & 2) != 0 && (v = VBODataBuilderThread.findOrMakeVBOForTexture(chunkvbos, this.rot_st[sr], tr)) != null) {
            v.addVertexInfoToVBO(brw + (float)xo, brw + (float)yo, -brw + (float)zo, this.tcoords[sr][0], this.tcoords[sr][1], cbr * 0.8f, cbg * 0.8f, cbb * 0.8f);
            v.addVertexInfoToVBO(brw + (float)xo, brw + (float)yo, brw + (float)zo, this.tcoords[sr][2], this.tcoords[sr][3], cbr * 0.8f, cbg * 0.8f, cbb * 0.8f);
            v.addVertexInfoToVBO(brw + (float)xo, -brw + (float)yo, brw + (float)zo, this.tcoords[sr][4], this.tcoords[sr][5], cbr * 0.8f, cbg * 0.8f, cbb * 0.8f);
            v.addVertexInfoToVBO(brw + (float)xo, -brw + (float)yo, -brw + (float)zo, this.tcoords[sr][6], this.tcoords[sr][7], cbr * 0.8f, cbg * 0.8f, cbb * 0.8f);
        }
    }

    public static VBOBuffer findOrMakeVBOForTexture(long[] cvs, StitchedTexture st, boolean translucent) {
        if (st == st_last && v_last != null && VBODataBuilderThread.v_last.isTranslucent == translucent) {
            return v_last;
        }
        VBOBuffer v = null;
        WorldRenderer.VBOlistlock.lock();
        int i = 0;
        while (i < 20) {
            if (cvs[i] <= 0L) break;
            v = WorldRenderer.VBOmap.get(cvs[i]);
            if (v != null && v.textureindex == st.texturesindex && translucent == v.isTranslucent) {
                v_last = v;
                st_last = st;
                WorldRenderer.VBOlistlock.unlock();
                return v;
            }
            ++i;
        }
        v = new VBOBuffer();
        v.textureindex = st.texturesindex;
        v.VBOid = WorldRenderer.getNextVBOid();
        v.isTranslucent = translucent;
        WorldRenderer.VBOmap.put(v.VBOid, v);
        ++WorldRenderer.vbocount;
        cvs[i] = v.VBOid;
        v_last = v;
        st_last = st;
        WorldRenderer.VBOlistlock.unlock();
        return v;
    }

    public static StitchedTexture findVBOtextureforblockside(int side, int bid) {
        StitchedTexture st = Blocks.BlockArray[bid].getStitchedTexture(side);
        if (st.texturesindex < 0) {
            DangerZone.wr.oneblock = bid;
            while (DangerZone.wr.oneblock >= 0) {
                Thread.yield();
            }
        }
        return st;
    }

    private void setVBOBrightness(float m) {
        float flb;
        float flg;
        float flr = this.brightness_red + m;
        if (flr < 0.0f) {
            flr = 0.0f;
        }
        if (flr > 1.0f) {
            flr = 1.0f;
        }
        if ((flg = this.brightness_green + m) < 0.0f) {
            flg = 0.0f;
        }
        if (flg > 1.0f) {
            flg = 1.0f;
        }
        if ((flb = this.brightness_blue + m) < 0.0f) {
            flb = 0.0f;
        }
        if (flb > 1.0f) {
            flb = 1.0f;
        }
        cbr = flr;
        cbg = flg;
        cbb = flb;
    }

    private void recalcBrightness(int d, int yp) {
        float f = WorldRendererUtils.getBrightnessForLevel(d, yp);
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        this.brightness_green = this.brightness_blue = f;
        this.brightness_red = this.brightness_blue;
    }
}

