/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.items;

import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Item;

public class ItemFireStick
extends Item {
    public ItemFireStick(String name, String tx) {
        super(name, tx);
        this.maxstack = 16;
        this.brightness = 0.65f;
    }

    @Override
    public boolean onLeftClick(Entity holder, Entity clickedon, InventoryContainer ic) {
        if (holder != null && clickedon != null && holder.world.isServer && clickedon instanceof EntityLiving) {
            clickedon.doSetOnFire(100);
            clickedon.doAttackFrom(holder, 10, 1.0f);
        }
        return true;
    }

    @Override
    public boolean onRightClick(Entity holder, Entity clickedon, InventoryContainer ic) {
        if (holder != null && clickedon != null && holder.world.isServer && clickedon instanceof EntityLiving) {
            clickedon.setOnFire(100);
            clickedon.doAttackFrom(holder, 10, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public boolean rightClickOnBlock(Player p, int dimension, int x, int y, int z, int side) {
        Entity eb;
        if (p != null && !p.world.isServer && (eb = p.world.createEntityByName("DangerZone:Fire", dimension, (double)x + 0.5, (double)y - 0.0625, (double)z + 0.5)) != null) {
            eb.init();
            p.world.spawnEntityInWorld(eb);
        }
        return true;
    }
}

