/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.items;

import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlock;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Item;

public class ItemDropStick
extends Item {
    public ItemDropStick(String name, String tx) {
        super(name, tx);
        this.maxstack = 16;
        this.brightness = 0.55f;
    }

    @Override
    public boolean onLeftClick(Entity holder, Entity clickedon, InventoryContainer ic) {
        if (holder != null && clickedon != null && holder.world.isServer && clickedon instanceof EntityLiving) {
            clickedon.doSetOnFire(10);
            clickedon.doAttackFrom(holder, 10, 1.0f);
        }
        return true;
    }

    @Override
    public boolean onRightClick(Entity holder, Entity clickedon, InventoryContainer ic) {
        if (holder != null && clickedon != null && holder.world.isServer && clickedon instanceof EntityLiving) {
            clickedon.setOnFire(10);
            clickedon.doAttackFrom(holder, 10, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public boolean rightClickOnBlock(Player p, int dimension, int x, int y, int z, int side) {
        int bid;
        if (p != null && !p.world.isServer && (bid = p.world.getblock(dimension, x, y, z)) != 0 && p.world.getblock(dimension, x, y - 1, z) == 0) {
            int meta = p.world.getblockmeta(dimension, x, y, z);
            EntityBlock eb = (EntityBlock)p.world.createEntityByName("DangerZone:EntityBlock", dimension, (double)x + 0.5 + (double)((p.world.rand.nextFloat() - p.world.rand.nextFloat()) * 0.01f), y, (double)z + 0.5 + (double)((p.world.rand.nextFloat() - p.world.rand.nextFloat()) * 0.01f));
            if (eb != null) {
                eb.init();
                p.world.setblock(dimension, x, y, z, 0);
                eb.rotation_roll = 0.0f;
                eb.rotation_yaw = 0.0f;
                eb.rotation_pitch = 0.0f;
                eb.rotation_roll_motion = 0.0f;
                eb.rotation_yaw_motion = 0.0f;
                eb.rotation_pitch_motion = 0.0f;
                eb.setBID(bid);
                eb.setIID(meta);
                p.world.spawnEntityInWorld(eb);
            }
        }
        return true;
    }
}

