/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class Werewolf
extends EntityLiving {
    public Werewolf(World w) {
        super(w);
        this.width = 0.75f;
        this.height = 1.75f;
        this.uniquename = "DangerZone:Werewolf";
        this.has_inventory = true;
        this.attackRange = 3.0f;
        this.setMaxHealth(40.0f);
        this.setHealth(40.0f);
        this.setExperience(50);
        this.setDefense(1.5f);
        this.setAttackDamage(5.0f);
        this.setMaxAir(40.0f);
        this.setAir(40.0f);
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = false;
    }

    @Override
    public void init() {
        super.init();
        if (this.world != null && this.world.isServer && this.getInitialized() == 0) {
            this.setInitialized(1);
            if (this.world.rand.nextInt(6) == 0) {
                int wt = this.world.rand.nextInt(4);
                int itd = 0;
                InventoryContainer ic = new InventoryContainer();
                if (wt == 0) {
                    itd = Items.stoneaxe.itemID;
                }
                if (wt == 1) {
                    itd = Items.woodenaxe.itemID;
                }
                if (wt == 2) {
                    itd = Items.stonesword.itemID;
                }
                if (wt == 3) {
                    itd = Items.woodensword.itemID;
                }
                ic.iid = itd;
                ic.count = 1;
                ic.currentuses = this.world.rand.nextInt(ic.getItem().maxuses);
                this.setHotbar(0, ic);
                this.sethotbarindex(0);
            }
        }
    }

    @Override
    public void jump() {
        if (this.getInLiquid() && this.canSwim && Blocks.isLiquid(this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy + (double)(this.height * 3.0f / 4.0f) + (double)this.swimoffset), (int)this.posz)) && this.world.rand.nextInt(2) == 0) {
            this.motiony += 0.155f;
            if (this.isSolidAtLevel(this.dimension, this.posx, this.posy - (double)0.35f, this.posz)) {
                this.motiony += 0.55f;
            }
        }
        if (!this.isSolidAtLevel(this.dimension, this.posx, this.posy - (double)0.1f, this.posz)) {
            return;
        }
        if (Math.abs(this.motiony) > 0.15f) {
            return;
        }
        this.motiony += (0.75f + 0.15f * this.height) * 2.0f;
    }

    @Override
    public void moveTowardsTarget(float deltaT) {
        super.moveTowardsTarget(deltaT);
        if (this.target != null && this.target.te != null && this.world.rand.nextInt(20) == 0) {
            this.jump();
        }
    }

    @Override
    public String getLivingSound() {
        if (this.world.rand.nextInt(5) != 0) {
            return null;
        }
        return "DangerZone:werewolf_living";
    }

    @Override
    public float getAdjustedFallDamage(float ouch) {
        float damage = ouch / 2.0f;
        if (damage < 3.0f) {
            damage = 0.0f;
        }
        return damage;
    }

    @Override
    public String getHurtSound() {
        return "DangerZone:anteater_hit";
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:werewolf_death";
    }

    @Override
    public String getAttackSound() {
        return "DangerZone:werewolf_attack";
    }

    @Override
    public void doDeathDrops() {
        super.doDeathDrops();
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand(this.world, 0, Items.trophywerewolf.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        int howmany = 5 + this.world.rand.nextInt(5);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.furball.itemID, 3.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/werewolf.png");
        }
        return this.texture;
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Werewolf) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }
}

