/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlockItem;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;

public class ThrownBlockItem
extends Entity {
    public int deathtimer = 300;
    public Entity thrower = null;
    public Entity thrower2 = null;
    public float spz = 0.0f;
    public float spzoff = 0.0f;

    public ThrownBlockItem(World w) {
        super(w);
        this.maxrenderdist = 50;
        this.height = 0.25f;
        this.width = 0.25f;
        this.uniquename = "DangerZone:ThrownBlockItem";
        this.movement_friction = false;
        if (w != null) {
            this.rotation_pitch = w.rand.nextInt(360);
            this.rotation_yaw = w.rand.nextInt(360);
            this.rotation_roll = w.rand.nextInt(360);
        }
        this.setAttackDamage(0.1f);
        this.spzoff = DangerZone.rand.nextFloat() * 12.0f;
        this.spzoff += 9.0f;
        this.spzoff = -this.spzoff;
    }

    @Override
    public void writeSelf(Properties prop, String tag) {
        super.writeSelf(prop, tag);
        prop.setProperty(String.format("%s%s", tag, "DEATHTIMER"), String.format("%d", this.deathtimer));
    }

    @Override
    public void readSelf(Properties prop, String tag) {
        super.readSelf(prop, tag);
        this.deathtimer = Utils.getPropertyInt(prop, String.format("%s%s", tag, "DEATHTIMER"), 0, 32768, 600);
    }

    public void setDirectionAndVelocity(float x, float y, float z, float velocity, float variability) {
        this.motionx = x * (velocity + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * variability * velocity);
        this.motiony = y * (velocity + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * variability * velocity);
        this.motionz = z * (velocity + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * variability * velocity);
    }

    @Override
    public void update(float deltaT) {
        this.rotation_pitch_motion = 0.0f;
        this.rotation_yaw_motion = 0.0f;
        this.rotation_roll_motion = 0.0f;
        if (this.world.isServer) {
            this.motiony -= 0.16f * deltaT;
            float dist = (float)Math.sqrt(this.motionx * deltaT * this.motionx * deltaT + this.motiony * deltaT * this.motiony * deltaT + this.motionz * deltaT * this.motionz * deltaT);
            float blockdist = 0.0f;
            float edist = 0.0f;
            boolean hitblock = false;
            boolean hitentity = false;
            List<Entity> nearby_list = null;
            Entity enthit = null;
            Entity ridden = null;
            nearby_list = DangerZone.server.entityManager.findEntitiesInRange(16.0f + dist, this.dimension, this.posx, this.posy, this.posz);
            int lz = 0;
            int ly = 0;
            int lx = 0;
            double fx = this.posx;
            double fy = this.posy;
            double fz = this.posz;
            if (this.thrower != null && (ridden = this.thrower.getRiddenEntity()) == null) {
                ridden = this.thrower.getRiderEntity();
            }
            while (dist > 0.0f && blockdist < dist) {
                fx = this.posx + (double)(this.motionx * deltaT * blockdist / dist);
                fy = this.posy + (double)(this.motiony * deltaT * blockdist / dist);
                fz = this.posz + (double)(this.motionz * deltaT * blockdist / dist);
                int x = (int)fx;
                int y = (int)fy;
                int z = (int)fz;
                ListIterator<Entity> li = nearby_list.listIterator();
                while (li.hasNext()) {
                    enthit = li.next();
                    if (enthit == this || enthit.canthitme || enthit == this.thrower || enthit == ridden || enthit == this.thrower2 || !(fy > enthit.posy) || !(fy < enthit.posy + (double)enthit.getHeight())) continue;
                    edist = (float)enthit.getHorizontalDistanceFromEntity(fx, fz);
                    edist -= this.getWidth() / 2.0f;
                    if (!((edist -= enthit.getWidth() / 2.0f) < 0.0f)) continue;
                    hitentity = true;
                    break;
                }
                if (hitentity) break;
                if (x != lx || y != ly || z != lz) {
                    lx = x;
                    ly = y;
                    lz = z;
                    int bid = this.world.getblock(this.dimension, x, y, z);
                    if (bid != 0) {
                        hitblock = true;
                        break;
                    }
                }
                this.doSpecialEffects(fx, fy, fz);
                blockdist += 0.1f;
            }
            if (hitentity || hitblock) {
                this.motionx = this.motionx * deltaT * blockdist / dist;
                this.motiony = this.motiony * deltaT * blockdist / dist;
                this.motionz = this.motionz * deltaT * blockdist / dist;
                this.doHitSomething(hitblock, fx, fy, fz, hitentity, hitentity ? enthit : null);
                this.deadflag = true;
                return;
            }
            --this.deathtimer;
            if (this.deathtimer <= 0) {
                this.deadflag = true;
                return;
            }
        } else {
            this.rotateFlatToPlayer();
        }
        super.update(deltaT);
    }

    public void doSpecialEffects(double x, double y, double z) {
    }

    public void rotateFlatToPlayer() {
        float tdir = (float)Math.atan2(DangerZone.player.posx - this.posx, DangerZone.player.posz - this.posz);
        float dx = (float)(DangerZone.player.posx - this.posx);
        float dz = (float)(DangerZone.player.posz - this.posz);
        dx = (float)Math.sqrt(dx * dx + dz * dz);
        dz = (float)(DangerZone.player.posy + (double)DangerZone.player.eyeheight - this.posy);
        dz = (float)Math.atan2(dx, dz);
        this.rotation_pitch = (float)Math.toDegrees((double)dz + 1.5707963267948966);
        this.rotation_yaw = (float)Math.toDegrees(tdir);
        this.rotation_roll = 0.0f;
    }

    @Override
    public float getSpinz() {
        this.spz += this.spzoff;
        if (this.spz > 360.0f) {
            this.spz -= 360.0f;
        }
        if (this.spz < -360.0f) {
            this.spz += 360.0f;
        }
        return this.spz;
    }

    public void doHitSomething(boolean hb, double x, double y, double z, boolean he, Entity ent) {
        EntityBlockItem ee = (EntityBlockItem)this.world.createEntityByName(DangerZone.blockitemname, this.dimension, this.posx + (double)this.motionx, this.posy + (double)this.motiony, this.posz + (double)this.motionz);
        if (ee != null) {
            ee.init();
            ee.setBID(this.getBID());
            ee.setIID(this.getIID());
            this.world.spawnEntityInWorld(ee);
        }
        if (he && ent != null) {
            ent.doAttackFrom(this.thrower, 8, this.getAttackDamage());
        }
        this.world.playSound("DangerZone:little_splat", this.dimension, this.posx + (double)this.motionx, this.posy + (double)this.motiony, this.posz + (double)this.motionz, 0.5f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
    }
}

