/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.Effects;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.Vampire;
import dangerzone.entities.VampireMoose;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class TheCount
extends EntityLiving {
    public int lightcount = 0;

    public TheCount(World w) {
        super(w);
        this.width = 0.75f;
        this.height = 1.75f;
        this.uniquename = "DangerZone:The Count";
        this.has_inventory = true;
        this.attackRange = 3.5f;
        this.setMaxHealth(120.0f);
        this.setHealth(120.0f);
        this.setExperience(120);
        this.setDefense(2.5f);
        this.setAttackDamage(25.0f);
        this.setMaxAir(40.0f);
        this.setAir(40.0f);
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = false;
    }

    @Override
    public void init() {
        super.init();
        if (this.world != null && this.world.isServer && this.getInitialized() == 0) {
            this.setInitialized(1);
            int wt = this.world.rand.nextInt(4);
            int itd = 0;
            InventoryContainer ic = new InventoryContainer();
            if (wt == 0) {
                itd = Items.silveraxe.itemID;
            }
            if (wt == 1) {
                itd = Items.platinumaxe.itemID;
            }
            if (wt == 2) {
                itd = Items.silversword.itemID;
            }
            if (wt == 3) {
                itd = Items.platinumsword.itemID;
            }
            ic.iid = itd;
            ic.count = 1;
            ic.currentuses = this.world.rand.nextInt(ic.getItem().maxuses);
            this.setHotbar(0, ic);
            this.sethotbarindex(0);
            if (this.world.rand.nextInt(3) == 0) {
                int at = this.world.rand.nextInt(2);
                if (this.world.rand.nextInt(2) == 0) {
                    ic = new InventoryContainer();
                    ic.iid = at == 0 ? Items.silverhelmet.itemID : Items.platinumhelmet.itemID;
                    ic.count = 1;
                    ic.currentuses = this.world.rand.nextInt(ic.getItem().maxuses);
                    this.setArmor(0, ic);
                }
                if (this.world.rand.nextInt(2) == 0) {
                    ic = new InventoryContainer();
                    ic.iid = at == 0 ? Items.silverchestplate.itemID : Items.platinumchestplate.itemID;
                    ic.count = 1;
                    ic.currentuses = this.world.rand.nextInt(ic.getItem().maxuses);
                    this.setArmor(1, ic);
                }
                if (this.world.rand.nextInt(2) == 0) {
                    ic = new InventoryContainer();
                    ic.iid = at == 0 ? Items.silverleggings.itemID : Items.platinumleggings.itemID;
                    ic.count = 1;
                    ic.currentuses = this.world.rand.nextInt(ic.getItem().maxuses);
                    this.setArmor(2, ic);
                    ic = new InventoryContainer();
                    ic.iid = at == 0 ? Items.silverboots.itemID : Items.platinumboots.itemID;
                    ic.count = 1;
                    ic.currentuses = this.world.rand.nextInt(ic.getItem().maxuses);
                    this.setArmor(3, ic);
                }
            }
        }
    }

    @Override
    public void doAttack(Entity victim) {
        Effects ef = new Effects();
        ef.effect = 6;
        ef.duration = 100;
        ef.amplitude = 0.02f;
        victim.addEffectFromServer(ef);
        super.doAttack(victim);
    }

    @Override
    public String getLivingSound() {
        if (this.world.rand.nextInt(5) != 0) {
            return null;
        }
        return "DangerZone:vampire_living";
    }

    @Override
    public String getHurtSound() {
        return "DangerZone:werewolf_attack";
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:werewolf_death";
    }

    @Override
    public String getAttackSound() {
        return "DangerZone:werewolf_attack";
    }

    @Override
    public void doDeathDrops() {
        super.doDeathDrops();
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand(this.world, 0, Items.trophythecount.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        Utils.doDropRand(this.world, 0, Items.vampireteeth.itemID, 2.0f, this.dimension, this.posx, this.posy, this.posz);
    }

    @Override
    public void update(float deltaT) {
        if (this.world.isServer) {
            ++this.lightcount;
            if (this.world.isDaytime() && this.lightcount > 100) {
                this.lightcount = 0;
                if (this.getLightAtLocation(this.world, this.dimension, (int)this.posx, (int)this.posy, (int)this.posz) > 0.55f) {
                    this.setOnFire(50);
                    if (this.world.rand.nextInt(20) == 0) {
                        this.doAttackFrom(null, 7, 1.0f);
                    }
                }
            }
        }
        super.update(deltaT);
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof TheCount) {
            return false;
        }
        if (e instanceof Vampire) {
            return false;
        }
        if (e instanceof VampireMoose) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/thecount.png");
        }
        return this.texture;
    }
}

