/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.ModelBase;
import dangerzone.ModelRenderer;
import dangerzone.Player;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Item;
import dangerzone.items.ItemArmor;
import dangerzone.items.Items;
import org.lwjgl.opengl.GL11;

public class ModelHumanoid
extends ModelBase {
    ModelRenderer head = new ModelRenderer(0, 0);
    ModelRenderer body;
    ModelRenderer leftarm;
    ModelRenderer rightarm;
    ModelRenderer rightleg;
    ModelRenderer leftleg;

    public ModelHumanoid() {
        this.head.addCube(-4.0f, -8.0f, -4.0f, 8, 8, 8);
        this.head.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.head.setTextureSize(64, 32);
        this.head.setRotation(0.0f, 0.0f, 0.0f);
        this.body = new ModelRenderer(16, 16);
        this.body.addCube(-4.0f, 0.0f, -2.0f, 8, 12, 4);
        this.body.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.body.setTextureSize(64, 32);
        this.body.setRotation(0.0f, 0.0f, 0.0f);
        this.leftarm = new ModelRenderer(40, 16);
        this.leftarm.addCube(0.0f, -1.0f, -2.0f, 4, 12, 4);
        this.leftarm.setRotationPoint(4.0f, 1.0f, 0.0f);
        this.leftarm.setTextureSize(64, 32);
        this.leftarm.setRotation(0.0f, 0.0f, 0.0f);
        this.leftarm.mirror = false;
        this.rightarm = new ModelRenderer(40, 16);
        this.rightarm.addCube(-4.0f, -1.0f, -2.0f, 4, 12, 4);
        this.rightarm.setRotationPoint(-4.0f, 1.0f, 0.0f);
        this.rightarm.setTextureSize(64, 32);
        this.rightarm.setRotation(0.0f, 0.0f, 0.0f);
        this.rightleg = new ModelRenderer(0, 16);
        this.rightleg.addCube(-2.0f, 0.0f, -2.0f, 4, 12, 4);
        this.rightleg.setRotationPoint(-2.0f, 12.0f, 0.0f);
        this.rightleg.setTextureSize(64, 32);
        this.rightleg.setRotation(0.0f, 0.0f, 0.0f);
        this.leftleg = new ModelRenderer(0, 16);
        this.leftleg.addCube(-2.0f, 0.0f, -2.0f, 4, 12, 4);
        this.leftleg.setRotationPoint(2.0f, 12.0f, 0.0f);
        this.leftleg.setTextureSize(64, 32);
        this.leftleg.setRotation(0.0f, 0.0f, 0.0f);
        this.leftleg.mirror = false;
    }

    @Override
    public void render(Entity entity, float f, float f1, float f2, float f3, float f4, float deathfactor) {
        Player pl;
        int armorid;
        InventoryContainer ic;
        float newangle = 0.0f;
        Entity ridden = null;
        if (entity != null) {
            ridden = entity.getRiddenEntity();
        }
        if (ridden != null) {
            f1 = 0.0f;
        }
        if ((double)f1 > 0.02) {
            if (f1 > 1.0f) {
                f1 = 1.0f;
            }
            newangle = (float)(Math.cos(Math.toRadians(f * 10.6f)) * 3.1415927410125732 * (double)0.45f * (double)f1);
            if (entity.isBaby()) {
                newangle = (float)(Math.cos(Math.toRadians(f * 20.6f)) * 3.1415927410125732 * (double)0.45f * (double)f1);
            }
        } else {
            newangle = 0.0f;
        }
        this.leftleg.rotateAngleX = newangle;
        this.rightleg.rotateAngleX = -newangle;
        this.leftarm.rotateAngleX = -newangle;
        this.rightarm.rotateAngleX = newangle;
        newangle = (float)(Math.cos(Math.toRadians(f * 1.6f)) * 3.1415927410125732 * (double)0.01f);
        this.leftarm.rotateAngleZ = -0.017f + newangle;
        newangle = (float)(Math.cos(Math.toRadians(f * 1.3f)) * 3.1415927410125732 * (double)0.01f);
        this.rightarm.rotateAngleZ = 0.017f + newangle;
        newangle = (float)(Math.cos(Math.toRadians(f * 1.1f)) * 3.1415927410125732 * (double)0.015f);
        this.leftarm.rotateAngleX += newangle;
        newangle = (float)(Math.cos(Math.toRadians(f * 1.2f)) * 3.1415927410125732 * (double)0.015f);
        this.rightarm.rotateAngleX += newangle;
        if (entity != null) {
            if (entity.getArmsUp()) {
                this.rightarm.rotateAngleX = (float)((double)this.rightarm.rotateAngleX - 1.5707963267948966);
                this.leftarm.rotateAngleX = (float)((double)this.leftarm.rotateAngleX - 1.5707963267948966);
            } else {
                this.rightarm.rotateAngleX = (float)((double)this.rightarm.rotateAngleX + Math.toRadians(entity.getRightArmAngle()));
                this.rightarm.rotateAngleZ = (float)((double)this.rightarm.rotateAngleZ + Math.toRadians(entity.getRightArmAngle()) / 6.0);
            }
        }
        if (f2 > 40.0f) {
            f2 = 40.0f;
        }
        if (f2 < -40.0f) {
            f2 = -40.0f;
        }
        if (f3 > 55.0f) {
            f3 = 55.0f;
        }
        if (f3 < -55.0f) {
            f3 = -55.0f;
        }
        if (f4 > 30.0f) {
            f4 = 30.0f;
        }
        if (f4 < -30.0f) {
            f4 = -30.0f;
        }
        this.head.rotateAngleX = (float)Math.toRadians(f2);
        this.head.rotateAngleY = entity instanceof Player ? (float)Math.toRadians(f3) : (float)(-Math.toRadians(f3));
        this.head.rotateAngleZ = (float)Math.toRadians(f4);
        if (entity != null && (entity != DangerZone.player || DangerZone.f5_front || DangerZone.f5_back) && (ic = entity.getHotbar(entity.gethotbarindex())) != null) {
            this.rightarm.rotateAngleX += -0.624f;
        }
        if (entity != null && entity.getSitting()) {
            this.leftleg.rotateAngleX = -1.344f;
            this.rightleg.rotateAngleX = -1.344f;
            this.leftleg.rotateAngleY = -0.244f;
            this.rightleg.rotateAngleY = 0.244f;
            GL11.glTranslatef((float)0.0f, (float)-10.0f, (float)0.0f);
        } else if (entity != null && entity instanceof Player && (armorid = (pl = (Player)entity).getBootsID()) != 0) {
            GL11.glTranslatef((float)0.0f, (float)1.45f, (float)0.0f);
        }
        this.head.render(deathfactor);
        this.body.render(deathfactor);
        this.leftarm.render(deathfactor);
        this.rightarm.render(deathfactor);
        this.rightleg.render(deathfactor);
        this.leftleg.render(deathfactor);
        if (entity != null && (entity != DangerZone.player || DangerZone.f5_front || DangerZone.f5_back)) {
            int bid = 0;
            int iid = 0;
            InventoryContainer ic2 = entity.getHotbar(entity.gethotbarindex());
            if (ic2 != null) {
                bid = ic2.bid;
                iid = ic2.iid;
            }
            if (bid != 0 || iid != 0) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)this.rightarm.rotationPointX, (float)(this.rightarm.rotationPointY + 24.0f), (float)this.rightarm.rotationPointZ);
                if (bid != 0) {
                    GL11.glRotatef((float)(-((float)Math.toDegrees(this.rightarm.rotateAngleZ))), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glRotatef((float)((float)Math.toDegrees(this.rightarm.rotateAngleY)), (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)((float)Math.toDegrees(this.rightarm.rotateAngleX) * 8.0f / 10.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)this.rightarm.offsetX, (float)(this.rightarm.offsetY - 8.0f), (float)(this.rightarm.offsetZ + 10.0f));
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)2.4f, (float)-2.2f, (float)-4.4f);
                    GL11.glRotatef((float)46.1f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glRotatef((float)22.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)85.8f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glScalef((float)0.3f, (float)0.3f, (float)0.3f);
                    if (Blocks.hasOwnRenderer(bid)) {
                        Blocks.renderMe(DangerZone.wr, entity.world, entity.dimension, (int)entity.posx, (int)entity.posy, (int)entity.posz, bid, 0, 255, false);
                    } else {
                        DangerZone.wr.drawTexturedCube(255, Blocks.isSolidForRender(bid), bid, 0, false);
                    }
                    GL11.glPopMatrix();
                } else if (iid != 0) {
                    GL11.glRotatef((float)(-((float)Math.toDegrees(this.rightarm.rotateAngleZ))), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glRotatef((float)((float)Math.toDegrees(this.rightarm.rotateAngleY)), (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)((float)Math.toDegrees(this.rightarm.rotateAngleX) * 8.0f / 10.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)this.rightarm.offsetX, (float)(this.rightarm.offsetY - 8.0f), (float)(this.rightarm.offsetZ + 10.0f));
                    GL11.glPushMatrix();
                    if (Items.isFlipped(iid)) {
                        GL11.glRotatef((float)268.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        GL11.glRotatef((float)200.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glRotatef((float)68.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    } else {
                        GL11.glTranslatef((float)0.0f, (float)-0.7f, (float)0.6f);
                        GL11.glRotatef((float)-95.7f, (float)0.0f, (float)0.0f, (float)1.0f);
                        GL11.glRotatef((float)-53.8f, (float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glRotatef((float)-73.2f, (float)1.0f, (float)0.0f, (float)0.0f);
                    }
                    DangerZone.wr.loadtexture(Items.getTexture(iid));
                    Items.renderMe(DangerZone.wr, entity.world, entity.dimension, (int)entity.posx, (int)entity.posy, (int)entity.posz, iid, 0, 0, false);
                    GL11.glPopMatrix();
                }
                GL11.glPopMatrix();
            }
        }
        if (entity != null && entity instanceof EntityLiving) {
            ItemArmor ita;
            Item it;
            EntityLiving pl2 = (EntityLiving)entity;
            armorid = pl2.getHelmetID();
            if (armorid != 0 && (it = Items.getItem(armorid)) != null && it instanceof ItemArmor) {
                ita = (ItemArmor)it;
                GL11.glPushMatrix();
                DangerZone.wr.loadtexture(ita.getArmorTexture(armorid));
                GL11.glScalef((float)1.1f, (float)1.1f, (float)1.1f);
                GL11.glTranslatef((float)0.0f, (float)-2.8f, (float)0.0f);
                this.head.render(deathfactor);
                GL11.glPopMatrix();
            }
            if ((armorid = pl2.getLeggingsID()) != 0 && (it = Items.getItem(armorid)) != null && it instanceof ItemArmor) {
                ita = (ItemArmor)it;
                GL11.glPushMatrix();
                DangerZone.wr.loadtexture(ita.getArmorTexture2(armorid));
                GL11.glScalef((float)1.1f, (float)1.1f, (float)1.1f);
                GL11.glTranslatef((float)0.0f, (float)-1.1f, (float)0.0f);
                GL11.glTranslatef((float)-0.18f, (float)0.0f, (float)0.0f);
                this.leftleg.render(deathfactor);
                GL11.glTranslatef((float)0.36f, (float)0.0f, (float)0.0f);
                this.rightleg.render(deathfactor);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glScalef((float)1.1f, (float)1.1f, (float)1.1f);
                GL11.glTranslatef((float)0.0f, (float)-1.8f, (float)0.0f);
                this.body.render(deathfactor);
                GL11.glPopMatrix();
            }
            if ((armorid = pl2.getChestplateID()) != 0 && (it = Items.getItem(armorid)) != null && it instanceof ItemArmor) {
                ita = (ItemArmor)it;
                GL11.glPushMatrix();
                DangerZone.wr.loadtexture(ita.getArmorTexture(armorid));
                GL11.glScalef((float)1.15f, (float)1.15f, (float)1.15f);
                GL11.glTranslatef((float)0.0f, (float)-2.9f, (float)0.0f);
                this.body.render(deathfactor);
                GL11.glTranslatef((float)-0.6f, (float)0.0f, (float)0.0f);
                this.leftarm.render(deathfactor);
                GL11.glTranslatef((float)1.2f, (float)0.0f, (float)0.0f);
                this.rightarm.render(deathfactor);
                GL11.glPopMatrix();
            }
            if ((armorid = pl2.getBootsID()) != 0 && (it = Items.getItem(armorid)) != null && it instanceof ItemArmor) {
                ita = (ItemArmor)it;
                GL11.glPushMatrix();
                DangerZone.wr.loadtexture(ita.getArmorTexture(armorid));
                GL11.glScalef((float)1.15f, (float)1.15f, (float)1.15f);
                GL11.glTranslatef((float)0.0f, (float)-1.3f, (float)0.0f);
                GL11.glTranslatef((float)-0.18f, (float)0.0f, (float)0.0f);
                this.leftleg.render(deathfactor);
                GL11.glTranslatef((float)0.36f, (float)0.0f, (float)0.0f);
                this.rightleg.render(deathfactor);
                GL11.glPopMatrix();
            }
        }
    }

    @Override
    public void doScale(Entity ent) {
        super.doScale(ent);
        GL11.glScalef((float)0.8f, (float)0.95f, (float)0.8f);
    }
}

