/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.WorldRendererUtils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.Ghost;
import dangerzone.entities.TargetHelper;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class GhostSkelly
extends EntityLiving {
    float myspeed = 0.125f;

    public GhostSkelly(World w) {
        super(w);
        this.maxrenderdist = 80;
        this.height = 1.75f;
        this.width = 1.25f;
        this.uniquename = "DangerZone:GhostSkelly";
        this.setMaxHealth(5.0f);
        this.setHealth(5.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(0.55f);
        this.takesFallDamage = false;
        this.ignoreCollisions = true;
        this.setExperience(30);
        this.temperament = 1;
        this.daytimespawn = false;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = false;
        this.canFly = true;
        this.setFlying(true);
    }

    @Override
    public void doEntityCollisions(float deltaT) {
    }

    @Override
    public void doEntityAction(float deltaT) {
    }

    @Override
    public void update(float deltaT) {
        if (this.world.isServer) {
            int bid;
            if (this.world.isDaytime() && this.world.rand.nextInt(100) == 1) {
                double dist = 0.0;
                Player p = DangerZone.server.findNearestPlayer(this);
                if (p == null) {
                    this.deadflag = true;
                } else {
                    dist = Utils.getDistanceBetweenEntities(this, p);
                    if (dist > (double)(this.maxrenderdist / 2)) {
                        this.deadflag = true;
                    }
                }
            }
            if (this.target == null) {
                this.target = new TargetHelper(this.posx, this.posy, this.posz);
            }
            if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0 || this.world.rand.nextInt(40) == 1 || this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < 2.0) {
                Player p = DangerZone.server.findNearestPlayer(this);
                if (p != null && this.getDistanceFromEntity(p) < 12.0 && p.getGameMode() == 0) {
                    this.target.setTarget(p.posx, p.posy, p.posz);
                    if (this.getDistanceFromEntity(p) < 2.0 && this.world.rand.nextInt(10) == 1) {
                        p.doAttackFrom(this, 4, this.getAttackDamage());
                    }
                } else {
                    int i = 0;
                    while (i < 3) {
                        bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy + i, (int)this.posz);
                        if (bid == 0) break;
                        ++i;
                    }
                    int j = -1;
                    while (j >= -3) {
                        bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy + j, (int)this.posz);
                        if (bid != 0) break;
                        --j;
                    }
                    this.target.setTarget((int)this.posx + this.world.rand.nextInt(10) - this.world.rand.nextInt(10), (int)this.posy + i + j + this.world.rand.nextInt(4) + 1, (int)this.posz + this.world.rand.nextInt(10) - this.world.rand.nextInt(10));
                }
            }
            float dy = (float)(this.target.targety - this.posy);
            this.motiony += dy / 30.0f;
            float cdir = (float)Math.toRadians(this.rotation_yaw);
            float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
            float ddiff = tdir - cdir;
            while ((double)ddiff > Math.PI) {
                ddiff = (float)((double)ddiff - Math.PI * 2);
            }
            while ((double)ddiff < -Math.PI) {
                ddiff = (float)((double)ddiff + Math.PI * 2);
            }
            this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 10.0);
            float speedadjust = 1.0f;
            float effectspeed = this.getTotalEffect(1);
            if (effectspeed > 1.0f) {
                speedadjust *= effectspeed;
            }
            if ((effectspeed = this.getTotalEffect(2)) > 1.0f) {
                speedadjust /= effectspeed;
            }
            this.motionx = (float)((double)this.motionx + (double)(this.myspeed * speedadjust) * Math.sin(tdir) * (double)deltaT);
            this.motionz = (float)((double)this.motionz + (double)(this.myspeed * speedadjust) * Math.cos(tdir) * (double)deltaT);
        } else if (WorldRendererUtils.getTotalLightAt(this.world, this.dimension, (int)this.posx, (int)this.posy, (int)this.posz) > 0.55f && this.world.rand.nextInt(70) == 1) {
            DangerZone.server_connection.sendKillMe(this.entityID);
        }
        super.update(deltaT);
    }

    @Override
    public void doDeathDrops() {
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand(this.world, 0, Items.trophyghostskelly.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
    }

    @Override
    public String getLivingSound() {
        if (this.world.rand.nextInt(2) != 0) {
            return null;
        }
        return "DangerZone:chain_rattles";
    }

    @Override
    public String getHurtSound() {
        return "DangerZone:rathit";
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:chain_rattles";
    }

    @Override
    public boolean getCanSpawnHereNow(World w, int dimension, int x, int y, int z) {
        if (w.isDaytime()) {
            return false;
        }
        return !(this.getLightAtLocation(w, dimension, x, y, z) > 0.35f);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/GhostSkellytexture.png");
        }
        return this.texture;
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Ghost) {
            return false;
        }
        if (e instanceof GhostSkelly) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }
}

