/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.Dimensions;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Cockroach;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlockItem;
import dangerzone.entities.EntityExp;
import dangerzone.entities.GenericTargetSorter;
import dangerzone.entities.TargetHelper;
import dangerzone.gui.PlayerPetNameGUI;
import dangerzone.items.Item;
import dangerzone.items.ItemArmor;
import dangerzone.items.ItemAxe;
import dangerzone.items.ItemFood;
import dangerzone.items.ItemPickAxe;
import dangerzone.items.ItemShovel;
import dangerzone.items.ItemSword;
import dangerzone.items.Items;
import dangerzone.threads.LightingThread;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class EntityLiving
extends Entity {
    public float deathfactor = 0.0f;
    public TargetHelper target = null;
    public TargetHelper idletarget = null;
    public float moveSpeed = 0.25f;
    public float accellerator = 1.0f;
    public boolean newtargetnow = false;
    public int movefrequency = 100;
    public int damage_backoff = 0;
    public int fallcount = 0;
    public int lastbx;
    public int lastby;
    public int lastbz;
    public int lastbd;
    public boolean canSwim = true;
    public float eyeheight = 1.0f;
    public float swimoffset = 0.0f;
    public int closest = 99999;
    public int tx = 0;
    public int ty = 0;
    public int tz = 0;
    public int tickadjust = 0;
    public float jumpstrength = 0.9f;
    public boolean targetLiquidOnly = false;
    public boolean enable_lookaround = true;
    public GenericTargetSorter LookTargetSorter = null;
    public float lookDistance = 16.0f;
    public boolean enable_avoid = false;
    public int avoiddistance = 10;
    public boolean enable_buddy = false;
    public int findbuddydistance = 10;
    public int findbuddyfrequency = 20;
    public boolean enable_hostile = false;
    public GenericTargetSorter TargetSorter = null;
    public float searchDistance = 16.0f;
    public float attackRange = 2.0f;
    public int searchcounter = 0;
    public Entity hurtMe = null;
    public Entity targetentity = null;
    public float armangle = 0.0f;
    public int armdir = 0;
    public boolean enable_findfoodblock = false;
    public int foodblockfreq = 60;
    public int foodblockdistxz = 12;
    public int foodblockdisty = 3;
    public int foodblockdisteat = 12;
    public int foodblockheal = 5;
    public boolean fooddaytimeonly = true;
    public boolean daytimespawn = true;
    public boolean daytimedespawn = false;
    public boolean nighttimespawn = false;
    public boolean nighttimedespawn = true;
    public boolean enable_followfood = false;
    public int foodfollowDistance = 12;
    public GenericTargetSorter FoodSorter = null;
    public boolean enable_droppedfood = false;
    public int foodsearchDistance = 12;
    public boolean enable_taming = false;
    public int ownercheckcounter = 0;
    public float maxdisttoowner = 16.0f;
    public int growupmax = 10000;
    public int growupcounter = 0;
    public boolean enable_breeding = false;
    public int breeding = 0;
    public int findmatedistance = 10;

    public EntityLiving(World w) {
        super(w);
        this.setMaxHealth(1.0f);
        this.setHealth(1.0f);
        this.setDefense(1.0f);
        this.deathfactor = 0.0f;
        this.takesFallDamage = true;
        this.canSwim = true;
        this.setMaxAir(40.0f);
        this.setAir(40.0f);
        this.setCanDespawn(true);
        this.temperament = 2;
    }

    @Override
    public void init() {
        super.init();
        this.eyeheight = this.getHeight() * 9.0f / 10.0f;
        this.LookTargetSorter = new GenericTargetSorter(this);
        this.TargetSorter = new GenericTargetSorter(this);
        this.FoodSorter = new GenericTargetSorter(this);
        this.lookDistance = this.getWidth() * 10.0f;
        if (this.lookDistance > 64.0f) {
            this.lookDistance = 64.0f;
        }
        this.jumpstrength = 0.15f * this.getHeight();
        if (this.enable_taming && this.getOwnerName() != null) {
            this.setCanDespawn(false);
            if (this.temperament == 1) {
                this.temperament = 3;
            }
        }
        if (this.isBaby()) {
            this.growupcounter = this.growupmax / 2 + this.world.rand.nextInt(this.growupmax / 2);
        }
    }

    public void setSpawning(boolean spawn_daytime, boolean despawn_daytime, boolean spawn_nighttime, boolean despawn_nighttime) {
        this.daytimespawn = spawn_daytime;
        this.daytimedespawn = despawn_daytime;
        this.nighttimespawn = spawn_nighttime;
        this.nighttimedespawn = despawn_nighttime;
    }

    public void enableLookAround(int distance) {
        this.enable_lookaround = true;
        this.lookDistance = distance;
    }

    public void enableBreeding(int distance) {
        this.enable_breeding = true;
        this.findmatedistance = distance;
    }

    public void enableAvoidEntity(int distance) {
        this.enable_avoid = true;
        this.avoiddistance = distance;
    }

    public void enableFindBuddy(int distance, int frequency) {
        this.enable_buddy = true;
        this.findbuddydistance = distance;
        this.findbuddyfrequency = frequency;
    }

    public void enableHostility(float search_distance, float attack_range) {
        this.enable_hostile = true;
        this.searchDistance = search_distance;
        this.attackRange = attack_range;
        this.temperament = 1;
    }

    public void enableFindFoodBlock(int frequency, int distance_xz, int distance_y, int distance_eat, int healamount, boolean daytimeonly) {
        this.enable_findfoodblock = true;
        this.foodblockfreq = frequency;
        this.foodblockdistxz = distance_xz;
        this.foodblockdisty = distance_y;
        this.foodblockdisteat = distance_eat * distance_eat * 3;
        this.foodblockheal = healamount;
        this.fooddaytimeonly = daytimeonly;
    }

    public void enableFollowHeldFood(int distance) {
        this.enable_followfood = true;
        this.foodfollowDistance = distance;
    }

    public void enableDroppedFood(int distance) {
        this.enable_droppedfood = true;
        this.foodsearchDistance = distance;
    }

    public void enableTaming(int max_distance_to_owner) {
        this.enable_taming = true;
        this.maxdisttoowner = max_distance_to_owner;
    }

    @Override
    public boolean getCanDespawn() {
        if ((this.getVarInt(5) & 0x10) == 16) {
            return true;
        }
        return this.getOwnerName() != null;
    }

    public boolean doSolidsPushback(float kf, float deltaT) {
        float wdth = this.getWidth();
        int intwidth = (int)(wdth / 2.0f + 0.995f);
        float tmx = this.motionx * deltaT;
        float tmz = this.motionz * deltaT;
        float rate = (float)DangerZone.entityupdaterate / (float)DangerZone.serverentityupdaterate;
        if (!this.world.isServer) {
            tmx *= rate;
            tmz *= rate;
        }
        boolean hitsomething = false;
        double dist = Math.sqrt(tmx * tmx + tmz * tmz);
        double curdist = 0.0;
        int bid = 0;
        if (dist == 0.0) {
            return false;
        }
        float nudge = 0.02f;
        float bounce = 2.0f;
        boolean bh = false;
        boolean fh = false;
        boolean rh = false;
        boolean lh = false;
        if (this instanceof Player && (this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy + (double)this.getHeight()) + 2, (int)this.posz) != 0 || this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy + (double)this.getHeight()) + 3, (int)this.posz) != 0)) {
            nudge = 0.02f;
            bounce = 20.0f;
        }
        while (curdist < dist && !hitsomething) {
            if ((curdist += (double)0.1f) > dist) {
                curdist = dist;
            }
            double mx = curdist / dist * (double)tmx;
            double mz = curdist / dist * (double)tmz;
            double upx = this.posx + mx;
            double upz = this.posz + mz;
            int i = -intwidth;
            while (i <= intwidth) {
                int j = -intwidth;
                while (j <= intwidth) {
                    bid = this.world.getblock(this.dimension, (int)upx + i, (int)(this.posy + (double)kf), (int)upz + j);
                    if (bid != 0 && Blocks.isSolid(bid, this.world, this.dimension, (int)upx + i, (int)(this.posy + (double)kf), (int)upz + j)) {
                        int itemp = (int)upx + i;
                        double dx = (double)itemp + 0.5 - this.posx;
                        itemp = (int)upz + j;
                        double dz = (double)itemp + 0.5 - this.posz;
                        if (Math.abs(dx) - (double)(0.51f + wdth / 2.0f) < 0.0 && Math.abs(dz) - (double)(0.51f + wdth / 2.0f) < 0.0) {
                            this.posx = dx > 0.0 ? (this.posx -= (double)nudge) : (this.posx += (double)nudge);
                            this.posz = dz > 0.0 ? (this.posz -= (double)nudge) : (this.posz += (double)nudge);
                            itemp = (int)this.posx + i;
                            dx = (double)itemp + 0.5 - this.posx;
                            itemp = (int)this.posz + j;
                            dz = (double)itemp + 0.5 - this.posz;
                        }
                        double dxsave = dx;
                        if (dx < 0.0 && mx < 0.0) {
                            if (Math.abs(dz) < (double)(0.51f + wdth / 2.0f)) {
                                dx += (double)0.51f;
                                if ((dx += (double)(wdth / 2.0f)) > mx && !Blocks.isSolid(this.world.getblock(this.dimension, (int)upx + i + 1, (int)(this.posy + (double)kf), (int)upz + j), this.world, this.dimension, (int)upx + i + 1, (int)(this.posy + (double)kf), (int)upz + j)) {
                                    if (!lh) {
                                        this.motionx = -this.motionx / bounce;
                                    }
                                    hitsomething = true;
                                    Blocks.bumpedBlock(bid, this, this.world, this.dimension, (int)upx + i, (int)(this.posy + (double)kf), (int)upz + j);
                                    lh = true;
                                }
                            }
                        } else if (dx > 0.0 && mx > 0.0 && Math.abs(dz) < (double)(0.51f + wdth / 2.0f)) {
                            dx -= (double)0.51f;
                            if ((dx -= (double)(wdth / 2.0f)) < mx && !Blocks.isSolid(this.world.getblock(this.dimension, (int)upx + i - 1, (int)(this.posy + (double)kf), (int)upz + j), this.world, this.dimension, (int)upx + i - 1, (int)(this.posy + (double)kf), (int)upz + j)) {
                                if (!rh) {
                                    this.motionx = -this.motionx / bounce;
                                }
                                hitsomething = true;
                                Blocks.bumpedBlock(bid, this, this.world, this.dimension, (int)upx + i, (int)(this.posy + (double)kf), (int)upz + j);
                                rh = true;
                            }
                        }
                        dx = dxsave;
                        if (dz < 0.0 && mz < 0.0) {
                            if (Math.abs(dx) < (double)(0.51f + wdth / 2.0f)) {
                                dz += (double)0.51f;
                                if ((dz += (double)(wdth / 2.0f)) > mz && !Blocks.isSolid(this.world.getblock(this.dimension, (int)upx + i, (int)(this.posy + (double)kf), (int)upz + j + 1), this.world, this.dimension, (int)upx + i, (int)(this.posy + (double)kf), (int)upz + j + 1)) {
                                    if (!fh) {
                                        this.motionz = -this.motionz / bounce;
                                    }
                                    hitsomething = true;
                                    Blocks.bumpedBlock(bid, this, this.world, this.dimension, (int)upx + i, (int)(this.posy + (double)kf), (int)upz + j);
                                    fh = true;
                                }
                            }
                        } else if (dz > 0.0 && mz > 0.0 && Math.abs(dx) < (double)(0.51f + wdth / 2.0f)) {
                            dz -= (double)0.51f;
                            if ((dz -= (double)(wdth / 2.0f)) < mz && !Blocks.isSolid(this.world.getblock(this.dimension, (int)upx + i, (int)(this.posy + (double)kf), (int)upz + j - 1), this.world, this.dimension, (int)upx + i, (int)(this.posy + (double)kf), (int)upz + j - 1)) {
                                if (!bh) {
                                    this.motionz = -this.motionz / bounce;
                                }
                                hitsomething = true;
                                Blocks.bumpedBlock(bid, this, this.world, this.dimension, (int)upx + i, (int)(this.posy + (double)kf), (int)upz + j);
                                bh = true;
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        return hitsomething;
    }

    public boolean wouldBump(double x, double y, double z, float w) {
        int intwidth = (int)(w / 2.0f + 0.995f);
        int i = -intwidth;
        while (i <= intwidth) {
            int j = -intwidth;
            while (j <= intwidth) {
                if (Blocks.isSolid(this.world.getblock(this.dimension, (int)x + i, (int)y, (int)z + j), this.world, this.dimension, (int)x + i, (int)y, (int)z + j)) {
                    int itemp = (int)this.posx + i;
                    double dx = x - ((double)itemp + 0.5);
                    double dz = z - ((double)(itemp = (int)this.posz + j) + 0.5);
                    if (Math.sqrt(dx * dx + dz * dz) < (double)(0.5f + w / 2.0f)) {
                        return true;
                    }
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public boolean isSolidAtLevel(int d, double x, double y, double z) {
        float wdth = this.getWidth();
        int intwidth = (int)(wdth / 2.0f + 0.995f);
        int i = -intwidth;
        while (i <= intwidth) {
            int j = -intwidth;
            while (j <= intwidth) {
                if (Blocks.isSolid(this.world.getblock(d, (int)x + i, (int)y, (int)z + j), this.world, d, (int)x + i, (int)y, (int)z + j)) {
                    int itemp = (int)x + i;
                    double dx = x - ((double)itemp + 0.5);
                    if ((dx = Math.abs(dx)) < (double)(0.49f + wdth / 2.0f)) {
                        itemp = (int)z + j;
                        double dz = z - ((double)itemp + 0.5);
                        if ((dz = Math.abs(dz)) < (double)(0.49f + wdth / 2.0f)) {
                            return true;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public boolean isLiquidAtLevel(int d, double x, double y, double z) {
        float wdth = this.getWidth();
        int intwidth = (int)(wdth / 2.0f + 0.995f);
        int i = -intwidth;
        while (i <= intwidth) {
            int j = -intwidth;
            while (j <= intwidth) {
                if (Blocks.isLiquid(this.world.getblock(d, (int)x + i, (int)y, (int)z + j))) {
                    int itemp = (int)x + i;
                    double dx = x - ((double)itemp + 0.5);
                    if ((dx = Math.abs(dx)) < (double)(0.49f + wdth / 2.0f)) {
                        itemp = (int)z + j;
                        double dz = z - ((double)itemp + 0.5);
                        if ((dz = Math.abs(dz)) < (double)(0.49f + wdth / 2.0f)) {
                            return true;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean isDying() {
        return this.deathfactor > 0.0f && this.deathfactor < 8.0f;
    }

    @Override
    public void doDeathAnimation() {
        this.deathfactor = 0.9f;
        this.motionz = 0.0f;
        this.motionx = 0.0f;
        this.motiony = 0.0f;
        if (!this.world.isServer) {
            Utils.spawnDeathParticles(this.world, this.dimension, this.posx, this.posy, this.posz, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public float getDeathFactor() {
        return this.deathfactor;
    }

    @Override
    public void doEntityCollisions(float deltaT) {
        if (this.ignoreCollisions) {
            return;
        }
        float wdth = this.getWidth();
        List<Entity> nearby_list = null;
        Entity ridden = this.getRiddenEntity();
        Entity rider = this.getRiderEntity();
        int riddenid = 0;
        int riderid = 0;
        if (ridden != null) {
            riddenid = ridden.entityID;
        }
        if (rider != null) {
            riderid = rider.entityID;
        }
        if ((nearby_list = DangerZone.server.entityManager.findEntitiesInRange(wdth / 2.0f + 8.0f, this.dimension, this.posx, this.posy, this.posz)) != null && !nearby_list.isEmpty()) {
            Entity e = null;
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = li.next();
                if (e == this || e.ignoreCollisions || !(e.posy >= this.posy && e.posy < this.posy + (double)this.getHeight() || e.posy + (double)e.getHeight() > this.posy && e.posy + (double)e.getHeight() < this.posy + (double)this.getHeight() || this.posy >= e.posy && this.posy < e.posy + (double)e.getHeight()) && (!(this.posy + (double)this.getHeight() > e.posy) || !(this.posy + (double)this.getHeight() < e.posy + (double)e.getHeight()))) continue;
                double dist = e.getHorizontalDistanceFromEntity(this);
                dist -= (double)(wdth / 2.0f);
                if (!((dist -= (double)(e.getWidth() / 2.0f)) < 0.0) || riddenid == e.entityID || riderid == e.entityID) continue;
                double dir = Math.atan2(e.posz - this.posz, e.posx - this.posx);
                dist = -0.25;
                this.motionx = (float)((double)this.motionx + Math.cos(dir) * dist * (double)deltaT);
                this.motionz = (float)((double)this.motionz + Math.sin(dir) * dist * (double)deltaT);
            }
        }
    }

    @Override
    public void setBaby(boolean tf) {
        if (tf) {
            if (this.growupmax < 300) {
                this.growupmax = 300;
            }
            this.growupcounter = this.growupmax / 2 + this.world.rand.nextInt(this.growupmax / 2);
            if (!this.isBaby()) {
                this.doGrowDown();
            }
        } else if (this.isBaby()) {
            this.doGrowUp();
        }
        super.setBaby(tf);
    }

    public void doGrowUp() {
        super.setBaby(false);
        this.setHealth(this.getMaxHealth());
    }

    public void doGrowDown() {
        super.setBaby(true);
        this.setHealth(this.getMaxHealth());
    }

    @Override
    public void update(float deltaT) {
        int maybenot;
        float gravity = 0.045f * deltaT;
        float rate = (float)DangerZone.entityupdaterate / (float)DangerZone.serverentityupdaterate;
        Entity rider = null;
        if (this.world.isServer && this.isBaby()) {
            --this.growupcounter;
            if (this.growupcounter <= 0) {
                this.setBaby(false);
            }
        }
        if (!(this instanceof Player)) {
            if (this.getAttacking() && this.armdir == 0) {
                this.armdir = 1;
            }
            if (this.armdir != 0) {
                if (this.armdir > 0) {
                    this.armangle += 22.0f * deltaT;
                    if (this.armangle > 150.0f) {
                        this.armdir = -1;
                    }
                }
                if (this.armdir < 0) {
                    this.armangle -= 22.0f * deltaT;
                    if (this.armangle <= 0.0f) {
                        this.armdir = 0;
                        this.armangle = 0.0f;
                    }
                }
            }
            if (this.world.isServer && this.world.rand.nextInt(250) == 1) {
                this.heal(1.0f);
            }
        }
        if (this.world.isServer && this.getCanDespawn() && (this.world.isDaytime() && this.daytimedespawn || !this.world.isDaytime() && this.nighttimedespawn)) {
            double dist = 0.0;
            Player p = DangerZone.server.findNearestPlayer(this);
            if (p == null) {
                this.deadflag = true;
            } else {
                dist = Utils.getDistanceBetweenEntities(this, p);
                if (dist > (double)DangerZone.entityupdatedist) {
                    this.deadflag = true;
                } else if (dist > (double)(DangerZone.entityupdatedist / 2)) {
                    if (this.world.rand.nextInt(500) == 0) {
                        this.deadflag = true;
                    }
                } else if (dist > (double)(DangerZone.entityupdatedist / 4)) {
                    if (this.world.rand.nextInt(5000) == 0) {
                        this.deadflag = true;
                    }
                } else if (dist > (double)(DangerZone.entityupdatedist / 8) && this.world.rand.nextInt(10000) == 0) {
                    this.deadflag = true;
                }
            }
        }
        if (this.damage_backoff > 0) {
            --this.damage_backoff;
        }
        if (this.hurtanimationtimer > 0) {
            --this.hurtanimationtimer;
        }
        if (this.madtimer > 0) {
            --this.madtimer;
        }
        if (this.deadflag) {
            this.deathfactor += 0.11f;
        }
        if (this.isDying()) {
            this.deadflag = true;
        }
        if (this.world.isServer && (maybenot = (int)this.getTotalEffect(7)) >= 2 && this.world.rand.nextInt(maybenot) != 1) {
            this.addKnockback(this.world.rand.nextFloat() * (float)Math.PI * 2.0f, this.world.rand.nextFloat() * (float)maybenot / 10.0f, 0.0f);
        }
        if (this.ignoreCollisions) {
            if (this.getOnFire() > 0) {
                this.setOnFire(0);
            }
            if (this.world.isServer) {
                this.updateEffects();
                float healthadjust = this.getTotalEffect(5);
                healthadjust -= this.getTotalEffect(6);
                if (healthadjust < 0.0f) {
                    this.doAttackFrom(this, 13, Math.abs(healthadjust));
                } else if (healthadjust > 0.0f) {
                    this.heal(healthadjust);
                }
            }
            super.update(deltaT);
            return;
        }
        if (this.world.isServer) {
            gravity = 0.2f * deltaT;
            float healthadjust = this.getTotalEffect(5);
            if ((healthadjust -= this.getTotalEffect(6)) < 0.0f) {
                this.doAttackFrom(this, 13, Math.abs(healthadjust));
            } else if (healthadjust > 0.0f) {
                this.heal(healthadjust);
            }
            if (!(this instanceof Player)) {
                float ff;
                int bid;
                int imax;
                int i;
                this.updateEffects();
                if (this.isImmuneToFire && this.getOnFire() > 0) {
                    this.setOnFire(0);
                }
                if (this.getOnFire() > 0) {
                    this.setOnFire(this.getOnFire() - 1);
                    ++this.firecounter;
                    if (this.firecounter > 20) {
                        this.doAttackFrom(this, 10, 1.0f);
                        this.firecounter = 0;
                    }
                }
                float startheight = this.getHeight() / 4.0f;
                while (startheight < this.getHeight()) {
                    this.doSolidsPushback(startheight, deltaT);
                    startheight += 1.0f;
                    if (!(startheight > this.getHeight())) continue;
                    this.doSolidsPushback(this.getHeight(), deltaT);
                }
                if (this.getInLiquid()) {
                    gravity /= 5.0f;
                }
                this.motiony -= gravity;
                if (this.isSolidAtLevel(this.dimension, this.posx, this.posy, this.posz)) {
                    this.motiony += gravity * 2.0f;
                }
                float df = this.motiony * deltaT;
                int idf = (int)df;
                df -= (float)idf;
                if (this.motiony < 0.0f) {
                    i = 0;
                    while (i >= idf) {
                        if (this.isSolidAtLevel(this.dimension, this.posx, this.posy + (double)df + (double)i, this.posz)) {
                            imax = (int)(this.posy + (double)df + (double)i) + 1;
                            this.motiony = 0.0f;
                            this.posy = (float)imax + 0.01f;
                            if (this.fallcount > 7) {
                                this.doAttackFrom(this, 5, this.getAdjustedFallDamage(this.fallcount - 7));
                            }
                            this.fallcount = 0;
                            break;
                        }
                        --i;
                    }
                }
                if (this.motiony >= 0.0f && !this.isSolidAtLevel(this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz)) {
                    df = this.motiony * deltaT;
                    idf = (int)df;
                    df -= (float)idf;
                    i = 0;
                    while (i <= idf) {
                        if (this.isSolidAtLevel(this.dimension, this.posx, this.posy + (double)df + (double)this.getHeight() + (double)i, this.posz)) {
                            imax = (int)(this.posy + (double)df + (double)this.getHeight() + (double)i);
                            this.motiony = 0.0f;
                            this.posy = (double)imax - (double)this.getHeight() - (double)0.01f;
                            this.fallcount = 0;
                            break;
                        }
                        ++i;
                    }
                }
                if (!this.isSolidAtLevel(this.dimension, this.posx, this.posy - (double)0.15f, this.posz) && this.getRiddenEntity() == null) {
                    this.setOnGround(false);
                    if (!this.takesFallDamage) {
                        this.fallcount = 0;
                    } else if (this.motiony < 0.0f) {
                        ++this.fallcount;
                    }
                    this.lastbd = 0;
                    this.lastbz = 0;
                    this.lastby = 0;
                    this.lastbx = 0;
                } else {
                    this.setOnGround(true);
                    this.fallcount = 0;
                    bid = this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy - 0.25), (int)this.posz);
                    float ff2 = Blocks.getFriction(bid);
                    if (ff2 != 0.0f) {
                        if ((ff2 = 1.0f - ff2) < 0.0f) {
                            ff2 = 0.0f;
                        }
                        this.motionx *= ff2;
                        this.motionz *= ff2;
                    }
                    if (this.dimension != this.lastbd || (int)this.posx != this.lastbx || (int)(this.posy - 0.25) != this.lastby || (int)this.posz != this.lastbz) {
                        this.lastbd = this.dimension;
                        this.lastbx = (int)this.posx;
                        this.lastby = (int)(this.posy - 0.25);
                        this.lastbz = (int)this.posz;
                        Blocks.doSteppedOn(bid, this, this.world, this.dimension, (int)this.posx, (int)(this.posy - 0.25), (int)this.posz);
                    }
                }
                int intheight = (int)this.getHeight();
                ++intheight;
                boolean tmpb = false;
                boolean tmps = false;
                int sbid = 0;
                int lbid = 0;
                int k = 0;
                while (k < intheight) {
                    bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy + k, (int)this.posz);
                    if (Blocks.isLiquid(bid)) {
                        tmpb = true;
                        lbid = bid;
                    }
                    if (Blocks.isSquishy(bid)) {
                        tmps = true;
                        sbid = bid;
                    }
                    ++k;
                }
                this.setInLiquid(tmpb);
                if (this.getInLiquid()) {
                    this.fallcount = 0;
                    ff = Blocks.getFriction(lbid);
                    if (ff != 0.0f) {
                        if ((ff = 1.0f - ff) < 0.0f) {
                            ff = 0.0f;
                        }
                        this.motionx *= ff;
                        this.motionz *= ff;
                        this.motiony *= ff;
                    }
                    Blocks.entityInLiquid(lbid, this);
                }
                if (tmps) {
                    this.fallcount = 0;
                    ff = Blocks.getFriction(sbid);
                    if (ff != 0.0f) {
                        if ((ff = 1.0f - ff) < 0.0f) {
                            ff = 0.0f;
                        }
                        this.motionx *= ff;
                        this.motionz *= ff;
                        this.motiony *= ff;
                    }
                }
                if (this.getInLiquid() && this.canSwim && Blocks.isLiquid(this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy + (double)(this.getHeight() * 3.0f / 4.0f) + (double)this.swimoffset), (int)this.posz)) && this.world.rand.nextInt(9) != 0) {
                    this.motiony += 0.08f;
                }
                if (!Blocks.isLiquid(bid = this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy + (double)this.eyeheight), (int)this.posz))) {
                    this.setAir(this.getMaxAir());
                } else {
                    this.setAir(this.getAir() - 0.06f * deltaT);
                }
                if (this.getAir() < 0.0f) {
                    this.doAttackFrom(null, 6, 2.5f * deltaT);
                }
                if (this.has_inventory) {
                    InventoryContainer ic;
                    Item it = Items.getItem(this.getHelmetID());
                    ItemArmor ia = null;
                    if (it instanceof ItemArmor) {
                        ia = (ItemArmor)it;
                        ia.inUseTick(this);
                    }
                    if ((it = Items.getItem(this.getChestplateID())) instanceof ItemArmor) {
                        ia = (ItemArmor)it;
                        ia.inUseTick(this);
                    }
                    if ((it = Items.getItem(this.getLeggingsID())) instanceof ItemArmor) {
                        ia = (ItemArmor)it;
                        ia.inUseTick(this);
                    }
                    if ((it = Items.getItem(this.getBootsID())) instanceof ItemArmor) {
                        ia = (ItemArmor)it;
                        ia.inUseTick(this);
                    }
                    if ((ic = this.getHotbar(this.gethotbarindex())) != null && (it = ic.getItem()) != null) {
                        Items.doitemtick(this, it.itemID);
                    }
                }
                if (this.posy < 0.0) {
                    float h = this.getHealth();
                    if (h > 20.0f) {
                        this.setHealth(this.getHealth() / 4.0f);
                    } else {
                        this.setHealth(this.getHealth() - 1.0f);
                    }
                }
                this.doInLiquid(1.0f);
            }
        } else {
            if (this.getOnFire() != 0 && this.world.rand.nextInt(60) == 0) {
                LightingThread.addRequest(this.dimension, (int)this.posx, (int)(this.posy + (double)(this.getHeight() / 2.0f)), (int)this.posz, 0.55f);
            }
            if (this instanceof Player) {
                if (this == DangerZone.player) {
                    float ff;
                    int bid;
                    int i;
                    float cdir = (float)Math.toRadians(this.rotation_yaw);
                    float tdir = (float)Math.toRadians(this.rotation_yaw_head);
                    float ddiff = tdir - cdir;
                    while ((double)ddiff > Math.PI) {
                        ddiff = (float)((double)ddiff - Math.PI * 2);
                    }
                    while ((double)ddiff < -Math.PI) {
                        ddiff = (float)((double)ddiff + Math.PI * 2);
                    }
                    this.rotation_yaw = (float)((double)this.rotation_yaw + (double)(ddiff * 180.0f) / Math.PI / 10.0);
                    if (this.isImmuneToFire && this.getOnFire() > 0) {
                        this.setOnFire(0);
                    }
                    ++this.tickadjust;
                    if (this.tickadjust >= DangerZone.wr.fps / 10) {
                        InventoryContainer ic;
                        this.tickadjust = 0;
                        if (this.getOnFire() > 0) {
                            this.setOnFire(this.getOnFire() - 1);
                            ++this.firecounter;
                            if (this.firecounter > 20) {
                                this.doAttackFrom(this, 10, 1.0f);
                                this.firecounter = 0;
                            }
                        }
                        if (this.getAir() < 0.0f && this.getGameMode() == 0) {
                            this.doAttackFrom(null, 6, 1.5f);
                        }
                        this.updateEffects();
                        Item it = Items.getItem(this.getHelmetID());
                        ItemArmor ia = null;
                        if (it instanceof ItemArmor) {
                            ia = (ItemArmor)it;
                            ia.inUseTick(this);
                        }
                        if ((it = Items.getItem(this.getChestplateID())) instanceof ItemArmor) {
                            ia = (ItemArmor)it;
                            ia.inUseTick(this);
                        }
                        if ((it = Items.getItem(this.getLeggingsID())) instanceof ItemArmor) {
                            ia = (ItemArmor)it;
                            ia.inUseTick(this);
                        }
                        if ((it = Items.getItem(this.getBootsID())) instanceof ItemArmor) {
                            ia = (ItemArmor)it;
                            ia.inUseTick(this);
                        }
                        if ((ic = this.getHotbar(this.gethotbarindex())) != null && (it = ic.getItem()) != null) {
                            Items.doitemtick(this, it.itemID);
                        }
                    }
                    if (DangerZone.player.getGameMode() == 2) {
                        int intheight = (int)this.getHeight();
                        ++intheight;
                        boolean tmpb = false;
                        int lbid = 0;
                        int k = 0;
                        while (k < intheight) {
                            int bid2 = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy + k, (int)this.posz);
                            if (Blocks.isLiquid(bid2)) {
                                tmpb = true;
                                lbid = bid2;
                            }
                            ++k;
                        }
                        this.setInLiquid(tmpb);
                        super.update(deltaT);
                        return;
                    }
                    float startheight = this.getHeight() / 4.0f;
                    while (startheight < this.getHeight()) {
                        this.doSolidsPushback(startheight, deltaT);
                        startheight += 1.0f;
                        if (!(startheight > this.getHeight())) continue;
                        this.doSolidsPushback(this.getHeight(), deltaT);
                    }
                    if (this.isFlying()) {
                        gravity /= 10.0f;
                    }
                    if (this.getInLiquid()) {
                        gravity /= 5.0f;
                    }
                    this.motiony -= gravity;
                    if (this.isSolidAtLevel(this.dimension, this.posx, this.posy, this.posz)) {
                        this.motiony += gravity * 2.0f;
                    }
                    float df = this.motiony * deltaT * rate;
                    int idf = (int)df;
                    df -= (float)idf;
                    if (this.motiony < 0.0f) {
                        i = 0;
                        while (i >= idf) {
                            if (this.isSolidAtLevel(this.dimension, this.posx, this.posy + (double)df + (double)i, this.posz)) {
                                int imax = (int)(this.posy + (double)df + (double)i) + 1;
                                this.motiony = 0.0f;
                                this.posy = (float)imax + 0.001f;
                                if (this.fallcount > 40) {
                                    this.doAttackFrom(this, 5, this.getAdjustedFallDamage((float)(this.fallcount - 40) * rate));
                                }
                                this.fallcount = 0;
                                break;
                            }
                            --i;
                        }
                    }
                    if (this.motiony >= 0.0f && !this.isSolidAtLevel(this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz)) {
                        df = this.motiony * deltaT * rate;
                        idf = (int)df;
                        df -= (float)idf;
                        i = 0;
                        while (i <= idf) {
                            if (this.isSolidAtLevel(this.dimension, this.posx, this.posy + (double)df + (double)this.getHeight() + (double)i, this.posz)) {
                                this.motiony = 0.0f;
                                this.fallcount = 0;
                                break;
                            }
                            ++i;
                        }
                    }
                    if (!this.isSolidAtLevel(this.dimension, this.posx, this.posy - (double)0.1f, this.posz) && this.getRiddenEntity() == null) {
                        this.setOnGround(false);
                        if (this.motiony < 0.0f) {
                            ++this.fallcount;
                        }
                        if (this.getGameMode() != 0) {
                            this.fallcount = 0;
                        }
                        this.lastbd = 0;
                        this.lastbz = 0;
                        this.lastby = 0;
                        this.lastbx = 0;
                    } else {
                        this.setOnGround(true);
                        this.fallcount = 0;
                        if (this.getGameMode() != 2) {
                            bid = this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy - 0.25), (int)this.posz);
                            float ff3 = Blocks.getFriction(bid) * rate;
                            if (ff3 != 0.0f) {
                                if ((ff3 = 1.0f - ff3) < 0.0f) {
                                    ff3 = 0.0f;
                                }
                                this.motionx *= ff3;
                                this.motionz *= ff3;
                            }
                            if (this.dimension != this.lastbd || (int)this.posx != this.lastbx || (int)(this.posy - 0.25) != this.lastby || (int)this.posz != this.lastbz) {
                                this.lastbd = this.dimension;
                                this.lastbx = (int)this.posx;
                                this.lastby = (int)(this.posy - 0.25);
                                this.lastbz = (int)this.posz;
                                Blocks.doSteppedOn(bid, this, this.world, this.dimension, (int)this.posx, (int)(this.posy - 0.25), (int)this.posz);
                            }
                        }
                    }
                    int intheight = (int)this.getHeight();
                    ++intheight;
                    boolean tmpb = false;
                    boolean tmps = false;
                    int sbid = 0;
                    int lbid = 0;
                    int k = 0;
                    while (k < intheight) {
                        bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy + k, (int)this.posz);
                        if (Blocks.isLiquid(bid)) {
                            tmpb = true;
                            lbid = bid;
                        }
                        if (Blocks.isSquishy(bid)) {
                            tmps = true;
                            sbid = bid;
                        }
                        ++k;
                    }
                    this.setInLiquid(tmpb);
                    if (this.getInLiquid()) {
                        this.fallcount = 0;
                        if (this.getGameMode() != 2) {
                            ff = Blocks.getFriction(lbid) * rate;
                            if (ff != 0.0f) {
                                if ((ff = 1.0f - ff) < 0.0f) {
                                    ff = 0.0f;
                                }
                                this.motionx *= ff;
                                this.motionz *= ff;
                                this.motiony *= ff;
                            }
                            Blocks.entityInLiquid(lbid, this);
                        }
                    }
                    if (tmps) {
                        this.fallcount = 0;
                        if (this.getGameMode() != 2 && (ff = Blocks.getFriction(sbid) * rate) != 0.0f) {
                            if ((ff = 1.0f - ff) < 0.0f) {
                                ff = 0.0f;
                            }
                            this.motionx *= ff;
                            this.motionz *= ff;
                            this.motiony *= ff;
                        }
                    }
                    if (!Blocks.isLiquid(bid = this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy + (double)this.eyeheight), (int)this.posz))) {
                        this.setAir(this.getMaxAir());
                    } else if (this.getGameMode() == 0) {
                        this.setAir(this.getAir() - 0.02f * deltaT);
                    }
                    if (this.getGameMode() == 0 && this.posy < 0.0) {
                        float h = this.getHealth();
                        if (h > 10.0f) {
                            this.setHealth(this.getHealth() - 1.0f);
                        } else {
                            this.setHealth(this.getHealth() - 0.01f);
                        }
                    }
                    this.doInLiquid(0.2f);
                }
            } else {
                rider = this.getRiderEntity();
                if (rider != null && rider.entityID == DangerZone.player.entityID) {
                    int imax;
                    int i;
                    float startheight = this.getHeight() / 4.0f;
                    while (startheight < this.getHeight()) {
                        this.doSolidsPushback(startheight, deltaT);
                        startheight += 1.0f;
                        if (!(startheight > this.getHeight())) continue;
                        this.doSolidsPushback(this.getHeight(), deltaT);
                    }
                    float df = this.motiony * deltaT * rate;
                    int idf = (int)df;
                    df -= (float)idf;
                    if (this.motiony < 0.0f) {
                        i = 0;
                        while (i >= idf) {
                            if (this.isSolidAtLevel(this.dimension, this.posx, this.posy + (double)df + (double)i, this.posz)) {
                                imax = (int)(this.posy + (double)df + (double)i) + 1;
                                this.motiony = 0.0f;
                                this.posy = (float)imax + 0.001f;
                                if (this.fallcount > 40) {
                                    this.doAttackFrom(this, 5, this.getAdjustedFallDamage((float)(this.fallcount - 40) * rate));
                                }
                                this.fallcount = 0;
                                break;
                            }
                            --i;
                        }
                    }
                    if (this.motiony >= 0.0f && !this.isSolidAtLevel(this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz)) {
                        df = this.motiony * deltaT * rate;
                        idf = (int)df;
                        df -= (float)idf;
                        i = 0;
                        while (i <= idf) {
                            if (this.isSolidAtLevel(this.dimension, this.posx, this.posy + (double)df + (double)this.getHeight() + (double)i, this.posz)) {
                                imax = (int)(this.posy + (double)df + (double)this.getHeight() + (double)i);
                                this.motiony = 0.0f;
                                this.posy = (double)imax - (double)this.getHeight() - (double)0.01f;
                                this.fallcount = 0;
                                break;
                            }
                            ++i;
                        }
                    }
                }
            }
        }
        super.update(deltaT);
    }

    public int getHelmetID() {
        if (this.getArmor(0) != null) {
            return this.getArmor((int)0).iid;
        }
        return 0;
    }

    public int getChestplateID() {
        if (this.getArmor(1) != null) {
            return this.getArmor((int)1).iid;
        }
        return 0;
    }

    public int getLeggingsID() {
        if (this.getArmor(2) != null) {
            return this.getArmor((int)2).iid;
        }
        return 0;
    }

    public int getBootsID() {
        if (this.getArmor(3) != null) {
            return this.getArmor((int)3).iid;
        }
        return 0;
    }

    @Override
    public float getDefense() {
        float df = super.getDefense();
        if (this.has_inventory) {
            Item it = Items.getItem(this.getHelmetID());
            ItemArmor ia = null;
            if (it instanceof ItemArmor) {
                ia = (ItemArmor)it;
                df += ia.protection;
            }
            if ((it = Items.getItem(this.getChestplateID())) instanceof ItemArmor) {
                ia = (ItemArmor)it;
                df += ia.protection;
            }
            if ((it = Items.getItem(this.getLeggingsID())) instanceof ItemArmor) {
                ia = (ItemArmor)it;
                df += ia.protection;
            }
            if ((it = Items.getItem(this.getBootsID())) instanceof ItemArmor) {
                ia = (ItemArmor)it;
                df += ia.protection;
            }
        }
        if (this.enable_taming && this.getOwnerName() != null && df < 3.0f) {
            df = 3.0f;
        }
        return df;
    }

    @Override
    public float getAttackDamage() {
        if (this.isBaby()) {
            return super.getAttackDamage() / 16.0f;
        }
        return super.getAttackDamage();
    }

    @Override
    public void doArmorDamage(Entity e, int dt, float pain) {
        super.doArmorDamage(e, dt, pain);
        if (pain <= 0.0f) {
            return;
        }
        int which = this.world.rand.nextInt(4);
        if (this.getArmor(which) != null) {
            int ad = (int)(pain + 1.0f);
            this.getArmor((int)which).currentuses += ad;
            if (this.getArmor((int)which).currentuses >= Items.getMaxUses(this.getArmor((int)which).iid)) {
                this.setArmor(which, null);
            }
            if (this instanceof Player) {
                Player pl = (Player)this;
                pl.server_thread.sendInventoryUpdateToPlayer(2, which, this.getArmor(which));
            } else {
                this.setArmorChanged(which);
            }
        }
    }

    @Override
    public void doHurtAnimation() {
        this.hurtanimationtimer = 35;
        this.madtimer = this.world.rand.nextInt(100) + 100;
    }

    @Override
    public boolean isHurt() {
        return this.hurtanimationtimer > 0;
    }

    @Override
    public void jump() {
        Entity e = this.getRiddenEntity();
        if (e != null) {
            e.jump();
            return;
        }
        if (this.getInLiquid() && this.canSwim && Blocks.isLiquid(this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy + (double)(this.getHeight() * 3.0f / 4.0f) + (double)this.swimoffset), (int)this.posz)) && this.world.rand.nextInt(2) == 0) {
            this.motiony += 0.155f;
            if (this.isSolidAtLevel(this.dimension, this.posx, this.posy - (double)0.35f, this.posz)) {
                this.motiony += 0.55f;
            }
        }
        if (!this.isSolidAtLevel(this.dimension, this.posx, this.posy - (double)0.1f, this.posz)) {
            return;
        }
        if (Math.abs(this.motiony) > 0.15f) {
            return;
        }
        float jumpfactor = 1.0f + this.getHeight() / 20.0f;
        float jumpadjust = this.getTotalEffect(3);
        if (jumpadjust != 0.0f) {
            jumpfactor += jumpfactor * jumpadjust / 4.0f;
        }
        if ((jumpadjust = this.getTotalEffect(4)) != 0.0f) {
            jumpfactor /= jumpadjust;
        }
        this.motiony += 0.75f * jumpfactor + this.jumpstrength * jumpfactor;
    }

    @Override
    public void doAttackFrom(Entity e, int dt, float pain) {
        float dfn;
        int maybenot;
        if (!this.world.isServer) {
            return;
        }
        if (e != null && (maybenot = (int)e.getTotalEffect(7)) >= 2 && this.world.rand.nextInt(maybenot) != 1) {
            return;
        }
        if (e != null && e != this && !DangerZone.playnicely) {
            if (!this.enable_taming) {
                this.hurtMe = e;
            } else {
                Entity eo = DangerZone.server.entityManager.findPlayerByName(this.getOwnerName());
                if (e != eo) {
                    this.hurtMe = e;
                }
            }
        }
        if (dt != 5 && dt != 11 && dt != 6 && dt != 7 && dt != 9 && dt != 10 && dt != 13 && dt != 12) {
            if (this.damage_backoff > 0) {
                return;
            }
            this.damage_backoff = 5;
        }
        if (this.enable_taming) {
            this.setStaying(false);
            this.setSitting(false);
            if (pain > 5.0f && this.getOwnerName() != null && e instanceof Player) {
                pain = 5.0f;
            }
        }
        if ((dfn = this.getDefense()) <= 0.1f) {
            dfn = 0.1f;
        }
        if (dfn > 1000.0f) {
            dfn = 1000.0f;
        }
        if (dt == 13) {
            dfn = 1.0f;
        }
        float totalpain = pain / dfn;
        if (e != null) {
            float painadjust = e.getTotalEffect(3);
            if (painadjust != 0.0f) {
                totalpain *= painadjust;
            }
            if ((painadjust = e.getTotalEffect(4)) != 0.0f) {
                totalpain /= painadjust;
            }
        }
        if (!this.takesDamageFrom(dt)) {
            return;
        }
        if (totalpain == 0.0f) {
            return;
        }
        if (this.has_inventory && dt != 7 && dt != 11 && dt != 13) {
            this.doArmorDamage(e, dt, pain);
        }
        if ((totalpain = this.getHealth() - totalpain) > this.getMaxHealth()) {
            totalpain = this.getMaxHealth();
        }
        if (totalpain < 0.0f) {
            totalpain -= 10.0f;
        }
        this.setHealth(totalpain);
        this.madtimer = this.world.rand.nextInt(25) + 25;
        if (e != null && dt != 5 && dt != 7 && dt != 10 && dt != 11 && dt != 6 && dt != 13) {
            float dir = (float)Math.atan2(this.posz - e.posz, this.posx - e.posx);
            float sf = e.getHeight() * e.getWidth() / 3.0f;
            if (sf < 0.15f) {
                sf = 0.15f;
            }
            if (sf > 5.0f) {
                sf = 5.0f;
            }
            this.motionx = (float)((double)this.motionx + Math.cos(dir) * (double)sf);
            this.motionz = (float)((double)this.motionz + Math.sin(dir) * (double)sf);
            this.motiony += 0.25f * sf;
            if (this instanceof Player) {
                Player pl = (Player)this;
                pl.server_thread.sendVelocityUpdateToPlayer(this.motionx, this.motiony, this.motionz);
            }
        }
        if (dt != 13) {
            this.newtargetnow = true;
        }
        if (this.getHealth() > 0.0f) {
            if (this.getHurtSound() != null && dt != 11 && dt != 13) {
                this.world.playSound(this.getHurtSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.2f);
            }
            DangerZone.server.sendEntityHitToAll(this);
        } else {
            if (this.getDeathSound() != null) {
                this.world.playSound(this.getDeathSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.1f);
            }
            if (e != null && e != this) {
                e.onKill(this);
            }
            if (!this.isBaby()) {
                this.doDeathDrops();
            } else {
                this.doBabyDeathDrops();
            }
            this.deadflag = true;
            this.onDeath();
            this.removeAllEffects();
            DangerZone.server.sendEntityDeathToAll(this);
        }
    }

    public void doBabyDeathDrops() {
        if (this instanceof Player) {
            this.doDeathDrops();
        }
    }

    @Override
    public void addKnockback(Entity hitter, float xz, float y) {
        if (!this.world.isServer) {
            return;
        }
        if (hitter == null) {
            return;
        }
        float dir = (float)Math.atan2(this.posz - hitter.posz, this.posx - hitter.posx);
        this.motionx = (float)((double)this.motionx + Math.cos(dir) * (double)xz);
        this.motionz = (float)((double)this.motionz + Math.sin(dir) * (double)xz);
        this.motiony += y;
        if (this instanceof Player) {
            Player pl = (Player)this;
            pl.server_thread.sendVelocityUpdateToPlayer(this.motionx, this.motiony, this.motionz);
        }
    }

    public void addKnockback(float dir, float xz, float y) {
        if (!this.world.isServer) {
            return;
        }
        this.motionx = (float)((double)this.motionx + Math.cos(dir) * (double)xz);
        this.motionz = (float)((double)this.motionz + Math.sin(dir) * (double)xz);
        this.motiony += y;
        if (this instanceof Player) {
            Player pl = (Player)this;
            pl.server_thread.sendVelocityUpdateToPlayer(this.motionx, this.motiony, this.motionz);
        }
    }

    @Override
    public int getExperience() {
        if (this.isBaby() && !(this instanceof Player)) {
            return 1;
        }
        return super.getExperience();
    }

    @Override
    public void onDeath() {
        if (this.world.isServer) {
            EntityExp e;
            int iexp = this.getExperience();
            float ht = this.getHeight() / 4.0f;
            float wd = this.getWidth() / 2.0f;
            if (ht > 2.0f) {
                ht = 2.0f;
            }
            if (wd > 1.75f) {
                wd = 1.75f;
            }
            while (iexp >= 1000) {
                e = (EntityExp)this.world.createEntityByName("DangerZone:Experience", this.dimension, this.posx, this.posy, this.posz);
                if (e != null) {
                    e.setBID(0);
                    e.setIID(0);
                    e.setExperience(1000);
                    e.rotation_pitch = 0.0f;
                    e.rotation_yaw = this.world.rand.nextInt(360);
                    e.rotation_roll = 0.0f;
                    e.motionx = (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * wd;
                    e.motiony = this.world.rand.nextFloat() * ht;
                    e.motionz = (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * wd;
                    this.world.spawnEntityInWorld(e);
                }
                iexp -= 1000;
            }
            while (iexp >= 100) {
                e = (EntityExp)this.world.createEntityByName("DangerZone:Experience", this.dimension, this.posx, this.posy, this.posz);
                if (e != null) {
                    e.setBID(0);
                    e.setIID(0);
                    e.setExperience(100);
                    e.rotation_pitch = 0.0f;
                    e.rotation_yaw = this.world.rand.nextInt(360);
                    e.rotation_roll = 0.0f;
                    e.motionx = (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * wd;
                    e.motiony = this.world.rand.nextFloat() * ht;
                    e.motionz = (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * wd;
                    this.world.spawnEntityInWorld(e);
                }
                iexp -= 100;
            }
            while (iexp >= 10) {
                e = (EntityExp)this.world.createEntityByName("DangerZone:Experience", this.dimension, this.posx, this.posy, this.posz);
                if (e != null) {
                    e.setBID(0);
                    e.setIID(0);
                    e.setExperience(10);
                    e.rotation_pitch = 0.0f;
                    e.rotation_yaw = this.world.rand.nextInt(360);
                    e.rotation_roll = 0.0f;
                    e.motionx = (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * wd;
                    e.motiony = this.world.rand.nextFloat() * ht;
                    e.motionz = (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * wd;
                    this.world.spawnEntityInWorld(e);
                }
                iexp -= 10;
            }
            while (iexp >= 1) {
                e = (EntityExp)this.world.createEntityByName("DangerZone:Experience", this.dimension, this.posx, this.posy, this.posz);
                if (e != null) {
                    e.setBID(0);
                    e.setIID(0);
                    e.setExperience(1);
                    e.rotation_pitch = 0.0f;
                    e.rotation_yaw = this.world.rand.nextInt(360);
                    e.rotation_roll = 0.0f;
                    e.motionx = (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * wd;
                    e.motiony = this.world.rand.nextFloat() * ht;
                    e.motionz = (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * wd;
                    this.world.spawnEntityInWorld(e);
                }
                --iexp;
            }
        }
        super.onDeath();
    }

    @Override
    public void doEntityAction(float deltaT) {
        if (!this.getStaying()) {
            Entity e;
            Entity rider = this.getRiderEntity();
            if (rider != null && rider instanceof EntityLiving && !(rider instanceof Player)) {
                EntityLiving erider = (EntityLiving)rider;
                this.target = erider.target;
                if (this.target != null) {
                    if (this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < (double)(this.getWidth() / 2.0f)) {
                        erider.target = null;
                        this.target = null;
                    }
                } else {
                    float cdir = (float)Math.toRadians(this.rotation_yaw);
                    float tdir = (float)Math.toRadians(erider.rotation_yaw);
                    float ddiff = tdir - cdir;
                    while ((double)ddiff > Math.PI) {
                        ddiff = (float)((double)ddiff - Math.PI * 2);
                    }
                    while ((double)ddiff < -Math.PI) {
                        ddiff = (float)((double)ddiff + Math.PI * 2);
                    }
                    this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 10.0);
                }
            }
            if (this.enable_hostile) {
                ++this.searchcounter;
                if (this.searchcounter >= 10) {
                    this.searchcounter = this.world.rand.nextInt(4);
                    if (this.hurtMe != null && this.hurtMe.deadflag) {
                        this.hurtMe = null;
                    }
                    if (this.world.rand.nextInt(25) == 1) {
                        this.hurtMe = null;
                    }
                    this.targetentity = this.hurtMe;
                    if (this.targetentity == null) {
                        this.targetentity = this.findSomethingToAttack();
                    }
                    if (this.targetentity != null) {
                        this.target = new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy, this.targetentity.posz);
                        this.setAttacking(true);
                    } else {
                        this.setAttacking(false);
                    }
                }
                if (this.targetentity != null && this.world.rand.nextInt(8) == 1) {
                    float ar = this.attackRange;
                    if (this.isBaby()) {
                        ar /= 4.0f;
                    }
                    if (this.getDistanceFromEntity(this.targetentity) < (double)(ar + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
                        this.doAttack(this.targetentity);
                    } else {
                        this.doDistanceAttack(this.targetentity);
                    }
                }
            }
            if (this.enable_droppedfood && this.world.rand.nextInt(5) == 1) {
                if (this.targetentity == null) {
                    e = this.findSomethingToEat();
                    this.setAttacking(false);
                    if (e != null) {
                        if (e.getDistanceFromEntity(this) < (double)(this.getWidth() / 2.0f + 2.0f)) {
                            ((EntityBlockItem)e).deadflag = true;
                            this.doEatDroppedFood((EntityBlockItem)e);
                            this.target = null;
                        } else {
                            this.target = new TargetHelper(((EntityBlockItem)e).posx, ((EntityBlockItem)e).posy, ((EntityBlockItem)e).posz);
                            this.setAttacking(true);
                        }
                    }
                } else if (this.target != null && this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < (double)(this.getWidth() / 2.0f + 2.0f) && (e = this.findSomethingToEat()) != null && e.getDistanceFromEntity(this) < (double)(this.getWidth() / 2.0f + 2.0f)) {
                    ((EntityBlockItem)e).deadflag = true;
                    this.doEatDroppedFood((EntityBlockItem)e);
                    this.target = null;
                    this.targetentity = null;
                    this.setAttacking(false);
                }
            }
            if (this.enable_avoid && this.avoiddistance > 0 && !DangerZone.playnicely) {
                this.doAvoidEntity();
            }
            if (this.enable_buddy && this.findbuddydistance > 0 && this.findbuddyfrequency > 1 && this.getOwnerName() == null) {
                this.doFindBuddy();
            }
            if (this.enable_followfood && this.target == null && this.world.rand.nextInt(5) == 1 && (e = this.followFood()) != null) {
                this.target = new TargetHelper(e, e.posx, e.posy, e.posz);
            }
            int mf = this.movefrequency;
            if (this.isBaby() && mf > 10) {
                mf /= 2;
            }
            if (this.madtimer > 0) {
                mf /= 4;
            }
            if (mf < 2) {
                mf = 2;
            }
            if (this.world.rand.nextInt(mf) == 0 || this.newtargetnow) {
                this.findNewTarget(this.rotation_yaw, 70.0f);
            }
            if (this.target != null && this.target.getDistanceToTarget(this.posx, this.posy, this.posz) > (double)(this.getWidth() / 2.0f)) {
                this.moveTowardsTarget(deltaT);
            } else {
                this.target = null;
            }
            if (this.enable_taming) {
                ++this.ownercheckcounter;
                if (this.ownercheckcounter > 10) {
                    double dist;
                    Entity e2;
                    this.ownercheckcounter = this.world.rand.nextInt(5);
                    this.accellerator = 1.0f;
                    if (this.getOwnerName() != null && (e2 = DangerZone.server.entityManager.findPlayerByName(this.getOwnerName())) != null && (dist = this.getDistanceFromEntity(e2)) > (double)this.maxdisttoowner) {
                        this.accellerator = 1.75f;
                        this.findNewTargetNearOwner(e2);
                        if (dist > (double)(this.maxdisttoowner * 2.0f)) {
                            this.target = null;
                            this.accellerator = 1.0f;
                            if (e2.getOnGround()) {
                                Dimensions.DimensionArray[e2.dimension].teleportToDimension(this, this.world, e2.dimension, (int)e2.posx, (int)e2.posy, (int)e2.posz);
                            }
                        }
                    }
                }
            }
            if (this.enable_findfoodblock && this.target == null && this.foodblockdistxz > 0 && this.foodblockdisty > 0 && (!this.fooddaytimeonly || this.fooddaytimeonly && this.world.isDaytime()) && this.world.rand.nextInt(this.foodblockfreq) == 1) {
                this.findBlockFood(this.foodblockdistxz, this.foodblockdisty, this.foodblockheal, this.foodblockdisteat);
            }
            if (this.enable_breeding && !this.isBaby()) {
                EntityLiving e3;
                if (this.breeding > 0) {
                    --this.breeding;
                }
                if (this.breeding != 0 && this.target == null && this.world.rand.nextInt(5) == 1 && (e3 = this.findMate()) != null) {
                    this.target = new TargetHelper(e3, e3.posx, e3.posy, e3.posz);
                    if (e3.breeding != 0 && this.getDistanceFromEntity(e3) < (double)(this.getWidth() * 2.0f) && this.world.rand.nextInt(2) == 1) {
                        this.breeding = 0;
                        e3.breeding = 0;
                        int howmany = 1 + this.world.rand.nextInt(2);
                        int j = 0;
                        while (j < howmany) {
                            this.makeBaby(this, e3);
                            ++j;
                        }
                    }
                }
                if (this.breeding != 0 && this.world.rand.nextInt(5) == 0) {
                    Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleHappy", 2, this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz);
                }
            }
            if (!this.isHurt() && !this.deadflag && this.world.rand.nextInt(100) == 1) {
                this.world.playSound(this.getLivingSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, this.getLivingSoundVolume(), this.getLivingSoundPitch());
            }
        }
        if (this.enable_lookaround) {
            this.doLookAction();
        }
        super.doEntityAction(deltaT);
    }

    public void makeBaby(Entity p1, Entity p2) {
        Entity newme = this.world.createEntityByName(p1.uniquename, p1.dimension, (p1.posx + p2.posx) / 2.0, (p1.posy + p2.posy) / 2.0, (p1.posz + p2.posz) / 2.0);
        if (newme != null) {
            newme.init();
            newme.setBaby(true);
            newme.setCanDespawn(false);
            newme.setOwnerName(p1.getOwnerName());
            this.world.spawnEntityInWorld(newme);
            this.world.playSound("DangerZone:pop", this.dimension, (p1.posx + p2.posx) / 2.0, (p1.posy + p2.posy) / 2.0, (p1.posz + p2.posz) / 2.0, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
        }
        p1.setCanDespawn(false);
        p2.setCanDespawn(false);
    }

    public EntityBlockItem findSomethingToEat() {
        List<Entity> nearby_list = null;
        nearby_list = DangerZone.server.entityManager.findALLEntitiesInRange(this.getWidth() / 2.0f + (float)this.foodsearchDistance, this.dimension, this.posx, this.posy, this.posz);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            Entity e = null;
            Collections.sort(nearby_list, this.FoodSorter);
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = li.next();
                if (!(e instanceof EntityBlockItem) || !this.isSuitableFood(e)) continue;
                return (EntityBlockItem)e;
            }
        }
        return null;
    }

    public boolean isSuitableFood(Entity e) {
        Entity p;
        if (!(e instanceof EntityBlockItem)) {
            return false;
        }
        EntityBlockItem eb = (EntityBlockItem)e;
        if (!this.isFoodForMe(eb.getBID(), eb.getIID())) {
            return false;
        }
        if (this.enable_taming && this.getOwnerName() != null && (p = DangerZone.server.entityManager.findPlayerByName(this.getOwnerName())) != null && p.getDistanceFromEntity(eb) > (double)this.maxdisttoowner) {
            return false;
        }
        return this.CanProbablySeeEntity(eb);
    }

    public void doEatDroppedFood(EntityBlockItem eb) {
        Block bl;
        Item it;
        int bid = eb.getBID();
        int iid = eb.getIID();
        if (iid != 0 && (it = Items.getItem(iid)) != null) {
            it.onFoodEaten(this);
        }
        if (bid != 0 && (bl = Blocks.getBlock(bid)) != null) {
            bl.onFoodEaten(this);
        }
        this.playburp();
        this.heal(2.0f);
    }

    public void doAvoidEntity() {
        if (this.world.rand.nextInt(8) == 1) {
            List<Entity> nearby_list = null;
            nearby_list = DangerZone.server.entityManager.findEntitiesInRange(this.avoiddistance, this.dimension, this.posx, this.posy, this.posz);
            if (nearby_list != null && !nearby_list.isEmpty()) {
                Entity e = null;
                Collections.sort(nearby_list, this.LookTargetSorter);
                ListIterator<Entity> li = nearby_list.listIterator();
                while (li.hasNext()) {
                    e = li.next();
                    double dist = this.getDistanceFromEntityCenter(e);
                    if (!(dist < (double)this.avoiddistance) || !this.shouldAvoidEntity(e)) continue;
                    float rundir = (float)Math.atan2(e.posx - this.posx, e.posz - this.posz);
                    rundir = (float)((double)rundir + Math.PI);
                    rundir = (float)Math.toDegrees(rundir);
                    this.findNewTarget(rundir, 45.0f);
                    break;
                }
            }
        }
    }

    public boolean shouldAvoidEntity(Entity e) {
        return false;
    }

    public void doFindBuddy() {
        if (this.world.rand.nextInt(this.findbuddyfrequency) == 1) {
            List<Entity> nearby_list = null;
            nearby_list = DangerZone.server.entityManager.findEntitiesInRange(this.findbuddydistance, this.dimension, this.posx, this.posy, this.posz);
            if (nearby_list != null && !nearby_list.isEmpty()) {
                Entity e = null;
                Collections.sort(nearby_list, this.LookTargetSorter);
                ListIterator<Entity> li = nearby_list.listIterator();
                while (li.hasNext()) {
                    e = li.next();
                    if (!this.isBuddy(e)) continue;
                    float rundir = (float)Math.atan2(e.posx - this.posx, e.posz - this.posz);
                    rundir = (float)Math.toDegrees(rundir);
                    this.findNewTarget(rundir, 45.0f);
                    break;
                }
            }
        }
    }

    public boolean isBuddy(Entity e) {
        return false;
    }

    public EntityLiving findMate() {
        List<Entity> nearby_list = null;
        nearby_list = DangerZone.server.entityManager.findEntitiesInRange(this.findmatedistance, this.dimension, this.posx, this.posy, this.posz);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            EntityLiving e = null;
            Collections.sort(nearby_list, this.LookTargetSorter);
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = (EntityLiving)li.next();
                if (e == this || !this.isMate(e)) continue;
                return e;
            }
        }
        return null;
    }

    public boolean isMate(Entity e) {
        return e.uniquename.equals(this.uniquename);
    }

    public void doLookAction() {
        TargetHelper look;
        if (this.world.rand.nextInt(120) == 1) {
            this.idletarget = null;
        }
        if (this.world.rand.nextInt(this.movefrequency / 8 + 3) == 0 && this.idletarget == null) {
            Entity lookentity = this.findEntityToLookAt();
            this.idletarget = lookentity != null ? new TargetHelper(lookentity, lookentity.posx, lookentity.posy, lookentity.posz) : null;
        }
        if ((look = this.target) == null && (look = this.idletarget) != null && look.te != null) {
            look.setTarget(look.te.posx, look.te.posy, look.te.posz);
        }
        if (look != null) {
            float cdir = (float)Math.toRadians(this.rotation_yaw_head);
            float tdir = (float)Math.atan2(look.targetx - this.posx, look.targetz - this.posz);
            float ddiff = tdir - cdir;
            float ht = 0.0f;
            float mht = 0.0f;
            while ((double)ddiff > Math.PI) {
                ddiff = (float)((double)ddiff - Math.PI * 2);
            }
            while ((double)ddiff < -Math.PI) {
                ddiff = (float)((double)ddiff + Math.PI * 2);
            }
            this.rotation_yaw_head = (float)((double)this.rotation_yaw_head + (double)(ddiff * 180.0f) / Math.PI / 5.0);
            if (look.te != null) {
                ht = look.te.getHeight() * 7.0f / 8.0f;
                mht = this.eyeheight;
            }
            cdir = (float)Math.toRadians(this.rotation_pitch_head);
            tdir = (float)Math.atan2(this.posy + (double)mht - (look.targety + (double)ht), look.getDistanceToTarget(this.posx, look.targety, this.posz));
            ddiff = tdir - cdir;
            while ((double)ddiff > Math.PI) {
                ddiff = (float)((double)ddiff - Math.PI * 2);
            }
            while ((double)ddiff < -Math.PI) {
                ddiff = (float)((double)ddiff + Math.PI * 2);
            }
            this.rotation_pitch_head = (float)((double)this.rotation_pitch_head + (double)(ddiff * 180.0f) / Math.PI / 5.0);
            cdir = (float)Math.toRadians(this.rotation_yaw);
            tdir = (float)Math.atan2(look.targetx - this.posx, look.targetz - this.posz);
            ddiff = tdir - cdir;
            while ((double)ddiff > Math.PI) {
                ddiff = (float)((double)ddiff - Math.PI * 2);
            }
            while ((double)ddiff < -Math.PI) {
                ddiff = (float)((double)ddiff + Math.PI * 2);
            }
            this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 50.0);
        }
    }

    public Entity findEntityToLookAt() {
        List<Entity> nearby_list = null;
        nearby_list = DangerZone.server.entityManager.findEntitiesInRange(this.getWidth() / 2.0f + this.lookDistance, this.dimension, this.posx, this.posy, this.posz);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            Entity e = null;
            Collections.sort(nearby_list, this.LookTargetSorter);
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = li.next();
                if (!(e instanceof Player) || !this.isSuitableLookTarget(e)) continue;
                return e;
            }
            while (li.hasNext()) {
                e = li.next();
                if (!this.isSuitableLookTarget(e)) continue;
                return e;
            }
        }
        return null;
    }

    public boolean isSuitableLookTarget(Entity e) {
        if (e == this) {
            return false;
        }
        return this.CanProbablySeeEntity(e);
    }

    public void moveTowardsTarget(float deltaT) {
        int startheight;
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
        float ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 10.0);
        double dist = this.target.getDistanceToTarget(this.posx, this.posy, this.posz);
        double speed = Math.sqrt(this.motionx * this.motionx + this.motionz * this.motionz);
        if ((speed = dist / (speed * 10.0)) > 1.0) {
            speed = 1.0;
        }
        if (!this.getOnGround() && !this.getInLiquid()) {
            return;
        }
        this.accellerator = this.isBaby() || this.madtimer > 0 ? 1.5f : 1.0f;
        dist = this.getTotalEffect(1);
        if (dist > 1.0) {
            speed *= dist;
        }
        if ((dist = (double)this.getTotalEffect(2)) > 1.0) {
            speed /= dist;
        }
        this.motionx = (float)((double)this.motionx + (double)(this.moveSpeed * this.accellerator) * speed * Math.sin(tdir));
        this.motionz = (float)((double)this.motionz + (double)(this.moveSpeed * this.accellerator) * speed * Math.cos(tdir));
        if (!(this.isSolidAtLevel(this.dimension, this.posx + (double)(this.motionx * deltaT), this.posy - 1.0, this.posz + (double)(this.motionz * deltaT)) || this.isSolidAtLevel(this.dimension, this.posx + (double)(this.motionx * deltaT), this.posy - (double)(this.getHeight() / 4.0f) - 2.0, this.posz + (double)(this.motionz * deltaT)) || this.canSwim && this.isLiquidAtLevel(this.dimension, this.posx + (double)(this.motionx * deltaT), this.posy - 1.0, this.posz + (double)(this.motionz * deltaT)))) {
            this.motionz = 0.0f;
            this.motionx = 0.0f;
            this.newtargetnow = true;
            return;
        }
        Entity e = this.getRiddenEntity();
        float useheight = this.getHeight();
        float usewidth = this.getWidth();
        double usex = this.posx + (double)(this.motionx * deltaT);
        double usey = this.posy;
        double usez = this.posz + (double)(this.motionz * deltaT);
        if (e != null) {
            useheight = e.getHeight();
            usewidth = e.getWidth();
            usex = e.posx + (double)(this.motionx * deltaT);
            usey = e.posy;
            usez = e.posz + (double)(this.motionz * deltaT);
        }
        int intheight = (int)(useheight + 0.995f);
        int k = startheight = (int)useheight / 4;
        while (k < intheight) {
            if (this.wouldBump(usex, usey + (double)k, usez, usewidth)) {
                if (k <= startheight + 1) {
                    if (this.world.rand.nextInt(3) == 0) {
                        this.jump();
                        break;
                    }
                } else {
                    this.motionx /= 2.0f * deltaT;
                    this.motionz /= 2.0f * deltaT;
                    this.newtargetnow = true;
                    break;
                }
            }
            ++k;
        }
    }

    public void findNewTarget(float dir, float delta) {
        int i;
        double newy;
        double newz;
        double newx;
        int intdist;
        double newdist;
        double newdir;
        int tries = 4;
        block0: while (tries > 0) {
            --tries;
            newdir = this.world.rand.nextFloat() - this.world.rand.nextFloat();
            newdir *= (double)delta;
            newdist = 2.0f + this.world.rand.nextFloat() * this.getWidth() * this.getHeight() * 2.0f;
            intdist = (int)(newdist + (double)0.995f);
            newx = this.posx + Math.sin(Math.toRadians(newdir += (double)dir)) * newdist;
            newz = this.posz + Math.cos(Math.toRadians(newdir)) * newdist;
            newy = this.posy;
            i = intdist;
            while (i > -intdist) {
                newy = this.posy + (double)i;
                if (!this.isSolidAtLevel(this.dimension, newx, newy + 1.0, newz)) {
                    if (!this.targetLiquidOnly && this.isSolidAtLevel(this.dimension, newx, newy, newz) && this.CanProbablySee(this.dimension, newx, newy + 1.0, newz, (int)newdist)) {
                        if (!this.canSwim && Blocks.isLiquid(this.world.getblock(this.dimension, (int)newx, (int)newy + 1, (int)newz))) continue block0;
                        newy += 1.0;
                        newy = (int)newy;
                        this.target = new TargetHelper(null, newx, newy, newz);
                        this.newtargetnow = false;
                        return;
                    }
                    if (this.canSwim && this.isLiquidAtLevel(this.dimension, newx, newy, newz) && this.CanProbablySee(this.dimension, newx, newy + 1.0, newz, (int)newdist)) {
                        newy += 1.0;
                        newy = (int)newy;
                        this.target = new TargetHelper(null, newx, newy, newz);
                        this.newtargetnow = false;
                        return;
                    }
                }
                --i;
            }
        }
        tries = 1;
        block2: while (tries > 0) {
            --tries;
            newdir = this.world.rand.nextFloat() - this.world.rand.nextFloat();
            newdir *= (double)delta;
            newdist = 2.0f + this.world.rand.nextFloat() * this.getWidth() * this.getHeight() * 4.0f;
            intdist = (int)(newdist + (double)0.995f);
            newx = this.posx + Math.sin(Math.toRadians(newdir += (double)(dir + 180.0f))) * newdist;
            newz = this.posz + Math.cos(Math.toRadians(newdir)) * newdist;
            newy = this.posy;
            i = intdist;
            while (i > -intdist) {
                newy = this.posy + (double)i;
                if (!this.isSolidAtLevel(this.dimension, newx, newy + 1.0, newz) && !this.targetLiquidOnly && this.isSolidAtLevel(this.dimension, newx, newy, newz) && this.CanProbablySee(this.dimension, newx, newy + 1.0, newz, (int)newdist)) {
                    if (!this.canSwim && Blocks.isLiquid(this.world.getblock(this.dimension, (int)newx, (int)newy + 1, (int)newz))) continue block2;
                    newy += 1.0;
                    newy = (int)newy;
                    this.target = new TargetHelper(null, newx, newy, newz);
                    this.newtargetnow = false;
                    return;
                }
                if (this.canSwim && this.isLiquidAtLevel(this.dimension, newx, newy, newz) && this.CanProbablySee(this.dimension, newx, newy + 1.0, newz, (int)newdist)) {
                    newy += 1.0;
                    newy = (int)newy;
                    this.target = new TargetHelper(null, newx, newy, newz);
                    this.newtargetnow = false;
                    return;
                }
                --i;
            }
        }
        if (!this.canSwim) {
            tries = 4;
            while (tries > 0) {
                --tries;
                newdir = this.world.rand.nextFloat() - this.world.rand.nextFloat();
                newdir *= (double)delta;
                newdist = 2.0f + this.world.rand.nextFloat() * this.getWidth() * this.getHeight() * 2.0f;
                intdist = (int)(newdist + (double)0.995f);
                newx = this.posx + Math.sin(Math.toRadians(newdir += (double)dir)) * newdist;
                newz = this.posz + Math.cos(Math.toRadians(newdir)) * newdist;
                newy = this.posy;
                i = intdist;
                while (i > -intdist) {
                    newy = this.posy + (double)i;
                    if (!this.isSolidAtLevel(this.dimension, newx, newy + 1.0, newz) && this.isSolidAtLevel(this.dimension, newx, newy, newz) && this.CanProbablySee(this.dimension, newx, newy + 1.0, newz, (int)newdist)) {
                        newy += 1.0;
                        newy = (int)newy;
                        this.target = new TargetHelper(null, newx, newy, newz);
                        this.newtargetnow = false;
                        return;
                    }
                    --i;
                }
            }
            tries = 1;
            while (tries > 0) {
                --tries;
                newdir = this.world.rand.nextFloat() - this.world.rand.nextFloat();
                newdir *= (double)delta;
                newdist = 2.0f + this.world.rand.nextFloat() * this.getWidth() * this.getHeight() * 4.0f;
                intdist = (int)(newdist + (double)0.995f);
                newx = this.posx + Math.sin(Math.toRadians(newdir += (double)(dir + 180.0f))) * newdist;
                newz = this.posz + Math.cos(Math.toRadians(newdir)) * newdist;
                newy = this.posy;
                i = intdist;
                while (i > -intdist) {
                    newy = this.posy + (double)i;
                    if (!this.isSolidAtLevel(this.dimension, newx, newy + 1.0, newz) && this.isSolidAtLevel(this.dimension, newx, newy, newz) && this.CanProbablySee(this.dimension, newx, newy + 1.0, newz, (int)newdist)) {
                        newy += 1.0;
                        newy = (int)newy;
                        this.target = new TargetHelper(null, newx, newy, newz);
                        this.newtargetnow = false;
                        return;
                    }
                    --i;
                }
            }
        }
    }

    @Override
    public void findBlockFood(int maxdistxz, int maxdisty, int healamount, int eatitdistance) {
        this.closest = 99999;
        this.tz = 0;
        this.ty = 0;
        this.tx = 0;
        int i = 1;
        while (i < maxdistxz) {
            int j = i;
            if (j > maxdisty) {
                j = maxdisty;
            }
            if (this.scan_it((int)this.posx, (int)this.posy + 1, (int)this.posz, i, j, i)) break;
            if (i >= 6) {
                ++i;
            }
            ++i;
        }
        if (this.closest < 99999) {
            this.target = new TargetHelper(this.tx, this.ty - 1, this.tz);
            if (this.closest < eatitdistance) {
                this.heal(healamount);
                this.doEatFoodAction(this.dimension, this.tx, this.ty, this.tz);
                this.target = null;
            }
        }
    }

    public void doEatFoodAction(int d, int x, int y, int z) {
        if (this.world.rand.nextInt(4) == 1) {
            this.playburp();
        }
        this.world.setblockandmeta(d, x, y, z, 0, 0);
    }

    @Override
    public void playburp() {
        int which = this.world.rand.nextInt(4);
        if (which == 0) {
            this.world.playSound("DangerZone:burp1", this.dimension, this.posx, this.posy, this.posz, 0.55f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.25f);
        }
        if (which == 1) {
            this.world.playSound("DangerZone:burp2", this.dimension, this.posx, this.posy, this.posz, 0.55f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.25f);
        }
        if (which == 2) {
            this.world.playSound("DangerZone:burp3", this.dimension, this.posx, this.posy, this.posz, 0.55f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.25f);
        }
        if (which == 3) {
            this.world.playSound("DangerZone:burp", this.dimension, this.posx, this.posy, this.posz, 0.55f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.25f);
        }
    }

    public boolean scan_it(int x, int y, int z, int dx, int dy, int dz) {
        int d;
        int bid;
        int j;
        int found = 0;
        int i = -dy;
        while (i <= dy) {
            j = -dz;
            while (j <= dz) {
                bid = this.world.getblock(this.dimension, x + dx, y + i, z + j);
                if (this.isFoodBlock(bid) && (d = dx * dx + j * j + i * i) < this.closest) {
                    this.closest = d;
                    this.tx = x + dx;
                    this.ty = y + i;
                    this.tz = z + j;
                    ++found;
                }
                if (this.isFoodBlock(bid = this.world.getblock(this.dimension, x - dx, y + i, z + j)) && (d = dx * dx + j * j + i * i) < this.closest) {
                    this.closest = d;
                    this.tx = x - dx;
                    this.ty = y + i;
                    this.tz = z + j;
                    ++found;
                }
                ++j;
            }
            ++i;
        }
        i = -dx;
        while (i <= dx) {
            j = -dz;
            while (j <= dz) {
                bid = this.world.getblock(this.dimension, x + i, y + dy, z + j);
                if (this.isFoodBlock(bid) && (d = dy * dy + j * j + i * i) < this.closest) {
                    this.closest = d;
                    this.tx = x + i;
                    this.ty = y + dy;
                    this.tz = z + j;
                    ++found;
                }
                if (this.isFoodBlock(bid = this.world.getblock(this.dimension, x + i, y - dy, z + j)) && (d = dy * dy + j * j + i * i) < this.closest) {
                    this.closest = d;
                    this.tx = x + i;
                    this.ty = y - dy;
                    this.tz = z + j;
                    ++found;
                }
                ++j;
            }
            ++i;
        }
        i = -dx;
        while (i <= dx) {
            j = -dy;
            while (j <= dy) {
                bid = this.world.getblock(this.dimension, x + i, y + j, z + dz);
                if (this.isFoodBlock(bid) && (d = dz * dz + j * j + i * i) < this.closest) {
                    this.closest = d;
                    this.tx = x + i;
                    this.ty = y + j;
                    this.tz = z + dz;
                    ++found;
                }
                if (this.isFoodBlock(bid = this.world.getblock(this.dimension, x + i, y + j, z - dz)) && (d = dz * dz + j * j + i * i) < this.closest) {
                    this.closest = d;
                    this.tx = x + i;
                    this.ty = y + j;
                    this.tz = z - dz;
                    ++found;
                }
                ++j;
            }
            ++i;
        }
        return found != 0;
    }

    @Override
    public float getAdjustedFallDamage(float ouch) {
        float damage = ouch;
        if (this.getOwnerName() != null && damage > 1.0f) {
            damage = 1.0f;
        }
        if (!this.takesFallDamage) {
            return 0.0f;
        }
        return damage;
    }

    @Override
    public boolean getCanSpawnHereNow(World w, int dimension, int x, int y, int z) {
        if (this.daytimespawn) {
            if (!w.isDaytime()) {
                return false;
            }
            if (this.getLightAtLocation(w, dimension, x, y, z) < 0.55f) {
                return false;
            }
        }
        if (this.nighttimespawn) {
            if (w.isDaytime()) {
                return false;
            }
            if (this.getLightAtLocation(w, dimension, x, y, z) > 0.35f) {
                return false;
            }
        }
        return true;
    }

    public void doAttack(Entity victim) {
        InventoryContainer ic;
        float dmg = this.getAttackDamage();
        int dt = 4;
        if (this.has_inventory && (ic = this.getHotbar(this.gethotbarindex())) != null) {
            if (ic.bid != 0) {
                dt = 3;
            } else if (ic.iid > 0 && ic.iid < 2048) {
                dmg = Items.getAttackStrength(ic.iid);
                dt = 0;
                Item it = ic.getItem();
                if (it != null) {
                    if (it instanceof ItemSword) {
                        dt = 1;
                    }
                    if (it instanceof ItemPickAxe) {
                        dt = 2;
                    }
                    if (it instanceof ItemAxe) {
                        dt = 2;
                    }
                    if (it instanceof ItemShovel) {
                        dt = 2;
                    }
                }
            }
        }
        victim.doAttackFrom(this, dt, dmg);
    }

    @Override
    public float getRightArmAngle() {
        return -this.armangle;
    }

    public Entity findSomethingToAttack() {
        List<Entity> nearby_list = null;
        int maybenot = (int)this.getTotalEffect(7);
        if (maybenot >= 2 && this.world.rand.nextInt(maybenot) != 1) {
            return null;
        }
        nearby_list = DangerZone.server.entityManager.findEntitiesInRange(this.getWidth() / 2.0f + this.searchDistance, this.dimension, this.posx, this.posy, this.posz);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            Entity e = null;
            Collections.sort(nearby_list, this.TargetSorter);
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = li.next();
                if (!(e.posy < 300.0) || !this.isSuitableTarget(e)) continue;
                return e;
            }
        }
        return null;
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Cockroach) {
            return this.CanProbablySeeEntity(e);
        }
        if (e instanceof Player) {
            return this.CanProbablySeeEntity(e);
        }
        return e.temperament == 1 && this.CanProbablySeeEntity(e);
    }

    public boolean isIgnorable(Entity e) {
        if (DangerZone.playnicely) {
            return true;
        }
        if (e == null) {
            return true;
        }
        if (e == this) {
            return true;
        }
        if (!(e instanceof EntityLiving)) {
            return true;
        }
        if (e.deadflag) {
            return true;
        }
        if (e instanceof Player && e.getGameMode() != 0) {
            return true;
        }
        if (e == this.getRiderEntity()) {
            return true;
        }
        if (this.getOwnerName() != null) {
            if (this.getDistanceFromEntity(e) > (double)this.maxdisttoowner) {
                return true;
            }
            if (e instanceof Player) {
                return true;
            }
            if (e.getOwnerName() != null) {
                return true;
            }
        }
        return false;
    }

    public Entity followFood() {
        List<Entity> nearby_list = null;
        nearby_list = DangerZone.server.entityManager.findEntitiesInRange(this.getWidth() / 2.0f + (float)this.foodfollowDistance, this.dimension, this.posx, this.posy, this.posz);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            Entity e = null;
            Collections.sort(nearby_list, this.FoodSorter);
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                Player p;
                InventoryContainer ic;
                e = li.next();
                if (!(e instanceof Player) || (ic = (p = (Player)e).getHotbar(p.gethotbarindex())) == null || !this.isFoodForMe(ic.bid, ic.iid)) continue;
                return e;
            }
        }
        return null;
    }

    @Override
    public boolean rightClickedByPlayer(Player p, InventoryContainer ic) {
        if (this.world.isServer) {
            if (this.enable_breeding) {
                if (this.enable_taming && ic != null && this.isFoodForMe(ic.bid, ic.iid) && this.getOwnerName() == null) {
                    if (this.world.rand.nextInt(3) == 1) {
                        this.setOwnerName(p.myname);
                        Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleHappy", 20, this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz);
                        this.heal(10.0f);
                    }
                    this.playburp();
                    this.setCanDespawn(false);
                    return true;
                }
                if (ic != null && this.isBreedingFoodForMe(ic.bid, ic.iid)) {
                    Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleHappy", 10, this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz);
                    this.heal(10.0f);
                    this.breeding = 200 + this.world.rand.nextInt(200);
                    this.playburp();
                    return true;
                }
            }
            if (this.enable_taming) {
                if (ic != null && this.isFoodForMe(ic.bid, ic.iid) && this.getOwnerName() == null) {
                    if (this.world.rand.nextInt(3) == 1) {
                        this.setOwnerName(p.myname);
                        Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleHappy", 20, this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz);
                        this.heal(10.0f);
                    }
                    this.playburp();
                    this.setCanDespawn(false);
                    return true;
                }
                if (ic != null && this.isFoodForMe(ic.bid, ic.iid) && this.getOwnerName() != null && p.myname.equals(this.getOwnerName())) {
                    Block bl;
                    Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleHappy", 10, this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz);
                    this.playburp();
                    Item it = ic.getItem();
                    if (it != null && (it instanceof ItemFood || it.isfood)) {
                        this.heal(it.foodvalue * 10.0f);
                    } else {
                        this.heal(25.0f);
                    }
                    int bid = ic.bid;
                    int iid = ic.iid;
                    if (iid != 0 && (it = Items.getItem(iid)) != null) {
                        it.onFoodEaten(this);
                    }
                    if (bid != 0 && (bl = Blocks.getBlock(bid)) != null) {
                        bl.onFoodEaten(this);
                    }
                    return true;
                }
                if (ic != null && ic.iid == Items.moosebone.itemID && this.getOwnerName() != null && p.myname.equals(this.getOwnerName())) {
                    Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleHappy", 20, this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz);
                    this.heal(1.0f);
                    this.world.playSound("DangerZone:pop", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
                    return true;
                }
                if (ic != null && ic.iid == Items.vampireteeth.itemID && this.getOwnerName() != null && p.myname.equals(this.getOwnerName())) {
                    Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleSmoke", 10, this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz);
                    this.setStaying(false);
                    this.setOwnerName(null);
                    this.setPetName(null);
                    this.setCanDespawn(true);
                    this.world.playSound("DangerZone:pop", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
                    return true;
                }
                if (ic != null && this.getOwnerName() != null && p.myname.equals(this.getOwnerName()) && this.getRiderEntity() == null) {
                    if (this.getStaying()) {
                        this.setStaying(false);
                        this.setSitting(false);
                        Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleHappy", 20, this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz);
                    } else {
                        this.setStaying(true);
                        this.setAttacking(false);
                        this.setSitting(true);
                        this.motionz = 0.0f;
                        this.motionx = 0.0f;
                        this.target = null;
                        Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleSmoke", 10, this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz);
                    }
                }
            }
        } else if (this.enable_taming && ic != null && ic.iid == Items.moosebone.itemID && this.getOwnerName() != null && p.myname.equals(this.getOwnerName())) {
            PlayerPetNameGUI pg = new PlayerPetNameGUI(this);
            DangerZone.setActiveGui(pg);
            return false;
        }
        return false;
    }

    public void findNewTargetNearOwner(Entity e) {
        if (this.target == null) {
            this.target = new TargetHelper(e.posx, e.posy, e.posz);
        }
        int tries = 8;
        block0: while (tries > 0) {
            --tries;
            double newdir = this.world.rand.nextFloat() - this.world.rand.nextFloat();
            newdir *= 180.0;
            double newdist = 2.0f + this.world.rand.nextFloat() * this.getWidth() * this.getHeight() * 2.0f;
            int intdist = (int)(newdist + (double)0.995f);
            double newx = e.posx + Math.cos(newdir += (double)this.rotation_yaw) * newdist;
            double newz = e.posz + Math.sin(newdir) * newdist;
            double newy = e.posy;
            int i = intdist;
            while (i > -intdist) {
                newy = this.posy + (double)i;
                if (!this.isSolidAtLevel(this.dimension, newx, newy + 1.0, newz) && this.isSolidAtLevel(this.dimension, newx, newy, newz) && this.CanProbablySee(this.dimension, newx, newy + 1.0, newz, (int)newdist)) {
                    if (!this.canSwim && Blocks.isLiquid(this.world.getblock(this.dimension, (int)newx, (int)newy + 1, (int)newz))) continue block0;
                    newy += 1.0;
                    newy = (int)newy;
                    this.target.setTarget(newx, newy, newz);
                    this.newtargetnow = false;
                    return;
                }
                --i;
            }
        }
    }
}

